"use strict";

var _typings = require("../../typings");

var _preProcessor = require("./pre-processor");

const AN_ENTITY = 'person';
const OTHER_ENTITY = 'animal';
describe('Preprocessing', () => {
  test('generate training seq', () => {
    const slotDef = [{
      name: 'ME',
      entities: [AN_ENTITY]
    }, {
      name: 'YOU',
      entities: [AN_ENTITY, OTHER_ENTITY]
    }];
    const trainingSeq = (0, _preProcessor.generateTrainingSequence)(`hello my name is [Jacob Jacobson](${slotDef[0].name}) and your name is [Paul](${slotDef[1].name})`, slotDef);
    expect(trainingSeq.cannonical).toEqual('hello my name is Jacob Jacobson and your name is Paul');
    expect(trainingSeq.tokens.filter(t => t.tag != _typings.BIO.OUT).length).toEqual(3);
    expect(trainingSeq.tokens[0].slot).toBeUndefined();
    expect(trainingSeq.tokens[0].matchedEntities).toEqual([]);
    expect(trainingSeq.tokens[0].tag).toEqual(_typings.BIO.OUT);
    expect(trainingSeq.tokens[0].value).toEqual('hello');
    expect(trainingSeq.tokens[4].slot).toEqual(slotDef[0].name);
    expect(trainingSeq.tokens[4].matchedEntities).toEqual(slotDef[0].entities);
    expect(trainingSeq.tokens[4].tag).toEqual(_typings.BIO.BEGINNING);
    expect(trainingSeq.tokens[4].value).toEqual('Jacob');
    expect(trainingSeq.tokens[5].slot).toEqual(slotDef[0].name);
    expect(trainingSeq.tokens[5].matchedEntities).toEqual(slotDef[0].entities);
    expect(trainingSeq.tokens[5].tag).toEqual(_typings.BIO.INSIDE);
    expect(trainingSeq.tokens[5].value).toEqual('Jacobson');
    expect(trainingSeq.tokens[10].matchedEntities).toEqual(slotDef[1].entities);
  });
  test('generate prediction seq', () => {
    const entities = [{
      name: 'numeral',
      type: 'system',
      meta: {
        start: 26,
        end: 28,
        confidence: 1,
        provider: 'native',
        raw: {},
        source: '70'
      },
      data: {
        value: 70
      }
    }, {
      name: 'amountOfMoney',
      type: 'system',
      meta: {
        start: 26,
        end: 36,
        confidence: 1,
        provider: 'native',
        raw: {},
        source: '70 dollars'
      },
      data: {
        unit: 'dollar',
        value: 70
      }
    }, {
      name: 'email',
      type: 'system',
      meta: {
        start: 51,
        end: 70,
        confidence: 1,
        provider: 'native',
        raw: {},
        source: 'misterhyde@evil.com'
      },
      data: {
        value: 'misterhyde@evil.com'
      }
    }]; // some extra spaces on purpose here

    const testingSeq = (0, _preProcessor.generatePredictionSequence)('Hey can you   please send 70 dollars to  Jekyll at misterhyde@evil.com', 'a name', entities);
    const entityTokens = testingSeq.tokens.filter(t => t.matchedEntities.length);
    expect(entityTokens.length).toEqual(3);
    expect(entityTokens[0].value).toEqual('70');
    expect(entityTokens[0].matchedEntities).toEqual(['numeral', 'amountOfMoney']);
    expect(entityTokens[1].value).toEqual('dollars');
    expect(entityTokens[1].matchedEntities).toEqual(['amountOfMoney']);
    expect(entityTokens[2].value).toEqual('misterhyde@evil.com');
    expect(entityTokens[2].matchedEntities).toEqual(['email']);
    expect(testingSeq.tokens[0].value).toEqual('Hey');
    expect(testingSeq.tokens[0].matchedEntities).toEqual([]);
  });
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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