"use strict";

var _utils = require("./utils");

describe('matches', () => {
  test('Exact match', () => {
    const matches = (0, _utils.createIntentMatcher)('faq.hello');
    expect(matches('faq.hello')).toBe(true);
    expect(matches('faq.hello2')).toBe(false);
    expect(matches('faq.hell')).toBe(false);
    expect(matches('faq_hello')).toBe(false);
  });
  test('Wildcard ending', () => {
    const matches = (0, _utils.createIntentMatcher)('faq.hello');
    expect(matches('faq.hell*')).toBe(true);
    expect(matches('faq.h*')).toBe(true);
    expect(matches('faq.q*')).toBe(false);
    expect(matches('faq.hello*')).toBe(false);
    expect(matches('*')).toBe(true);
    expect(matches('faq.faq.h*')).toBe(false);
  });
  test('Wildcard starting', () => {
    const matches = (0, _utils.createIntentMatcher)('faq.hello');
    expect(matches('*.hello')).toBe(true);
    expect(matches('*aq.hello')).toBe(true);
    expect(matches('*.nope')).toBe(false);
  });
  test('Wildcard both', () => {
    const matches = (0, _utils.createIntentMatcher)('faq.hello');
    expect(matches('*.*')).toBe(true);
    expect(matches('*aq.hell*')).toBe(true);
    expect(matches('*.nope*')).toBe(false);
  });
  test('Escaping', () => {
    const matches = (0, _utils.createIntentMatcher)('faq.hello');
    expect(matches('.+')).toBe(false);
  });
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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