"use strict";

/**
 * Removes the provided context(s) from the list of contexts that will be used by the NLU Engine
 * for the next messages for that chat session.
 *
 * This method is contextual to the current user and chat session.
 *
 * You can specify more than one context by separating them with a comma.
 *
 * @title Remove Context
 * @category NLU
 * @author Botpress, Inc.
 * @param {string} contexts - Comma-separated list of contextss
 */
const removeContext = contexts => {
  const existing = event.state.session.nluContexts || [];
  const remove = contexts.split(',');
  event.state.session.nluContexts = existing.filter(x => remove.indexOf(x.context) < 0);
};

return removeContext(args.contexts);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInJlbW92ZUNvbnRleHQuanMiXSwibmFtZXMiOlsicmVtb3ZlQ29udGV4dCIsImNvbnRleHRzIiwiZXhpc3RpbmciLCJldmVudCIsInN0YXRlIiwic2Vzc2lvbiIsIm5sdUNvbnRleHRzIiwicmVtb3ZlIiwic3BsaXQiLCJmaWx0ZXIiLCJ4IiwiaW5kZXhPZiIsImNvbnRleHQiLCJhcmdzIl0sIm1hcHBpbmdzIjoiOztBQUFBOzs7Ozs7Ozs7Ozs7O0FBYUEsTUFBTUEsYUFBYSxHQUFHQyxRQUFRLElBQUk7QUFDaEMsUUFBTUMsUUFBUSxHQUFHQyxLQUFLLENBQUNDLEtBQU4sQ0FBWUMsT0FBWixDQUFvQkMsV0FBcEIsSUFBbUMsRUFBcEQ7QUFDQSxRQUFNQyxNQUFNLEdBQUdOLFFBQVEsQ0FBQ08sS0FBVCxDQUFlLEdBQWYsQ0FBZjtBQUNBTCxFQUFBQSxLQUFLLENBQUNDLEtBQU4sQ0FBWUMsT0FBWixDQUFvQkMsV0FBcEIsR0FBa0NKLFFBQVEsQ0FBQ08sTUFBVCxDQUFnQkMsQ0FBQyxJQUFJSCxNQUFNLENBQUNJLE9BQVAsQ0FBZUQsQ0FBQyxDQUFDRSxPQUFqQixJQUE0QixDQUFqRCxDQUFsQztBQUNELENBSkQ7O0FBTUEsT0FBT1osYUFBYSxDQUFDYSxJQUFJLENBQUNaLFFBQU4sQ0FBcEIiLCJzb3VyY2VSb290IjoiL3Zhci9saWIvamVua2lucy93b3Jrc3BhY2UvYnVpbGQtbGludXgvbW9kdWxlcy9idWlsdGluL3NyYy9iYWNrZW5kIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBSZW1vdmVzIHRoZSBwcm92aWRlZCBjb250ZXh0KHMpIGZyb20gdGhlIGxpc3Qgb2YgY29udGV4dHMgdGhhdCB3aWxsIGJlIHVzZWQgYnkgdGhlIE5MVSBFbmdpbmVcbiAqIGZvciB0aGUgbmV4dCBtZXNzYWdlcyBmb3IgdGhhdCBjaGF0IHNlc3Npb24uXG4gKlxuICogVGhpcyBtZXRob2QgaXMgY29udGV4dHVhbCB0byB0aGUgY3VycmVudCB1c2VyIGFuZCBjaGF0IHNlc3Npb24uXG4gKlxuICogWW91IGNhbiBzcGVjaWZ5IG1vcmUgdGhhbiBvbmUgY29udGV4dCBieSBzZXBhcmF0aW5nIHRoZW0gd2l0aCBhIGNvbW1hLlxuICpcbiAqIEB0aXRsZSBSZW1vdmUgQ29udGV4dFxuICogQGNhdGVnb3J5IE5MVVxuICogQGF1dGhvciBCb3RwcmVzcywgSW5jLlxuICogQHBhcmFtIHtzdHJpbmd9IGNvbnRleHRzIC0gQ29tbWEtc2VwYXJhdGVkIGxpc3Qgb2YgY29udGV4dHNzXG4gKi9cbmNvbnN0IHJlbW92ZUNvbnRleHQgPSBjb250ZXh0cyA9PiB7XG4gIGNvbnN0IGV4aXN0aW5nID0gZXZlbnQuc3RhdGUuc2Vzc2lvbi5ubHVDb250ZXh0cyB8fCBbXVxuICBjb25zdCByZW1vdmUgPSBjb250ZXh0cy5zcGxpdCgnLCcpXG4gIGV2ZW50LnN0YXRlLnNlc3Npb24ubmx1Q29udGV4dHMgPSBleGlzdGluZy5maWx0ZXIoeCA9PiByZW1vdmUuaW5kZXhPZih4LmNvbnRleHQpIDwgMClcbn1cblxucmV0dXJuIHJlbW92ZUNvbnRleHQoYXJncy5jb250ZXh0cylcbiJdfQ==