"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.csvParse = exports.jsonParse = void 0;

var _sync = _interopRequireDefault(require("csv-parse/lib/sync"));

var _get = _interopRequireDefault(require("lodash/get"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const parseFlow = str => {
  const [redirectFlow, redirectNode = ''] = str.split('#');
  return {
    redirectFlow,
    redirectNode
  };
};

const jsonParse = (jsonContent, options) => jsonContent.map(({
  questions,
  answer: instruction,
  answer2,
  action,
  category
}, i) => {
  if (!['text', 'redirect', 'text_redirect'].includes(action)) {
    throw new Error(`Failed to process CSV-row ${i + 1}: action should be either "text", "redirect" or "text_redirect"`);
  }

  let redirectInstruction = undefined;
  let textAnswer = '';
  const {
    hasCategory
  } = options;

  if (action === 'text') {
    textAnswer = instruction;
  } else if (action === 'redirect') {
    redirectInstruction = instruction;
  } else if (action === 'text_redirect') {
    textAnswer = instruction;
    redirectInstruction = answer2;
  }

  const flowParams = redirectInstruction ? parseFlow(redirectInstruction) : {
    redirectFlow: '',
    redirectNode: ''
  };
  const categoryWrapper = hasCategory ? {
    category
  } : {};
  return {
    questions,
    action,
    answer: textAnswer,
    ...flowParams,
    ...categoryWrapper
  };
});

exports.jsonParse = jsonParse;

const csvParse = (csvContent, options) => {
  const {
    hasCategory
  } = options;

  const mergeRows = (acc, {
    question,
    answer,
    answer2,
    category,
    action
  }) => {
    const [prevRow] = acc.slice(-1);
    const isSameAnswer = prevRow && prevRow.answer === answer && (!answer2 || answer2 === prevRow.answer2);

    if (isSameAnswer) {
      return [...acc.slice(0, acc.length - 1), { ...prevRow,
        questions: [...prevRow.questions, question]
      }];
    }

    const categoryWrapper = hasCategory ? {
      category
    } : {};
    return [...acc, {
      answer,
      answer2,
      action,
      ...categoryWrapper,
      questions: [question]
    }];
  };

  const categoryWrapper = hasCategory ? ['category'] : [];
  const rows = (0, _sync.default)(csvContent, {
    columns: ['question', 'action', 'answer', 'answer2', ...categoryWrapper]
  }).reduce(mergeRows, []); // We trim the header if detected in the first row

  if ((0, _get.default)(rows, '0.action') === 'action') {
    rows.splice(0, 1);
  }

  return jsonParse(rows, options);
};

exports.csvParse = csvParse;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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