"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdateTask = void 0;

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class UpdateTask {
  constructor(_bp, _interval) {
    this._bp = _bp;
    this._interval = _interval;

    _defineProperty(this, "runTask", void 0);

    _defineProperty(this, "_currentPromise", void 0);

    _defineProperty(this, "_intervalRef", void 0);
  }

  async start(botId) {
    if (this._intervalRef) {
      throw new Error('The update is already running.');
    }

    this._intervalRef = setInterval(this._runTaskWhenReady.bind(this), this._interval);
  }

  stop(botId) {
    clearInterval(this._intervalRef);
    this._intervalRef = undefined;
  }

  async _runTaskWhenReady() {
    if (this._currentPromise) {
      return;
    }

    this._currentPromise = this.runTask && this.runTask().catch(err => this._bp.logger.warn('Error running update: ' + err.message)).finally(() => {
      this._currentPromise = undefined;
    });
  }

}

exports.UpdateTask = UpdateTask;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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