"use strict";

const axios = require('axios');
/**
 * Sets the absolute value of a specific metric group.
 *
 * @title Set Custom Metric
 * @category Analytics
 * @param {string} metric The name of the metric
 * @param {string} [group=all] Optional group inside the metrics
 * @param {Number} [count=1] The absolute value to set
 */


const set = async (metric, group, count = 1) => {
  const axiosConfig = await bp.http.getAxiosConfigForBot(event.botId);
  await axios.post('/mod/analytics/custom_metrics/set', {
    name: `${metric}~${group}`,
    count: Number(count)
  }, axiosConfig);
};

return set(args.metric, args.group, args.count);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNldC5qcyJdLCJuYW1lcyI6WyJheGlvcyIsInJlcXVpcmUiLCJzZXQiLCJtZXRyaWMiLCJncm91cCIsImNvdW50IiwiYXhpb3NDb25maWciLCJicCIsImh0dHAiLCJnZXRBeGlvc0NvbmZpZ0ZvckJvdCIsImV2ZW50IiwiYm90SWQiLCJwb3N0IiwibmFtZSIsIk51bWJlciIsImFyZ3MiXSwibWFwcGluZ3MiOiI7O0FBQUEsTUFBTUEsS0FBSyxHQUFHQyxPQUFPLENBQUMsT0FBRCxDQUFyQjtBQUVBOzs7Ozs7Ozs7OztBQVNBLE1BQU1DLEdBQUcsR0FBRyxPQUFPQyxNQUFQLEVBQWVDLEtBQWYsRUFBc0JDLEtBQUssR0FBRyxDQUE5QixLQUFvQztBQUM5QyxRQUFNQyxXQUFXLEdBQUcsTUFBTUMsRUFBRSxDQUFDQyxJQUFILENBQVFDLG9CQUFSLENBQTZCQyxLQUFLLENBQUNDLEtBQW5DLENBQTFCO0FBQ0EsUUFBTVgsS0FBSyxDQUFDWSxJQUFOLENBQ0osbUNBREksRUFFSjtBQUFFQyxJQUFBQSxJQUFJLEVBQUcsR0FBRVYsTUFBTyxJQUFHQyxLQUFNLEVBQTNCO0FBQThCQyxJQUFBQSxLQUFLLEVBQUVTLE1BQU0sQ0FBQ1QsS0FBRDtBQUEzQyxHQUZJLEVBR0pDLFdBSEksQ0FBTjtBQUtELENBUEQ7O0FBU0EsT0FBT0osR0FBRyxDQUFDYSxJQUFJLENBQUNaLE1BQU4sRUFBY1ksSUFBSSxDQUFDWCxLQUFuQixFQUEwQlcsSUFBSSxDQUFDVixLQUEvQixDQUFWIiwic291cmNlUm9vdCI6Ii92YXIvbGliL2plbmtpbnMvd29ya3NwYWNlL2J1aWxkLWxpbnV4L21vZHVsZXMvYW5hbHl0aWNzL3NyYy9iYWNrZW5kIiwic291cmNlc0NvbnRlbnQiOlsiY29uc3QgYXhpb3MgPSByZXF1aXJlKCdheGlvcycpXG5cbi8qKlxuICogU2V0cyB0aGUgYWJzb2x1dGUgdmFsdWUgb2YgYSBzcGVjaWZpYyBtZXRyaWMgZ3JvdXAuXG4gKlxuICogQHRpdGxlIFNldCBDdXN0b20gTWV0cmljXG4gKiBAY2F0ZWdvcnkgQW5hbHl0aWNzXG4gKiBAcGFyYW0ge3N0cmluZ30gbWV0cmljIFRoZSBuYW1lIG9mIHRoZSBtZXRyaWNcbiAqIEBwYXJhbSB7c3RyaW5nfSBbZ3JvdXA9YWxsXSBPcHRpb25hbCBncm91cCBpbnNpZGUgdGhlIG1ldHJpY3NcbiAqIEBwYXJhbSB7TnVtYmVyfSBbY291bnQ9MV0gVGhlIGFic29sdXRlIHZhbHVlIHRvIHNldFxuICovXG5jb25zdCBzZXQgPSBhc3luYyAobWV0cmljLCBncm91cCwgY291bnQgPSAxKSA9PiB7XG4gIGNvbnN0IGF4aW9zQ29uZmlnID0gYXdhaXQgYnAuaHR0cC5nZXRBeGlvc0NvbmZpZ0ZvckJvdChldmVudC5ib3RJZClcbiAgYXdhaXQgYXhpb3MucG9zdChcbiAgICAnL21vZC9hbmFseXRpY3MvY3VzdG9tX21ldHJpY3Mvc2V0JyxcbiAgICB7IG5hbWU6IGAke21ldHJpY31+JHtncm91cH1gLCBjb3VudDogTnVtYmVyKGNvdW50KSB9LFxuICAgIGF4aW9zQ29uZmlnXG4gIClcbn1cblxucmV0dXJuIHNldChhcmdzLm1ldHJpYywgYXJncy5ncm91cCwgYXJncy5jb3VudClcbiJdfQ==