"use strict";

const axios = require('axios');
/**
 * Update the session nluContexts for a specific intent
 * @hidden
 * @param intentName The name of the intent to get contexts from
 */


const updateContexts = async intentName => {
  const botId = event.botId;
  const axiosConfig = await bp.http.getAxiosConfigForBot(botId);
  const {
    data
  } = await axios.get(`/mod/nlu/intents/${intentName}`, axiosConfig);
  const nluContexts = data.contexts.map(context => {
    return {
      context,
      ttl: 1000
    };
  });
  event.state.session.nluContexts = nluContexts;
};

return updateContexts(args.intentName);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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