"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _lodash = _interopRequireDefault(require("lodash"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const outgoingTypes = ['text', 'typing', 'login_prompt', 'file', 'carousel', 'custom', 'data'];

var _default = async (bp, db) => {
  const config = {}; // FIXME

  const {
    botName = 'Bot',
    botAvatarUrl = undefined
  } = config || {}; // FIXME

  bp.events.registerMiddleware({
    description: 'Sends out messages that targets platform = webchat.' + ' This middleware should be placed at the end as it swallows events once sent.',
    direction: 'outgoing',
    handler: outgoingHandler,
    name: 'web.sendMessages',
    order: 100
  });

  async function outgoingHandler(event, next) {
    if (event.channel !== 'web') {
      return next();
    }

    const messageType = event.type === 'default' ? 'text' : event.type;
    const userId = event.target;
    const conversationId = event.threadId || (await db.getOrCreateRecentConversation(event.botId, userId));

    if (!_lodash.default.includes(outgoingTypes, messageType)) {
      return next(new Error('Unsupported event type: ' + event.type));
    }

    const standardTypes = ['text', 'carousel', 'custom', 'file', 'login_prompt'];

    if (!event.payload.type) {
      event.payload.type = messageType;
    }

    if (messageType === 'typing') {
      const typing = parseTyping(event.payload.value);
      const payload = bp.RealTimePayload.forVisitor(userId, 'webchat.typing', {
        timeInMs: typing,
        conversationId
      }); // Don't store "typing" in DB

      bp.realtime.sendPayload(payload);
      await Promise.delay(typing);
    } else if (messageType === 'data') {
      const payload = bp.RealTimePayload.forVisitor(userId, 'webchat.data', event.payload);
      bp.realtime.sendPayload(payload);
    } else if (standardTypes.includes(messageType)) {
      const message = await db.appendBotMessage(botName, botAvatarUrl, conversationId, event.payload);
      bp.realtime.sendPayload(bp.RealTimePayload.forVisitor(userId, 'webchat.message', message));
    } else {
      throw new Error(`Message type "${messageType}" not implemented yet`);
    }

    next(undefined, false); // TODO Make official API (BotpressAPI.events.updateStatus(event.id, 'done'))
  }
};

exports.default = _default;

function parseTyping(typing) {
  if (isNaN(typing)) {
    return 1000;
  }

  return Math.max(typing, 500);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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