#!/bin/sh

# Copyright (C) 2010 Help/Systems LLC, All Rights Reserved
# This script is used to start/run Java processes in a UNIX shell scripting
#    environment. 

WORKING_DIR=`dirname $0`

JAVA_HOME=XXX

PS1=`hostname`:
export PS1
TERM=dumb
export TERM
# Import any custom environment settings the customer would like to use
if [ -r myenv.sh ]; then
    . ./myenv.sh "$@" 
fi

JAVA_EXEC=${JAVA_HOME}/bin/java
if [ ! -f ${JAVA_EXEC} ]; then
    echo "The java executable does not exist: ${JAVA_EXEC}"
    exit 1
fi

if [ ! -x ${JAVA_EXEC} ]; then
    echo "Unable to run java: ${JAVA_EXEC}"
    exit 1
fi

if [ $# -lt 1 ]; then
    echo Please specify the Java class to be run, and any optional arguments.
    exit 1
fi

if [ -z "$LIB_DIR" ]; then
    # LIB_DIR hasn't defined yet. Use the default.
    LIB_DIR=lib
fi

LIB_PREFIX_NEEDED=`echo $LIB_DIR | grep /`
# If there's no "/" in the LIB_DIR, then it's a relative path, and we need to 
#   figure out the absolute path.
if [ -z "$LIB_PREFIX_NEEDED" ]; then
    LIB_DIR=${WORKING_DIR}/${LIB_DIR}
fi
    

if [ ! -d "$LIB_DIR" ]; then
    echo The directory $LIB_DIR does not exist.
    exit 1
fi

# Build a dynamic list of all the jar files in the LIB directory
liblist=`ls $LIB_DIR/*.jar`
CLASSPATH=.
for i in ${liblist}; do
    CLASSPATH=${CLASSPATH}:${i}
done

if [ -z "${COMPUTERNAME}" ]; then
    # Cheap hack to make UNIX systems use the same env var as Windows.
    COMPUTERNAME=`hostname`
fi
export COMPUTERNAME

JAVA_FLAGS=""

. $WORKING_DIR/sysinfo.sh
if [ "${OP_SYS}" = "HP-UX" ]; then
    JAVA_FLAGS="-d64"
fi

if [ "${OP_SYS}" = "SunOS" -a "${BIT_WIDTH}" = "64" ]; then
    JAVA_FLAGS="-d${BIT_WIDTH}"
fi

OUR_LIB_PATH=bin/${OP_SYS}/${PROCESSOR}
# A long list of pre-defined generic java flags. The caller can override
#    these settings by setting the JAVA_OPTS variable.
GENERIC_JAVA_OPTS="-Djava.library.path=${OUR_LIB_PATH} -Dhelpsystems.module.dir=$LIB_DIR -Djava.awt.headless=true -XX:+HeapDumpOnOutOfMemoryError" 

LD_LIBRARY_PATH=${OUR_LIB_PATH}:${LD_LIBRARY_PATH}
export LD_LIBRARY_PATH

#SECURITY_SETTINGS=`uname`SSL.security
#if [ -f ${SECURITY_SETTINGS} ]; then
#    GENERIC_JAVA_OPTS="${GENERIC_JAVA_OPTS} -Djava.security.properties=${SECURITY_SETTINGS}"
#fi

exec ${JAVA_EXEC} ${JAVA_FLAGS} -cp ${CLASSPATH} ${GENERIC_JAVA_OPTS} ${JAVA_OPTS} "$@" 
EXIT_CODE=$?

# use java's exit code as our own.
exit $EXIT_CODE
