#!/bin/sh

# Copyright (C) 2009 Help/Systems LLC, All Rights Reserved
# Allows user to send a FTP from or to an Agent.

WORKING_DIR=`dirname $0`
logDebug="false"
MAIN_CLASS="com.helpsystems.enterprise.module.filetransfer.FileTransferWorker"

# Initialize a verbose parameter
# "verbose=" to turn off verbose mode
# "verbose=-v" to turn on verbose mode
verbose=

# initialize empty parm flags
CFG_FILE=${WORKING_DIR}/agent.xml
COMMAND=ftp
parm_d=:put
parm_r=
parm_a=
parm_e=:yes
parm_t=:binary
parm_m=
parm_y=
parm_u=
parm_w=
parm_s=
parm_p=
parm_c=
parm_g=
parm_i=
parm_l=
parm_b=
parm_k=

# ------------------------------------------------------------------------
# Function: Log an error message                                         -
# ------------------------------------------------------------------------
logError() {
  printf "$1\n">&2
}

# ------------------------------------------------------------------------
# Function: Log an info message                                         -
# ------------------------------------------------------------------------
logInfo() {
  printf "$1\n"
}

# ------------------------------------------------------------------------
# Function: Log a debug message                                          -
# ------------------------------------------------------------------------
debugMsg() {
  if test "$logDebug" = "true"
  then 
    logInfo "DEBUG: $1"
  fi
}

# ------------------------------------------------------------------------
# Function: Show Usage Text                                              -
# ------------------------------------------------------------------------
showUsageText() {
  logInfo "Usage: $0 [-f <agent_config_file>]

          -d:<put|get>               the direction (put or get)
          -r:<remote file name>      the remote file name
          -a:<local file name>       the local file name
          -e:<yes|no>                replace an existing file
          -t:<binary|text>           the transfer mode
          -m:<ftp|ftps|sftp>         the transfer protocol
          -y:<host name>             the remote system host name
          -p:<port>                  the port of the remote server
          -u:<user name>             the user name on the remote system
          -w:<password>              the password for the remote user, which is 
                                     encrypted when password salt is specified
          [-s:<password salt>]       the password salt for password encryption
          -c:<yes|no>                unknown host challenge
          -i:<yes|no>                implicit security mode
          -l:<yes|no>                delete source file after transfer
		  -g:<site command>          the site command
		  -b:<Authentication type>   The authentication type [1:2] 1 for username/password 2 for private/public key
		  -k:<private key path>      The private key file path
  "
  logInfo ""
}

# ------------------------------------------------------------------------
# Function: Show Help Text                                               -
# ------------------------------------------------------------------------
showHelpText() {
  logInfo "Transfers files to/from a remote system using FTP, SFTP, or FTPS"
  logInfo ""
  showUsageText
}

# ------------------------------------------------------------------------
# Main Line Code.                                                        -
# ------------------------------------------------------------------------

if [ $# -eq 0 ]; then
  logError "Host information and file parameters are required."
  showUsageText
  exit 1
fi

if [ "$1" = "--help" ]; then
  showHelpText
  exit 0
fi

#Check for config file first
if [ "$1" = "-f" ]; then
   if [ -z "$2" ]; then
     echo "Error: A configuration file must follow the -f parameter"
     exit 1
   fi
fi

while getopts :hvf:d:r:a:e:t:m:y:u:w:s:p:c:i:g:l:b:k: opt
  do
    case $opt in
    h)   showHelpText
         exit 0
         ;;
    v)   verbose=-v
         debugMsg "Setting on verbose mode"
         ;;
    f)   CFG_FILE=${WORKING_DIR}/$OPTARG
         debugMsg "Config file: $CFG_FILE"
         ;;
    d)   parm_d=$OPTARG
         debugMsg "parm_d: $parm_d"
         ;;
    r)   parm_r=$OPTARG
         debugMsg "parm_r: $parm_r"
         ;;
    a)   parm_a=$OPTARG
         debugMsg "parm_a: $parm_a"
         ;;
    e)   parm_e=$OPTARG
         debugMsg "parm_e: $parm_e"
         ;;
    t)   parm_t=$OPTARG
         debugMsg "parm_t: $parm_t"
         ;;
    m)   parm_m=$OPTARG
         debugMsg "parm_m: $parm_m"
         ;;
    y)   parm_y=$OPTARG
         debugMsg "parm_y: $parm_y"
         ;;
    u)   parm_u=$OPTARG
         debugMsg "parm_u: $parm_u"
         ;;
    w)   parm_w=$OPTARG
         debugMsg "parm_w: $parm_w"
         ;;
    s)   parm_s=$OPTARG
         debugMsg "parm_s: $parm_s"
         ;;
    p)   parm_p=$OPTARG
         debugMsg "parm_p: $parm_p"
         ;;
    c)   parm_c=$OPTARG
         debugMsg "parm_c: $parm_c"
         ;;
    i)   parm_i=$OPTARG
         debugMsg "parm_i: $parm_i"
         ;;
	g)   parm_g=$OPTARG
         debugMsg "parm_g: $parm_g"
         ;;
	l)   parm_l=$OPTARG
         debugMsg "parm_l: $parm_l"
         ;;		
    b)   parm_b=$OPTARG
         debugMsg "parm_b: $parm_b"
         ;;
	k)   parm_k=$OPTARG
         debugMsg "parm_k: $parm_k"
         ;;		 		 
    esac
  done

debugMsg "----------------------------------------------------------------"
debugMsg "- Verbose flag  . . . . . . : ${verbose}"
debugMsg "- Secure flag . . . . . . . : ${parm_x}"
debugMsg "- Using config file . . . . : ${CFG_FILE}"
debugMsg "- Sending Command . . . . . : ${COMMAND}"
debugMsg "- D-Parmateter  . . . . . . : ${parm_d}"
debugMsg "- R-Parameter . . . . . . . : ${parm_r}"
debugMsg "- A-Parameter . . . . . . . : ${parm_a}"
debugMsg "- E-Parameter . . . . . . . : ${parm_e}"
debugMsg "- T-Parameter . . . . . . . : ${parm_t}"
debugMsg "- M-Parameter . . . . . . . : ${parm_m}"
debugMsg "- Y-Parameter . . . . . . . : ${parm_y}"
debugMsg "- U-Parameter . . . . . . . : ${parm_u}"
debugMsg "- W-Parameter . . . . . . . : ${parm_w}"
debugMsg "- S-Parameter . . . . . . . : ${parm_s}"
debugMsg "- P-Parameter . . . . . . . : ${parm_p}"
debugMsg "- C-Parameter . . . . . . . : ${parm_c}"
debugMsg "- I-Parameter . . . . . . . : ${parm_i}"
debugMsg "- G-Parameter . . . . . . . : ${parm_g}"
debugMsg "- L-Parameter . . . . . . . : ${parm_l}"
debugMsg "- B-Parameter . . . . . . . : ${parm_b}"
debugMsg "- K-Parameter . . . . . . . : ${parm_k}"

debugMsg "----------------------------------------------------------------"

PATH=$PATH:/usr/ucb



if [ ! -f "${CFG_FILE}" ]; then
    logError "The config file ${CFG_FILE} does not exist. Command failed."
    exit 1
fi

if [ ! -r "${CFG_FILE}" ]; then
    echo "The config file $CFG_FILE is not readable by the current user."
    exit 1
fi

# Parameter notes:
# - There are double quotes around the parms that could contain embedded blanks.
# - The verbose parameter is not quoted because it is optional.
${WORKING_DIR}/runjava.sh $MAIN_CLASS -d"${parm_d}" -r"${parm_r}" -a"${parm_a}" -e"${parm_e}" -t"${parm_t}" -m"${parm_m}" -y"${parm_y}" -u"${parm_u}" -p"${parm_p}" -c"${parm_c}" -i"${parm_i}" -g"${parm_g}" -l"${parm_l}" -b"${parm_b}" -k"${parm_k}" ${verbose}
