#!/bin/sh

# This script grants permission for the currently running
#   Automate Schedule Agent's PID to use the 'nopwd' no-password/setuid program
#   to switch to another user without having the user's password.
# Copyright (C) 2012  Help/Systems, LLC

PATH=$PATH:/usr/ucb

if [ `whoami` != "root" ] ; then
    echo "This script must be started by \"root\""
    exit 1
fi

WORKING_DIR=`dirname $0`
cd ${WORKING_DIR}
FULL_DIR=`pwd`
. ./sysinfo.sh

HOSTNAME="`uname -n`"
PID_FILE=agent.xml.pid

while [ $# -ne 0 ]; do
   if [ "$1" = "-f" ]; then
       if [ -n "$2" ]; then
           PID_FILE=$2.pid
           shift
       else
           echo "Error: A configuration file must follow the -f parameter."
           exit 1
       fi
   else
      echo Undefined parameter: $1
   fi
   shift
done

PID=0
processExists=0
retry=10

echo Using Automate Schedule Agent Process ID File: $PID_FILE

while [ $retry -gt 0 ]; do
    if [ -f "$PID_FILE" ]; then
        PID=`cat $PID_FILE`
        count=`ps -p $PID | wc -l 2>/dev/null`
        status=$?
        if [ $status -eq 0 -a $count -eq 2 ]; then
            processExists=1
            break
        fi
    fi
    let "retry=retry-1"
    sleep 1
done

if [ $processExists -eq 0 ]; then
    if [ ! -f "$PID_FILE" ]; then
        echo The Automate Schedule Agent is not currently running.
    else 
        echo The Automate Schedule Agent process $PID is not currently active.
        echo Please restart the Automate Schedule Agent and try again.
    fi
    exit 1
fi

PS_FLAGS='-fjp'
if [ "Darwin" = "$OP_SYS" ]; then
    PS_FLAGS='-jp'
fi

PINFO=`$PS $PS_FLAGS $PID | tail -1`
POWNER=`echo $PINFO |  awk '{ print $1 }'`
PGID=`echo $PINFO | awk '{ print $4 }'`
if [ $PID -ne $PGID ]; then
    echo "The agent cannot be reliably secured because its PID $PID "
    echo "    does not match its Process-Group ID ${PGID}:"
    $PS -fjp $PID
    exit 1
fi

PROG=bin/${OP_SYS}/${PROCESSOR}/nopwd
chown root $PROG
chmod 4750 $PROG

SID=0
PID=0

auth_dir="authorized-agents"
auth_base="$PID:$PGID:$SID:$HOSTNAME"
umask 027
rm -f ${auth_dir}/*
./runjava.sh com.helpsystems.enterprise.peer.Hash "$auth_base" 
