/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.varia;

import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;

public class PropertyFilter
extends Filter {
    private Hashtable properties;

    public void setProperties(String props) {
        this.properties = this.parseProperties(props);
    }

    public int decide(LoggingEvent event) {
        Hashtable eventProps = event.getProperties();
        eventProps = eventProps == null ? new Hashtable() : new Hashtable(this.properties);
        this.properties.putAll(eventProps);
        event.setProperties(this.properties);
        return 0;
    }

    private Hashtable parseProperties(String props) {
        Hashtable<String, String> hashTable = new Hashtable<String, String>();
        StringTokenizer pairs = new StringTokenizer(props, ",");
        while (pairs.hasMoreTokens()) {
            StringTokenizer entry = new StringTokenizer(pairs.nextToken(), "=");
            hashTable.put(entry.nextElement().toString().trim(), entry.nextElement().toString().trim());
        }
        return hashTable;
    }
}

