/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.varia;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.plugins.Receiver;
import org.apache.log4j.rule.ExpressionRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class LogFilePatternReceiver
extends Receiver {
    public static final String TIMESTAMP = "TIMESTAMP";
    public static final String LOGGER = "LOGGER";
    public static final String LEVEL = "LEVEL";
    public static final String THREAD = "THREAD";
    public static final String CLASS = "CLASS";
    public static final String FILE = "FILE";
    public static final String LINE = "LINE";
    public static final String METHOD = "METHOD";
    public static final String RELATIVETIME = "RELATIVETIME";
    public static final String MESSAGE = "MESSAGE";
    public static final String WILDCARD = "*";
    private static final String TAB = "\t";
    private static final String PROP_PREFIX = "PROP(";
    private static final String PROP_SUFFIX = ")";
    private final List keywords = new ArrayList();
    private final List logFormatFields = new ArrayList();
    private final Map defaultMap = new HashMap();
    private SimpleDateFormat dateFormat;
    private String timestampFormat = "yyyy-MM-d HH:mm:ss,SSS";
    private String logFormat;
    private String fileURL;
    private String shortFileName;
    private boolean tailing;
    private String filterExpression;
    private Rule expressionRule;

    public LogFilePatternReceiver() {
        this.defaultMap.put(LOGGER, "Unknown");
        this.keywords.add(TIMESTAMP);
        this.keywords.add(LOGGER);
        this.keywords.add(LEVEL);
        this.keywords.add(THREAD);
        this.keywords.add(CLASS);
        this.keywords.add(FILE);
        this.keywords.add(LINE);
        this.keywords.add(METHOD);
        this.keywords.add(WILDCARD);
        this.keywords.add(RELATIVETIME);
        this.keywords.add(MESSAGE);
    }

    public static void main(String[] stringArray) {
        LogFilePatternReceiver logFilePatternReceiver = new LogFilePatternReceiver();
        logFilePatternReceiver.setTimestampFormat("yyyy-MM-d HH:mm:ss,SSS");
        logFilePatternReceiver.setFileURL(stringArray[0]);
        logFilePatternReceiver.initialize();
        try {
            logFilePatternReceiver.process(new InputStreamReader(new URL(logFilePatternReceiver.getFileURL()).openStream()));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public String getFileURL() {
        return this.fileURL;
    }

    public void setFileURL(String string) {
        this.fileURL = string;
        try {
            this.shortFileName = new URL(string).getFile();
        }
        catch (MalformedURLException malformedURLException) {
            this.shortFileName = string;
        }
    }

    public String getFilterExpression() {
        return this.filterExpression;
    }

    public void setFilterExpression(String string) {
        this.filterExpression = string;
    }

    public boolean isTailing() {
        return this.tailing;
    }

    public void setTailing(boolean bl) {
        this.tailing = bl;
    }

    public String getLogFormat() {
        return this.logFormat;
    }

    public void setLogFormat(String string) {
        this.logFormat = string;
    }

    public void setTimestampFormat(String string) {
        this.timestampFormat = string;
    }

    public String getTimestampFormat() {
        return this.timestampFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        LinkedList<String> linkedList = new LinkedList<String>();
        String string = null;
        while (true) {
            LoggingEvent loggingEvent;
            String[] stringArray;
            Object object;
            if ((string = bufferedReader.readLine()) != null) {
                if (string.length() == 0) continue;
                linkedList.addLast(string);
                if (linkedList.size() <= 2) continue;
                if (string.startsWith(TAB)) {
                    object = (String)linkedList.remove(0);
                    while (string != null && string.startsWith(TAB)) {
                        string = bufferedReader.readLine();
                        if (string == null || string.length() == 0) continue;
                        linkedList.addLast(string);
                    }
                    String string2 = (String)linkedList.getLast();
                    if (string2 != null && !string2.startsWith(TAB)) {
                        linkedList.removeLast();
                    }
                    stringArray = new String[linkedList.size()];
                    int n = linkedList.size();
                    for (int i = 0; i < n; ++i) {
                        stringArray[i] = (String)linkedList.remove(0);
                    }
                    if (string2 != null && !string2.startsWith(TAB)) {
                        linkedList.addLast(string2);
                    }
                    if ((loggingEvent = this.convertToEvent((String)object, stringArray)) == null) continue;
                    if (this.expressionRule != null) {
                        if (!this.expressionRule.evaluate(loggingEvent)) continue;
                        this.doPost(loggingEvent);
                        continue;
                    }
                    this.doPost(loggingEvent);
                    continue;
                }
                object = this.convertToEvent((String)linkedList.remove(0));
                if (object == null) continue;
                if (this.expressionRule != null) {
                    if (!this.expressionRule.evaluate((LoggingEvent)object)) continue;
                    this.doPost((LoggingEvent)object);
                    continue;
                }
                this.doPost((LoggingEvent)object);
                continue;
            }
            int n = linkedList.size();
            for (int i = 0; i < n; ++i) {
                stringArray = (String[])linkedList.remove(0);
                if (stringArray == null || stringArray.length() <= 0 || (loggingEvent = this.convertToEvent((String)stringArray)) == null) continue;
                if (this.expressionRule != null) {
                    if (!this.expressionRule.evaluate(loggingEvent)) continue;
                    this.doPost(loggingEvent);
                    continue;
                }
                this.doPost(loggingEvent);
            }
            try {
                object = this;
                synchronized (object) {
                    this.wait(2000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.tailing) break;
        }
        try {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private Map extractEventFields(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>(this.defaultMap);
        for (int i = 0; i < this.logFormatFields.size(); ++i) {
            String string2;
            String string3 = (String)this.logFormatFields.get(i);
            if (string3.equals(WILDCARD)) {
                string2 = (String)this.logFormatFields.get(i + 1);
                if (string.indexOf(string2) == -1) {
                    LogLog.info(string2 + " does not exist in line - ignoring: " + string);
                    return null;
                }
                string = string.substring(string.indexOf(string2));
                continue;
            }
            if (string3.equals(TIMESTAMP)) {
                string2 = (String)this.logFormatFields.get(i + 1);
                if (string.indexOf(string2) == -1) {
                    LogLog.info(string2 + " does not exist in line - ignoring: " + string);
                    return null;
                }
                int n = string.substring(0, this.timestampFormat.length()).length() - 1;
                int n2 = n + string.substring(n - 1).indexOf(string2) - 1;
                int n3 = Math.max(n, n2);
                hashMap.put(string3, string.substring(0, n3));
                string = string.substring(n3);
                continue;
            }
            if (this.keywords.contains(string3) || string3.startsWith(PROP_PREFIX)) {
                string = string.trim();
                if (i < this.logFormatFields.size() - 1) {
                    string2 = (String)this.logFormatFields.get(i + 1);
                    if (string.indexOf(string2) == -1) {
                        LogLog.info(string2 + " does not exist in line - ignoring: " + string);
                        return null;
                    }
                    hashMap.put(string3, string.substring(0, string.indexOf(string2)).trim());
                    string = string.substring(string.indexOf(string2));
                    continue;
                }
                hashMap.put(string3, string.trim());
                continue;
            }
            string = string.substring(string3.length());
        }
        return hashMap;
    }

    private LoggingEvent convertToEvent(String string) {
        return this.convertToEvent(string, null);
    }

    private LoggingEvent convertToEvent(String string, String[] stringArray) {
        return this.convertToEvent(this.extractEventFields(string), stringArray);
    }

    private LoggingEvent convertToEvent(Map map, String[] stringArray) {
        Object object;
        if (map == null) {
            return null;
        }
        if (stringArray == null) {
            stringArray = new String[]{""};
        }
        Logger logger = null;
        long l = 0L;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        Hashtable hashtable = new Hashtable();
        if (this.dateFormat != null && map.containsKey(TIMESTAMP)) {
            try {
                l = this.dateFormat.parse((String)map.get(TIMESTAMP)).getTime();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (l == 0L) {
            l = System.currentTimeMillis();
        }
        logger = Logger.getLogger((String)map.get(LOGGER));
        string = (String)map.get(LEVEL);
        string2 = (String)map.get(THREAD);
        string3 = (String)map.get(MESSAGE);
        string4 = (String)map.get(CLASS);
        string5 = (String)map.get(METHOD);
        string6 = (String)map.get(FILE);
        string7 = (String)map.get(LINE);
        if (map.get(RELATIVETIME) != null) {
            hashtable.put(RELATIVETIME, map.get(RELATIVETIME));
        }
        Level level = Level.toLevel(string);
        LocationInfo locationInfo = null;
        locationInfo = string6 != null || string4 != null || string5 != null || string7 != null ? new LocationInfo(string6, string4, string5, string7) : LocationInfo.NA_LOCATION_INFO;
        hashtable.put("hostname", "file");
        hashtable.put("application", this.shortFileName);
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (!((String)object).startsWith(PROP_PREFIX)) continue;
            String string8 = ((String)object).substring(PROP_PREFIX.length(), ((String)object).length() - 1).trim();
            hashtable.put(string8, map.get(object));
        }
        object = new LoggingEvent();
        ((LoggingEvent)object).setLogger(logger);
        ((LoggingEvent)object).setTimeStamp(l);
        ((LoggingEvent)object).setLevel(level);
        ((LoggingEvent)object).setThreadName(string2);
        ((LoggingEvent)object).setMessage(string3);
        ((LoggingEvent)object).setThrowableInformation(new ThrowableInformation(stringArray));
        ((LoggingEvent)object).setLocationInformation(locationInfo);
        ((LoggingEvent)object).setProperties(hashtable);
        return object;
    }

    public void activateOptions() {
        try {
            if (this.filterExpression != null) {
                this.expressionRule = ExpressionRule.getRule(this.filterExpression);
            }
        }
        catch (Exception exception) {
            LogLog.warn("Invalid filter expression: " + this.filterExpression, exception);
        }
        new Thread(new Runnable(){

            public void run() {
                LogFilePatternReceiver.this.initialize();
                try {
                    LogFilePatternReceiver.this.process(new InputStreamReader(new URL(LogFilePatternReceiver.this.getFileURL()).openStream()));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }).start();
    }

    private void initialize() {
        if (this.timestampFormat != null) {
            this.dateFormat = new SimpleDateFormat(this.timestampFormat);
        }
        int n = 0;
        int n2 = 0;
        while (n < this.logFormat.length()) {
            String string = this.endsInKeyword(this.logFormat.substring(n, n2));
            if (string != null) {
                String string2 = this.logFormat.substring(n, n2 - string.length());
                if (string2.length() > 0) {
                    this.logFormatFields.add(string2);
                }
                this.logFormatFields.add(string);
                n = n2++;
                continue;
            }
            ++n2;
        }
    }

    private String endsInKeyword(String string) {
        String string2 = string.trim();
        Iterator iterator = this.keywords.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (!string2.endsWith(string3)) continue;
            return string3;
        }
        if (string2.indexOf(PROP_PREFIX) > -1 && string2.endsWith(PROP_SUFFIX)) {
            return string2.substring(string2.indexOf(PROP_PREFIX));
        }
        return null;
    }

    public void shutdown() {
    }
}

