/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rule;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.apache.log4j.rule.AbstractRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.LoggingEventFieldResolver;

public class TimestampInequalityRule
extends AbstractRule {
    private static final LoggingEventFieldResolver resolver = LoggingEventFieldResolver.getInstance();
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private transient String inequalitySymbol;
    private long timeStamp;

    private TimestampInequalityRule(String string, String string2) {
        this.inequalitySymbol = string;
        try {
            this.timeStamp = dateFormat.parse(string2).getTime();
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("Could not parse date: " + string2);
        }
    }

    public static Rule getRule(String string, String string2) {
        return new TimestampInequalityRule(string, string2);
    }

    public boolean evaluate(LoggingEvent loggingEvent) {
        long l = Long.parseLong(resolver.getValue("TIMESTAMP", loggingEvent).toString()) / 1000L * 1000L;
        boolean bl = false;
        long l2 = l;
        long l3 = this.timeStamp;
        if ("<".equals(this.inequalitySymbol)) {
            bl = l2 < l3;
        } else if (">".equals(this.inequalitySymbol)) {
            bl = l2 > l3;
        } else if ("<=".equals(this.inequalitySymbol)) {
            bl = l2 <= l3;
        } else if (">=".equals(this.inequalitySymbol)) {
            bl = l2 >= l3;
        }
        return bl;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.inequalitySymbol = (String)objectInputStream.readObject();
        this.timeStamp = objectInputStream.readLong();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.inequalitySymbol);
        objectOutputStream.writeLong(this.timeStamp);
    }
}

