/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rule;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.apache.log4j.chainsaw.filter.FilterModel;
import org.apache.log4j.rule.ExpressionRule;
import org.apache.log4j.rule.ExpressionRuleContext;
import org.apache.log4j.rule.InFixToPostFix;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.LoggingEvent;

public class RuleTest
extends JFrame {
    Rule rule;
    FilterModel filterModel;

    public RuleTest(String string) {
        Serializable serializable;
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new BorderLayout());
        this.filterModel = new FilterModel();
        final ArrayList<LoggingEvent> arrayList = new ArrayList<LoggingEvent>();
        MDC.put("entry1", "123");
        arrayList.add(new LoggingEvent("org.apache.log4j.chainsaw", Logger.getLogger("logger1"), Level.DEBUG, "message1", new Exception("test")));
        MDC.put("entry2", "test1");
        arrayList.add(new LoggingEvent("org.apache.log4j.chainsaw", Logger.getLogger("logger2"), Level.DEBUG, "message2", new Exception("test2")));
        arrayList.add(new LoggingEvent("org.apache.log4j.net", Logger.getLogger("logger3"), Level.DEBUG, "message3", new Exception("test3")));
        MDC.put("test", "234");
        arrayList.add(new LoggingEvent("org.apache.log4j.chainsaw", Logger.getLogger("logger4"), Level.WARN, "message4", new Exception("test4")));
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            serializable = (LoggingEvent)iterator.next();
            this.filterModel.processNewLoggingEvent((LoggingEvent)serializable);
        }
        serializable = new JPanel(new GridLayout(5, 1));
        ((Container)serializable).add(new JLabel("Enter infix expression to convert to postfix: "));
        final JTextField jTextField = new JTextField(string);
        ((Container)serializable).add(jTextField);
        ExpressionRuleContext expressionRuleContext = new ExpressionRuleContext(this.filterModel, jTextField);
        jTextField.addKeyListener(expressionRuleContext);
        JButton jButton = new JButton("Convert InFix to PostFix");
        ((Container)serializable).add(jButton);
        JLabel jLabel = new JLabel("Results:");
        ((Container)serializable).add(jLabel);
        final JTextField jTextField2 = new JTextField();
        ((Container)serializable).add(jTextField2);
        jButton.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                InFixToPostFix inFixToPostFix = new InFixToPostFix();
                jTextField2.setText(inFixToPostFix.convert(jTextField.getText()));
                RuleTest.this.rule = ExpressionRule.getRule(jTextField2.getText(), true);
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        JButton jButton2 = new JButton("Evaluate postfix expression against collection of events: ");
        jPanel.add((Component)jButton2, "North");
        final JTextArea jTextArea = new JTextArea(5, 50);
        jPanel.add((Component)jTextArea, "Center");
        jButton2.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                jTextArea.setText("");
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    LoggingEvent loggingEvent = (LoggingEvent)iterator.next();
                    Iterator iterator2 = loggingEvent.getPropertyKeySet().iterator();
                    StringBuffer stringBuffer = new StringBuffer();
                    while (iterator2.hasNext()) {
                        String string = (String)iterator2.next();
                        stringBuffer.append(string);
                        stringBuffer.append(":");
                        stringBuffer.append(loggingEvent.getProperty(string));
                    }
                    jTextArea.setText(jTextArea.getText() + (jTextArea.getText().length() == 0 ? "" : "\n") + "level: " + loggingEvent.getLevel() + ", logger: " + loggingEvent.getLoggerName() + ", MDC: " + stringBuffer.toString() + " - result: " + RuleTest.this.rule.evaluate(loggingEvent));
                }
            }
        });
        this.getContentPane().add((Component)serializable, "North");
        this.getContentPane().add((Component)jPanel, "Center");
    }

    public static void main(String[] stringArray) {
        RuleTest ruleTest = new RuleTest("( level ~= deb ) && ( logger like logger[1-2] || PROP.entry1 >= 234 )");
        ruleTest.pack();
        ruleTest.setVisible(true);
    }
}

