/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rolling.helpers;

import java.util.Date;
import org.apache.log4j.Logger;
import org.apache.log4j.rolling.helpers.DateTokenConverter;
import org.apache.log4j.rolling.helpers.IdentityTokenConverter;
import org.apache.log4j.rolling.helpers.IntegerTokenConverter;
import org.apache.log4j.rolling.helpers.TokenConverter;

public class FileNamePattern {
    static Logger logger = Logger.getLogger(class$org$apache$log4j$rolling$helpers$FileNamePattern == null ? (class$org$apache$log4j$rolling$helpers$FileNamePattern = FileNamePattern.class$("org.apache.log4j.rolling.helpers.FileNamePattern")) : class$org$apache$log4j$rolling$helpers$FileNamePattern);
    String pattern;
    int patternLength;
    TokenConverter headTokenConverter;
    static /* synthetic */ Class class$org$apache$log4j$rolling$helpers$FileNamePattern;

    public FileNamePattern(String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("The argument to constrcutor cannot be null. ");
        }
        this.pattern = pattern;
        if (pattern != null) {
            this.patternLength = pattern.length();
            this.pattern = this.pattern.trim();
        }
        this.parse();
    }

    public String toString() {
        return this.pattern;
    }

    void parse() {
        int lastIndex = 0;
        TokenConverter tc = null;
        block5: while (true) {
            int i;
            if ((i = this.pattern.indexOf(37, lastIndex)) == -1) {
                String remainingStr = this.pattern.substring(lastIndex);
                this.addTokenConverter(tc, new IdentityTokenConverter(remainingStr));
                break;
            }
            if (i == this.patternLength - 1) {
                String remainingStr = this.pattern.substring(lastIndex);
                this.addTokenConverter(tc, new IdentityTokenConverter(remainingStr));
                break;
            }
            tc = this.addTokenConverter(tc, new IdentityTokenConverter(this.pattern.substring(lastIndex, i)));
            char nextChar = this.pattern.charAt(i + 1);
            switch (nextChar) {
                case 'i': {
                    tc = this.addTokenConverter(tc, new IntegerTokenConverter());
                    lastIndex = i + 2;
                    break;
                }
                case 'd': {
                    int optionEnd = this.getOptionEnd(i + 2);
                    if (optionEnd != -1) {
                        String option = this.pattern.substring(i + 3, optionEnd);
                        tc = this.addTokenConverter(tc, new DateTokenConverter(option));
                        lastIndex = optionEnd + 1;
                        break;
                    }
                    logger.warn("Could not parse option related to the %d conversion pattern");
                    tc = this.addTokenConverter(tc, new IdentityTokenConverter(this.pattern.substring(i)));
                    break block5;
                }
                case '%': {
                    tc = this.addTokenConverter(tc, new IdentityTokenConverter("%"));
                    lastIndex = i + 2;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("The pattern[" + this.pattern + "] does not contain a valid specifer at position " + (i + 1));
                }
            }
        }
    }

    protected int getOptionEnd(int i) {
        if (i < this.patternLength && this.pattern.charAt(i) == '{') {
            int end = this.pattern.indexOf(125, i);
            if (end > i) {
                return end;
            }
            return -1;
        }
        return -1;
    }

    TokenConverter addTokenConverter(TokenConverter tc, TokenConverter newTokenConverter) {
        if (tc == null) {
            tc = this.headTokenConverter = newTokenConverter;
        } else {
            tc.next = newTokenConverter;
            tc = newTokenConverter;
        }
        return tc;
    }

    public DateTokenConverter getDateTokenConverter() {
        for (TokenConverter p = this.headTokenConverter; p != null; p = p.getNext()) {
            if (p.getType() != 1) continue;
            return (DateTokenConverter)p;
        }
        return null;
    }

    public String convert(int i) {
        StringBuffer buf = new StringBuffer();
        block4: for (TokenConverter p = this.headTokenConverter; p != null; p = p.getNext()) {
            switch (p.getType()) {
                case 0: {
                    buf.append(((IdentityTokenConverter)p).convert());
                    continue block4;
                }
                case 1: {
                    buf.append(((IntegerTokenConverter)p).convert(i));
                    continue block4;
                }
                default: {
                    logger.error("Encountered an unknown TokenConverter type for pattern [" + this.pattern + "].");
                }
            }
        }
        return buf.toString();
    }

    public String convert(Date date) {
        StringBuffer buf = new StringBuffer();
        block4: for (TokenConverter p = this.headTokenConverter; p != null; p = p.getNext()) {
            switch (p.getType()) {
                case 0: {
                    buf.append(((IdentityTokenConverter)p).convert());
                    continue block4;
                }
                case 1: {
                    buf.append(((DateTokenConverter)p).convert(date));
                    continue block4;
                }
                default: {
                    logger.error("Encountered an unknown TokenConverter type for pattern [" + this.pattern + "].");
                }
            }
        }
        return buf.toString();
    }

    public String getPattern() {
        return this.pattern;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

