/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rolling;

import java.io.File;
import java.util.Date;
import org.apache.log4j.Logger;
import org.apache.log4j.rolling.RollingPolicySkeleton;
import org.apache.log4j.rolling.RolloverFailure;
import org.apache.log4j.rolling.TriggeringPolicy;
import org.apache.log4j.rolling.helpers.Compress;
import org.apache.log4j.rolling.helpers.DateTokenConverter;
import org.apache.log4j.rolling.helpers.FileNamePattern;
import org.apache.log4j.rolling.helpers.RollingCalendar;
import org.apache.log4j.rolling.helpers.Util;

public class TimeBasedRollingPolicy
extends RollingPolicySkeleton
implements TriggeringPolicy {
    static final Logger logger = Logger.getLogger(class$org$apache$log4j$rolling$TimeBasedRollingPolicy == null ? (class$org$apache$log4j$rolling$TimeBasedRollingPolicy = TimeBasedRollingPolicy.class$("org.apache.log4j.rolling.TimeBasedRollingPolicy")) : class$org$apache$log4j$rolling$TimeBasedRollingPolicy);
    FileNamePattern fileNamePattern;
    String fileNamePatternStr;
    RollingCalendar rc;
    long nextCheck;
    Date now = new Date();
    String currentFileName = null;
    String activeFileName;
    static /* synthetic */ Class class$org$apache$log4j$rolling$TimeBasedRollingPolicy;

    public void activateOptions() {
        DateTokenConverter dtc;
        if (this.fileNamePatternStr != null) {
            int len = this.fileNamePatternStr.length();
            if (this.fileNamePatternStr.endsWith(".gz")) {
                logger.debug("Will use gz compression");
                this.fileNamePattern = new FileNamePattern(this.fileNamePatternStr.substring(0, len - 3));
                this.compressionMode = 1;
            } else if (this.fileNamePatternStr.endsWith(".zip")) {
                logger.debug("Will use zip compression");
                this.fileNamePattern = new FileNamePattern(this.fileNamePatternStr.substring(0, len - 4));
                this.compressionMode = 1;
            } else {
                this.fileNamePattern = new FileNamePattern(this.fileNamePatternStr);
                this.compressionMode = 0;
            }
        }
        if ((dtc = this.fileNamePattern.getDateTokenConverter()) == null) {
            throw new IllegalStateException("FileNamePattern [" + this.fileNamePattern.getPattern() + "] does not contain a valid DateToken");
        }
        this.rc = new RollingCalendar();
        this.rc.init(dtc.getDatePattern());
        logger.debug("The date pattern is [" + dtc.getDatePattern() + "] from file name pattern [" + this.fileNamePattern.getPattern() + "].");
        this.rc.printPeriodicity();
        long n = System.currentTimeMillis();
        this.now.setTime(n);
        this.nextCheck = this.rc.getNextCheckMillis(this.now);
    }

    public void rollover() throws RolloverFailure {
        logger.debug("rollover called");
        logger.debug("compressionMode: " + this.compressionMode);
        if (this.activeFileName == null) {
            if (this.currentFileName != null) {
                switch (this.compressionMode) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        logger.debug("Compressing [" + this.currentFileName + "]");
                        Compress.GZCompress(this.currentFileName);
                    }
                }
            }
        } else {
            switch (this.compressionMode) {
                case 0: {
                    Util.rename(this.activeFileName, this.currentFileName);
                    break;
                }
                case 1: {
                    logger.debug("Compressing [" + this.currentFileName + "]");
                    Compress.GZCompress(this.activeFileName, this.currentFileName);
                }
            }
        }
    }

    public String getActiveLogFileName() {
        logger.debug("getActiveLogFileName called");
        if (this.activeFileName == null) {
            return this.fileNamePattern.convert(this.now);
        }
        return this.activeFileName;
    }

    public void setFileNamePattern(String fnp) {
        this.fileNamePatternStr = fnp;
    }

    public boolean isTriggeringEvent(File file) {
        long n = System.currentTimeMillis();
        if (n >= this.nextCheck) {
            logger.debug("Time to trigger rollover");
            this.currentFileName = this.fileNamePattern.convert(this.now);
            this.now.setTime(n);
            this.nextCheck = this.rc.getNextCheckMillis(this.now);
            Date x = new Date();
            x.setTime(this.nextCheck);
            logger.debug("Next check: " + x);
            return true;
        }
        return false;
    }

    public String getActiveFileName() {
        return this.activeFileName;
    }

    public void setActiveFileName(String string) {
        this.activeFileName = string;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

