/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rolling;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.rolling.RollingPolicy;
import org.apache.log4j.rolling.RolloverFailure;
import org.apache.log4j.rolling.TriggeringPolicy;
import org.apache.log4j.spi.LoggingEvent;

public class RollingFileAppender
extends FileAppender {
    Logger logger = Logger.getLogger(class$org$apache$log4j$rolling$RollingFileAppender == null ? (class$org$apache$log4j$rolling$RollingFileAppender = RollingFileAppender.class$("org.apache.log4j.rolling.RollingFileAppender")) : class$org$apache$log4j$rolling$RollingFileAppender);
    File activeFile;
    TriggeringPolicy triggeringPolicy;
    RollingPolicy rollingPolicy;
    static /* synthetic */ Class class$org$apache$log4j$rolling$RollingFileAppender;

    public void activateOptions() {
        if (this.triggeringPolicy == null) {
            this.logger.warn("Please set a TriggeringPolicy for ");
            return;
        }
        if (this.rollingPolicy != null) {
            String afn = this.rollingPolicy.getActiveLogFileName();
            this.activeFile = new File(afn);
            this.logger.debug("Active log file name: " + afn);
            this.setFile(afn);
            this.activeFile = new File(afn);
            super.activateOptions();
        } else {
            this.logger.warn("Please set a rolling policy");
        }
    }

    public void rollover() {
        this.closeWriter();
        boolean append = false;
        try {
            this.rollingPolicy.rollover();
        }
        catch (RolloverFailure rf) {
            LogLog.warn("RolloverFailure occurred. Deferring rollover.");
            append = true;
        }
        this.fileName = this.rollingPolicy.getActiveLogFileName();
        this.logger.debug("Active file name is now [" + this.fileName + "].");
        this.activeFile = new File(this.fileName);
        try {
            this.setFile(this.fileName, append, this.bufferedIO, this.bufferSize);
        }
        catch (IOException e) {
            this.errorHandler.error("setFile(" + this.fileName + ", false) call failed.", e, 4);
        }
    }

    protected void subAppend(LoggingEvent event) {
        if (this.triggeringPolicy.isTriggeringEvent(this.activeFile)) {
            this.logger.debug("About to rollover");
            this.rollover();
        }
        super.subAppend(event);
    }

    public RollingPolicy getRollingPolicy() {
        return this.rollingPolicy;
    }

    public TriggeringPolicy getTriggeringPolicy() {
        return this.triggeringPolicy;
    }

    public void setRollingPolicy(RollingPolicy policy) {
        this.rollingPolicy = policy;
        if (this.rollingPolicy instanceof TriggeringPolicy) {
            this.triggeringPolicy = (TriggeringPolicy)((Object)policy);
        }
    }

    public void setTriggeringPolicy(TriggeringPolicy policy) {
        this.triggeringPolicy = policy;
        if (policy instanceof RollingPolicy) {
            this.rollingPolicy = (RollingPolicy)((Object)policy);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

