/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.net.AddressBased;
import org.apache.log4j.net.PortBased;
import org.apache.log4j.net.SocketNode;
import org.apache.log4j.net.SocketNodeEventListener;
import org.apache.log4j.plugins.Pauseable;
import org.apache.log4j.plugins.Plugin;
import org.apache.log4j.plugins.Receiver;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.LoggingEvent;

public class SocketReceiver
extends Receiver
implements Runnable,
PortBased,
Pauseable {
    private Map socketMap = new HashMap();
    private boolean paused;
    private boolean shutdown;
    private Thread rThread;
    protected int port;
    private ServerSocket serverSocket;
    private Vector socketList = new Vector();
    private SocketNodeEventListener listener = null;
    private List listenerList = Collections.synchronizedList(new ArrayList());

    public SocketReceiver() {
    }

    public SocketReceiver(int _port) {
        this.port = _port;
    }

    public SocketReceiver(int _port, LoggerRepository _repository) {
        this.port = _port;
        this.repository = _repository;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int _port) {
        this.port = _port;
    }

    public boolean isEquivalent(Plugin testPlugin) {
        if (testPlugin != null && testPlugin instanceof SocketReceiver) {
            SocketReceiver sReceiver = (SocketReceiver)testPlugin;
            return this.port == sReceiver.getPort() && super.isEquivalent(testPlugin);
        }
        return false;
    }

    public void activateOptions() {
        if (!this.isActive()) {
            this.rThread = new Thread(this);
            this.rThread.setDaemon(true);
            this.rThread.start();
            this.active = true;
            this.setShutdown(false);
        }
    }

    public synchronized void shutdown() {
        LogLog.debug(this.getName() + " received shutdown request");
        this.active = false;
        if (this.rThread != null) {
            this.rThread.interrupt();
            this.rThread = null;
        }
        this.doShutdown();
    }

    private synchronized void doShutdown() {
        this.active = false;
        LogLog.debug(this.getName() + " doShutdown called");
        this.closeServerSocket();
        this.closeAllAcceptedSockets();
        this.setShutdown(true);
    }

    private void closeServerSocket() {
        LogLog.debug(this.getName() + " closing server socket");
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.serverSocket = null;
    }

    private synchronized void closeAllAcceptedSockets() {
        for (int x = 0; x < this.socketList.size(); ++x) {
            try {
                ((Socket)this.socketList.get(x)).close();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.socketMap.clear();
        this.socketList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.closeServerSocket();
        this.closeAllAcceptedSockets();
        try {
            this.serverSocket = new ServerSocket(this.port);
        }
        catch (Exception e) {
            LogLog.error("error starting SocketReceiver (" + this.getName() + "), receiver did not start", e);
            this.active = false;
            this.setShutdown(true);
            return;
        }
        Socket socket = null;
        try {
            LogLog.debug("in run-about to enter while not interrupted loop");
            this.active = true;
            while (!this.rThread.isInterrupted()) {
                if (socket != null) {
                    LogLog.debug("socket not null - creating and starting socketnode");
                    this.socketList.add(socket);
                    SocketNode node = new SocketNode(socket, this);
                    List list = this.listenerList;
                    synchronized (list) {
                        Iterator iter = this.listenerList.iterator();
                        while (iter.hasNext()) {
                            SocketNodeEventListener listener = (SocketNodeEventListener)iter.next();
                            node.addSocketNodeEventListener(listener);
                        }
                    }
                    this.socketMap.put(socket, node);
                    new Thread(node).start();
                    socket = null;
                }
                LogLog.debug("waiting to accept socket");
                socket = this.serverSocket.accept();
                LogLog.debug("accepted socket");
            }
        }
        catch (Exception e) {
            LogLog.warn("exception while watching socket server in SocketReceiver (" + this.getName() + "), stopping");
        }
        LogLog.debug(this.getName() + " has exited the not interrupted loop");
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException e1) {
                LogLog.warn("socket exception caught - socket closed");
            }
        }
        LogLog.debug(this.getName() + " is exiting main run loop");
    }

    public Vector getConnectedSocketDetails() {
        Vector<SocketDetail> details = new Vector<SocketDetail>(this.socketList.size());
        Enumeration enumeration = this.socketList.elements();
        while (enumeration.hasMoreElements()) {
            Socket socket = (Socket)enumeration.nextElement();
            details.add(new SocketDetail(socket, (SocketNode)this.socketMap.get(socket)));
        }
        return details;
    }

    public SocketNodeEventListener getListener() {
        return this.listener;
    }

    public void addSocketNodeEventListener(SocketNodeEventListener listener) {
        this.listenerList.add(listener);
    }

    public void removeSocketNodeEventListener(SocketNodeEventListener listener) {
        this.listenerList.remove(listener);
    }

    public void setListener(SocketNodeEventListener listener) {
        this.removeSocketNodeEventListener(listener);
        this.addSocketNodeEventListener(listener);
        this.listener = listener;
    }

    private boolean isShutdown() {
        return this.shutdown;
    }

    private void setShutdown(boolean b) {
        this.shutdown = b;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean b) {
        this.paused = b;
    }

    public void doPost(LoggingEvent event) {
        if (!this.isPaused()) {
            super.doPost(event);
        }
    }

    public static class SocketDetail
    implements AddressBased,
    PortBased,
    Pauseable {
        private String address;
        private int port;
        private SocketNode socketNode;

        private SocketDetail(Socket socket, SocketNode socketNode) {
            this.address = socket.getInetAddress().getHostName();
            this.port = socket.getPort();
            this.socketNode = socketNode;
        }

        public String getAddress() {
            return this.address;
        }

        public int getPort() {
            return this.port;
        }

        public String getName() {
            return "Socket";
        }

        public boolean isActive() {
            return true;
        }

        public boolean isPaused() {
            return this.socketNode.isPaused();
        }

        public void setPaused(boolean paused) {
            this.socketNode.setPaused(paused);
        }
    }
}

