/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.net.PortBased;
import org.apache.log4j.spi.LoggingEvent;

public class MulticastAppender
extends AppenderSkeleton
implements PortBased {
    static final int DEFAULT_PORT = 9991;
    private static final int PACKET_LENGTH = 16384;
    String hostname;
    String remoteHost;
    String application;
    String overrideProperties = "true";
    int timeToLive;
    InetAddress address;
    int port = 9991;
    MulticastSocket outSocket;
    int count = 0;
    private String encoding;

    public MulticastAppender() {
    }

    public MulticastAppender(InetAddress address, int port) {
        this.address = address;
        this.remoteHost = address.getHostName();
        this.port = port;
        this.connect();
    }

    public MulticastAppender(String host, int port) {
        this(MulticastAppender.getAddressByName(host), port);
    }

    public void activateOptions() {
        try {
            this.hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhe) {
            try {
                this.hostname = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException uhe2) {
                this.hostname = "unknown";
            }
        }
        if (this.application == null) {
            this.application = System.getProperty("application");
        } else if (System.getProperty("application") != null) {
            this.application = this.application + "-" + System.getProperty("application");
        }
        this.connect();
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.cleanUp();
    }

    public void cleanUp() {
        if (this.outSocket != null) {
            try {
                this.outSocket.close();
            }
            catch (Exception e) {
                LogLog.error("Could not close outSocket.", e);
            }
            this.outSocket = null;
        }
    }

    void connect() {
        if (this.address == null) {
            return;
        }
        try {
            this.cleanUp();
            this.outSocket = new MulticastSocket();
            this.outSocket.setTimeToLive(this.timeToLive);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void append(LoggingEvent event) {
        if (event == null) {
            return;
        }
        if (this.address == null) {
            this.errorHandler.error("No remote host is set for MulticastAppender named \"" + this.name + "\".");
            return;
        }
        if (this.outSocket != null) {
            if (this.overrideProperties != null && this.overrideProperties.equalsIgnoreCase("true")) {
                event.setProperty("hostname", this.hostname);
                if (this.application != null) {
                    event.setProperty("application", this.application);
                }
            }
            try {
                StringBuffer buf = new StringBuffer(this.layout.format(event).trim());
                if (buf.length() < 16384) {
                    buf.append(new char[16384 - buf.length()]);
                }
                DatagramPacket dp = new DatagramPacket(buf.toString().getBytes(this.encoding), buf.length(), this.address, this.port);
                this.outSocket.send(dp);
                event.setProperty("hostname", null);
                event.setProperty("application", null);
            }
            catch (IOException e) {
                this.outSocket = null;
                LogLog.warn("Detected problem with Multicast connection: " + e);
            }
        }
    }

    static InetAddress getAddressByName(String host) {
        try {
            return InetAddress.getByName(host);
        }
        catch (Exception e) {
            LogLog.error("Could not find address of [" + host + "].", e);
            return null;
        }
    }

    public boolean requiresLayout() {
        return true;
    }

    public void setRemoteHost(String host) {
        this.address = MulticastAppender.getAddressByName(host);
        this.remoteHost = host;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setApplication(String app) {
        this.application = app;
    }

    public String getApplication() {
        return this.application;
    }

    public void setOverrideProperties(String overrideProperties) {
        this.overrideProperties = overrideProperties;
    }

    public String getOverrideProperties() {
        return this.overrideProperties;
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isActive() {
        return true;
    }
}

