/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.joran.action;

import org.apache.joran.ErrorItem;
import org.apache.joran.ExecutionContext;
import org.apache.joran.action.Action;
import org.apache.joran.helper.Option;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.plugins.Plugin;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.OptionHandler;
import org.xml.sax.Attributes;

public class PluginAction
extends Action {
    static final Logger logger = Logger.getLogger(class$org$apache$log4j$joran$action$PluginAction == null ? (class$org$apache$log4j$joran$action$PluginAction = PluginAction.class$("org.apache.log4j.joran.action.PluginAction")) : class$org$apache$log4j$joran$action$PluginAction);
    Plugin plugin;
    boolean inError = false;
    static /* synthetic */ Class class$org$apache$log4j$joran$action$PluginAction;
    static /* synthetic */ Class class$org$apache$log4j$plugins$Plugin;

    public void begin(ExecutionContext ec, String localName, Attributes attributes) {
        String className = attributes.getValue("class");
        try {
            logger.debug("About to instantiate plugin of type [" + className + "]");
            Object instance = OptionConverter.instantiateByClassName(className, class$org$apache$log4j$plugins$Plugin == null ? (class$org$apache$log4j$plugins$Plugin = PluginAction.class$("org.apache.log4j.plugins.Plugin")) : class$org$apache$log4j$plugins$Plugin, null);
            this.plugin = (Plugin)instance;
            String pluginName = attributes.getValue("name");
            if (Option.isEmpty(pluginName)) {
                logger.warn("No plugin name given for plugin of type " + className + "].");
            } else {
                this.plugin.setName(pluginName);
                logger.debug("plugin named as [" + pluginName + "]");
            }
            LoggerRepository repository = (LoggerRepository)ec.getObject(0);
            repository.getPluginRegistry().addPlugin(this.plugin);
            this.plugin.setLoggerRepository(repository);
            logger.debug("Pushing plugin on to the object stack.");
            ec.pushObject(this.plugin);
        }
        catch (Exception oops) {
            this.inError = true;
            logger.error("Could not create a plugin. Reported error follows.", oops);
            ec.addError(new ErrorItem("Could not create plugin of type " + className + "]."));
        }
    }

    public void end(ExecutionContext ec, String name) {
        Object o;
        if (this.inError) {
            return;
        }
        if (this.plugin instanceof OptionHandler) {
            this.plugin.activateOptions();
        }
        if ((o = ec.peekObject()) != this.plugin) {
            logger.warn("The object at the of the stack is not the plugin named [" + this.plugin.getName() + "] pushed earlier.");
        } else {
            logger.warn("Popping plugin named [" + this.plugin.getName() + "] from the object stack");
            ec.popObject();
        }
    }

    public void finish(ExecutionContext ec) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

