/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.helpers;

import java.io.IOException;
import java.io.Writer;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.apache.log4j.helpers.LogLog;

public class SyslogWriter
extends Writer {
    final int SYSLOG_PORT = 514;
    String syslogHost;
    private InetAddress address;
    private DatagramSocket ds;

    public SyslogWriter(String syslogHost) {
        this.syslogHost = syslogHost;
        try {
            this.address = InetAddress.getByName(syslogHost);
        }
        catch (UnknownHostException e) {
            LogLog.error("Could not find " + syslogHost + ". All logging will FAIL.", e);
        }
        try {
            this.ds = new DatagramSocket();
        }
        catch (SocketException e) {
            e.printStackTrace();
            LogLog.error("Could not instantiate DatagramSocket to " + syslogHost + ". All logging will FAIL.", e);
        }
    }

    public void write(char[] buf, int off, int len) throws IOException {
        this.write(new String(buf, off, len));
    }

    public void write(String string) throws IOException {
        byte[] bytes = string.getBytes();
        DatagramPacket packet = new DatagramPacket(bytes, bytes.length, this.address, 514);
        if (this.ds != null) {
            this.ds.send(packet);
        }
    }

    public void flush() {
    }

    public void close() {
    }
}

