/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.helpers;

import java.io.PrintWriter;

public class ReaderWriterLock {
    int readers = 0;
    int writers = 0;
    int waitingWriters = 0;
    PrintWriter printWriter;

    public ReaderWriterLock() {
    }

    public ReaderWriterLock(PrintWriter pw) {
        this.printWriter = pw;
    }

    public synchronized void getReadLock() {
        if (this.printWriter != null) {
            this.printMessage("Asking for read lock.");
        }
        while (this.writers > 0 || this.waitingWriters > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.printWriter != null) {
            this.printMessage("Got read lock.");
        }
        ++this.readers;
    }

    public synchronized void releaseReadLock() {
        if (this.printWriter != null) {
            this.printMessage("About to release read lock.");
        }
        --this.readers;
        if (this.waitingWriters > 0) {
            this.notifyAll();
        }
    }

    public synchronized void getWriteLock() {
        if (this.printWriter != null) {
            this.printMessage("Asking for write lock.");
        }
        ++this.waitingWriters;
        while (this.readers > 0 || this.writers > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.printWriter != null) {
            this.printMessage("Got write lock.");
        }
        --this.waitingWriters;
        ++this.writers;
    }

    public synchronized void releaseWriteLock() {
        if (this.printWriter != null) {
            this.printMessage("About to release write lock.");
        }
        --this.writers;
        this.notifyAll();
    }

    void printMessage(String msg) {
        this.printWriter.println(Thread.currentThread().getName() + " " + msg);
    }
}

