/*
 * Decompiled with CFR 0.152.
 */
package org.apache.joran.action;

import java.util.Stack;
import org.apache.joran.ErrorItem;
import org.apache.joran.ExecutionContext;
import org.apache.joran.Pattern;
import org.apache.joran.action.ActionData;
import org.apache.joran.action.ImplicitAction;
import org.apache.joran.helper.Option;
import org.apache.log4j.Logger;
import org.apache.log4j.config.PropertySetter;
import org.apache.log4j.helpers.Loader;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.OptionHandler;
import org.xml.sax.Attributes;

public class NestComponentIA
extends ImplicitAction {
    static final Logger logger = Logger.getLogger(class$org$apache$joran$action$NestComponentIA == null ? (class$org$apache$joran$action$NestComponentIA = NestComponentIA.class$("org.apache.joran.action.NestComponentIA")) : class$org$apache$joran$action$NestComponentIA);
    Stack actionDataStack = new Stack();
    static /* synthetic */ Class class$org$apache$joran$action$NestComponentIA;

    public boolean isApplicable(Pattern pattern, Attributes attributes, ExecutionContext ec) {
        String nestedElementTagName = pattern.peekLast();
        Object o = ec.peekObject();
        PropertySetter parentBean = new PropertySetter(o);
        int containmentType = parentBean.canContainComponent(nestedElementTagName);
        switch (containmentType) {
            case 0: {
                return false;
            }
            case 1: 
            case 2: {
                ActionData ad = new ActionData(parentBean, containmentType);
                this.actionDataStack.push(ad);
                return true;
            }
        }
        ec.addError(new ErrorItem("PropertySetter.canContainComponent returned " + containmentType));
        return false;
    }

    public void begin(ExecutionContext ec, String localName, Attributes attributes) {
        ActionData actionData = (ActionData)this.actionDataStack.peek();
        String className = attributes.getValue("class");
        if (Option.isEmpty(className = ec.subst(className))) {
            actionData.inError = true;
            String errMsg = "No class name attribute in <" + localName + ">";
            logger.error(errMsg);
            ec.addError(new ErrorItem(errMsg));
            return;
        }
        try {
            LogLog.debug("About to instantiate component <" + localName + "> of type [" + className + "]");
            actionData.nestedComponent = Loader.loadClass(className).newInstance();
            LogLog.debug("Pushing component <" + localName + "> on top of the object stack.");
            ec.pushObject(actionData.nestedComponent);
        }
        catch (Exception oops) {
            actionData.inError = true;
            String msg = "Could not create component <" + localName + ">.";
            LogLog.error(msg, oops);
            ec.addError(new ErrorItem(msg));
        }
    }

    public void end(ExecutionContext ec, String tagName) {
        Object o;
        logger.debug("entering end method");
        ActionData actionData = (ActionData)this.actionDataStack.pop();
        if (actionData.inError) {
            return;
        }
        if (actionData.nestedComponent instanceof OptionHandler) {
            ((OptionHandler)actionData.nestedComponent).activateOptions();
        }
        if ((o = ec.peekObject()) != actionData.nestedComponent) {
            logger.warn("The object on the top the of the stack is not the component pushed earlier.");
        } else {
            logger.warn("Removing component from the object stack");
            ec.popObject();
            switch (actionData.containmentType) {
                case 1: {
                    LogLog.debug("Setting [" + tagName + "] to parent of type [" + actionData.parentBean.getObjClass() + "]");
                    actionData.parentBean.setComponent(tagName, actionData.nestedComponent);
                    break;
                }
                case 2: {
                    LogLog.debug("Adding [" + tagName + "] to parent of type [" + actionData.parentBean.getObjClass() + "]");
                    actionData.parentBean.addComponent(tagName, actionData.nestedComponent);
                }
            }
        }
    }

    public void finish(ExecutionContext ec) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

