/*
 * Decompiled with CFR 0.152.
 */
package org.apache.joran;

import java.util.ArrayList;

public class Pattern {
    ArrayList components = new ArrayList();

    public Pattern() {
    }

    public Pattern(String p) {
        this();
        if (p == null) {
            return;
        }
        int lastIndex = 0;
        while (true) {
            int k;
            if ((k = p.indexOf(47, lastIndex)) == -1) break;
            String c = p.substring(lastIndex, k);
            if (c.length() > 0) {
                this.components.add(c);
            }
            lastIndex = k + 1;
        }
        this.components.add(p.substring(lastIndex));
    }

    public void push(String s) {
        this.components.add(s);
    }

    public int size() {
        return this.components.size();
    }

    public String get(int i) {
        return (String)this.components.get(i);
    }

    public void pop() {
        if (!this.components.isEmpty()) {
            this.components.remove(this.components.size() - 1);
        }
    }

    public String peekLast() {
        if (!this.components.isEmpty()) {
            int size = this.components.size();
            return (String)this.components.get(size - 1);
        }
        return null;
    }

    public int tailMatch(Pattern p) {
        String r;
        String l;
        if (p == null) {
            return 0;
        }
        int lSize = this.components.size();
        int rSize = p.components.size();
        if (lSize == 0 || rSize == 0) {
            return 0;
        }
        int minLen = lSize <= rSize ? lSize : rSize;
        int match = 0;
        for (int i = 1; i <= minLen && (l = (String)this.components.get(lSize - i)).equals(r = (String)p.components.get(rSize - i)); ++i) {
            ++match;
        }
        return match;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Pattern)) {
            return false;
        }
        Pattern r = (Pattern)o;
        if (r.size() != this.size()) {
            return false;
        }
        int len = this.size();
        for (int i = 0; i < len; ++i) {
            if (this.get(i).equals(r.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hc = 0;
        int len = this.size();
        for (int i = 0; i < len; ++i) {
            hc ^= this.get(i).hashCode();
        }
        return hc;
    }

    public String toString() {
        int size = this.components.size();
        String result = "";
        for (int i = 0; i < size; ++i) {
            result = result + "/" + this.components.get(i);
        }
        return result;
    }
}

