/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.scheduler.executors;

import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.dm.CalendarObjectDM;
import com.helpsystems.enterprise.core.logger.CrossAppenderLogger;
import com.helpsystems.enterprise.core.logger.Log4jID;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.messages.SystemMessage;
import com.helpsystems.enterprise.core.messages.SystemMessageQueue;
import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.FiscalCalendar;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class CalendarObjectExpirationRunner
implements Runnable {
    static Logger logger = Logger.getLogger(CalendarObjectExpirationRunner.class);
    private static final int START_WARNING = 28;
    private static final int FOUR_WEEK_WARNING = 28;
    private static final int THREE_WEEK_WARNING = 21;
    private static final int TWO_WEEK_WARNING = 14;
    private static final int LAST_WEEK_WARNING = 7;

    @Override
    public void run() {
        int n = 0;
        logger.debug((Object)"Checking for expiring Calendars...");
        Date date = new Date(System.currentTimeMillis());
        try {
            CalendarObjectDM calendarObjectDM = (CalendarObjectDM)ManagerRegistry.getManager((String)"ENTERPRISE.CalendarObjectDM");
            CalendarObject[] calendarObjectArray = calendarObjectDM.getList();
            if (calendarObjectArray != null && calendarObjectArray.length > 0) {
                for (int i = 0; i < calendarObjectArray.length; ++i) {
                    Object object;
                    CalendarObject calendarObject = calendarObjectArray[i];
                    if (!calendarObject.isNotifyBeforeExpiration()) continue;
                    Object object2 = 0;
                    boolean bl = false;
                    int n2 = -1;
                    if (calendarObject instanceof FiscalCalendar) {
                        object = (FiscalCalendar)calendarObject;
                        object2 = object.maximumDateDefined();
                    } else {
                        object = calendarObject.getOtherNonWorkdates();
                        if (((FiscalCalendar)object).length > 0) {
                            object2 = object[((FiscalCalendar)object).length - 1];
                        }
                    }
                    if (object2 > 0) {
                        object = new SimpleDateFormat("yyyyMMddhhmmss").parse(Integer.toString(object2, 0) + "235959");
                        long l = ((Date)object).getTime() - date.getTime();
                        double d = l / 86400000L;
                        n2 = (int)d;
                        if (logger.isTraceEnabled()) {
                            if (l >= 0L) {
                                logger.trace((Object)("Calendar " + calendarObject.getName() + " expires in " + n2 + " days (" + object + ")."));
                            } else {
                                logger.trace((Object)("Calendar " + calendarObject.getName() + " expired " + Math.abs(n2) + " days ago (" + object + ")."));
                            }
                        }
                        if (l >= 0L && n2 >= 0 && n2 <= 28) {
                            bl = true;
                        }
                    }
                    if (!bl) continue;
                    ++n;
                    this.sendExpiringNotification(calendarObject, n2);
                }
            }
        }
        catch (Exception exception) {
            this.sendFailedMessage(exception);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Found " + n + " Calendars expiring soon."));
        }
    }

    private void sendExpiringNotification(CalendarObject calendarObject, int n) {
        if (n == 28 || n == 28 || n == 21 || n == 14 || n <= 7) {
            ScheduleLogEntry scheduleLogEntry;
            String[] stringArray = new String[]{calendarObject.getName(), Integer.toString(n)};
            SystemMessage systemMessage = null;
            if (n > 0) {
                if (n > 1) {
                    scheduleLogEntry = RosettaMsg.CALENDAR_OBJECT_EXPIRING_DAYS.newLogEntry(stringArray);
                    systemMessage = RosettaMsg.CALENDAR_OBJECT_EXPIRING_DAYS.newSystemMessage(stringArray);
                } else {
                    scheduleLogEntry = RosettaMsg.CALENDAR_OBJECT_EXPIRING_TOMORROW.newLogEntry(stringArray);
                    systemMessage = RosettaMsg.CALENDAR_OBJECT_EXPIRING_TOMORROW.newSystemMessage(stringArray);
                }
            } else {
                scheduleLogEntry = RosettaMsg.CALENDAR_OBJECT_EXPIRING_TODAY.newLogEntry(stringArray);
                systemMessage = RosettaMsg.CALENDAR_OBJECT_EXPIRING_TODAY.newSystemMessage(stringArray);
            }
            ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
            SystemMessageQueue.write((SystemMessage)systemMessage);
            logger.warn((Object)scheduleLogEntry.getMessageText());
            CrossAppenderLogger.logMessage((Log4jID)Log4jID.SCHEDULER, (Level)Level.WARN, (String)scheduleLogEntry.getMessageText());
        }
    }

    private void sendFailedMessage(Exception exception) {
        ScheduleLogEntry scheduleLogEntry = RosettaMsg.FAILED_TO_RUN.newLogEntry(this.getNameForRosettaMsg());
        logger.debug((Object)scheduleLogEntry.getMessageText(), (Throwable)exception);
        ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
    }

    public String toString() {
        return RosettaMsg.PURGE_RUNNER_NAME.newLogEntry(this.getNameForRosettaMsg()).getMessageText();
    }

    private String[] getNameForRosettaMsg() {
        String[] stringArray = new String[]{this.getName()};
        return stringArray;
    }

    public String getName() {
        return RosettaMsg.EXPIRING_CALENDAR_OBJECT_NAME.newLogEntry().getMessageText();
    }
}

