/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.scheduler;

import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.AgentGroupProxy;
import com.helpsystems.enterprise.core.busobj.AgentGroupType;
import com.helpsystems.enterprise.core.busobj.MissedAgentJob;
import com.helpsystems.enterprise.core.busobj.MissedJobsAccountant;
import com.helpsystems.enterprise.core.dm.AgentDM;
import com.helpsystems.enterprise.core.dm.AgentGroupDM;
import com.helpsystems.enterprise.core.dm.JobHistoryDM;
import com.helpsystems.enterprise.core.dm.JobMonitorManagerAM;
import com.helpsystems.enterprise.core.dm.ScheduleJobDM;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.messages.SystemMessage;
import com.helpsystems.enterprise.core.messages.SystemMessageQueue;
import com.helpsystems.enterprise.core.scheduler.PrereqDM;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfoDM;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobProxy;
import com.helpsystems.enterprise.core.scheduler.ScheduledJobsList;
import com.helpsystems.enterprise.core.scheduler.ScheduledTimeDM;
import com.helpsystems.enterprise.scheduler.NSTCalculator;
import com.helpsystems.enterprise.scheduler.PrereqEvaluator;
import com.helpsystems.enterprise.scheduler.ReactivityMonitor;
import com.helpsystems.enterprise.scheduler.Scheduler;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class RunMissedJobs {
    private static final Logger logger = Logger.getLogger(RunMissedJobs.class);
    private static final TimeZone GMT_TZ = TimeZone.getTimeZone("GMT");
    private boolean testMode = false;
    private ScheduleJobDM scheduleJobDM = (ScheduleJobDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ScheduleJobDM");
    private AgentGroupDM agentGroupDM = (AgentGroupDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentGroupDM");

    public static Calendar getStartTime() {
        Calendar calendar = Calendar.getInstance(GMT_TZ);
        calendar.setTimeInMillis(System.currentTimeMillis());
        return calendar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMissedJobs(Calendar calendar, Set<MissedAgentJob> set, Scheduler scheduler, boolean bl, Date date) {
        String[] stringArray = new String[]{ScheduleLogger.formatTimeStamp((Calendar)calendar)};
        ScheduleLogEntry scheduleLogEntry = RosettaMsg.MISSED_JOB_PROCESS_STARTED.newLogEntry(stringArray);
        logger.info((Object)scheduleLogEntry.getMessageText());
        ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
        this.waitForReactivityMonitor();
        Set<MissedAgentJob> set2 = set;
        if (set == null) {
            set2 = new HashSet<MissedAgentJob>();
        }
        ScheduleInfoDM scheduleInfoDM = null;
        ScheduleJobDM scheduleJobDM = null;
        ScheduledTimeDM scheduledTimeDM = null;
        PrereqDM prereqDM = null;
        JobMonitorManagerAM jobMonitorManagerAM = null;
        ScheduledJobsList scheduledJobsList = null;
        JobHistoryDM jobHistoryDM = null;
        PrereqEvaluator prereqEvaluator = null;
        try {
            Calendar calendar2;
            int n;
            scheduleInfoDM = (ScheduleInfoDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ScheduleInfoDM");
            scheduleJobDM = (ScheduleJobDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ScheduleJobDM");
            scheduledTimeDM = (ScheduledTimeDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ScheduledTimeDM");
            jobMonitorManagerAM = (JobMonitorManagerAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobMonitorManagerAM");
            prereqDM = (PrereqDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.PrereqDM");
            jobHistoryDM = (JobHistoryDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobHistoryDM");
            AgentDM agentDM = (AgentDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentDM");
            AgentGroupDM agentGroupDM = (AgentGroupDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentGroupDM");
            NSTCalculator nSTCalculator = new NSTCalculator(scheduleInfoDM, scheduledTimeDM, scheduleJobDM, agentDM, jobMonitorManagerAM, agentGroupDM);
            try {
                prereqEvaluator = new PrereqEvaluator(nSTCalculator, scheduleJobDM, prereqDM);
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                logger.error((Object)"Could not start the Scheduler Prerequisite Evaluator.", (Throwable)resourceUnavailableException);
            }
            nSTCalculator.setScheduler(scheduler);
            int n2 = 0;
            MissedJobsAccountant missedJobsAccountant = new MissedJobsAccountant();
            scheduledJobsList = scheduledTimeDM.getScheduledJobsList();
            while (scheduledJobsList.next()) {
                n = scheduledJobsList.getJobNumber();
                int n3 = scheduledJobsList.getSystem();
                calendar2 = scheduledJobsList.getNextScheduledTime();
                if (!calendar2.before(calendar)) break;
                ++n2;
                Calendar calendar3 = this.processMissedJob(n, n3, calendar2, prereqEvaluator, set2, missedJobsAccountant, bl, date);
                if (calendar3 == null) continue;
                scheduledJobsList.reload();
            }
            stringArray = new String[]{ScheduleLogger.formatTimeStamp((Calendar)calendar), Integer.toString(missedJobsAccountant.getAllmissedJobsCount()), Integer.toString(missedJobsAccountant.getIgnoredissedJobsCount()), Integer.toString(missedJobsAccountant.getFailedMissedJobsCount()), Integer.toString(missedJobsAccountant.getCompletedMissedJobsCount()), Integer.toString(missedJobsAccountant.getRanMissedJobsCount()), Integer.toString(missedJobsAccountant.getManagedMissedJobsCount())};
            scheduleLogEntry = RosettaMsg.MISSED_JOB_PROCESS_COMPLETED.newLogEntry(stringArray);
            logger.info((Object)scheduleLogEntry.getMessageText());
            ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
            n = 0;
            try {
                n = jobHistoryDM.getManagedJobCount();
            }
            catch (Exception exception) {
                logger.debug((Object)"Error retrieving manged job count.", (Throwable)exception);
            }
            if (n > 0) {
                stringArray = new String[]{Integer.toString(n)};
                SystemMessage systemMessage = RosettaMsg.MISSED_JOB_MANAGING_EXIST.newSystemMessage(stringArray);
                calendar2 = RosettaMsg.SKYBOT_SCHEDULER_SERVER_NOTICE_MISSED_JOB_MANAGING_EXISTS.newSystemMessage(stringArray);
                if (n == 1) {
                    systemMessage = RosettaMsg.MISSED_JOB_MANAGING_EXIST_ONE.newSystemMessage();
                    calendar2 = RosettaMsg.SKYBOT_SCHEDULER_SERVER_NOTICE_MISSED_JOB_MANAGING_EXIST_ONE.newSystemMessage();
                }
                SystemMessageQueue.write((SystemMessage)systemMessage, (SystemMessage)calendar2);
                scheduleLogEntry = n == 1 ? RosettaMsg.MISSED_JOB_MANAGING_EXIST_ONE.newLogEntry() : RosettaMsg.MISSED_JOB_MANAGING_EXIST.newLogEntry(stringArray);
                ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
                logger.info((Object)scheduleLogEntry.getMessageText());
            }
            return;
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)"Error processing missed jobs.", (Throwable)resourceUnavailableException);
        }
        finally {
            if (scheduledJobsList != null) {
                scheduledJobsList.close();
            }
            prereqEvaluator.shutDown();
            logger.debug((Object)"Missed job processing is complete.");
        }
    }

    private Calendar processMissedJob(int n, int n2, Calendar calendar, PrereqEvaluator prereqEvaluator, Set<MissedAgentJob> set, MissedJobsAccountant missedJobsAccountant, boolean bl, Date date) throws ResourceUnavailableException {
        boolean bl2;
        AgentGroupProxy agentGroupProxy;
        String string = ScheduleLogger.formatTimeStamp((Calendar)calendar);
        String string2 = "Processing missed job " + n + " which was scheduled to run at " + string + " on agent " + n2;
        logger.debug((Object)string2);
        int n3 = n2;
        ScheduleJobProxy scheduleJobProxy = this.getScheduleJobProxy(n);
        if (scheduleJobProxy != null) {
            if (scheduleJobProxy.getTargetType() == ScheduleInfo.TargetType.AGENT_GROUP) {
                agentGroupProxy = this.getAgentGroupProxy(scheduleJobProxy.getTargetId(), scheduleJobProxy.getName());
                if (agentGroupProxy != null) {
                    if (agentGroupProxy.getAgentGroupType() == AgentGroupType.UTILIZATION_BALANCED || agentGroupProxy.getAgentGroupType() == AgentGroupType.PREFERRED_AGENT) {
                        n3 = 0;
                    }
                } else {
                    logger.warn((Object)("Agent Group Proxy was not loaded for ID: " + scheduleJobProxy.getTargetId()));
                }
            }
        } else {
            logger.warn((Object)("Schedule Job Proxy was not loaded for Job ID: " + n));
        }
        if (!(bl2 = set.contains(agentGroupProxy = new MissedAgentJob((long)n3, (long)n)))) {
            set.add((MissedAgentJob)agentGroupProxy);
        }
        Calendar calendar2 = prereqEvaluator.timerEventMissed(n, n2, calendar, !bl2, this.testMode, missedJobsAccountant, bl, date, scheduleJobProxy);
        return calendar2;
    }

    private AgentGroupProxy getAgentGroupProxy(long l, String string) {
        try {
            return this.agentGroupDM.getProxy(l);
        }
        catch (Exception exception) {
            logger.error((Object)("Error retrieving Agent Group Proxy for Job " + string + " with Agent Group ID " + l + "."), (Throwable)exception);
            return null;
        }
    }

    private ScheduleJobProxy getScheduleJobProxy(long l) {
        try {
            return this.scheduleJobDM.getScheduleJobProxy(l);
        }
        catch (Exception exception) {
            logger.error((Object)("Error retrieving Job Proxy for Job ID " + l + "."), (Throwable)exception);
            return null;
        }
    }

    private void waitForReactivityMonitor() {
        int n = 0;
        int n2 = 3;
        long l = System.currentTimeMillis() + (long)(60000 * n2);
        while (!ReactivityMonitor.isCaughtUp()) {
            if (l < System.currentTimeMillis()) {
                logger.warn((Object)("Missed Jobs processing waited the maximum time for the Reactivity Monitor to catch-up (" + n2 + " minutes)."));
                return;
            }
            if (n > 15) {
                logger.debug((Object)"Missed Jobs process is waiting for Reactivity Monitor to catchup...");
                n = 0;
            } else {
                ++n;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Throwable throwable) {}
        }
    }
}

