/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.transport.moduleimpl.processor;

import com.helpsystems.common.tl.Envelope;
import com.helpsystems.common.tl.HeavyweightPeer;
import com.helpsystems.common.tl.Peer;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.common.tl.processor.Command;
import com.helpsystems.common.tl.processor.CommandBroadcaster;
import com.helpsystems.common.tl.processor.Processable;
import com.helpsystems.common.tl.processor.Processor;
import com.helpsystems.common.tl.processor.impl.PeerDisconnectCommand;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class PeerDisconnectProcessor
extends Processor {
    private static final Logger logger = Logger.getLogger(PeerDisconnectProcessor.class);
    private HashMap<PeerID, Long> deadPeerMap = new HashMap();
    private static final long WAIT_INTERVAL = 5000L;

    public String[] listCommands() {
        return new String[]{PeerDisconnectCommand.class.getName()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processCommand(Peer peer, Envelope envelope, PeerDisconnectCommand peerDisconnectCommand) {
        Object object;
        long l = System.currentTimeMillis();
        PeerID peerID = peerDisconnectCommand.getSource();
        CommandBroadcaster commandBroadcaster = this.deadPeerMap;
        synchronized (commandBroadcaster) {
            long l2;
            object = this.deadPeerMap.get(peerID);
            if (object != null && (l2 = ((Long)object).longValue()) + 5000L > l) {
                return;
            }
            this.deadPeerMap.put(peerID, new Long(l));
        }
        try {
            peer.checkWaitingThreads(peerID);
            if (peer.isGateway()) {
                commandBroadcaster = new CommandBroadcaster(peer, (Command)peerDisconnectCommand, envelope.getRemainingHops(), envelope.getRoute());
                commandBroadcaster.run();
            }
        }
        catch (Exception exception) {
            logger.debug((Object)("Error forwarding a PeerDisconnectCommand to " + null), (Throwable)exception);
        }
        commandBroadcaster = this.deadPeerMap;
        synchronized (commandBroadcaster) {
            object = this.deadPeerMap.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                Long l3 = (Long)entry.getValue();
                if (l3 + 5000L >= l) continue;
                object.remove();
            }
        }
    }

    public void processObject(HeavyweightPeer heavyweightPeer, Envelope envelope, Processable processable) {
        if (processable instanceof PeerDisconnectCommand) {
            this.processCommand((Peer)heavyweightPeer, envelope, (PeerDisconnectCommand)processable);
            return;
        }
        throw new RuntimeException("This processor cannot handle an object of type " + processable.getClass().getName());
    }
}

