/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.transport.moduleimpl.processor;

import com.helpsystems.common.core.xml.XMLReflector;
import com.helpsystems.common.tl.Envelope;
import com.helpsystems.common.tl.HeavyweightPeer;
import com.helpsystems.common.tl.IRemoteLingeringObject;
import com.helpsystems.common.tl.Peer;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.common.tl.access.LingeringObjectCache;
import com.helpsystems.common.tl.processor.Command;
import com.helpsystems.common.tl.processor.Processable;
import com.helpsystems.common.tl.processor.Processor;
import com.helpsystems.common.tl.processor.impl.LingeringObjectCommand;
import com.helpsystems.common.tl.processor.impl.LingeringObjectExpiredCommand;
import com.helpsystems.common.tl.processor.impl.ThrowableCommandResponse;
import com.helpsystems.transport.moduleimpl.processor.LingeringObjectResponse;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;

public class LingeringObjectProcessor
extends Processor {
    private static final Logger logger = Logger.getLogger(LingeringObjectProcessor.class);

    protected Object findAndInvoke(HeavyweightPeer heavyweightPeer, LingeringObjectCommand lingeringObjectCommand) throws Throwable {
        String string;
        String string2 = lingeringObjectCommand.getObjectID();
        if (string2 == null) {
            throw new NullPointerException("The object ID in the command is null.");
        }
        Object object = heavyweightPeer.getRemoteObjectRegistry().get(string2);
        if (object == null) {
            throw new NullPointerException("The object is no longer available and may have expired.");
        }
        if (lingeringObjectCommand.isFinishedWithObject()) {
            heavyweightPeer.getRemoteObjectRegistry().remove(string2);
        }
        if ((string = lingeringObjectCommand.getMethodName()) == null && !lingeringObjectCommand.isFinishedWithObject()) {
            throw new NullPointerException("The method name in the command is null.");
        }
        Object object2 = null;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Invoking " + string + " on object " + object.getClass().getName() + " : " + string2));
        }
        if (string != null) {
            Method method;
            Object object3;
            Object[] objectArray;
            Class[] classArray = lingeringObjectCommand.getParameterTypes();
            if (classArray == null) {
                classArray = new Class[]{};
            }
            if ((objectArray = lingeringObjectCommand.getParameters()) != null) {
                object3 = objectArray;
                int n = ((Object[])object3).length;
                for (int i = 0; i < n; ++i) {
                    IRemoteLingeringObject iRemoteLingeringObject;
                    Object object4 = object3[i];
                    if (!(object4 instanceof IRemoteLingeringObject) || (iRemoteLingeringObject = (IRemoteLingeringObject)object4).getLocalPeer() != null) continue;
                    iRemoteLingeringObject.setLocalPeer((Peer)heavyweightPeer);
                }
            }
            if ((method = XMLReflector.findMethod((Class)(object3 = object.getClass()), (String)string, (Class[])classArray)) == null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("The method ");
                stringBuffer.append(string);
                stringBuffer.append("(");
                if (classArray != null || classArray.length > 0) {
                    for (int i = 0; i < classArray.length; ++i) {
                        if (i > 0) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(classArray[i].getName());
                    }
                }
                stringBuffer.append(") does not exist in ");
                stringBuffer.append(object3);
                throw new NullPointerException(stringBuffer.toString());
            }
            try {
                object2 = method.invoke(object, objectArray);
                logger.trace((Object)("Method '" + object.getClass().getName() + "." + string + "' returned " + object2));
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
        }
        return object2;
    }

    public String[] listCommands() {
        return new String[]{LingeringObjectExpiredCommand.class.getName(), LingeringObjectCommand.class.getName(), LingeringObjectResponse.class.getName()};
    }

    protected void processCommand(HeavyweightPeer heavyweightPeer, Envelope envelope, LingeringObjectCommand lingeringObjectCommand) {
        LingeringObjectResponse lingeringObjectResponse;
        PeerID peerID = lingeringObjectCommand.getSource();
        if (peerID == null) {
            logger.debug((Object)("Command " + lingeringObjectCommand.getArbitraryID() + " has a null source"));
            return;
        }
        Object object = null;
        Throwable throwable = null;
        try {
            object = this.findAndInvoke(heavyweightPeer, lingeringObjectCommand);
        }
        catch (Throwable throwable2) {
            logger.debug((Object)"Error invoking a method on a lingering object.", throwable2);
            throwable = throwable2;
        }
        LingeringObjectResponse lingeringObjectResponse2 = null;
        lingeringObjectResponse2 = throwable == null ? (lingeringObjectResponse = new LingeringObjectResponse(object)) : (lingeringObjectResponse = new ThrowableCommandResponse(throwable));
        lingeringObjectResponse2.setCommand((Command)lingeringObjectCommand);
        try {
            this.sendReplyEnvelope(heavyweightPeer, envelope, (Processable)lingeringObjectResponse2);
        }
        catch (Exception exception) {
            logger.debug((Object)("Error sending a LingeringObjectResponse to " + envelope.getSource()), (Throwable)exception);
        }
    }

    public void processObject(HeavyweightPeer heavyweightPeer, Envelope envelope, Processable processable) {
        if (processable instanceof LingeringObjectExpiredCommand) {
            this.doExpiredObject((LingeringObjectExpiredCommand)processable);
            return;
        }
        if (processable instanceof LingeringObjectCommand) {
            this.processCommand(heavyweightPeer, envelope, (LingeringObjectCommand)processable);
            return;
        }
        if (processable instanceof LingeringObjectResponse) {
            return;
        }
        logger.debug((Object)("The LingeringObjectProcessor can't handle " + processable.getClass().getName()));
    }

    private void doExpiredObject(LingeringObjectExpiredCommand lingeringObjectExpiredCommand) {
        String string = lingeringObjectExpiredCommand.getObjectID();
        LingeringObjectCache.expired((String)string);
    }
}

