/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.access.client;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.ResultSetDataSet;
import com.helpsystems.common.access.SQLWhereClause;
import com.helpsystems.common.core.access.DataSet;
import com.helpsystems.common.core.access.DataSetException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.UserIdentity;
import com.helpsystems.common.core.client.Client;
import com.helpsystems.common.core.client.ClientDM;
import com.helpsystems.common.core.client.ClientProxy;
import com.helpsystems.common.core.filter.DataFilter;
import com.helpsystems.common.core.filter.GenericSortField;
import com.helpsystems.common.core.filter.SortField;
import com.helpsystems.common.core.util.ResourceBundleHandler;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class ClientJDBC
extends AbstractDatabaseManager
implements ClientDM {
    private static ResourceBundleHandler rbh = ResourceBundleHandler.getHandler((String)ClientJDBC.class.getName());
    private static final Logger logger = Logger.getLogger(ClientJDBC.class);
    private static final SortField[] SORT_FIELDS = new SortField[]{new GenericSortField(10101, 0), new GenericSortField(333, 0), new GenericSortField(444, 0)};
    protected String msgFileLib = null;
    protected String libraryName;
    protected String libFile;
    protected String fullLibFile;
    protected String fileName = "rclru";
    protected String fullFileName = "rclci";
    protected static final String msgFileName = "rclmsg.msgf";

    public ClientJDBC(String string, String string2, String string3) {
        super(string);
        this.setName(string3);
        this.libraryName = string2;
        this.libFile = this.libraryName + "." + this.fileName;
        this.fullLibFile = this.libraryName + "." + this.fullFileName;
        this.msgFileLib = "/QSYS.lib/" + this.libraryName.trim() + ".lib/" + msgFileName;
    }

    public ClientProxy getClientProxy(String string) throws NoDataException, ResourceUnavailableException {
        ClientProxy clientProxy;
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            wrappedConnection = this.getConnection();
            String string2 = "select RUCLTID, rucltdesc, rucltstus, ruclttype from " + this.libFile + " where RUCLTID=? ";
            preparedStatement = wrappedConnection.prepareStatement(string2);
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                throw new NoDataException(rbh.getMsg("invalid_robot_client", (Object)string));
            }
            ClientProxyGenerator clientProxyGenerator = new ClientProxyGenerator();
            clientProxy = (ClientProxy)clientProxyGenerator.generateObject(resultSet);
        }
        catch (Exception exception) {
            try {
                String string3 = "SQL error loading Client " + string + ".";
                throw new ResourceUnavailableException(string3, (Throwable)exception);
            }
            catch (Throwable throwable) {
                ClientJDBC.closeEm(wrappedConnection, preparedStatement, resultSet);
                throw throwable;
            }
        }
        ClientJDBC.closeEm(wrappedConnection, preparedStatement, resultSet);
        return clientProxy;
    }

    private String getString(ResultSet resultSet, String string) throws SQLException {
        if (resultSet == null || string == null) {
            throw new IllegalArgumentException("Result set and fld are required.");
        }
        String string2 = resultSet.getString(string);
        if (string2 == null) {
            return "";
        }
        return string2.trim();
    }

    public DataSet getDataSet(UserIdentity userIdentity, DataFilter dataFilter, SortField sortField) throws DataSetException, ResourceUnavailableException {
        return this.getClientList(dataFilter, sortField);
    }

    public DataSet getClientList(DataFilter dataFilter, SortField sortField) throws ResourceUnavailableException {
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        String string = "select RUCLTID, rucltdesc, rucltstus, ruclttype from " + this.libFile + " ";
        try {
            wrappedConnection = this.getConnection();
            String string2 = "";
            if (dataFilter != null && !dataFilter.isEmpty()) {
                string2 = " where " + SQLWhereClause.getSQL(dataFilter, true) + " ";
            }
            String string3 = "select count (*) from " + this.libFile + string2;
            logger.trace((Object)("Count String: " + string3));
            PreparedStatement preparedStatement = wrappedConnection.prepareStatement(string3);
            if (string2.length() > 0) {
                SQLWhereClause.prepareSQLWhereClause(preparedStatement, 1, dataFilter);
            }
            String string4 = this.getClientSortSQL(sortField);
            String string5 = string + string2 + string4;
            logger.trace((Object)("Query String: " + string5));
            PreparedStatement preparedStatement2 = wrappedConnection.prepareStatement(string5, 1004, 1007);
            if (string2.length() > 0) {
                SQLWhereClause.prepareSQLWhereClause(preparedStatement2, 1, dataFilter);
            }
            int n = -1;
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            resultSet = preparedStatement2.executeQuery();
            ClientProxyGenerator clientProxyGenerator = new ClientProxyGenerator();
            return ResultSetDataSet.createDataSet(resultSet, clientProxyGenerator, n);
        }
        catch (Exception exception) {
            ClientJDBC.closeEm(wrappedConnection, null, null);
            throw new ResourceUnavailableException("Client list query failed.", (Throwable)exception);
        }
    }

    private String getClientSortSQL(SortField sortField) {
        String string = "order by rucltdesc";
        if (sortField == null) {
            return string;
        }
        String string2 = "";
        if (sortField.getDirection() == 1) {
            string2 = "desc ";
        }
        switch (sortField.getField()) {
            case 10101: {
                string = "order by rucltdesc " + string2;
                break;
            }
            case 444: {
                string = "order by rucltstus " + string2 + ", rucltdesc ";
                break;
            }
            case 333: {
                string = "order by ruclttype " + string2 + ", rucltdesc ";
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Sort Order: " + sortField.getField());
            }
        }
        return string;
    }

    public SortField[] getSortFields() {
        return SORT_FIELDS;
    }

    public String getMsgFileLibrary() {
        return this.msgFileLib;
    }

    public Client getClient(String string) throws NoDataException, ResourceUnavailableException {
        Client client;
        Client client2 = new Client();
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        ClientProxy clientProxy = null;
        try {
            clientProxy = this.getClientProxy(string);
        }
        catch (Exception exception) {
            throw new NoDataException(string + " is not a valid Robot/CLIENT ID.");
        }
        try {
            wrappedConnection = this.getConnection();
            String string2 = "CICLTID, CIMEMSIZE, CIOSNAME, CIOSVER, CIOSBUILD, CIOSINFO, CICPUTYPE, CINBRCPU, CICPUSPEED ";
            String string3 = "select " + string2 + "from " + this.fullLibFile + " where CICLTID=? ";
            preparedStatement = wrappedConnection.prepareStatement(string3);
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                throw new NoDataException(string + " is not a valid Robot/CLIENT ID.");
            }
            client2.setClientOid(clientProxy.getClientOid());
            client2.setName(clientProxy.getName());
            client2.setStatus(clientProxy.getStatus());
            client2.setType(clientProxy.getType());
            client2.setCpuNumber(resultSet.getShort("CINBRCPU"));
            String string4 = resultSet.getString("CICPUSPEED");
            if (string4 == null || string4.trim().length() < 1) {
                client2.setCpuSpeed(0);
            } else {
                client2.setCpuSpeed(resultSet.getInt("CICPUSPEED"));
            }
            client2.setCpuType(this.getString(resultSet, "CICPUTYPE"));
            client2.setOsBuild(this.getString(resultSet, "CIOSBUILD"));
            client2.setOsInfo(this.getString(resultSet, "CIOSINFO"));
            client2.setOsLevel(this.getString(resultSet, "CIOSVER"));
            client2.setOsName(this.getString(resultSet, "CIOSNAME"));
            client = client2;
        }
        catch (SQLException sQLException) {
            try {
                throw new ResourceUnavailableException("SQL error loading Client " + string + ".", (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                ClientJDBC.closeEm(wrappedConnection, preparedStatement, resultSet);
                throw throwable;
            }
        }
        ClientJDBC.closeEm(wrappedConnection, preparedStatement, resultSet);
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLegacyClientCount(int n) {
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = "select count (*) from " + this.libFile + " where RUCLTTYPE='0'";
        String string2 = "select count (*) from " + this.libFile + " where RUCLTTYPE='1'";
        String string3 = "select count (*) from " + this.libFile + " where RUCLTTYPE='2'";
        boolean bl = n < 1 || n > -1;
        boolean bl2 = n != 0 && n != 2;
        boolean bl3 = n != 0 && n != 1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        try {
            wrappedConnection = this.getConnection();
            if (bl2) {
                logger.trace((Object)("Count String: " + string2));
                preparedStatement = wrappedConnection.prepareStatement(string2);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    n2 = resultSet.getInt(1);
                }
                if (n2 == -1) {
                    n2 = 0;
                }
            }
            if (bl3) {
                logger.trace((Object)("Count String: " + string3));
                preparedStatement = wrappedConnection.prepareStatement(string3);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    n3 = resultSet.getInt(1);
                }
                if (n3 == -1) {
                    n3 = 0;
                }
            }
            if (bl) {
                logger.trace((Object)("Count String: " + string));
                preparedStatement = wrappedConnection.prepareStatement(string);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    n4 = resultSet.getInt(1);
                }
                if (n4 == -1) {
                    n4 = 0;
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n5 = n2 + n3;
            switch (n) {
                case 0: {
                    stringBuffer.append(n4);
                    break;
                }
                case 1: {
                    stringBuffer.append(n2);
                    break;
                }
                case 2: {
                    stringBuffer.append(n3);
                    break;
                }
                case 3: {
                    stringBuffer.append(n5);
                    break;
                }
                default: {
                    stringBuffer.append(n5);
                    stringBuffer.append(";");
                    stringBuffer.append(n4);
                }
            }
            String string4 = stringBuffer.toString();
            ClientJDBC.closeEm(wrappedConnection, preparedStatement, resultSet);
            return string4;
        }
        catch (Exception exception) {
            ClientJDBC.closeEm(wrappedConnection, preparedStatement, resultSet);
            logger.debug((Object)"Unable to retrieve legacy count.", (Throwable)exception);
            String string5 = "Unable to retrieve legacy count";
            return string5;
        }
        finally {
            ClientJDBC.closeEm(wrappedConnection, preparedStatement, resultSet);
        }
    }

    private class ClientProxyGenerator
    extends AbstractBusObjGenerator {
        ClientProxyGenerator() {
            super(4, ClientProxy.class.getName());
        }

        @Override
        protected Object constructObject() {
            return new ClientProxy();
        }

        @Override
        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException {
            ClientProxy clientProxy = (ClientProxy)object;
            switch (n) {
                case 1: {
                    clientProxy.setClientOid(ClientJDBC.this.getString(resultSet, "rucltid"));
                    break;
                }
                case 2: {
                    clientProxy.setName(ClientJDBC.this.getString(resultSet, "rucltdesc"));
                    break;
                }
                case 3: {
                    clientProxy.setStatus(resultSet.getInt("rucltstus"));
                    break;
                }
                case 4: {
                    clientProxy.setType(resultSet.getInt("ruclttype"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass #" + n + " exceeds maximum.");
                }
            }
        }
    }
}

