/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.access;

import com.helpsystems.common.core.filter.AbsoluteSortField;
import com.helpsystems.common.core.filter.SortField;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import java.util.HashMap;

public class SQLOrderByClause {
    public static final int NO_SECOND_SORT = -1;
    private HashMap<Integer, String> sorts = new HashMap();
    private HashMap<Integer, String> sorts2 = new HashMap();
    private int secondSort = -1;
    private boolean secondSortDirection = true;
    private boolean addOrderByString = false;

    public SQLOrderByClause(boolean bl) {
        this.addOrderByString = bl;
    }

    public SQLOrderByClause(boolean bl, int n, boolean bl2) {
        this(bl);
        this.secondSort = n;
        this.secondSortDirection = bl2;
    }

    public void addSort(int n, String string) {
        if (string == null) {
            throw new NullPointerException("Field name cannot be null");
        }
        if (string.trim().length() == 0) {
            throw new IllegalArgumentException("Field name cannot be blank.");
        }
        this.sorts.put(new Integer(n), string);
    }

    public void addSort(int n, String string, String string2) {
        this.addSort(n, string);
        if (string2 == null) {
            throw new NullPointerException("Field name cannot be null.");
        }
        if (string2.trim().length() == 0) {
            throw new IllegalArgumentException("Field name cannot be blank.");
        }
        this.sorts2.put(new Integer(n), string2);
    }

    public String generateClause(int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.addOrderByString) {
            stringBuffer.append(" order by ");
        }
        stringBuffer.append(this.getFieldName(n, bl));
        if (this.secondSort != -1 && n != this.secondSort) {
            stringBuffer.append(", ");
            stringBuffer.append(this.getFieldName(this.secondSort, this.secondSortDirection));
        }
        return stringBuffer.toString();
    }

    public String generateClause(SortField sortField) {
        ValidationHelper.checkForNull((String)"Sort Field", (Object)sortField);
        StringBuffer stringBuffer = new StringBuffer(" ");
        if (this.addOrderByString) {
            stringBuffer.append("order by ");
        }
        this.appendClause(sortField, stringBuffer);
        return stringBuffer.toString();
    }

    private void appendClause(SortField sortField, StringBuffer stringBuffer) {
        String string = null;
        if (sortField instanceof AbsoluteSortField) {
            string = ((AbsoluteSortField)sortField).getFieldName();
            if (string == null) {
                throw new IllegalArgumentException("Sort information missing field name.");
            }
        } else {
            string = this.sorts.get(sortField.getField());
            if (string == null) {
                throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Sort code {0} not found in table.", (Object[])new Object[]{sortField.getField()}));
            }
        }
        stringBuffer.append(string + " ");
        if (sortField.isAscending()) {
            stringBuffer.append("asc ");
        } else {
            stringBuffer.append("desc ");
        }
        if (sortField.getSecondarySort() != null) {
            stringBuffer.append(", ");
            this.appendClause(sortField.getSecondarySort(), stringBuffer);
        }
    }

    private String getFieldName(int n, boolean bl) {
        Integer n2 = new Integer(n);
        if (!this.sorts.containsKey(n2)) {
            throw new RuntimeException("Sort not in table.");
        }
        String string = this.sorts.get(n2) + this.getSortDirection(bl);
        return string + this.getField2Name(n, bl);
    }

    private String getField2Name(int n, boolean bl) {
        Integer n2 = new Integer(n);
        if (!this.sorts2.containsKey(n2)) {
            return "";
        }
        return ", " + this.sorts2.get(n2) + this.getSortDirection(bl);
    }

    private String getSortDirection(boolean bl) {
        if (bl) {
            return " asc ";
        }
        return " desc ";
    }
}

