/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.access;

import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.ResultSetDataSet;
import com.helpsystems.common.access.SQLHelperGenerator;
import com.helpsystems.common.access.SQLOrderByClause;
import com.helpsystems.common.access.SQLWhereClause;
import com.helpsystems.common.core.access.BadDataArrayException;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.DataSet;
import com.helpsystems.common.core.access.DataSetException;
import com.helpsystems.common.core.access.ErrorList;
import com.helpsystems.common.core.access.ErrorTable;
import com.helpsystems.common.core.access.ExceptionErrorList;
import com.helpsystems.common.core.access.dataset.DataSetWithAttributes;
import com.helpsystems.common.core.filter.AbsoluteSortField;
import com.helpsystems.common.core.filter.AbstractFilterField;
import com.helpsystems.common.core.filter.DataFilter;
import com.helpsystems.common.core.filter.FilterCriteria;
import com.helpsystems.common.core.filter.FilterField;
import com.helpsystems.common.core.filter.FilterFieldString;
import com.helpsystems.common.core.filter.FilterFieldTimestamp;
import com.helpsystems.common.core.filter.GenericSortField;
import com.helpsystems.common.core.filter.SortField;
import com.helpsystems.common.core.util.ResourceBundleHandler;
import com.helpsystems.common.core.xml.XMLUtil;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SQLManagerHelper {
    protected Hashtable<String, MagicalAssociation> associationTable = new Hashtable();
    private String filename;
    private static final Logger logger = Logger.getLogger(SQLManagerHelper.class);
    protected static final Method NULL_METHOD = SQLManagerHelper.class.getMethods()[0];
    public static final String PROPERTY_TRACE_SQL = "common.java.trace.sql";
    private static final String BUG_6621_HACK = "_Z_Z_";

    public SQLManagerHelper(String string) throws IOException {
        this(string, false, null);
    }

    public SQLManagerHelper(String string, boolean bl, ClassLoader classLoader) throws IOException {
        Document document = this.loadXMLFile(string, bl, classLoader);
        this.parseDocument(document);
        this.filename = string;
    }

    public SQLManagerHelper(Document document) throws IOException {
        this.parseDocument(document);
        this.filename = "[internal document]";
    }

    public SortField[] buildGenericSortFields(Object object) {
        if (object == null) {
            throw new NullPointerException("The object passed in was null.");
        }
        MagicalAssociation magicalAssociation = this.lookupAssociation(object.getClass());
        if (magicalAssociation == null) {
            throw new NullPointerException("The file " + this.filename + " does not contain a mapping for " + object.getClass().getName());
        }
        MagicalMapping[] magicalMappingArray = magicalAssociation.listMappings();
        if (magicalMappingArray == null) {
            throw new NullPointerException("The file " + this.filename + " contains an empty mapping for " + object.getClass().getName());
        }
        ArrayList<GenericSortField> arrayList = new ArrayList<GenericSortField>();
        for (int i = 0; i < magicalMappingArray.length; ++i) {
            if (magicalMappingArray[i].isIgnored() || !magicalMappingArray[i].isSortField()) continue;
            arrayList.add(new GenericSortField(magicalMappingArray[i].getSortKey(), 0));
        }
        SortField[] sortFieldArray = new SortField[arrayList.size()];
        arrayList.toArray(sortFieldArray);
        return sortFieldArray;
    }

    public FilterField[] buildGenericFilterFields(Object object) {
        return this.buildGenericFilterFields(object, null);
    }

    public FilterField[] buildGenericFilterFields(Object object, ResourceBundleHandler resourceBundleHandler) {
        if (object == null) {
            throw new NullPointerException("The object passed in was null.");
        }
        MagicalAssociation magicalAssociation = this.lookupAssociation(object.getClass());
        if (magicalAssociation == null) {
            throw new NullPointerException("The file " + this.filename + " does not contain a mapping for " + object.getClass().getName());
        }
        MagicalMapping[] magicalMappingArray = magicalAssociation.listMappings();
        if (magicalMappingArray == null) {
            throw new NullPointerException("The file " + this.filename + " contains an empty mapping for " + object.getClass().getName());
        }
        ArrayList<FilterFieldTimestamp> arrayList = new ArrayList<FilterFieldTimestamp>();
        for (int i = 0; i < magicalMappingArray.length; ++i) {
            Method method;
            if (magicalMappingArray[i].isIgnored() || !magicalMappingArray[i].isFilterField() || (method = this.resolveGetter(object.getClass(), magicalMappingArray[i])) == null) continue;
            String string = method.getName();
            String string2 = magicalMappingArray[i].getFilterField();
            if (resourceBundleHandler != null && string2 != null && string2.toUpperCase().startsWith("RBH:")) {
                string2 = string2.substring(4);
                try {
                    string2 = resourceBundleHandler.getText(string2);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            boolean bl = magicalMappingArray[i].isPrimaryKey();
            String string3 = magicalMappingArray[i].getParameterType();
            Class<String> clazz = null;
            try {
                clazz = SQLManagerHelper.resolveClass(string3);
            }
            catch (Exception exception) {
                logger.debug((Object)("Unable to resolve parameter class " + string3), (Throwable)exception);
                clazz = String.class;
            }
            Object object2 = null;
            object2 = java.util.Date.class.isAssignableFrom(clazz) ? new FilterFieldTimestamp(string2, string, 4) : new FilterFieldString(string2, string, 1000, bl, true, 0);
            arrayList.add((FilterFieldTimestamp)object2);
        }
        FilterField[] filterFieldArray = new FilterField[arrayList.size()];
        arrayList.toArray(filterFieldArray);
        Arrays.sort(filterFieldArray, AbstractFilterField.DISPLAY_NAME_COMPARATOR);
        return filterFieldArray;
    }

    public int countObject(Connection connection, Object object, String string) throws SQLException, DataException {
        Object object2;
        Object object3;
        if (connection == null) {
            throw new NullPointerException("The connection passed in was null");
        }
        if (object == null) {
            throw new NullPointerException("The object passed in was null");
        }
        MagicalAssociation magicalAssociation = this.lookupAssociation(object.getClass());
        if (magicalAssociation == null) {
            throw new NullPointerException("The file " + this.filename + " does not contain a mapping for " + object.getClass().getName());
        }
        MagicalMapping[] magicalMappingArray = magicalAssociation.listMappings();
        if (magicalMappingArray == null) {
            throw new NullPointerException("The file " + this.filename + " contains an empty mapping for " + object.getClass().getName());
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<MagicalMapping> arrayList2 = new ArrayList<MagicalMapping>();
        String string2 = null;
        for (int i = 0; i < magicalMappingArray.length; ++i) {
            String string3 = magicalMappingArray[i].getTableName();
            if (string3 == null) {
                string3 = magicalAssociation.getTableName();
            }
            object3 = string + "." + string3;
            if (string == null || string.length() == 0) {
                object3 = string3;
            }
            if (string2 == null) {
                string2 = object3;
            } else if (!string2.equals(object3)) {
                throw new SQLException("The object " + object.getClass().getName() + " is trying to count data in two different " + " tables: " + string3 + " and " + string2);
            }
            object2 = magicalMappingArray[i].getColumnName();
            if (!magicalMappingArray[i].isPrimaryKey()) continue;
            arrayList.add((String)object2);
            arrayList2.add(magicalMappingArray[i]);
        }
        if (arrayList.size() == 0) {
            throw new SQLException("Unable to compose the Count-WHERE clause for object " + object.getClass().getName());
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select count(*) from ");
        stringBuffer.append(string2);
        stringBuffer.append(" where ");
        for (int i = 0; i < arrayList.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(" and ");
            }
            stringBuffer.append((String)arrayList.get(i));
            stringBuffer.append("= ?");
        }
        String string4 = stringBuffer.toString();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("SQL is: " + string4));
        }
        object3 = null;
        object2 = null;
        String string5 = null;
        int n = -1;
        try {
            object3 = connection.prepareStatement(string4);
            for (int i = 0; i < arrayList2.size(); ++i) {
                MagicalMapping magicalMapping = (MagicalMapping)arrayList2.get(i);
                string5 = magicalMapping.getMethodName();
                Method method = this.resolveGetter(object.getClass(), magicalMapping);
                if (method == null) {
                    throw new NullPointerException("Cannot find a 'getter' for " + string5);
                }
                string5 = method.getName();
                Object object4 = this.invokeMethod(object, magicalMapping);
                if (logger.isTraceEnabled()) {
                    String string6 = "";
                    if (object4 != null) {
                        string6 = object4.getClass().getName() + ": ";
                    }
                    logger.trace((Object)("Setting parameter # " + (i + 1) + " = " + string6 + object4));
                }
                object3.setObject(i + 1, object4);
            }
            object2 = object3.executeQuery();
            if (object2.next()) {
                n = object2.getInt(1);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            SQLException sQLException = new SQLException("Unable to invoke the method " + string5 + " on object " + object.getClass().getName());
            sQLException.initCause(invocationTargetException);
            throw sQLException;
        }
        catch (IllegalAccessException illegalAccessException) {
            SQLException sQLException = new SQLException("Unable to invoke the method " + string5 + " on object " + object.getClass().getName());
            sQLException.initCause(illegalAccessException);
            throw sQLException;
        }
        finally {
            AbstractDatabaseManager.closeEm(null, (Statement)object3, (ResultSet)object2);
        }
        return n;
    }

    public int deleteObject(Connection connection, Object object, String string) throws SQLException, DataException {
        String string2;
        Object object2;
        if (connection == null) {
            throw new NullPointerException("The connection passed in was null");
        }
        if (object == null) {
            throw new NullPointerException("The object passed in was null");
        }
        MagicalAssociation magicalAssociation = this.lookupAssociation(object.getClass());
        if (magicalAssociation == null) {
            throw new NullPointerException("The file " + this.filename + " does not contain a mapping for " + object.getClass().getName());
        }
        MagicalMapping[] magicalMappingArray = magicalAssociation.listMappings();
        if (magicalMappingArray == null) {
            throw new NullPointerException("The file " + this.filename + " contains an empty mapping for " + object.getClass().getName());
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<MagicalMapping> arrayList2 = new ArrayList<MagicalMapping>();
        String string3 = null;
        for (int i = 0; i < magicalMappingArray.length; ++i) {
            String string4 = magicalMappingArray[i].getTableName();
            if (string4 == null) {
                string4 = magicalAssociation.getTableName();
            }
            object2 = string + "." + string4;
            if (string == null || string.length() == 0) {
                object2 = string4;
            }
            if (string3 == null) {
                string3 = object2;
            } else if (!string3.equals(object2)) {
                throw new SQLException("The object " + object.getClass().getName() + " is trying to delete data in two different " + " tables: " + string4 + " and " + string3);
            }
            string2 = magicalMappingArray[i].getColumnName();
            if (!magicalMappingArray[i].isPrimaryKey()) continue;
            arrayList.add(string2);
            arrayList2.add(magicalMappingArray[i]);
        }
        if (arrayList.size() == 0) {
            throw new SQLException("Unable to compose the Delete-WHERE clause for object " + object.getClass().getName());
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("delete from ");
        stringBuffer.append(string3);
        stringBuffer.append(" where ");
        for (int i = 0; i < arrayList.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(" and ");
            }
            stringBuffer.append((String)arrayList.get(i));
            stringBuffer.append("= ?");
        }
        String string5 = stringBuffer.toString();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("SQL is: " + string5));
        }
        object2 = null;
        string2 = null;
        int n = -1;
        try {
            object2 = connection.prepareStatement(string5);
            for (int i = 0; i < arrayList2.size(); ++i) {
                MagicalMapping magicalMapping = (MagicalMapping)arrayList2.get(i);
                string2 = magicalMapping.getMethodName();
                Method method = this.resolveGetter(object.getClass(), magicalMapping);
                if (method == null) {
                    throw new NullPointerException("Cannot find a 'getter' for " + string2);
                }
                string2 = method.getName();
                Object object3 = this.invokeMethod(object, magicalMapping);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Setting parameter # " + (i + 1) + " = " + object3.getClass().getName() + ": " + object3));
                }
                object2.setObject(i + 1, object3);
            }
            n = object2.executeUpdate();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SQLException("Unable to invoke the method " + string2 + " on object " + object.getClass().getName());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SQLException("Unable to invoke the method " + string2 + " on object " + object.getClass().getName());
        }
        finally {
            AbstractDatabaseManager.closeEm(null, (Statement)object2, null);
        }
        return n;
    }

    protected void doInsert(Object object, String string, MagicalMapping[] magicalMappingArray, Connection connection) throws SQLException {
        this.doInsert(new Object[]{object}, string, magicalMappingArray, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInsert(Object[] objectArray, String string, MagicalMapping[] magicalMappingArray, Connection connection) throws SQLException {
        if (objectArray.length == 0) {
            return;
        }
        String string2 = magicalMappingArray[0].getTableName();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl = false;
        int n = 0;
        for (int i = 0; i < magicalMappingArray.length; ++i) {
            if (magicalMappingArray[i].isIgnored() || magicalMappingArray[i].isIgnoredOnSave()) {
                if (!logger.isTraceEnabled()) continue;
                logger.trace((Object)("Skipping column " + magicalMappingArray[i].getColumnName() + " because it's marked as 'ignore'."));
                continue;
            }
            if (magicalMappingArray[i].isAutoIncrement()) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Skipping column " + magicalMappingArray[i].getColumnName() + " because it's marked as 'autoincrement'."));
                }
                bl = true;
                continue;
            }
            if (n > 0) {
                stringBuffer.append(", ");
                stringBuffer2.append(", ");
            }
            stringBuffer.append(magicalMappingArray[i].getColumnName());
            stringBuffer2.append("?");
            if (!string2.equals(magicalMappingArray[i].getTableName())) {
                throw new IllegalStateException("Element " + i + " in the mapping array refers to a " + " different table than the previous mappings.");
            }
            ++n;
        }
        StringBuffer stringBuffer3 = new StringBuffer();
        stringBuffer3.append("insert into ");
        if (string != null && string.length() > 0) {
            stringBuffer3.append(string);
            stringBuffer3.append(".");
        }
        stringBuffer3.append(string2);
        stringBuffer3.append(" (");
        stringBuffer3.append(stringBuffer.toString());
        stringBuffer3.append(") values (");
        stringBuffer3.append(stringBuffer2.toString());
        stringBuffer3.append(")");
        String string3 = stringBuffer3.toString();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Generated SQL= " + string3));
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(string3, 1);
            int n2 = 0;
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                Class<?> clazz = object.getClass();
                int n3 = 0;
                for (int j = 0; j < magicalMappingArray.length; ++j) {
                    Object object2;
                    Object object3;
                    if (magicalMappingArray[j].isIgnored() || magicalMappingArray[j].isAutoIncrement() || magicalMappingArray[j].isIgnoredOnSave()) continue;
                    ++n3;
                    String string4 = magicalMappingArray[j].getColumnName();
                    if (AbstractDatabaseManager.isUnicodeField(string4) && preparedStatement instanceof AbstractDatabaseManager.WrappedPreparedStatement) {
                        object3 = (AbstractDatabaseManager.WrappedPreparedStatement)preparedStatement;
                        ((AbstractDatabaseManager.WrappedPreparedStatement)object3).defineUnicodeParm(n3, string4);
                    }
                    object3 = magicalMappingArray[j].getMethodName();
                    try {
                        Object object4 = this.invokeMethod(object, magicalMappingArray[j]);
                        if (object4 == null) {
                            object2 = null;
                            int n4 = -1;
                            try {
                                object2 = preparedStatement.getParameterMetaData();
                                n4 = object2.getParameterType(n3);
                                if (logger.isTraceEnabled()) {
                                    logger.trace((Object)("Plugging in NULL sql type # " + n4));
                                }
                                preparedStatement.setNull(n3, n4);
                            }
                            catch (Exception exception) {
                                object4 = this.guessSqlNullValue(magicalMappingArray[j]);
                            }
                        }
                        if (object4 == null) continue;
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)("Plugging in " + (String)object3 + " value (" + object4.getClass().getName() + ") = " + object4));
                        }
                        if (object4.getClass() == byte[].class) {
                            preparedStatement.setBytes(n3, (byte[])object4);
                            continue;
                        }
                        preparedStatement.setObject(n3, object4);
                        continue;
                    }
                    catch (Exception exception) {
                        object2 = "Unable to get/use the value from the 'getter' method for " + (String)object3 + " from object " + clazz.getName();
                        logger.debug(object2, (Throwable)exception);
                        SQLException sQLException = new SQLException((String)object2);
                        sQLException.initCause(exception);
                        throw sQLException;
                    }
                }
                preparedStatement.execute();
                n2 = preparedStatement.getUpdateCount();
                if (n2 != 1) {
                    throw new SQLException("The insert affected " + n2 + " rows. It should have been 1.");
                }
                if (!bl) continue;
                resultSet = preparedStatement.getGeneratedKeys();
                if (resultSet.next()) {
                    this.saveAutoIncrementValues(object, resultSet);
                }
                resultSet.close();
            }
        }
        finally {
            AbstractDatabaseManager.closeEm(null, preparedStatement, resultSet);
        }
    }

    private String guessSqlNullValue(MagicalMapping magicalMapping) {
        String string = magicalMapping.getParameterType();
        if (string.endsWith("String") || string.equals("byte[]") || string.equals("char")) {
            return "";
        }
        return "0";
    }

    public Object fetchAndFill(Connection connection, Object object, String string) throws SQLException, DataException {
        Object object2;
        Object object3;
        if (connection == null) {
            throw new NullPointerException("The connection passed in was null");
        }
        if (object == null) {
            throw new NullPointerException("The object passed in was null");
        }
        MagicalAssociation magicalAssociation = this.lookupAssociation(object.getClass());
        if (magicalAssociation == null) {
            throw new NullPointerException("The file " + this.filename + " does not contain a mapping for " + object.getClass().getName());
        }
        MagicalMapping[] magicalMappingArray = magicalAssociation.listMappings();
        if (magicalMappingArray == null) {
            throw new NullPointerException("The file " + this.filename + " contains an empty mapping for " + object.getClass().getName());
        }
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        for (int i = 0; i < magicalMappingArray.length; ++i) {
            if (!magicalMappingArray[i].isPrimaryKey()) continue;
            String string2 = magicalMappingArray[i].getMethodName();
            object3 = this.resolveGetter(object.getClass(), magicalMappingArray[i]);
            if (object3 == null) {
                throw new NullPointerException("Cannot find a 'getter' for " + string2);
            }
            string2 = ((Method)object3).getName();
            object2 = null;
            try {
                object2 = this.invokeMethod(object, magicalMappingArray[i]);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new SQLException("Unable to invoke the method " + string2 + " on object " + object.getClass().getName());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SQLException("Unable to invoke the method " + string2 + " on object " + object.getClass().getName());
            }
            if (object2 instanceof Serializable) {
                hashMap.put(string2, (Serializable)object2);
                continue;
            }
            hashMap.put(string2, (Serializable)((Object)object2.toString()));
        }
        if (hashMap.size() == 0) {
            throw new SQLException("No primary keys found for object " + object.getClass().getName());
        }
        Object[] objectArray = null;
        try {
            objectArray = this.search(connection, object, hashMap, string);
        }
        catch (BadDataArrayException badDataArrayException) {
            object3 = badDataArrayException.getErrors().getErrorsForIndex(0);
            object3.nextError();
            object2 = (Exception)object3.getErrorObject();
            if (object2 instanceof BadDataException) {
                throw (BadDataException)((Object)object2);
            }
            throw badDataArrayException;
        }
        if (objectArray.length == 0) {
            return null;
        }
        if (objectArray.length > 1) {
            throw new SQLException("More than one match was found for the given object.");
        }
        return objectArray[0];
    }

    protected Object grabValueFromResultSet(ResultSet resultSet, int n, Class clazz, MagicalMapping magicalMapping) throws SQLException, BadDataException {
        Object object;
        if (clazz == String.class) {
            String string = resultSet.getString(n);
            if (string == null) {
                return null;
            }
            if (string.length() == 0) {
                return string;
            }
            if (magicalMapping.trimRight()) {
                int n2;
                for (n2 = string.length() - 1; n2 > -1 && string.charAt(n2) == ' '; --n2) {
                }
                string = string.substring(0, n2 + 1);
            }
            return string;
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            object = resultSet.getString(n);
            if (object == null) {
                return new Boolean(false);
            }
            object = ((String)object).toUpperCase().trim();
            String string = null;
            String string2 = null;
            if (magicalMapping != null) {
                string2 = magicalMapping.getBooleanFalse();
                string = magicalMapping.getBooleanTrue();
            }
            if (((String)object).equals(string2) || ((String)object).equals("") || ((String)object).equals("N") || ((String)object).equals("NO") || ((String)object).equals("F") || ((String)object).equals("FALSE") || ((String)object).equals("0") || ((String)object).equals("-")) {
                return new Boolean(false);
            }
            if (((String)object).equals(string) || ((String)object).equals("Y") || ((String)object).equals("YES") || ((String)object).equals("T") || ((String)object).equals("TRUE") || ((String)object).equals("1") || ((String)object).equals("+")) {
                return new Boolean(true);
            }
        }
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return new Byte(resultSet.getByte(n));
        }
        if (clazz == byte[].class) {
            return resultSet.getBytes(n);
        }
        if (clazz == Character.class || clazz == Character.TYPE) {
            object = resultSet.getString(n);
            if (((String)object).length() == 0) {
                return new Character(' ');
            }
            if (((String)object).length() == 1) {
                return new Character(((String)object).charAt(0));
            }
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return new Double(resultSet.getDouble(n));
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return new Float(resultSet.getFloat(n));
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            if (magicalMapping.getNumericNull() == null) {
                return new Integer(resultSet.getInt(n));
            }
            object = this.checkNumericNull(magicalMapping, resultSet, n);
            return new Integer(((Long)object).intValue());
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            if (magicalMapping.getNumericNull() == null) {
                return new Long(resultSet.getLong(n));
            }
            object = this.checkNumericNull(magicalMapping, resultSet, n);
            return new Long((Long)object);
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            if (magicalMapping.getNumericNull() == null) {
                return new Short(resultSet.getShort(n));
            }
            object = this.checkNumericNull(magicalMapping, resultSet, n);
            return new Short(((Long)object).shortValue());
        }
        if (clazz == Object.class) {
            return resultSet.getObject(n);
        }
        if (clazz == Date.class || clazz == java.util.Date.class) {
            return resultSet.getDate(n);
        }
        if (clazz == Time.class) {
            return resultSet.getTime(n);
        }
        if (clazz == Timestamp.class) {
            return resultSet.getTimestamp(n);
        }
        object = resultSet.getString(n);
        throw new BadDataException("Column '" + n + "' contains value '" + (String)object + "' which cannot be mapped into a " + clazz.getName() + ".", null, null, null);
    }

    private long checkNumericNull(MagicalMapping magicalMapping, ResultSet resultSet, int n) throws SQLException {
        Object object = resultSet.getObject(n);
        if (object == null) {
            if (magicalMapping.getNumericNull() != null) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Translating numeric null value for column " + n + "(" + magicalMapping.getColumnName() + ") to " + magicalMapping.getNumericNull()));
                }
                return magicalMapping.getNumericNull();
            }
            return 0L;
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            return number.longValue();
        }
        throw new SQLException("The value for column " + n + " (" + magicalMapping.getColumnName() + ") is not a number: " + object.getClass().getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertObject(Object object, String string, Connection connection, boolean bl) throws SQLException {
        try {
            if (object == null) {
                throw new NullPointerException("The busobj passed in is null.");
            }
            if (connection == null) {
                throw new NullPointerException("The connection passed in is null.");
            }
            MagicalAssociation magicalAssociation = this.lookupAssociation(object.getClass());
            if (magicalAssociation == null) {
                throw new NullPointerException("The file " + this.filename + " does not contain a mapping for " + object.getClass().getName());
            }
            MagicalMapping[] magicalMappingArray = magicalAssociation.listMappings();
            if (magicalMappingArray == null) {
                throw new NullPointerException("The file " + this.filename + " contains an empty mapping for " + object.getClass().getName());
            }
            Comparator<MagicalMapping> comparator = new Comparator<MagicalMapping>(){

                @Override
                public int compare(MagicalMapping magicalMapping, MagicalMapping magicalMapping2) {
                    return magicalMapping.getTableName().compareTo(magicalMapping2.getTableName());
                }
            };
            Arrays.sort(magicalMappingArray, comparator);
            String string2 = null;
            Vector<MagicalMapping> vector = new Vector<MagicalMapping>();
            for (int i = 0; i < magicalMappingArray.length; ++i) {
                String string3 = magicalMappingArray[i].getTableName();
                if (string2 != null && !string3.equals(string2)) {
                    MagicalMapping[] magicalMappingArray2 = new MagicalMapping[vector.size()];
                    vector.toArray(magicalMappingArray2);
                    this.doInsert(object, string, magicalMappingArray2, connection);
                    vector.removeAllElements();
                }
                string2 = string3;
                vector.addElement(magicalMappingArray[i]);
            }
            if (vector.size() > 0) {
                MagicalMapping[] magicalMappingArray3 = new MagicalMapping[vector.size()];
                vector.toArray(magicalMappingArray3);
                this.doInsert(object, string, magicalMappingArray3, connection);
            }
        }
        finally {
            if (bl) {
                AbstractDatabaseManager.closeEm(connection, null, null);
            }
        }
    }

    public void insertObjects(Object[] objectArray, String string, Connection connection) throws SQLException {
        if (objectArray == null) {
            throw new NullPointerException("The busobj passed in is null.");
        }
        if (objectArray.length == 0) {
            return;
        }
        if (connection == null) {
            throw new NullPointerException("The connection passed in is null.");
        }
        Object object = objectArray[0];
        MagicalAssociation magicalAssociation = this.lookupAssociation(object.getClass());
        if (magicalAssociation == null) {
            throw new NullPointerException("The file " + this.filename + " does not contain a mapping for " + object.getClass().getName());
        }
        MagicalMapping[] magicalMappingArray = magicalAssociation.listMappings();
        if (magicalMappingArray == null) {
            throw new NullPointerException("The file " + this.filename + " contains an empty mapping for " + object.getClass().getName());
        }
        this.doInsert(objectArray, string, magicalMappingArray, connection);
    }

    protected Object invokeMethod(Object object, MagicalMapping magicalMapping) throws InvocationTargetException, IllegalAccessException {
        Object object2;
        Comparable<Boolean> comparable;
        String string = magicalMapping.getMethodName();
        Class<?> clazz = object.getClass();
        Method method = this.resolveGetter(clazz, magicalMapping);
        if (method == null) {
            throw new NullPointerException("Could not find a 'getter' method for " + string);
        }
        Object object3 = method.invoke(object, (Object[])null);
        if (object3 != null && object3 instanceof Boolean) {
            String string2;
            if (magicalMapping.useBooleanObject()) {
                return object3;
            }
            comparable = (Boolean)object3;
            object2 = magicalMapping.getBooleanTrue();
            if (object2 == null) {
                object2 = "T";
            }
            if ((string2 = magicalMapping.getBooleanFalse()) == null) {
                string2 = "F";
            }
            object3 = ((Boolean)comparable).booleanValue() ? object2 : string2;
        }
        if (object3 != null && object3 instanceof Character && "char".equalsIgnoreCase(magicalMapping.getParameterType())) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Convering Character '" + object3 + "' to a String"));
            }
            object3 = object3.toString();
        }
        if (object3 != null && magicalMapping.getNumericNull() != null) {
            comparable = magicalMapping.getNumericNull();
            if (object3 instanceof Number) {
                object2 = (Number)object3;
                if (((Long)comparable).longValue() == ((Number)object2).longValue()) {
                    return null;
                }
            }
        }
        return object3;
    }

    public Object[] loadArray(Object object, String string, Connection connection, boolean bl) throws BadDataArrayException, SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        return this.loadArray(object, preparedStatement, bl, true);
    }

    public Object[] loadArray(Object object, PreparedStatement preparedStatement, boolean bl) throws BadDataArrayException, SQLException {
        return this.loadArray(object, preparedStatement, bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] loadArray(Object object, PreparedStatement preparedStatement, boolean bl, boolean bl2) throws BadDataArrayException, SQLException {
        if (object == null) {
            throw new NullPointerException("The busobj passed in is null.");
        }
        if (preparedStatement == null) {
            throw new NullPointerException("The Statmenet passed in is null.");
        }
        ResultSet resultSet = null;
        try {
            resultSet = preparedStatement.executeQuery();
            Object[] objectArray = this.loadArray(object, resultSet);
            return objectArray;
        }
        finally {
            if (bl) {
                AbstractDatabaseManager.closeEm(preparedStatement.getConnection(), null, null);
            }
            if (bl2) {
                AbstractDatabaseManager.closeEm(null, preparedStatement, null);
            }
            AbstractDatabaseManager.closeEm(null, null, resultSet);
        }
    }

    public Object[] loadArray(Object object, ResultSet resultSet) throws BadDataArrayException, SQLException {
        Object[] objectArray;
        try {
            object.getClass().newInstance();
        }
        catch (Exception exception) {
            SQLException sQLException = new SQLException("Unable to create a new instance of " + object.getClass().getName());
            sQLException.initCause(exception);
            throw sQLException;
        }
        Vector<Object[]> vector = new Vector<Object[]>();
        ErrorTable errorTable = new ErrorTable();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        while (resultSet.next()) {
            objectArray = null;
            try {
                objectArray = (Object[])object.getClass().newInstance();
            }
            catch (Exception exception) {
                SQLException sQLException = new SQLException("Unable to create a new instance of " + object.getClass().getName());
                sQLException.initCause(exception);
                throw sQLException;
            }
            try {
                this.loadObject(objectArray, resultSet, hashMap);
            }
            catch (BadDataException badDataException) {
                errorTable.addException(vector.size() + 1, (Exception)((Object)badDataException));
            }
            vector.add(objectArray);
        }
        objectArray = (Object[])Array.newInstance(object.getClass(), vector.size());
        vector.toArray(objectArray);
        if (errorTable.getBadObjectCount() > 0) {
            throw new BadDataArrayException("One or more of the objects contained bad data.", objectArray, errorTable);
        }
        return objectArray;
    }

    public Object loadObject(Object object, ResultSet resultSet, HashMap<String, Object> hashMap) throws BadDataException, SQLException {
        Object object2;
        Object object3;
        String string;
        if (object == null) {
            throw new NullPointerException("The busobj passed in is null.");
        }
        if (resultSet == null) {
            throw new NullPointerException("The ResultSet passed in is null.");
        }
        if (hashMap == null) {
            throw new NullPointerException("The hints-map is null.");
        }
        String string2 = Integer.toString(System.identityHashCode(resultSet));
        MagicalAssociation magicalAssociation = (MagicalAssociation)hashMap.get(string2);
        if (magicalAssociation == null) {
            magicalAssociation = this.lookupAssociation(object.getClass());
            hashMap.clear();
            hashMap.put(string2, magicalAssociation);
        }
        if (magicalAssociation == null) {
            throw new NullPointerException("The file " + this.filename + " does not contain a mapping for " + object.getClass().getName());
        }
        MagicalMapping[] magicalMappingArray = (MagicalMapping[])hashMap.get("mappingArray");
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        if (magicalMappingArray == null || magicalMappingArray.length != n) {
            magicalMappingArray = new MagicalMapping[n];
            hashMap.put("mappingArray", magicalMappingArray);
            for (int i = 0; i < n; ++i) {
                String string3 = resultSetMetaData.getColumnName(i + 1).toUpperCase();
                string = resultSetMetaData.getTableName(i + 1);
                object3 = string3;
                if (string3.indexOf(BUG_6621_HACK) > -1 && ((String[])(object2 = string3.split(BUG_6621_HACK))).length == 2) {
                    string = object2[0];
                    object3 = object2[1];
                }
                magicalMappingArray[i] = object2 = magicalAssociation.lookupMapping(string, (String)object3);
            }
        }
        ExceptionErrorList exceptionErrorList = new ExceptionErrorList();
        for (int i = 0; i < n; ++i) {
            Object object4;
            string = resultSetMetaData.getColumnName(i + 1);
            object3 = magicalMappingArray[i];
            if (object3 == null) {
                exceptionErrorList.addException((Exception)new RuntimeException("The DB field " + string + " is not mapped anything within the to object " + object.getClass().getName()));
                continue;
            }
            if (((MagicalMapping)object3).isIgnored()) continue;
            object2 = ((MagicalMapping)object3).getMethodName();
            String string4 = ((MagicalMapping)object3).getParameterType();
            Object object5 = null;
            Class clazz = null;
            try {
                clazz = SQLManagerHelper.resolveClass(string4);
                object5 = this.grabValueFromResultSet(resultSet, i + 1, clazz, (MagicalMapping)object3);
                object4 = this.resolveSetter(object.getClass(), (MagicalMapping)object3);
                if (object4 == null) continue;
                ((Method)object4).invoke(object, object5);
                continue;
            }
            catch (Exception exception) {
                Object object6;
                if (exception instanceof InvocationTargetException) {
                    object6 = exception.getCause();
                    if (object6 instanceof Error) {
                        throw (Error)object6;
                    }
                    object4 = (Exception)object6;
                }
                if (logger.isDebugEnabled()) {
                    object6 = object.getClass().getName() + "{cl=" + object.getClass().getClassLoader() + "}." + (String)object2 + "(" + clazz.getName() + "{cl=" + clazz.getClassLoader() + ", value=" + clazz + "})";
                    logger.debug((Object)("Invoke method failed: " + (String)object6), (Throwable)object4);
                }
                exceptionErrorList.addException((Exception)object4);
            }
        }
        if (exceptionErrorList.getErrorCount() > 0) {
            throw new BadDataException("Unable to fully restore the object " + object.getClass().getName(), object, (ErrorList)exceptionErrorList);
        }
        return object;
    }

    public MagicalAssociation lookupAssociation(Class<? extends Object> clazz) {
        return this.associationTable.get(clazz.getName());
    }

    protected Document loadXMLFile(String string, boolean bl, ClassLoader classLoader) throws IOException {
        if (string == null) {
            throw new NullPointerException("The filename passed in is null.");
        }
        Document document = null;
        try {
            document = bl ? XMLUtil.loadXMLAsResource((String)string, (ClassLoader)classLoader) : XMLUtil.loadXML((String)string);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            IOException iOException = new IOException("Unable to find a parser for the XML.");
            iOException.initCause(parserConfigurationException);
            throw iOException;
        }
        catch (SAXException sAXException) {
            IOException iOException = new IOException("Error parsing the XML file.");
            iOException.initCause(sAXException);
            throw iOException;
        }
        return document;
    }

    protected void parseDocument(Document document) {
        if (document == null) {
            throw new NullPointerException("The XML Document passed in is null.");
        }
        Element element = document.getDocumentElement();
        if (element == null) {
            return;
        }
        String string = element.getNodeName();
        if (!"database-mappings".equalsIgnoreCase(string)) {
            throw new RuntimeException("The first node in the Document was " + string + ". It should be 'database-mappings'");
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            MagicalAssociation magicalAssociation = this.parseAssociation((Element)node);
            this.associationTable.put(magicalAssociation.getClassname(), magicalAssociation);
            String[] stringArray = magicalAssociation.listProxies();
            if (stringArray == null || stringArray.length <= 0) continue;
            for (int i = 0; i < stringArray.length; ++i) {
                this.associationTable.put(stringArray[i], magicalAssociation);
            }
        }
    }

    protected MagicalAssociation parseAssociation(Element element) {
        String string;
        if (element == null) {
            throw new NullPointerException("The element passed in is null.");
        }
        String string2 = element.getNodeName();
        if (!"association".equalsIgnoreCase(string2)) {
            throw new RuntimeException("The element passed in is a " + string2 + ". It should be 'association'");
        }
        String string3 = element.getAttribute("class");
        if (string3 == null) {
            throw new NullPointerException("An 'association' node is missing a 'class' attribute.");
        }
        String string4 = element.getAttribute("table");
        if (string4 == null) {
            throw new NullPointerException("An 'association' node is missing a 'table' attribute.");
        }
        String string5 = element.getAttribute("leftOuterJoin");
        if (string5 != null && string5.length() == 0) {
            string5 = null;
        }
        MagicalAssociation magicalAssociation = new MagicalAssociation(string3, string4, string5);
        String string6 = element.getAttribute("defaultSortField");
        if (string6 != null && string6.length() == 0) {
            string6 = null;
        }
        if ((string = element.getAttribute("defaultSortDirection")) != null && string.length() == 0) {
            string = null;
        }
        if (string6 != null) {
            int n = -1;
            try {
                n = Integer.parseInt(string6);
            }
            catch (NumberFormatException numberFormatException) {
                throw new NumberFormatException("The mapping for class " + string3 + " contains an invalid 'defaultSortField' number: " + string6);
            }
            if (string == null) {
                string = "a";
            }
            int n2 = 0;
            if (string.toUpperCase().startsWith("D")) {
                n2 = 1;
            }
            magicalAssociation.setDefaultSort((SortField)new GenericSortField(n, n2));
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Object object;
            String string7 = node.getNodeName();
            if (!(node instanceof Element)) continue;
            if ("mapping".equals(string7) && (object = this.parseMapping((Element)node)) != null) {
                if (((MagicalMapping)object).getTableName() == null || ((MagicalMapping)object).getTableName().length() == 0) {
                    ((MagicalMapping)object).setTableName(string4);
                }
                magicalAssociation.addMapping((MagicalMapping)object);
            }
            if (!"proxy".equals(string7) || (object = this.parseProxy((Element)node)) == null || ((String)object).length() <= 0) continue;
            magicalAssociation.addProxy((String)object);
        }
        return magicalAssociation;
    }

    protected MagicalMapping parseMapping(Element element) {
        Object object;
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        if (element == null) {
            throw new NullPointerException("The element passed in is null.");
        }
        String string9 = element.getNodeName();
        if (!"mapping".equalsIgnoreCase(string9)) {
            throw new RuntimeException("The element passed in is a " + string9 + ". It should be 'mapping'");
        }
        String string10 = element.getAttribute("field");
        if (string10 == null) {
            throw new NullPointerException("A 'mapping' node is missing a 'field' attribute.");
        }
        boolean bl = false;
        String string11 = element.getAttribute("ignore");
        if (string11 != null && string11.equalsIgnoreCase("true")) {
            bl = true;
        }
        String string12 = element.getAttribute("method");
        if (!bl && string12 == null) {
            throw new NullPointerException("A 'mapping' node is missing a 'method' attribute.");
        }
        String string13 = element.getAttribute("type");
        if (!bl && string13 == null) {
            throw new NullPointerException("A 'mapping' node is missing a 'type' attribute.");
        }
        String string14 = element.getAttribute("table");
        MagicalMapping magicalMapping = new MagicalMapping(string10, string12, string13, string14, bl);
        String string15 = element.getAttribute("useBooleanObject");
        if (string15 != null) {
            magicalMapping.setUseBooleanObject("true".equalsIgnoreCase(string15));
        }
        if ((string8 = element.getAttribute("booleanTrue")) != null) {
            magicalMapping.setBooleanTrue(string8);
        }
        if ((string7 = element.getAttribute("booleanFalse")) != null) {
            magicalMapping.setBooleanFalse(string7);
        }
        if ("true".equalsIgnoreCase(string6 = element.getAttribute("pk"))) {
            magicalMapping.setPrimaryKey(true);
        }
        if ((string5 = element.getAttribute("filter")) != null && string5.length() > 0) {
            magicalMapping.setFilterField(string5);
        }
        if ("false".equalsIgnoreCase(string4 = element.getAttribute("trimRight"))) {
            magicalMapping.setTrimRight(false);
        }
        if ((string3 = element.getAttribute("sort")) != null && string3.length() > 0) {
            try {
                int n = Integer.parseInt(string3);
                magicalMapping.setSortKey(n);
            }
            catch (NumberFormatException numberFormatException) {
                throw new NumberFormatException("The mapping " + string10 + " contains an invalid 'sort' tag: " + string3);
            }
        }
        if ("true".equalsIgnoreCase(string2 = element.getAttribute("autoincrement"))) {
            magicalMapping.setAutoIncrement(true);
        }
        if ((string = element.getAttribute("numericNull")) != null && string.trim().length() > 0) {
            object = new Long(string.trim());
            magicalMapping.setNumericNull((Long)object);
        }
        if ((object = element.getAttribute("ignoreOnSave")) != null && ((String)object).equalsIgnoreCase("true")) {
            magicalMapping.setIgnoredOnSave(true);
        }
        return magicalMapping;
    }

    protected String parseProxy(Element element) {
        if (element == null) {
            throw new NullPointerException("The element passed in is null.");
        }
        String string = element.getNodeName();
        if (!"proxy".equalsIgnoreCase(string)) {
            throw new RuntimeException("The element passed in is a " + string + ". It should be 'proxy'");
        }
        String string2 = element.getAttribute("class");
        if (string2 == null) {
            throw new NullPointerException("A 'proxy' node is missing a 'class' attribute.");
        }
        if (string2 != null) {
            string2 = string2.trim();
        }
        return string2;
    }

    public static Class resolveClass(String string) throws ClassNotFoundException {
        if (string == null) {
            return Void.TYPE;
        }
        if (string.equals("String") || string.equals("java.lang.String")) {
            return String.class;
        }
        if (string.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (string.equals("byte")) {
            return Byte.TYPE;
        }
        if (string.equals("byte[]")) {
            return byte[].class;
        }
        if (string.equals("char")) {
            return Character.TYPE;
        }
        if (string.equals("double")) {
            return Double.TYPE;
        }
        if (string.equals("float")) {
            return Float.TYPE;
        }
        if (string.equals("int")) {
            return Integer.TYPE;
        }
        if (string.equals("long")) {
            return Long.TYPE;
        }
        if (string.equals("short")) {
            return Short.TYPE;
        }
        Class<?> clazz = null;
        ClassNotFoundException classNotFoundException = null;
        try {
            clazz = Class.forName(string);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException2) {
            classNotFoundException = classNotFoundException2;
            try {
                clazz = Class.forName("java.lang." + string);
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException3) {
                throw classNotFoundException;
            }
        }
    }

    protected Method resolveGetter(Class<? extends Object> clazz, MagicalMapping magicalMapping) {
        Method method = magicalMapping.getGetter(clazz.getName());
        if (method == null) {
            this.resolveMethods(clazz, magicalMapping);
            method = magicalMapping.getGetter(clazz.getName());
        }
        if (method == NULL_METHOD || method == null) {
            return null;
        }
        return method;
    }

    protected void resolveMethods(Class<? extends Object> clazz, MagicalMapping magicalMapping) {
        boolean bl;
        String string;
        Method method;
        block13: {
            method = null;
            string = null;
            bl = false;
            MagicalAssociation magicalAssociation = this.lookupAssociation(clazz);
            if (magicalAssociation.isDefinedProxy(clazz)) {
                bl = true;
            }
            String string2 = magicalMapping.getParameterType();
            try {
                string = magicalMapping.getMethodName();
                Class clazz2 = SQLManagerHelper.resolveClass(string2);
                method = clazz.getMethod(string, clazz2);
                if (method == null) {
                    method = NULL_METHOD;
                }
                magicalMapping.setSetter(clazz.getName(), method);
            }
            catch (Exception exception) {
                if (bl) break block13;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Unable to find method " + clazz.getName() + "." + string + "(" + string2 + ")"), (Throwable)exception);
                }
                magicalMapping.setSetter(clazz.getName(), NULL_METHOD);
            }
        }
        string = "g" + string.substring(1);
        try {
            method = clazz.getMethod(string, null);
            if (method != null) {
                magicalMapping.setGetter(clazz.getName(), method);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        string = "is" + string.substring(3);
        try {
            method = clazz.getMethod(string, null);
            if (method != null) {
                magicalMapping.setGetter(clazz.getName(), method);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            magicalMapping.setGetter(clazz.getName(), NULL_METHOD);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Unable to find a 'get' or 'is' method for class " + clazz.getName()));
            }
        }
    }

    protected Method resolveSetter(Class<? extends Object> clazz, MagicalMapping magicalMapping) throws NoSuchMethodException {
        Method method = magicalMapping.getSetter(clazz.getName());
        if (method == null) {
            this.resolveMethods(clazz, magicalMapping);
            method = magicalMapping.getSetter(clazz.getName());
        }
        if (method == NULL_METHOD || method == null) {
            MagicalAssociation magicalAssociation = this.lookupAssociation(clazz);
            if (magicalAssociation.isDefinedProxy(clazz)) {
                method = null;
            } else {
                throw new NoSuchMethodException("The class " + clazz.getName() + " does not contain a setter for " + magicalMapping.getMethodName() + "(" + magicalMapping.getParameterType() + ")");
            }
        }
        return method;
    }

    protected MagicalMapping[] retrieveMappingOrFail(Object object) {
        if (object == null) {
            throw new NullPointerException("The object passed in is null.");
        }
        MagicalAssociation magicalAssociation = this.lookupAssociation(object.getClass());
        if (magicalAssociation == null) {
            throw new NullPointerException("The file " + this.filename + " does not contain a mapping for " + object.getClass().getName());
        }
        MagicalMapping[] magicalMappingArray = magicalAssociation.listMappings();
        if (magicalMappingArray == null) {
            throw new NullPointerException("The file " + this.filename + " contains an empty mapping for " + object.getClass().getName());
        }
        return magicalMappingArray;
    }

    protected void saveAutoIncrementValues(Object object, ResultSet resultSet) throws SQLException {
        MagicalMapping[] magicalMappingArray = this.retrieveMappingOrFail(object);
        int n = 0;
        for (int i = 0; i < magicalMappingArray.length; ++i) {
            if (!magicalMappingArray[i].isAutoIncrement()) continue;
            ++n;
        }
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n2 = resultSetMetaData.getColumnCount();
        if (n2 < n) {
            throw new SQLException("Expected " + magicalMappingArray.length + " autoincrement values, instead we received " + n2);
        }
        int n3 = 0;
        for (int i = 0; i < magicalMappingArray.length; ++i) {
            Serializable serializable;
            if (!magicalMappingArray[i].isAutoIncrement()) continue;
            ++n3;
            Object object2 = null;
            String string = null;
            try {
                Method method;
                string = magicalMappingArray[i].getMethodName();
                String string2 = magicalMappingArray[i].getParameterType();
                serializable = SQLManagerHelper.resolveClass(string2);
                object2 = this.grabValueFromResultSet(resultSet, n3, (Class)serializable, magicalMappingArray[i]);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("value is " + object2.getClass().getName() + " = " + object2));
                }
                if ((method = this.resolveSetter(object.getClass(), magicalMappingArray[i])) == null) continue;
                method.invoke(object, object2);
                continue;
            }
            catch (Exception exception) {
                Exception exception2;
                if (exception instanceof InvocationTargetException) {
                    exception2 = (Exception)exception.getCause();
                }
                serializable = new SQLException("Unable to save the value " + object2 + " into method " + string);
                ((Throwable)serializable).initCause(exception2);
                throw serializable;
            }
        }
    }

    public Object[] search(Connection connection, Object object, Properties properties, String string) throws SQLException, DataException {
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            hashMap.put((String)entry.getKey(), (Serializable)((Object)((String)entry.getValue())));
        }
        return this.search(connection, object, hashMap, string);
    }

    public Object[] search(Connection connection, Object object, HashMap<String, Serializable> hashMap, String string) throws SQLException, DataException {
        if (hashMap == null) {
            throw new NullPointerException("The search map passed in was null");
        }
        DataSet dataSet = null;
        DataFilter dataFilter = new DataFilter();
        dataFilter.setConjunction(0);
        for (Map.Entry<String, Serializable> objectArray : hashMap.entrySet()) {
            dataFilter.addCriteria(new FilterCriteria(objectArray.getKey(), objectArray.getValue(), 0));
        }
        try {
            dataSet = this.getDataSet(connection, object, dataFilter, null, string, false, -1, -1, false, 1004);
            Object[] dataSetException = dataSet.get(0, dataSet.size());
            Object[] sQLException = (Object[])Array.newInstance(object.getClass(), dataSet.size());
            System.arraycopy(dataSetException, 0, sQLException, 0, dataSetException.length);
            if (sQLException == null) {
                sQLException = new Object[]{};
            }
            Object[] objectArray = sQLException;
            return objectArray;
        }
        catch (DataSetException dataSetException) {
            SQLException sQLException = new SQLException("Unable to create an array from a DataSet");
            sQLException.initCause(dataSetException);
            throw sQLException;
        }
        finally {
            try {
                if (dataSet instanceof ResultSetDataSet) {
                    ((ResultSetDataSet)dataSet).partiallyClose();
                } else {
                    dataSet.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public DataSet getDataSet(Connection connection, Object object, DataFilter dataFilter, SortField sortField, String string, boolean bl) throws SQLException, DataSetException {
        return this.getDataSet(connection, object, dataFilter, sortField, string, bl, 200, 0, true, 1004);
    }

    public DataSet getDataSet(Connection connection, Object object, DataFilter dataFilter, SortField sortField, String string, boolean bl, int n, int n2, boolean bl2, int n3) throws SQLException, DataSetException {
        Object object2;
        int n4;
        Object object3;
        String string2;
        CharSequence charSequence;
        CharSequence charSequence2;
        CharSequence charSequence3;
        if (connection == null) {
            throw new NullPointerException("The connection passed in was null");
        }
        if (object == null) {
            throw new NullPointerException("The object passed in was null");
        }
        DataFilter dataFilter2 = dataFilter;
        MagicalAssociation magicalAssociation = this.lookupAssociation(object.getClass());
        if (magicalAssociation == null) {
            throw new NullPointerException("The file " + this.filename + " does not contain a mapping for " + object.getClass().getName());
        }
        MagicalMapping[] magicalMappingArray = magicalAssociation.listMappings();
        if (magicalMappingArray == null) {
            throw new NullPointerException("The file " + this.filename + " contains an empty mapping for " + object.getClass().getName());
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<CharSequence> arrayList2 = new ArrayList<CharSequence>();
        for (int i = 0; i < magicalMappingArray.length; ++i) {
            if (magicalMappingArray[i].isIgnored()) continue;
            charSequence3 = magicalMappingArray[i].getTableName();
            if (charSequence3 == null) {
                charSequence3 = magicalAssociation.getTableName();
            }
            charSequence2 = string + "." + (String)charSequence3;
            if (string == null || string.length() == 0) {
                charSequence2 = charSequence3;
            }
            if (!arrayList2.contains(charSequence2)) {
                arrayList2.add(charSequence2);
            }
            try {
                int n5;
                Method method = this.resolveSetter(object.getClass(), magicalMappingArray[i]);
                if (method == null) continue;
                charSequence = magicalMappingArray[i].getColumnName();
                String string3 = charSequence;
                string2 = magicalMappingArray[i].getTableName();
                if (string3.contains(".") && (n5 = string3.indexOf(46)) + 1 < string3.length()) {
                    string3 = string3.substring(n5 + 1);
                }
                object3 = (String)charSequence + " as " + string2 + BUG_6621_HACK + string3;
                arrayList.add(object3);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String string4 = null;
        if (dataFilter2 != null) {
            dataFilter2 = (DataFilter)dataFilter2.clone();
            this.fixFilter(dataFilter2, object);
            string4 = SQLWhereClause.getSQL(dataFilter2, false);
        }
        charSequence3 = new StringBuffer();
        charSequence2 = new StringBuffer();
        ((StringBuffer)charSequence3).append("select ");
        ((StringBuffer)charSequence2).append("select count(*) ");
        for (n4 = 0; n4 < arrayList.size(); ++n4) {
            if (n4 > 0) {
                ((StringBuffer)charSequence3).append(", ");
            }
            ((StringBuffer)charSequence3).append((String)arrayList.get(n4));
        }
        ((StringBuffer)charSequence3).append(" from ");
        ((StringBuffer)charSequence2).append(" from ");
        for (n4 = 0; n4 < arrayList2.size(); ++n4) {
            if (n4 > 0) {
                ((StringBuffer)charSequence3).append(", ");
                ((StringBuffer)charSequence2).append(", ");
            }
            ((StringBuffer)charSequence3).append((String)arrayList2.get(n4));
            ((StringBuffer)charSequence2).append((String)arrayList2.get(n4));
        }
        String[] stringArray = magicalAssociation.getLeftOuterJoin();
        if (stringArray != null) {
            charSequence = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                ((StringBuffer)charSequence).append(" left outer join ");
                if (string != null && string.length() > 0) {
                    ((StringBuffer)charSequence).append(string);
                    ((StringBuffer)charSequence).append('.');
                }
                ((StringBuffer)charSequence).append(stringArray[i]);
            }
            ((StringBuffer)charSequence3).append(((StringBuffer)charSequence).toString());
            ((StringBuffer)charSequence2).append(((StringBuffer)charSequence).toString());
        }
        if (dataFilter2 != null) {
            ((StringBuffer)charSequence3).append(" where ");
            ((StringBuffer)charSequence3).append(string4);
            ((StringBuffer)charSequence2).append(" where ");
            ((StringBuffer)charSequence2).append(string4);
        }
        if ((charSequence = sortField == null ? magicalAssociation.getDefaultSort() : sortField) instanceof AbsoluteSortField) {
            object2 = new SQLOrderByClause(true);
            string2 = ((SQLOrderByClause)object2).generateClause((SortField)charSequence);
            ((StringBuffer)charSequence3).append(string2);
        } else {
            boolean bl3 = true;
            for (object2 = charSequence; object2 != null; object2 = object2.getSecondarySort()) {
                object3 = magicalAssociation.findMappingSortKey(object2.getField());
                if (object3 != null) {
                    if (bl3) {
                        ((StringBuffer)charSequence3).append(" order by ");
                        bl3 = false;
                    } else {
                        ((StringBuffer)charSequence3).append(", ");
                    }
                    ((StringBuffer)charSequence3).append(((MagicalMapping)object3).getColumnName());
                    if (object2.isDescending()) {
                        ((StringBuffer)charSequence3).append(" desc");
                        continue;
                    }
                    ((StringBuffer)charSequence3).append(" asc");
                    continue;
                }
                logger.debug((Object)("No sorting defined for field " + object2.getField() + " in object " + object.getClass().getName()));
            }
        }
        if (n2 > 0) {
            ((StringBuffer)charSequence3).append(" fetch first ");
            ((StringBuffer)charSequence3).append(n2);
            ((StringBuffer)charSequence3).append(" rows only");
        }
        object2 = ((StringBuffer)charSequence3).toString();
        String string5 = ((StringBuffer)charSequence2).toString();
        if (logger.isTraceEnabled() && System.getProperty(PROPERTY_TRACE_SQL) != null) {
            logger.trace((Object)("Count SQL is: " + string5));
            logger.trace((Object)("Data SQL is: " + (String)object2));
        }
        object3 = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        preparedStatement = connection.prepareStatement(string5);
        object3 = connection.prepareStatement((String)object2, n3, 1007);
        if (dataFilter2 != null) {
            SQLWhereClause.prepareSQLWhereClause(preparedStatement, 1, dataFilter2);
            SQLWhereClause.prepareSQLWhereClause((PreparedStatement)object3, 1, dataFilter2);
        }
        int n6 = -1;
        int n7 = -1;
        if (bl2) {
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                n6 = resultSet.getInt(1);
                if (n2 > 0 && n6 > n2) {
                    n7 = n6;
                    n6 = n2;
                }
            }
            resultSet.close();
        }
        resultSet = object3.executeQuery();
        SQLHelperGenerator sQLHelperGenerator = new SQLHelperGenerator(object.getClass(), this);
        if (bl) {
            return ResultSetDataSet.createDataSet((PreparedStatement)object3, preparedStatement, resultSet, sQLHelperGenerator, n6);
        }
        preparedStatement.close();
        DataSet dataSet = ResultSetDataSet.createDataSet(resultSet, sQLHelperGenerator, n6, n);
        if (n7 > 0 && dataSet instanceof DataSetWithAttributes) {
            DataSetWithAttributes dataSetWithAttributes = (DataSetWithAttributes)dataSet;
            dataSetWithAttributes.setAttribute("SIZE_BEFORE_TRUNCATION", (Object)new Integer(n7));
        }
        return dataSet;
    }

    private void fixFilter(DataFilter dataFilter, Object object) {
        if (dataFilter == null || object == null) {
            return;
        }
        MagicalAssociation magicalAssociation = this.lookupAssociation(object.getClass());
        if (magicalAssociation == null) {
            return;
        }
        MagicalMapping[] magicalMappingArray = magicalAssociation.listMappings();
        if (magicalMappingArray == null) {
            return;
        }
        DataFilter[] dataFilterArray = dataFilter.getFilters();
        for (int i = 0; i < dataFilterArray.length; ++i) {
            this.fixFilter(dataFilterArray[i], object);
        }
        FilterCriteria[] filterCriteriaArray = dataFilter.getCriteria();
        for (int i = 0; i < filterCriteriaArray.length; ++i) {
            String string = filterCriteriaArray[i].getFieldName();
            String string2 = null;
            for (int j = 0; j < magicalMappingArray.length; ++j) {
                Method method = this.resolveGetter(object.getClass(), magicalMappingArray[j]);
                if (method == null || !method.getName().equals(string)) continue;
                string2 = magicalMappingArray[j].getColumnName();
                filterCriteriaArray[i].setFieldName(string2);
                break;
            }
            if (string2 != null || !logger.isDebugEnabled()) continue;
            logger.debug((Object)("Unable to filter on field " + string + ", no such method in " + object.getClass().getName()));
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Map.Entry<String, MagicalAssociation> entry : this.associationTable.entrySet()) {
            stringBuffer.append("Key: ");
            stringBuffer.append((Object)entry.getKey());
            stringBuffer.append(System.getProperty("line.separator"));
            stringBuffer.append(entry.getValue());
            stringBuffer.append(System.getProperty("line.separator"));
        }
        return stringBuffer.toString();
    }

    public int updateObject(Connection connection, Object object, String string) throws SQLException, DataException {
        int n;
        Object object2;
        Object object3;
        if (connection == null) {
            throw new NullPointerException("The connection passed in was null");
        }
        if (object == null) {
            throw new NullPointerException("The object passed in was null");
        }
        MagicalAssociation magicalAssociation = this.lookupAssociation(object.getClass());
        if (magicalAssociation == null) {
            throw new NullPointerException("The file " + this.filename + " does not contain a mapping for " + object.getClass().getName());
        }
        MagicalMapping[] magicalMappingArray = magicalAssociation.listMappings();
        if (magicalMappingArray == null) {
            throw new NullPointerException("The file " + this.filename + " contains an empty mapping for " + object.getClass().getName());
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<MagicalMapping> arrayList3 = new ArrayList<MagicalMapping>();
        ArrayList<MagicalMapping> arrayList4 = new ArrayList<MagicalMapping>();
        String string2 = null;
        for (int i = 0; i < magicalMappingArray.length; ++i) {
            String string3 = magicalMappingArray[i].getTableName();
            if (string3 == null) {
                string3 = magicalAssociation.getTableName();
            }
            object3 = string + "." + string3;
            if (string == null || string.length() == 0) {
                object3 = string3;
            }
            if (string2 == null) {
                string2 = object3;
            } else if (!string2.equals(object3)) {
                throw new SQLException("The object " + object.getClass().getName() + " is trying to update data in two different " + " tables: " + string3 + " and " + string2);
            }
            object2 = magicalMappingArray[i].getColumnName();
            if (magicalMappingArray[i].isPrimaryKey()) {
                arrayList2.add((String)object2);
                arrayList4.add(magicalMappingArray[i]);
                continue;
            }
            if (magicalMappingArray[i].isIgnored() || magicalMappingArray[i].isIgnoredOnSave()) {
                if (!logger.isTraceEnabled()) continue;
                logger.trace((Object)("Skipping column " + magicalMappingArray[i].getColumnName() + " because it's marked as 'ignore'."));
                continue;
            }
            if (magicalMappingArray[i].isAutoIncrement()) {
                if (!logger.isTraceEnabled()) continue;
                logger.trace((Object)("Skipping column " + magicalMappingArray[i].getColumnName() + " because it's marked as 'autoincrement'."));
                continue;
            }
            arrayList.add((String)object2);
            arrayList3.add(magicalMappingArray[i]);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("update ");
        stringBuffer.append(string2);
        stringBuffer.append(" set ");
        for (n = 0; n < arrayList.size(); ++n) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append((String)arrayList.get(n));
            stringBuffer.append("=?");
        }
        if (arrayList2.size() > 0) {
            stringBuffer.append(" where ");
            for (n = 0; n < arrayList2.size(); ++n) {
                if (n > 0) {
                    stringBuffer.append(" and ");
                }
                stringBuffer.append((String)arrayList2.get(n));
                stringBuffer.append("= ?");
            }
        }
        String string4 = stringBuffer.toString();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("SQL is: " + string4));
        }
        object3 = new ArrayList();
        ((ArrayList)object3).addAll(arrayList3);
        ((ArrayList)object3).addAll(arrayList4);
        object2 = null;
        String string5 = null;
        int n2 = -1;
        int n3 = 0;
        try {
            object2 = connection.prepareStatement(string4);
            for (int i = 0; i < ((ArrayList)object3).size(); ++i) {
                Object object4;
                MagicalMapping magicalMapping = (MagicalMapping)((ArrayList)object3).get(i);
                ++n3;
                String string6 = magicalMapping.getColumnName();
                if (AbstractDatabaseManager.isUnicodeField(string6) && object2 instanceof AbstractDatabaseManager.WrappedPreparedStatement) {
                    object4 = (AbstractDatabaseManager.WrappedPreparedStatement)object2;
                    ((AbstractDatabaseManager.WrappedPreparedStatement)object4).defineUnicodeParm(n3, string6);
                }
                string5 = magicalMapping.getMethodName();
                object4 = this.resolveGetter(object.getClass(), magicalMapping);
                if (object4 == null) {
                    throw new NullPointerException("Cannot find a 'getter' for " + string5);
                }
                string5 = ((Method)object4).getName();
                Object object5 = this.invokeMethod(object, magicalMapping);
                if (object5 == null) {
                    ParameterMetaData parameterMetaData = null;
                    int n4 = -1;
                    try {
                        parameterMetaData = object2.getParameterMetaData();
                        n4 = parameterMetaData.getParameterType(n3);
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)("Plugging in NULL sql type # " + n4));
                        }
                        object2.setNull(n3, n4);
                    }
                    catch (Exception exception) {
                        object5 = this.guessSqlNullValue(magicalMapping);
                    }
                }
                if (object5 == null) continue;
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Setting parameter # " + n3 + " = " + object5.getClass().getName() + ": " + object5));
                }
                object2.setObject(n3, object5);
            }
            n2 = object2.executeUpdate();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SQLException("Unable to invoke the method " + string5 + " on object " + object.getClass().getName());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SQLException("Unable to invoke the method " + string5 + " on object " + object.getClass().getName());
        }
        finally {
            AbstractDatabaseManager.closeEm(null, (Statement)object2, null);
        }
        return n2;
    }

    public class MagicalAssociation {
        String tableName;
        String objectClassname;
        Hashtable<String, MagicalMapping> mappingTable;
        Vector<String> proxyList;
        String[] joinArray;
        SortField defaultSort;

        private MagicalAssociation(String string, String string2, String string3) {
            this.tableName = string2;
            this.objectClassname = string;
            this.mappingTable = new Hashtable();
            this.proxyList = new Vector();
            this.parseJoin(string3);
        }

        private void addMapping(MagicalMapping magicalMapping) {
            String string = null;
            String string2 = magicalMapping.getTableName();
            String string3 = magicalMapping.getColumnName();
            string = string2 == null ? string3 : string2 + "." + string3;
            this.mappingTable.put(string.toUpperCase(), magicalMapping);
        }

        public void addProxy(String string) {
            if (!this.proxyList.contains(string)) {
                this.proxyList.add(string);
            }
        }

        public MagicalMapping findMappingSortKey(int n) {
            MagicalMapping[] magicalMappingArray = this.listMappings();
            for (int i = 0; i < magicalMappingArray.length; ++i) {
                if (n != magicalMappingArray[i].getSortKey()) continue;
                return magicalMappingArray[i];
            }
            return null;
        }

        public MagicalMapping[] listMappings() {
            Collection<MagicalMapping> collection = this.mappingTable.values();
            MagicalMapping[] magicalMappingArray = new MagicalMapping[collection.size()];
            collection.toArray(magicalMappingArray);
            return magicalMappingArray;
        }

        public boolean isDefinedProxy(Class<? extends Object> clazz) {
            return this.proxyList.contains(clazz.getName());
        }

        public String[] listProxies() {
            String[] stringArray = new String[this.proxyList.size()];
            this.proxyList.toArray(stringArray);
            return stringArray;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getClassname() {
            return this.objectClassname;
        }

        public SortField getDefaultSort() {
            return this.defaultSort;
        }

        public String[] getLeftOuterJoin() {
            return this.joinArray;
        }

        public MagicalMapping lookupMapping(String string, String string2) {
            String string3 = null;
            string3 = string == null || string.length() == 0 ? string2 : string + "." + string2;
            MagicalMapping magicalMapping = this.mappingTable.get(string3.toUpperCase());
            if (magicalMapping != null) {
                return magicalMapping;
            }
            String string4 = string + "." + string + "." + string2;
            magicalMapping = this.mappingTable.get(string4.toUpperCase());
            if (magicalMapping != null) {
                return magicalMapping;
            }
            if (string == null || string.length() == 0) {
                String string5 = "." + string2.toUpperCase();
                for (Map.Entry<String, MagicalMapping> entry : this.mappingTable.entrySet()) {
                    string3 = entry.getKey();
                    if (!string3.endsWith(string5)) continue;
                    if (magicalMapping == null) {
                        magicalMapping = entry.getValue();
                        continue;
                    }
                    throw new RuntimeException("The DB field " + string2 + " appears to exist in two or more tables, " + "and the table name is blank or null.");
                }
            }
            return magicalMapping;
        }

        private void parseJoin(String string) {
            String string2 = string;
            if (string2 == null) {
                return;
            }
            if ((string2 = string2.trim()).length() == 0) {
                return;
            }
            if (!string2.startsWith("[")) {
                this.joinArray = new String[]{string2};
                return;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            while (string2.length() > 0) {
                int n = string2.indexOf("[");
                int n2 = string2.indexOf("]");
                if (n < 0 || n2 < 0 || n2 < n) {
                    throw new IllegalArgumentException("Unable to parse join statement: " + string2);
                }
                arrayList.add(string2.substring(n + 1, n2));
                if (n2 + 1 < string2.length()) {
                    string2 = string2.substring(n2 + 1).trim();
                    continue;
                }
                string2 = "";
            }
            this.joinArray = new String[arrayList.size()];
            arrayList.toArray(this.joinArray);
        }

        public void setDefaultSort(SortField sortField) {
            this.defaultSort = sortField;
        }

        public String toString() {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Assoc  class=" + this.objectClassname + ", table=" + this.tableName + ", leftOuterJoin= ");
            if (this.joinArray == null) {
                stringBuffer.append("null");
            } else {
                for (int i = 0; i < this.joinArray.length; ++i) {
                    stringBuffer.append("[" + this.joinArray[i] + "]");
                }
            }
            stringBuffer.append(System.getProperty("line.separator"));
            MagicalMapping[] magicalMappingArray = this.listMappings();
            for (n = 0; n < magicalMappingArray.length; ++n) {
                stringBuffer.append("\t" + magicalMappingArray[n]);
                stringBuffer.append(System.getProperty("line.separator"));
            }
            if (this.proxyList.size() == 0) {
                stringBuffer.append("\tNo proxy classes present.");
                stringBuffer.append(System.getProperty("line.separator"));
            } else {
                for (n = 0; n < this.proxyList.size(); ++n) {
                    stringBuffer.append("\tProxy ");
                    stringBuffer.append(n + 1);
                    stringBuffer.append(": ");
                    stringBuffer.append(this.proxyList.elementAt(n));
                    stringBuffer.append(System.getProperty("line.separator"));
                }
            }
            return stringBuffer.toString();
        }
    }

    public class MagicalMapping {
        private String columnName;
        private String methodName;
        private String parameterType;
        private String tableName;
        private String booleanFalse = "F";
        private String booleanTrue = "T";
        private boolean ignore;
        private boolean ignoreOnSave;
        private boolean primaryKey;
        private boolean autoIncrement;
        private HashMap<String, Method> setterMap;
        private HashMap<String, Method> getterMap;
        private String filterField;
        private int sortKey;
        private boolean trimRight;
        private Long numericNull = null;
        private boolean useBooleanObject;

        private MagicalMapping(String string, String string2, String string3, String string4, boolean bl) {
            this.columnName = string;
            this.methodName = string2;
            this.parameterType = string3;
            this.tableName = string4;
            this.ignore = bl;
            this.sortKey = Integer.MIN_VALUE;
            this.setterMap = new HashMap();
            this.getterMap = new HashMap();
            this.trimRight = true;
        }

        public String getBooleanFalse() {
            return this.booleanFalse;
        }

        public String getBooleanTrue() {
            return this.booleanTrue;
        }

        public boolean useBooleanObject() {
            return this.useBooleanObject;
        }

        public void setUseBooleanObject(boolean bl) {
            this.useBooleanObject = bl;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getMethodName() {
            return this.methodName;
        }

        private Method getGetter(String string) {
            return this.getterMap.get(string);
        }

        private Method getSetter(String string) {
            return this.setterMap.get(string);
        }

        public String getFilterField() {
            return this.filterField;
        }

        public int getSortKey() {
            return this.sortKey;
        }

        public boolean isAutoIncrement() {
            return this.autoIncrement;
        }

        public boolean isPrimaryKey() {
            return this.primaryKey;
        }

        public boolean isFilterField() {
            return this.filterField != null;
        }

        public boolean isSortField() {
            return this.sortKey != Integer.MIN_VALUE;
        }

        public String getParameterType() {
            return this.parameterType;
        }

        public String getTableName() {
            return this.tableName;
        }

        public boolean isIgnored() {
            return this.ignore;
        }

        public void setIgnored(boolean bl) {
            this.ignore = bl;
        }

        public boolean isIgnoredOnSave() {
            return this.ignoreOnSave;
        }

        public void setIgnoredOnSave(boolean bl) {
            this.ignoreOnSave = bl;
        }

        public void setTableName(String string) {
            this.tableName = string;
        }

        public void setAutoIncrement(boolean bl) {
            this.autoIncrement = bl;
        }

        public void setBooleanFalse(String string) {
            this.booleanFalse = string;
        }

        public void setBooleanTrue(String string) {
            this.booleanTrue = string;
        }

        public void setPrimaryKey(boolean bl) {
            this.primaryKey = bl;
        }

        public void setFilterField(String string) {
            this.filterField = string;
        }

        public void setSortKey(int n) {
            this.sortKey = n;
        }

        public void setTrimRight(boolean bl) {
            this.trimRight = bl;
        }

        public boolean trimRight() {
            return this.trimRight;
        }

        void setGetter(String string, Method method) {
            this.getterMap.put(string, method);
        }

        void setSetter(String string, Method method) {
            this.setterMap.put(string, method);
        }

        public Long getNumericNull() {
            return this.numericNull;
        }

        public void setNumericNull(Long l) {
            this.numericNull = l;
        }

        public String toString() {
            String string = this.numericNull != null ? ", nullNumeric=" + this.numericNull.intValue() : ", nullNumeric=N/A";
            return "column=" + this.columnName + ", method=" + this.methodName + ", param=" + this.parameterType + ", table=" + this.tableName + ", ignore=" + this.ignore + ", autoincrement=" + this.autoIncrement + ", trimRight= " + this.trimRight + string;
        }
    }
}

