/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.access;

import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.BusinessObjectGenerator;
import com.helpsystems.common.access.ReloadableResultSetDataSet;
import com.helpsystems.common.core.access.BadDataArrayException;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.DataSet;
import com.helpsystems.common.core.access.DataSetException;
import com.helpsystems.common.core.access.ErrorTable;
import com.helpsystems.common.core.access.dataset.ArrayDataSet;
import com.helpsystems.common.core.access.dataset.DataSetWithAttributes;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ResultSetDataSet
implements DataSetWithAttributes {
    private static final Logger logger = Logger.getLogger(ResultSetDataSet.class);
    public static final String SIZE_BEFORE_TRUNCATION = "SIZE_BEFORE_TRUNCATION";
    public static final int DEFAULT_THRESHOLD = 200;
    protected ResultSet rs;
    protected BusinessObjectGenerator generator;
    private HashMap<String, Object> attributeMap = new HashMap();
    protected int size;

    protected ResultSetDataSet(ResultSet resultSet, BusinessObjectGenerator businessObjectGenerator) throws DataSetException {
        this.rs = resultSet;
        this.size = -1;
        this.validateResultSet();
        if (businessObjectGenerator == null) {
            throw new NullPointerException("The BusinessObjectGenerator passed in is null.");
        }
        this.generator = businessObjectGenerator;
    }

    public void close() throws DataSetException {
        if (this.rs == null) {
            return;
        }
        try {
            Statement statement = this.rs.getStatement();
            Connection connection = statement.getConnection();
            AbstractDatabaseManager.closeEm(connection, statement, this.rs);
        }
        catch (SQLException sQLException) {
            throw new DataSetException("Error when closing the data set.", (Throwable)sQLException);
        }
        finally {
            this.rs = null;
        }
    }

    void partiallyClose() throws DataSetException {
        if (this.rs == null) {
            return;
        }
        try {
            Statement statement = this.rs.getStatement();
            AbstractDatabaseManager.closeEm(null, statement, this.rs);
        }
        catch (SQLException sQLException) {
            throw new DataSetException("Error when closing the data set.", (Throwable)sQLException);
        }
        finally {
            this.rs = null;
        }
    }

    public static DataSet createDataSet(ResultSet resultSet, BusinessObjectGenerator businessObjectGenerator) throws DataSetException {
        return ResultSetDataSet.createDataSet(resultSet, businessObjectGenerator, -1, 200);
    }

    public static DataSet createDataSet(ResultSet resultSet, BusinessObjectGenerator businessObjectGenerator, int n) throws DataSetException {
        return ResultSetDataSet.createDataSet(resultSet, businessObjectGenerator, n, 200);
    }

    public static DataSet createDataSet(ResultSet resultSet, BusinessObjectGenerator businessObjectGenerator, int n, int n2) throws DataSetException {
        Object object;
        int n3 = n;
        if (n3 > -1) {
            try {
                n3 = ResultSetDataSet.confirmOrAdjustSize(n3, resultSet);
                resultSet.beforeFirst();
            }
            catch (SQLException sQLException) {
                object = "Unable to confirm the size of the result set.";
                logger.debug(object, (Throwable)sQLException);
            }
        }
        boolean bl = false;
        if (n2 > -1 && n3 < 0) {
            try {
                bl = resultSet.absolute(n2);
                resultSet.beforeFirst();
            }
            catch (SQLException sQLException) {
                String string = "Unable to determine the size of the result set.";
                logger.debug((Object)string, (Throwable)sQLException);
                try {
                    Statement statement = resultSet.getStatement();
                    Connection connection = statement.getConnection();
                    AbstractDatabaseManager.closeEm(connection, statement, resultSet);
                }
                catch (SQLException sQLException2) {
                    // empty catch block
                }
                throw new DataSetException(string, (Throwable)sQLException);
            }
        }
        boolean bl2 = bl = n3 > n2;
        if (n2 < 0) {
            bl = true;
        }
        object = new ResultSetDataSet(resultSet, businessObjectGenerator);
        if (n3 > -1) {
            ((ResultSetDataSet)object).setSize(n3);
        }
        if (bl) {
            return object;
        }
        DataSet dataSet = ArrayDataSet.createDataSet((DataSet)object);
        try {
            Statement statement = resultSet.getStatement();
            Connection connection = statement.getConnection();
            AbstractDatabaseManager.closeEm(connection, statement, resultSet);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return dataSet;
    }

    public static DataSet createDataSet(PreparedStatement preparedStatement, PreparedStatement preparedStatement2, ResultSet resultSet, BusinessObjectGenerator businessObjectGenerator, int n) throws DataSetException {
        int n2 = n;
        ReloadableResultSetDataSet reloadableResultSetDataSet = new ReloadableResultSetDataSet(preparedStatement, preparedStatement2, resultSet, businessObjectGenerator);
        if (n2 > -1) {
            try {
                n2 = ResultSetDataSet.confirmOrAdjustSize(n2, resultSet);
                resultSet.beforeFirst();
            }
            catch (SQLException sQLException) {
                String string = "Unable to confirm the size of the result set.";
                logger.debug((Object)string, (Throwable)sQLException);
            }
            reloadableResultSetDataSet.setSize(n2);
        }
        return reloadableResultSetDataSet;
    }

    public synchronized Object[] get(int n, int n2) throws DataSetException, BadDataArrayException {
        Object object;
        int n3 = n;
        if (this.rs == null) {
            throw new DataSetException("This DataSet is closed.");
        }
        if (n2 == 0) {
            return new Object[0];
        }
        ++n3;
        int n4 = -1;
        try {
            n4 = this.rs.getRow();
        }
        catch (SQLException sQLException) {
            throw new DataSetException("Unable to determine the Result Set's cursor position.", (Throwable)sQLException);
        }
        if (n3 != n4) {
            boolean bl;
            if (n3 - 1 == n4) {
                bl = false;
                object = null;
                try {
                    bl = this.rs.next();
                }
                catch (SQLException sQLException) {
                    bl = false;
                    object = sQLException;
                }
                if (!bl) {
                    throw new DataSetException("Unable to advance the Result Set cursor to row " + n3, (Throwable)object);
                }
            } else if (n3 + 1 == n4) {
                bl = false;
                object = null;
                try {
                    bl = this.rs.previous();
                }
                catch (SQLException sQLException) {
                    bl = false;
                    object = sQLException;
                }
                if (!bl) {
                    throw new DataSetException("Unable to decrement the Result Set cursor to row " + n3, (Throwable)object);
                }
            } else {
                try {
                    if (!this.rs.absolute(n3)) {
                        throw new DataSetException("Unable to move the Result Set cursor to row " + n3);
                    }
                }
                catch (SQLException sQLException) {
                    throw new DataSetException("Unable to move the Result Set cursor to row " + n3, (Throwable)sQLException);
                }
            }
        }
        Object[] objectArray = new Object[n2];
        object = new ErrorTable();
        for (int i = 0; i < n2; ++i) {
            try {
                if (i > 0 && !this.rs.next()) {
                    throw new SQLException("Attempt to read data beyond the end of the Result Set");
                }
                objectArray[i] = this.generator.generateObject(this.rs);
                continue;
            }
            catch (BadDataException badDataException) {
                logger.trace((Object)("Bad data loading record # " + i + "."), (Throwable)badDataException);
                object.addException(i, (Exception)((Object)badDataException));
                objectArray[i] = badDataException.getLoadedObject();
                continue;
            }
            catch (Exception exception) {
                throw new DataSetException("There was a problem reading the data from the result set.", (Throwable)exception);
            }
        }
        if (object.getBadObjectCount() > 0) {
            throw new BadDataArrayException("One or more of the objects contained bad data.", objectArray, object);
        }
        return objectArray;
    }

    public void setSize(int n) {
        if (this.size > -1 && n != this.size) {
            throw new IllegalArgumentException("The size of this Data Set has already been set/calculated. You cannot change the size.");
        }
        this.size = n;
    }

    public int size() throws DataSetException {
        if (this.rs == null) {
            throw new DataSetException("This DataSet is closed.");
        }
        if (this.size > -1) {
            return this.size;
        }
        try {
            this.rs.last();
            this.size = this.rs.getRow();
            return this.size;
        }
        catch (SQLException sQLException) {
            String string = "Unable to calculate the number of rows.";
            logger.debug((Object)string, (Throwable)sQLException);
            throw new DataSetException(string, (Throwable)sQLException);
        }
    }

    protected void validateResultSet() throws DataSetException {
        if (this.rs == null) {
            throw new NullPointerException("The ResultSet passed in is null.");
        }
        try {
            if (!this.rs.next()) {
                this.size = 0;
            }
            this.rs.beforeFirst();
        }
        catch (SQLException sQLException) {
            logger.debug((Object)("Something's wrong with the result set " + this.rs.getClass().getName()), (Throwable)sQLException);
            this.rs = null;
            throw new DataSetException("There's a problem with the ResultSet", (Throwable)sQLException);
        }
    }

    static int confirmOrAdjustSize(int n, ResultSet resultSet) throws SQLException {
        int n2 = n;
        if (resultSet == null) {
            throw new NullPointerException("The ResultSet passed in is null.");
        }
        if (!resultSet.first()) {
            return 0;
        }
        int n3 = 0;
        while (!resultSet.absolute(n2)) {
            if ((n2 -= 20) < 20) {
                n2 = 0;
                break;
            }
            if (++n3 != 5) continue;
            resultSet.absolute(1);
            n2 = 1;
            break;
        }
        while (resultSet.next()) {
            ++n2;
        }
        return n2;
    }

    public Object getAttribute(String string) {
        return this.attributeMap.get(string);
    }

    public void setAttribute(String string, Object object) {
        this.attributeMap.put(string, object);
    }

    public void clearAttributes() {
        this.attributeMap.clear();
    }
}

