/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.access;

import com.helpsystems.common.access.JdbcPoolManager;
import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.LocalizedDate;
import com.helpsystems.common.core.busobj.LocalizedTime;
import com.helpsystems.common.core.busobj.LocalizedTimestamp;
import com.helpsystems.common.core.dm.EncodingManager;
import com.helpsystems.common.core.util.HSJvmProperties;
import com.helpsystems.common.core.util.OutputStreamLogger;
import com.helpsystems.common.core.util.ValidationHelper;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.apache.commons.dbcp.DbcpException;
import org.apache.commons.dbcp.PoolableConnection;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.log4j.Logger;

public abstract class AbstractDatabaseManager
extends AbstractManager {
    private static final Logger logger = Logger.getLogger(AbstractDatabaseManager.class);
    private static final int CURSOR_TYPE_FORWARD_ONLY = 1;
    private static final int CURSOR_TYPE_SCROLLABLE_INSENSITIVE = 2;
    private static final int CURSOR_TYPE_DEFAULT = 9;
    private static final String SEARCH_STRING = "jdbc:apache:commons:dbcp:";
    public static int TRACING_STACK_DEPTH = 2;
    private static HashSet<String> unicodeFields = new HashSet();
    protected String DBUrl;
    private String poolName;
    protected boolean productMasterDM;
    protected boolean useLocalizedDateTime = true;
    private Object lockObject;
    private boolean debugConnectionLeak = false;
    private EncodingManager encodingManager;

    public AbstractDatabaseManager(String string) {
        try {
            String string2 = System.getProperty("helpsystems.jdbc.log.connections");
            if (string2 != null && string2.trim().equalsIgnoreCase("true")) {
                this.debugConnectionLeak = true;
            }
        }
        catch (Exception exception) {
            logger.warn((Object)"Error loading connection logger settings.", (Throwable)exception);
        }
        this.DBUrl = string;
        this.poolName = this.DBUrl != null && this.DBUrl.startsWith(SEARCH_STRING) ? this.DBUrl.substring(SEARCH_STRING.length()) : "JdbcPool";
        this.lockObject = new Object();
    }

    public static void loadUnicodeFields(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            unicodeFields.add(stringArray[i].trim().toUpperCase());
        }
    }

    public static boolean isUnicodeField(String string) {
        if (string != null) {
            String string2 = string.trim().toUpperCase();
            if (string2.startsWith("COALESCE(")) {
                int n = string2.indexOf(".");
                int n2 = string2.indexOf(",", n);
                if (n > -1 && n2 > -1) {
                    string2 = string2.substring(n + 1, n2);
                }
            }
            return unicodeFields.contains(string2);
        }
        return false;
    }

    protected PreparedStatement prepareStatement(Connection connection, String string) throws SQLException {
        if (connection == null) {
            throw new NullPointerException("The connection passed in is null.");
        }
        if (connection.isClosed()) {
            throw new IllegalStateException("The connection is closed.");
        }
        return connection.prepareStatement(string, 1004, 1007);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WrappedConnection getConnection() throws SQLException {
        if (logger.isTraceEnabled() || this.debugConnectionLeak) {
            Object object = this.lockObject;
            synchronized (object) {
                return this.borrowOrGetConnection();
            }
        }
        return this.borrowOrGetConnection();
    }

    /*
     * Unable to fully structure code
     */
    private WrappedConnection borrowOrGetConnection() throws SQLException {
        if (this.DBUrl == null) {
            throw new NullPointerException("The DB URL for " + this.getName() + " has not been set");
        }
        var1_1 = null;
        var2_2 = null;
        if (this.poolName != null) {
            var2_2 = JdbcPoolManager.getInstance().getPool(this.poolName);
            var1_1 = JdbcPoolManager.getInstance().getInfo(this.poolName);
        }
        var3_3 = 0;
        var4_4 = 0;
        if (var1_1 != null) {
            var3_3 = var1_1.getRetryCount();
            var4_4 = var1_1.getRetryDelay();
        }
        var5_5 = null;
        var6_6 = false;
        while (var3_3 >= 0) {
            var7_7 = null;
            if (var2_2 != null) {
                try {
                    var7_7 = (Connection)var2_2.borrowObject();
                }
                catch (Exception var8_9) {
                    if (var6_6 == false & var8_9 instanceof DbcpException && (var9_11 = var8_9.getMessage()) != null && var9_11.contains("FATAL: sorry, too many clients already")) {
                        AbstractDatabaseManager.logger.info((Object)"The connection pool was prematurely exhausted...");
                        var6_6 = true;
                        if (var3_3 == 0) {
                            var3_3 = 300;
                            var4_4 = 200;
                        }
                    }
                    if (var3_3 != 0) ** GOTO lbl34
                    var9_11 = new SQLException("Unable to obtain a connection from the pool.");
                    var9_11.initCause(var8_9);
                    throw var9_11;
                }
            } else {
                var7_7 = DriverManager.getConnection(this.DBUrl);
            }
lbl34:
            // 3 sources

            if (var7_7 != null) {
                var5_5 = new WrappedConnection(var7_7, this.poolName);
                break;
            }
            --var3_3;
            try {
                if (AbstractDatabaseManager.logger.isTraceEnabled()) {
                    AbstractDatabaseManager.logger.trace((Object)("Waiting " + var4_4 + "ms to retry (" + var3_3 + ") for a DB connection."));
                }
                Thread.sleep(var4_4);
            }
            catch (InterruptedException var8_10) {}
        }
        if (var5_5 != null && (AbstractDatabaseManager.logger.isTraceEnabled() || this.debugConnectionLeak)) {
            this.logCaller(var5_5, "borrowed", true);
        }
        return var5_5;
    }

    protected WrappedConnection getConnectionOrFail() throws ResourceUnavailableException {
        WrappedConnection wrappedConnection = null;
        try {
            wrappedConnection = this.getConnection();
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Error while trying to get a connection.", (Throwable)exception);
        }
        if (wrappedConnection != null) {
            return wrappedConnection;
        }
        throw new ResourceUnavailableException("Could not get a connection.", null);
    }

    protected PreparedStatement getDefaultPreparedStmt(String string) throws ResourceUnavailableException {
        return this.getPreparedStmt(string, 9, null);
    }

    protected PreparedStatement getDefaultPreparedStmt(String string, Connection connection) throws ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"Connection", (Object)connection);
        return this.getPreparedStmt(string, 9, connection);
    }

    protected PreparedStatement getPreparedStmtThatReturnsGeneratedKeys(String string, Connection connection) throws ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"SQL", (Object)string);
        Connection connection2 = connection;
        if (connection2 == null) {
            connection2 = this.getConnectionOrFail();
        }
        Object var4_4 = null;
        try {
            return connection2.prepareStatement(string, 1);
        }
        catch (SQLException sQLException) {
            if (connection == null) {
                AbstractDatabaseManager.closeEm(connection2, var4_4, null);
            }
            connection2 = null;
            var4_4 = null;
            throw new ResourceUnavailableException("Error retrieving the Prepared Statement from the Connection.", (Throwable)sQLException);
        }
    }

    /*
     * Exception decompiling
     */
    protected int retrieveGeneratedKey(Statement var1_1) throws ResourceUnavailableException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected PreparedStatement getPreparedStmtForForwardOnlyList(String string) throws ResourceUnavailableException {
        return this.getPreparedStmt(string, 1, null);
    }

    protected PreparedStatement getPreparedStmtForScrollableList(String string) throws ResourceUnavailableException {
        return this.getPreparedStmt(string, 2, null);
    }

    private PreparedStatement getPreparedStmt(String string, int n, Connection connection) throws ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"SQL", (Object)string);
        Connection connection2 = connection;
        if (connection2 == null) {
            connection2 = this.getConnectionOrFail();
        }
        PreparedStatement preparedStatement = null;
        try {
            switch (n) {
                case 1: {
                    preparedStatement = connection2.prepareStatement(string, 1003, 1007);
                    break;
                }
                case 2: {
                    preparedStatement = connection2.prepareStatement(string, 1004, 1007);
                    break;
                }
                default: {
                    preparedStatement = connection2.prepareStatement(string);
                }
            }
            return preparedStatement;
        }
        catch (SQLException sQLException) {
            AbstractDatabaseManager.closeEm(connection2, preparedStatement, null);
            connection2 = null;
            preparedStatement = null;
            throw new ResourceUnavailableException("Error retrieving the Prepared Statement from the Connection.", (Throwable)sQLException);
        }
    }

    public static void closeEm(Connection connection, Statement statement, ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            if (connection != null && !connection.isClosed()) {
                connection.close();
            }
        }
        catch (Exception exception) {
            logger.debug((Object)"Error closing connection.", (Throwable)exception);
        }
    }

    protected void closeConnection(Statement statement) {
        if (statement == null) {
            throw new NullPointerException("Statement cannot be null.");
        }
        Connection connection = null;
        try {
            connection = statement.getConnection();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ResultSet resultSet = null;
        try {
            resultSet = statement.getResultSet();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        AbstractDatabaseManager.closeEm(connection, statement, resultSet);
    }

    protected int doCount(String string, Object[] objectArray) throws ResourceUnavailableException {
        return this.doCount(string, objectArray, null);
    }

    protected int doCount(String string, Object[] objectArray, Connection connection) throws ResourceUnavailableException {
        int n;
        block13: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            Connection connection2;
            block11: {
                block9: {
                    block12: {
                        block10: {
                            ValidationHelper.checkForNull((String)"SQL", (Object)string);
                            connection2 = connection;
                            preparedStatement = null;
                            resultSet = null;
                            if (connection2 == null) {
                                connection2 = this.getConnectionOrFail();
                            }
                            preparedStatement = connection2.prepareStatement(string);
                            for (n = 0; objectArray != null && n < objectArray.length; ++n) {
                                preparedStatement.setObject(n + 1, objectArray[n]);
                            }
                            resultSet = preparedStatement.executeQuery();
                            if (!resultSet.next()) break block9;
                            n = resultSet.getInt(1);
                            if (connection == null) break block10;
                            AbstractDatabaseManager.closeEm(null, preparedStatement, resultSet);
                            break block12;
                        }
                        AbstractDatabaseManager.closeEm(connection2, preparedStatement, resultSet);
                    }
                    return n;
                }
                try {
                    n = 0;
                    if (connection == null) break block11;
                }
                catch (SQLException sQLException) {
                    try {
                        throw new ResourceUnavailableException("Unable to execute a row-count.", (Throwable)sQLException);
                    }
                    catch (Throwable throwable) {
                        if (connection != null) {
                            AbstractDatabaseManager.closeEm(null, preparedStatement, resultSet);
                        } else {
                            AbstractDatabaseManager.closeEm(connection2, preparedStatement, resultSet);
                        }
                        throw throwable;
                    }
                }
                AbstractDatabaseManager.closeEm(null, preparedStatement, resultSet);
                break block13;
            }
            AbstractDatabaseManager.closeEm(connection2, preparedStatement, resultSet);
        }
        return n;
    }

    protected boolean isProductMasterDM() {
        return this.productMasterDM;
    }

    private void logCaller(WrappedConnection wrappedConnection, String string, boolean bl) {
        String string2;
        Object object;
        Object object2;
        GenericObjectPool genericObjectPool;
        Object object3;
        Object object4;
        Object object5;
        if (!logger.isTraceEnabled() && !this.debugConnectionLeak) {
            return;
        }
        String string3 = wrappedConnection.poolName1;
        long l = System.identityHashCode(wrappedConnection.con);
        String string4 = null;
        if (!bl) {
            string4 = wrappedConnection.getServerJobName();
        } else if (wrappedConnection.con instanceof PoolableConnection) {
            PoolableConnection poolableConnection = (PoolableConnection)wrappedConnection.con;
            try {
                object5 = poolableConnection.getMetaData();
                object4 = object5.getConnection();
                String string5 = object4.getClass().getName();
                if (string5.endsWith(".AS400JDBCConnection")) {
                    object3 = Class.forName(string5);
                    object2 = ((Class)object3).getMethod("getServerJobIdentifier", (Class<?>)(genericObjectPool = new Class[0]));
                    string2 = (String)((Method)object2).invoke(object4, object = new Object[0]);
                    if (string2 != null && string2.length() == 26) {
                        string4 = string2.substring(20).trim() + "/" + string2.substring(10, 20).trim() + "/" + string2.substring(0, 10).trim();
                        wrappedConnection.setServerJobName(string4);
                    } else if (string2 != null) {
                        string4 = string2;
                        wrappedConnection.setServerJobName(string4);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        boolean bl2 = false;
        object5 = new Throwable("Stack trace");
        object4 = ((Throwable)object5).getStackTrace();
        if (bl) {
            JdbcPoolManager.getInstance().connectionBorrowed(string3, l, (StackTraceElement[])object4);
        } else {
            JdbcPoolManager.getInstance().connectionReleased(string3, l);
        }
        for (int i = 0; i < ((Object)object4).length; ++i) {
            int n;
            object3 = ((StackTraceElement)object4[i]).getClassName();
            if (((String)object3).indexOf("AbstractDatabaseManager") > -1) {
                bl2 = true;
            }
            if (((String)object3).startsWith("com.helpsystems.common.access.Abstract") || ((String)object3).startsWith("com.helpsystems.common.access.Wrapped") || !bl2) continue;
            genericObjectPool = (GenericObjectPool)JdbcPoolManager.getInstance().getPool(string3);
            object2 = "x";
            object = "x";
            string2 = "x";
            String string6 = "x";
            String string7 = "x";
            if (genericObjectPool != null) {
                object2 = Integer.toString(genericObjectPool.getNumActive() + genericObjectPool.getNumIdle());
                object = Integer.toString(genericObjectPool.getNumActive());
                string2 = Integer.toString(genericObjectPool.getMaxActive());
                string6 = Integer.toString(genericObjectPool.getMaxIdle());
                string7 = Long.toString(genericObjectPool.getMinEvictableIdleTimeMillis());
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("JDBC Connection ");
            stringBuffer.append(l);
            stringBuffer.append(" ");
            stringBuffer.append(string);
            stringBuffer.append(" (");
            stringBuffer.append((String)object);
            stringBuffer.append("/");
            stringBuffer.append((String)object2);
            stringBuffer.append("/");
            stringBuffer.append(string2);
            stringBuffer.append("/");
            stringBuffer.append(string6);
            stringBuffer.append("/");
            stringBuffer.append(string7);
            stringBuffer.append(")");
            if (string4 != null) {
                stringBuffer.append("  Job: " + string4);
            }
            for (int j = 0; j < TRACING_STACK_DEPTH && (n = i + j) < ((Object)object4).length; ++j) {
                stringBuffer.append("\n\t");
                stringBuffer.append(((StackTraceElement)object4[n]).toString());
            }
            if (this.debugConnectionLeak) {
                logger.info((Object)stringBuffer.toString());
                break;
            }
            logger.trace((Object)stringBuffer.toString());
            break;
        }
    }

    public void setEncodingManager(EncodingManager encodingManager) {
        this.encodingManager = encodingManager;
    }

    static {
        if (HSJvmProperties.isJDBCTraceEnabled()) {
            DriverManager.setLogWriter(new PrintWriter(new OutputStreamWriter((OutputStream)new OutputStreamLogger("JDBC", logger))));
        }
    }

    class WrappedResultSet
    implements ResultSet {
        ResultSet rs;
        WrappedConnection wcon;
        WrappedStatement wstmt;
        ResultSetMetaData rsMetaData = null;

        WrappedResultSet(WrappedConnection wrappedConnection, WrappedStatement wrappedStatement, ResultSet resultSet) {
            this.wcon = wrappedConnection;
            this.wstmt = wrappedStatement;
            this.rs = resultSet;
            try {
                if (resultSet != null) {
                    this.rsMetaData = resultSet.getMetaData();
                }
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (Throwable throwable) {
                logger.debug((Object)"Error loading ResultSetMetaData.", throwable);
            }
        }

        @Override
        public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
            return this.rs.getObject(string, map);
        }

        @Override
        public Object getObject(int n, Map<String, Class<?>> map) throws SQLException {
            return this.rs.getObject(n, map);
        }

        @Override
        public Object getObject(String string) throws SQLException {
            return this.rs.getObject(string);
        }

        @Override
        public Object getObject(int n) throws SQLException {
            return this.rs.getObject(n);
        }

        @Override
        public boolean getBoolean(int n) throws SQLException {
            return this.rs.getBoolean(n);
        }

        @Override
        public boolean getBoolean(String string) throws SQLException {
            return this.rs.getBoolean(string);
        }

        @Override
        public byte getByte(int n) throws SQLException {
            return this.rs.getByte(n);
        }

        @Override
        public byte getByte(String string) throws SQLException {
            return this.rs.getByte(string);
        }

        @Override
        public short getShort(String string) throws SQLException {
            return this.rs.getShort(string);
        }

        @Override
        public short getShort(int n) throws SQLException {
            return this.rs.getShort(n);
        }

        @Override
        public int getInt(String string) throws SQLException {
            return this.rs.getInt(string);
        }

        @Override
        public int getInt(int n) throws SQLException {
            return this.rs.getInt(n);
        }

        @Override
        public long getLong(String string) throws SQLException {
            return this.rs.getLong(string);
        }

        @Override
        public long getLong(int n) throws SQLException {
            return this.rs.getLong(n);
        }

        @Override
        public float getFloat(String string) throws SQLException {
            return this.rs.getFloat(string);
        }

        @Override
        public float getFloat(int n) throws SQLException {
            return this.rs.getFloat(n);
        }

        @Override
        public double getDouble(String string) throws SQLException {
            return this.rs.getDouble(string);
        }

        @Override
        public double getDouble(int n) throws SQLException {
            return this.rs.getDouble(n);
        }

        @Override
        public byte[] getBytes(String string) throws SQLException {
            return this.rs.getBytes(string);
        }

        @Override
        public byte[] getBytes(int n) throws SQLException {
            return this.rs.getBytes(n);
        }

        @Override
        public Array getArray(int n) throws SQLException {
            return this.rs.getArray(n);
        }

        @Override
        public Array getArray(String string) throws SQLException {
            return this.rs.getArray(string);
        }

        @Override
        public URL getURL(String string) throws SQLException {
            return this.rs.getURL(string);
        }

        @Override
        public URL getURL(int n) throws SQLException {
            return this.rs.getURL(n);
        }

        @Override
        public boolean next() throws SQLException {
            return this.rs.next();
        }

        @Override
        public int getType() throws SQLException {
            return this.rs.getType();
        }

        @Override
        public boolean previous() throws SQLException {
            return this.rs.previous();
        }

        @Override
        public void close() throws SQLException {
            this.rs.close();
            this.wstmt.resultSetClosed(this);
        }

        @Override
        public Ref getRef(String string) throws SQLException {
            return this.rs.getRef(string);
        }

        @Override
        public Ref getRef(int n) throws SQLException {
            return this.rs.getRef(n);
        }

        @Override
        public Date getDate(String string) throws SQLException {
            Date date = this.rs.getDate(string);
            if (date == null || !AbstractDatabaseManager.this.useLocalizedDateTime) {
                return date;
            }
            date = new LocalizedDate((java.util.Date)date);
            this.wcon.adjustTimeIfNeeded(date);
            return date;
        }

        @Override
        public Date getDate(int n, Calendar calendar) throws SQLException {
            return this.rs.getDate(n, calendar);
        }

        @Override
        public Date getDate(String string, Calendar calendar) throws SQLException {
            return this.rs.getDate(string, calendar);
        }

        @Override
        public Date getDate(int n) throws SQLException {
            Date date = this.rs.getDate(n);
            if (date == null || !AbstractDatabaseManager.this.useLocalizedDateTime) {
                return date;
            }
            date = new LocalizedDate((java.util.Date)date);
            this.wcon.adjustTimeIfNeeded(date);
            return date;
        }

        @Override
        public boolean absolute(int n) throws SQLException {
            return this.rs.absolute(n);
        }

        @Override
        public void afterLast() throws SQLException {
            this.rs.afterLast();
        }

        @Override
        public void beforeFirst() throws SQLException {
            this.rs.beforeFirst();
        }

        @Override
        public void cancelRowUpdates() throws SQLException {
            this.rs.cancelRowUpdates();
        }

        @Override
        public void clearWarnings() throws SQLException {
            this.rs.clearWarnings();
        }

        @Override
        public void deleteRow() throws SQLException {
            this.rs.deleteRow();
        }

        @Override
        public int findColumn(String string) throws SQLException {
            return this.rs.findColumn(string);
        }

        @Override
        public boolean first() throws SQLException {
            return this.rs.first();
        }

        @Override
        public InputStream getAsciiStream(String string) throws SQLException {
            return this.rs.getAsciiStream(string);
        }

        @Override
        public InputStream getAsciiStream(int n) throws SQLException {
            return this.rs.getAsciiStream(n);
        }

        @Override
        public BigDecimal getBigDecimal(String string, int n) throws SQLException {
            return this.rs.getBigDecimal(string, n);
        }

        @Override
        public BigDecimal getBigDecimal(String string) throws SQLException {
            return this.rs.getBigDecimal(string);
        }

        @Override
        public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
            return this.rs.getBigDecimal(n, n2);
        }

        @Override
        public BigDecimal getBigDecimal(int n) throws SQLException {
            return this.rs.getBigDecimal(n);
        }

        @Override
        public InputStream getBinaryStream(int n) throws SQLException {
            return this.rs.getBinaryStream(n);
        }

        @Override
        public InputStream getBinaryStream(String string) throws SQLException {
            return this.rs.getBinaryStream(string);
        }

        @Override
        public Blob getBlob(String string) throws SQLException {
            return this.rs.getBlob(string);
        }

        @Override
        public Blob getBlob(int n) throws SQLException {
            return this.rs.getBlob(n);
        }

        @Override
        public Reader getCharacterStream(int n) throws SQLException {
            return this.rs.getCharacterStream(n);
        }

        @Override
        public Reader getCharacterStream(String string) throws SQLException {
            return this.rs.getCharacterStream(string);
        }

        @Override
        public Clob getClob(int n) throws SQLException {
            return this.rs.getClob(n);
        }

        @Override
        public Clob getClob(String string) throws SQLException {
            return this.rs.getClob(string);
        }

        @Override
        public int getConcurrency() throws SQLException {
            return this.rs.getConcurrency();
        }

        @Override
        public String getCursorName() throws SQLException {
            return this.rs.getCursorName();
        }

        @Override
        public int getFetchDirection() throws SQLException {
            return this.rs.getFetchDirection();
        }

        @Override
        public int getFetchSize() throws SQLException {
            return this.rs.getFetchSize();
        }

        @Override
        public ResultSetMetaData getMetaData() throws SQLException {
            return this.rs.getMetaData();
        }

        @Override
        public int getRow() throws SQLException {
            return this.rs.getRow();
        }

        @Override
        public Statement getStatement() throws SQLException {
            return this.wstmt;
        }

        @Override
        public String getString(int n) throws SQLException {
            String string = this.rs.getString(n);
            if (AbstractDatabaseManager.this.encodingManager != null && !this.isUnicodeDBField(n)) {
                string = AbstractDatabaseManager.this.encodingManager.adjustUnicodeFromDB(string);
            }
            return string;
        }

        private boolean isUnicodeDBField(int n) {
            try {
                if (this.rsMetaData != null) {
                    String string;
                    String string2 = this.rsMetaData.getColumnName(n);
                    if (string2.indexOf(string = "_Z_Z_") > -1) {
                        string2 = string2.substring(string2.indexOf(string) + string.length());
                    }
                    return this.isUnicodeDBField(string2);
                }
            }
            catch (Throwable throwable) {
                logger.error((Object)"Error checking for unicode data.", throwable);
            }
            return false;
        }

        @Override
        public String getString(String string) throws SQLException {
            String string2 = this.rs.getString(string);
            if (AbstractDatabaseManager.this.encodingManager != null && !this.isUnicodeDBField(string)) {
                string2 = AbstractDatabaseManager.this.encodingManager.adjustUnicodeFromDB(string2);
            }
            return string2;
        }

        private boolean isUnicodeDBField(String string) {
            boolean bl = AbstractDatabaseManager.isUnicodeField(string);
            if (!bl) {
                return false;
            }
            return this.checkCmdString(string);
        }

        private boolean checkCmdString(String string) {
            String string2 = "CMD_STRING";
            String string3 = string.trim().toUpperCase();
            if (string3.equals(string2)) {
                if (this.rsMetaData == null) {
                    logger.error((Object)("Result Set MetaData is unavailable for " + string));
                    return true;
                }
                try {
                    int n;
                    int n2 = this.rsMetaData.getColumnCount();
                    int n3 = -1;
                    for (n = 1; n <= n2; ++n) {
                        if (!this.rsMetaData.getColumnName(n).toUpperCase().equals(string2)) continue;
                        n3 = n;
                        break;
                    }
                    if (n3 > -1) {
                        n = this.rsMetaData.getColumnDisplaySize(n3);
                        return n >= 9000;
                    }
                }
                catch (Throwable throwable) {
                    logger.error((Object)"Error getting statement parameter data.", throwable);
                }
            } else {
                return true;
            }
            return false;
        }

        @Override
        public Time getTime(int n) throws SQLException {
            Time time = this.rs.getTime(n);
            if (time == null || !AbstractDatabaseManager.this.useLocalizedDateTime) {
                return null;
            }
            time = new LocalizedTime(time);
            this.wcon.adjustTimeIfNeeded(time);
            return time;
        }

        @Override
        public Time getTime(String string, Calendar calendar) throws SQLException {
            return this.rs.getTime(string, calendar);
        }

        @Override
        public Time getTime(String string) throws SQLException {
            Time time = this.rs.getTime(string);
            if (time == null || !AbstractDatabaseManager.this.useLocalizedDateTime) {
                return null;
            }
            time = new LocalizedTime(time);
            this.wcon.adjustTimeIfNeeded(time);
            return time;
        }

        @Override
        public Time getTime(int n, Calendar calendar) throws SQLException {
            return this.rs.getTime(n, calendar);
        }

        @Override
        public Timestamp getTimestamp(int n) throws SQLException {
            Timestamp timestamp = this.rs.getTimestamp(n);
            if (timestamp == null || !AbstractDatabaseManager.this.useLocalizedDateTime) {
                return timestamp;
            }
            timestamp = new LocalizedTimestamp(timestamp);
            this.wcon.adjustTimeIfNeeded(timestamp);
            return timestamp;
        }

        @Override
        public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
            return this.rs.getTimestamp(string, calendar);
        }

        @Override
        public Timestamp getTimestamp(String string) throws SQLException {
            Timestamp timestamp = this.rs.getTimestamp(string);
            if (timestamp == null || !AbstractDatabaseManager.this.useLocalizedDateTime) {
                return timestamp;
            }
            timestamp = new LocalizedTimestamp(timestamp);
            this.wcon.adjustTimeIfNeeded(timestamp);
            return timestamp;
        }

        @Override
        public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
            return this.rs.getTimestamp(n, calendar);
        }

        @Override
        public InputStream getUnicodeStream(String string) throws SQLException {
            return this.rs.getUnicodeStream(string);
        }

        @Override
        public InputStream getUnicodeStream(int n) throws SQLException {
            return this.rs.getUnicodeStream(n);
        }

        @Override
        public SQLWarning getWarnings() throws SQLException {
            return this.rs.getWarnings();
        }

        @Override
        public void insertRow() throws SQLException {
            this.rs.insertRow();
        }

        @Override
        public boolean isAfterLast() throws SQLException {
            return this.rs.isAfterLast();
        }

        @Override
        public boolean isBeforeFirst() throws SQLException {
            return this.rs.isBeforeFirst();
        }

        @Override
        public boolean isFirst() throws SQLException {
            return this.rs.isFirst();
        }

        @Override
        public boolean isLast() throws SQLException {
            return this.rs.isLast();
        }

        @Override
        public boolean last() throws SQLException {
            return this.rs.last();
        }

        @Override
        public void moveToCurrentRow() throws SQLException {
            this.rs.moveToCurrentRow();
        }

        @Override
        public void moveToInsertRow() throws SQLException {
            this.rs.moveToInsertRow();
        }

        @Override
        public void refreshRow() throws SQLException {
            this.rs.refreshRow();
        }

        @Override
        public boolean relative(int n) throws SQLException {
            return this.rs.relative(n);
        }

        @Override
        public boolean rowDeleted() throws SQLException {
            return this.rs.rowDeleted();
        }

        @Override
        public boolean rowInserted() throws SQLException {
            return this.rs.rowInserted();
        }

        @Override
        public boolean rowUpdated() throws SQLException {
            return this.rs.rowUpdated();
        }

        @Override
        public void setFetchDirection(int n) throws SQLException {
            this.rs.setFetchDirection(n);
        }

        @Override
        public void setFetchSize(int n) throws SQLException {
            this.rs.setFetchSize(n);
        }

        @Override
        public void updateArray(int n, Array array) throws SQLException {
            this.rs.updateArray(n, array);
        }

        @Override
        public void updateArray(String string, Array array) throws SQLException {
            this.rs.updateArray(string, array);
        }

        @Override
        public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
            this.rs.updateAsciiStream(string, inputStream, n);
        }

        @Override
        public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
            this.rs.updateAsciiStream(n, inputStream, n2);
        }

        @Override
        public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
            this.rs.updateBigDecimal(string, bigDecimal);
        }

        @Override
        public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
            this.rs.updateBigDecimal(n, bigDecimal);
        }

        @Override
        public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
            this.rs.updateBinaryStream(n, inputStream, n2);
        }

        @Override
        public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
            this.rs.updateBinaryStream(string, inputStream, n);
        }

        @Override
        public void updateBlob(int n, Blob blob) throws SQLException {
            this.rs.updateBlob(n, blob);
        }

        @Override
        public void updateBlob(String string, Blob blob) throws SQLException {
            this.rs.updateBlob(string, blob);
        }

        @Override
        public void updateBoolean(int n, boolean bl) throws SQLException {
            this.rs.updateBoolean(n, bl);
        }

        @Override
        public void updateBoolean(String string, boolean bl) throws SQLException {
            this.rs.updateBoolean(string, bl);
        }

        @Override
        public void updateByte(String string, byte by) throws SQLException {
            this.rs.updateByte(string, by);
        }

        @Override
        public void updateByte(int n, byte by) throws SQLException {
            this.rs.updateByte(n, by);
        }

        @Override
        public void updateBytes(int n, byte[] byArray) throws SQLException {
            this.rs.updateBytes(n, byArray);
        }

        @Override
        public void updateBytes(String string, byte[] byArray) throws SQLException {
            this.rs.updateBytes(string, byArray);
        }

        @Override
        public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
            this.rs.updateCharacterStream(n, reader, n2);
        }

        @Override
        public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
            this.rs.updateCharacterStream(string, reader, n);
        }

        @Override
        public void updateClob(int n, Clob clob) throws SQLException {
            this.rs.updateClob(n, clob);
        }

        @Override
        public void updateClob(String string, Clob clob) throws SQLException {
            this.rs.updateClob(string, clob);
        }

        @Override
        public void updateDate(int n, Date date) throws SQLException {
            this.rs.updateDate(n, date);
        }

        @Override
        public void updateDate(String string, Date date) throws SQLException {
            this.rs.updateDate(string, date);
        }

        @Override
        public void updateDouble(String string, double d) throws SQLException {
            this.rs.updateDouble(string, d);
        }

        @Override
        public void updateDouble(int n, double d) throws SQLException {
            this.rs.updateDouble(n, d);
        }

        @Override
        public void updateFloat(String string, float f) throws SQLException {
            this.rs.updateFloat(string, f);
        }

        @Override
        public void updateFloat(int n, float f) throws SQLException {
            this.rs.updateFloat(n, f);
        }

        @Override
        public void updateInt(String string, int n) throws SQLException {
            this.rs.updateInt(string, n);
        }

        @Override
        public void updateInt(int n, int n2) throws SQLException {
            this.rs.updateInt(n, n2);
        }

        @Override
        public void updateLong(int n, long l) throws SQLException {
            this.rs.updateLong(n, l);
        }

        @Override
        public void updateLong(String string, long l) throws SQLException {
            this.rs.updateLong(string, l);
        }

        @Override
        public void updateNull(int n) throws SQLException {
            this.rs.updateNull(n);
        }

        @Override
        public void updateNull(String string) throws SQLException {
            this.rs.updateNull(string);
        }

        @Override
        public void updateObject(String string, Object object, int n) throws SQLException {
            this.rs.updateObject(string, object, n);
        }

        @Override
        public void updateObject(String string, Object object) throws SQLException {
            this.rs.updateObject(string, object);
        }

        @Override
        public void updateObject(int n, Object object, int n2) throws SQLException {
            this.rs.updateObject(n, object, n2);
        }

        @Override
        public void updateObject(int n, Object object) throws SQLException {
            this.rs.updateObject(n, object);
        }

        @Override
        public void updateRef(String string, Ref ref) throws SQLException {
            this.rs.updateRef(string, ref);
        }

        @Override
        public void updateRef(int n, Ref ref) throws SQLException {
            this.rs.updateRef(n, ref);
        }

        @Override
        public void updateRow() throws SQLException {
            this.rs.updateRow();
        }

        @Override
        public void updateShort(String string, short s) throws SQLException {
            this.rs.updateShort(string, s);
        }

        @Override
        public void updateShort(int n, short s) throws SQLException {
            this.rs.updateShort(n, s);
        }

        @Override
        public void updateString(int n, String string) throws SQLException {
            this.rs.updateString(n, string);
        }

        @Override
        public void updateString(String string, String string2) throws SQLException {
            this.rs.updateString(string, string2);
        }

        @Override
        public void updateTime(int n, Time time) throws SQLException {
            this.rs.updateTime(n, time);
        }

        @Override
        public void updateTime(String string, Time time) throws SQLException {
            this.rs.updateTime(string, time);
        }

        @Override
        public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
            this.rs.updateTimestamp(string, timestamp);
        }

        @Override
        public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
            this.rs.updateTimestamp(n, timestamp);
        }

        @Override
        public boolean wasNull() throws SQLException {
            return this.rs.wasNull();
        }

        @Override
        public int getHoldability() throws SQLException {
            return this.rs.getHoldability();
        }

        @Override
        public Reader getNCharacterStream(int n) throws SQLException {
            return this.rs.getNCharacterStream(n);
        }

        @Override
        public Reader getNCharacterStream(String string) throws SQLException {
            return this.rs.getNCharacterStream(string);
        }

        @Override
        public NClob getNClob(int n) throws SQLException {
            return this.rs.getNClob(n);
        }

        @Override
        public NClob getNClob(String string) throws SQLException {
            return this.rs.getNClob(string);
        }

        @Override
        public String getNString(int n) throws SQLException {
            return this.rs.getNString(n);
        }

        @Override
        public String getNString(String string) throws SQLException {
            return this.rs.getNString(string);
        }

        @Override
        public RowId getRowId(int n) throws SQLException {
            return this.rs.getRowId(n);
        }

        @Override
        public RowId getRowId(String string) throws SQLException {
            return this.rs.getRowId(string);
        }

        @Override
        public SQLXML getSQLXML(int n) throws SQLException {
            return this.rs.getSQLXML(n);
        }

        @Override
        public SQLXML getSQLXML(String string) throws SQLException {
            return this.rs.getSQLXML(string);
        }

        @Override
        public boolean isClosed() throws SQLException {
            return this.rs.isClosed();
        }

        @Override
        public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
            this.rs.updateAsciiStream(n, inputStream);
        }

        @Override
        public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
            this.rs.updateAsciiStream(string, inputStream);
        }

        @Override
        public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
            this.rs.updateAsciiStream(n, inputStream, l);
        }

        @Override
        public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
            this.rs.updateAsciiStream(string, inputStream, l);
        }

        @Override
        public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
            this.rs.updateBinaryStream(n, inputStream);
        }

        @Override
        public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
            this.rs.updateBinaryStream(string, inputStream);
        }

        @Override
        public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
            this.rs.updateBinaryStream(n, inputStream, l);
        }

        @Override
        public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
            this.rs.updateBinaryStream(string, inputStream, l);
        }

        @Override
        public void updateBlob(int n, InputStream inputStream) throws SQLException {
            this.rs.updateBlob(n, inputStream);
        }

        @Override
        public void updateBlob(String string, InputStream inputStream) throws SQLException {
            this.rs.updateBlob(string, inputStream);
        }

        @Override
        public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
            this.rs.updateBlob(n, inputStream, l);
        }

        @Override
        public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
            this.rs.updateBlob(string, inputStream, l);
        }

        @Override
        public void updateCharacterStream(int n, Reader reader) throws SQLException {
            this.rs.updateCharacterStream(n, reader);
        }

        @Override
        public void updateCharacterStream(String string, Reader reader) throws SQLException {
            this.rs.updateCharacterStream(string, reader);
        }

        @Override
        public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
            this.rs.updateCharacterStream(n, reader, l);
        }

        @Override
        public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
            this.rs.updateCharacterStream(string, reader, l);
        }

        @Override
        public void updateClob(int n, Reader reader) throws SQLException {
            this.rs.updateClob(n, reader);
        }

        @Override
        public void updateClob(String string, Reader reader) throws SQLException {
            this.rs.updateClob(string, reader);
        }

        @Override
        public void updateClob(int n, Reader reader, long l) throws SQLException {
            this.rs.updateClob(n, reader, l);
        }

        @Override
        public void updateClob(String string, Reader reader, long l) throws SQLException {
            this.rs.updateClob(string, reader, l);
        }

        @Override
        public void updateNCharacterStream(int n, Reader reader) throws SQLException {
            this.rs.updateNCharacterStream(n, reader);
        }

        @Override
        public void updateNCharacterStream(String string, Reader reader) throws SQLException {
            this.rs.updateNCharacterStream(string, reader);
        }

        @Override
        public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
            this.rs.updateNCharacterStream(n, reader, l);
        }

        @Override
        public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
            this.rs.updateNCharacterStream(string, reader, l);
        }

        @Override
        public void updateNClob(int n, NClob nClob) throws SQLException {
            this.rs.updateNClob(n, nClob);
        }

        @Override
        public void updateNClob(String string, NClob nClob) throws SQLException {
            this.rs.updateNClob(string, nClob);
        }

        @Override
        public void updateNClob(int n, Reader reader) throws SQLException {
            this.rs.updateNClob(n, reader);
        }

        @Override
        public void updateNClob(String string, Reader reader) throws SQLException {
            this.rs.updateNClob(string, reader);
        }

        @Override
        public void updateNClob(int n, Reader reader, long l) throws SQLException {
            this.rs.updateNClob(n, reader, l);
        }

        @Override
        public void updateNClob(String string, Reader reader, long l) throws SQLException {
            this.rs.updateNClob(string, reader, l);
        }

        @Override
        public void updateNString(int n, String string) throws SQLException {
            this.rs.updateNString(n, string);
        }

        @Override
        public void updateNString(String string, String string2) throws SQLException {
            this.rs.updateNString(string, string2);
        }

        @Override
        public void updateRowId(int n, RowId rowId) throws SQLException {
            this.rs.updateRowId(n, rowId);
        }

        @Override
        public void updateRowId(String string, RowId rowId) throws SQLException {
            this.rs.updateRowId(string, rowId);
        }

        @Override
        public void updateSQLXML(int n, SQLXML sQLXML) throws SQLException {
            this.rs.updateSQLXML(n, sQLXML);
        }

        @Override
        public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
            this.rs.updateSQLXML(string, sQLXML);
        }

        @Override
        public boolean isWrapperFor(Class<?> clazz) throws SQLException {
            return this.rs.isWrapperFor(clazz);
        }

        @Override
        public <T> T unwrap(Class<T> clazz) throws SQLException {
            return this.rs.unwrap(clazz);
        }

        @Override
        public <T> T getObject(int n, Class<T> clazz) throws SQLException {
            return null;
        }

        @Override
        public <T> T getObject(String string, Class<T> clazz) throws SQLException {
            return null;
        }
    }

    class WrappedCallableStatement
    extends WrappedPreparedStatement
    implements CallableStatement {
        CallableStatement cs;

        WrappedCallableStatement(WrappedConnection wrappedConnection, CallableStatement callableStatement) {
            super(wrappedConnection, callableStatement);
            this.cs = callableStatement;
        }

        @Override
        public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
            return this.cs.getObject(string, map);
        }

        @Override
        public Object getObject(int n, Map<String, Class<?>> map) throws SQLException {
            return this.cs.getObject(n, map);
        }

        @Override
        public Object getObject(int n) throws SQLException {
            return this.cs.getObject(n);
        }

        @Override
        public Object getObject(String string) throws SQLException {
            return this.cs.getObject(string);
        }

        @Override
        public boolean getBoolean(String string) throws SQLException {
            return this.cs.getBoolean(string);
        }

        @Override
        public boolean getBoolean(int n) throws SQLException {
            return this.cs.getBoolean(n);
        }

        @Override
        public byte getByte(int n) throws SQLException {
            return this.cs.getByte(n);
        }

        @Override
        public byte getByte(String string) throws SQLException {
            return this.cs.getByte(string);
        }

        @Override
        public short getShort(String string) throws SQLException {
            return this.cs.getShort(string);
        }

        @Override
        public short getShort(int n) throws SQLException {
            return this.cs.getShort(n);
        }

        @Override
        public int getInt(int n) throws SQLException {
            return this.cs.getInt(n);
        }

        @Override
        public int getInt(String string) throws SQLException {
            return this.cs.getInt(string);
        }

        @Override
        public long getLong(String string) throws SQLException {
            return this.cs.getLong(string);
        }

        @Override
        public long getLong(int n) throws SQLException {
            return this.cs.getLong(n);
        }

        @Override
        public float getFloat(int n) throws SQLException {
            return this.cs.getFloat(n);
        }

        @Override
        public float getFloat(String string) throws SQLException {
            return this.cs.getFloat(string);
        }

        @Override
        public double getDouble(int n) throws SQLException {
            return this.cs.getDouble(n);
        }

        @Override
        public double getDouble(String string) throws SQLException {
            return this.cs.getDouble(string);
        }

        @Override
        public byte[] getBytes(int n) throws SQLException {
            return this.cs.getBytes(n);
        }

        @Override
        public byte[] getBytes(String string) throws SQLException {
            return this.cs.getBytes(string);
        }

        @Override
        public Array getArray(String string) throws SQLException {
            return this.cs.getArray(string);
        }

        @Override
        public Array getArray(int n) throws SQLException {
            return this.cs.getArray(n);
        }

        @Override
        public URL getURL(int n) throws SQLException {
            return this.cs.getURL(n);
        }

        @Override
        public URL getURL(String string) throws SQLException {
            return this.cs.getURL(string);
        }

        @Override
        public void setBoolean(String string, boolean bl) throws SQLException {
            this.cs.setBoolean(string, bl);
        }

        @Override
        public void setByte(String string, byte by) throws SQLException {
            this.cs.setByte(string, by);
        }

        @Override
        public void setDouble(String string, double d) throws SQLException {
            this.cs.setDouble(string, d);
        }

        @Override
        public void setFloat(String string, float f) throws SQLException {
            this.cs.setFloat(string, f);
        }

        @Override
        public void setInt(String string, int n) throws SQLException {
            this.cs.setInt(string, n);
        }

        @Override
        public void setLong(String string, long l) throws SQLException {
            this.cs.setLong(string, l);
        }

        @Override
        public void setShort(String string, short s) throws SQLException {
            this.cs.setShort(string, s);
        }

        @Override
        public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
            this.cs.setTimestamp(string, timestamp);
        }

        @Override
        public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
            this.cs.setTimestamp(string, timestamp, calendar);
        }

        @Override
        public Ref getRef(int n) throws SQLException {
            return this.cs.getRef(n);
        }

        @Override
        public Ref getRef(String string) throws SQLException {
            return this.cs.getRef(string);
        }

        @Override
        public void setURL(String string, URL uRL) throws SQLException {
            this.cs.setURL(string, uRL);
        }

        @Override
        public Date getDate(String string, Calendar calendar) throws SQLException {
            return this.cs.getDate(string, calendar);
        }

        @Override
        public Date getDate(int n, Calendar calendar) throws SQLException {
            return this.cs.getDate(n, calendar);
        }

        @Override
        public Date getDate(String string) throws SQLException {
            Date date = this.cs.getDate(string);
            if (date == null || !AbstractDatabaseManager.this.useLocalizedDateTime) {
                return date;
            }
            date = new LocalizedDate((java.util.Date)date);
            this.wcon.adjustTimeIfNeeded(date);
            return date;
        }

        @Override
        public Date getDate(int n) throws SQLException {
            Date date = this.cs.getDate(n);
            if (date == null || !AbstractDatabaseManager.this.useLocalizedDateTime) {
                return date;
            }
            date = new LocalizedDate((java.util.Date)date);
            this.wcon.adjustTimeIfNeeded(date);
            return date;
        }

        @Override
        public BigDecimal getBigDecimal(String string) throws SQLException {
            return this.cs.getBigDecimal(string);
        }

        @Override
        public BigDecimal getBigDecimal(int n) throws SQLException {
            return this.cs.getBigDecimal(n);
        }

        @Override
        public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
            return this.cs.getBigDecimal(n, n2);
        }

        @Override
        public Blob getBlob(String string) throws SQLException {
            return this.cs.getBlob(string);
        }

        @Override
        public Blob getBlob(int n) throws SQLException {
            return this.cs.getBlob(n);
        }

        @Override
        public Clob getClob(String string) throws SQLException {
            return this.cs.getClob(string);
        }

        @Override
        public Clob getClob(int n) throws SQLException {
            return this.cs.getClob(n);
        }

        @Override
        public String getString(int n) throws SQLException {
            return this.cs.getString(n);
        }

        @Override
        public String getString(String string) throws SQLException {
            return this.cs.getString(string);
        }

        @Override
        public Time getTime(int n) throws SQLException {
            Time time = this.cs.getTime(n);
            if (time == null || !AbstractDatabaseManager.this.useLocalizedDateTime) {
                return time;
            }
            time = new LocalizedTime(time);
            this.wcon.adjustTimeIfNeeded(time);
            return time;
        }

        @Override
        public Time getTime(String string) throws SQLException {
            Time time = this.cs.getTime(string);
            if (time == null || !AbstractDatabaseManager.this.useLocalizedDateTime) {
                return time;
            }
            time = new LocalizedTime(time);
            this.wcon.adjustTimeIfNeeded(time);
            return time;
        }

        @Override
        public Time getTime(String string, Calendar calendar) throws SQLException {
            return this.cs.getTime(string, calendar);
        }

        @Override
        public Time getTime(int n, Calendar calendar) throws SQLException {
            return this.cs.getTime(n, calendar);
        }

        @Override
        public Timestamp getTimestamp(String string) throws SQLException {
            Timestamp timestamp = this.cs.getTimestamp(string);
            if (timestamp == null || !AbstractDatabaseManager.this.useLocalizedDateTime) {
                return timestamp;
            }
            timestamp = new LocalizedTimestamp(timestamp);
            this.wcon.adjustTimeIfNeeded(timestamp);
            return timestamp;
        }

        @Override
        public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
            return this.cs.getTimestamp(n, calendar);
        }

        @Override
        public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
            return this.cs.getTimestamp(string, calendar);
        }

        @Override
        public Timestamp getTimestamp(int n) throws SQLException {
            Timestamp timestamp = this.cs.getTimestamp(n);
            if (timestamp == null || !AbstractDatabaseManager.this.useLocalizedDateTime) {
                return timestamp;
            }
            timestamp = new LocalizedTimestamp(timestamp);
            this.wcon.adjustTimeIfNeeded(timestamp);
            return timestamp;
        }

        @Override
        public void registerOutParameter(int n, int n2, String string) throws SQLException {
            this.cs.registerOutParameter(n, n2, string);
        }

        @Override
        public void registerOutParameter(String string, int n, int n2) throws SQLException {
            this.cs.registerOutParameter(string, n, n2);
        }

        @Override
        public void registerOutParameter(String string, int n, String string2) throws SQLException {
            this.cs.registerOutParameter(string, n, string2);
        }

        @Override
        public void registerOutParameter(int n, int n2, int n3) throws SQLException {
            this.cs.registerOutParameter(n, n2, n3);
        }

        @Override
        public void registerOutParameter(int n, int n2) throws SQLException {
            this.cs.registerOutParameter(n, n2);
        }

        @Override
        public void registerOutParameter(String string, int n) throws SQLException {
            this.cs.registerOutParameter(string, n);
        }

        @Override
        public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
            this.cs.setAsciiStream(string, inputStream, n);
        }

        @Override
        public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
            this.cs.setBigDecimal(string, bigDecimal);
        }

        @Override
        public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
            this.cs.setBinaryStream(string, inputStream, n);
        }

        @Override
        public void setBytes(String string, byte[] byArray) throws SQLException {
            this.cs.setBytes(string, byArray);
        }

        @Override
        public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
            this.cs.setCharacterStream(string, reader, n);
        }

        @Override
        public void setDate(String string, Date date, Calendar calendar) throws SQLException {
            this.cs.setDate(string, date, calendar);
        }

        @Override
        public void setDate(String string, Date date) throws SQLException {
            this.cs.setDate(string, date);
        }

        @Override
        public void setNull(String string, int n) throws SQLException {
            this.cs.setNull(string, n);
        }

        @Override
        public void setNull(String string, int n, String string2) throws SQLException {
            this.cs.setNull(string, n, string2);
        }

        @Override
        public void setObject(String string, Object object) throws SQLException {
            this.cs.setObject(string, object);
        }

        @Override
        public void setObject(String string, Object object, int n) throws SQLException {
            this.cs.setObject(string, object, n);
        }

        @Override
        public void setObject(String string, Object object, int n, int n2) throws SQLException {
            this.cs.setObject(string, object, n, n2);
        }

        @Override
        public void setString(String string, String string2) throws SQLException {
            this.cs.setString(string, string2);
        }

        @Override
        public void setTime(String string, Time time, Calendar calendar) throws SQLException {
            this.cs.setTime(string, time, calendar);
        }

        @Override
        public void setTime(String string, Time time) throws SQLException {
            this.cs.setTime(string, time);
        }

        @Override
        public boolean wasNull() throws SQLException {
            return this.cs.wasNull();
        }

        @Override
        public Reader getCharacterStream(int n) throws SQLException {
            return this.cs.getCharacterStream(n);
        }

        @Override
        public Reader getCharacterStream(String string) throws SQLException {
            return this.cs.getCharacterStream(string);
        }

        @Override
        public Reader getNCharacterStream(int n) throws SQLException {
            return this.cs.getNCharacterStream(n);
        }

        @Override
        public Reader getNCharacterStream(String string) throws SQLException {
            return this.cs.getNCharacterStream(string);
        }

        @Override
        public NClob getNClob(int n) throws SQLException {
            return this.cs.getNClob(n);
        }

        @Override
        public NClob getNClob(String string) throws SQLException {
            return this.cs.getNClob(string);
        }

        @Override
        public String getNString(int n) throws SQLException {
            return this.cs.getNString(n);
        }

        @Override
        public String getNString(String string) throws SQLException {
            return this.cs.getNString(string);
        }

        @Override
        public RowId getRowId(int n) throws SQLException {
            return this.cs.getRowId(n);
        }

        @Override
        public RowId getRowId(String string) throws SQLException {
            return this.cs.getRowId(string);
        }

        @Override
        public SQLXML getSQLXML(int n) throws SQLException {
            return this.cs.getSQLXML(n);
        }

        @Override
        public SQLXML getSQLXML(String string) throws SQLException {
            return this.cs.getSQLXML(string);
        }

        @Override
        public void setAsciiStream(String string, InputStream inputStream) throws SQLException {
            this.cs.setAsciiStream(string, inputStream);
        }

        @Override
        public void setAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
            this.cs.setAsciiStream(string, inputStream, l);
        }

        @Override
        public void setBinaryStream(String string, InputStream inputStream) throws SQLException {
            this.cs.setBinaryStream(string, inputStream);
        }

        @Override
        public void setBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
            this.cs.setBinaryStream(string, inputStream, l);
        }

        @Override
        public void setBlob(String string, Blob blob) throws SQLException {
            this.cs.setBlob(string, blob);
        }

        @Override
        public void setBlob(String string, InputStream inputStream) throws SQLException {
            this.cs.setBlob(string, inputStream);
        }

        @Override
        public void setBlob(String string, InputStream inputStream, long l) throws SQLException {
            this.cs.setBlob(string, inputStream, l);
        }

        @Override
        public void setCharacterStream(String string, Reader reader) throws SQLException {
            this.cs.setCharacterStream(string, reader);
        }

        @Override
        public void setCharacterStream(String string, Reader reader, long l) throws SQLException {
            this.cs.setCharacterStream(string, reader, l);
        }

        @Override
        public void setClob(String string, Clob clob) throws SQLException {
            this.cs.setClob(string, clob);
        }

        @Override
        public void setClob(String string, Reader reader) throws SQLException {
            this.cs.setClob(string, reader);
        }

        @Override
        public void setClob(String string, Reader reader, long l) throws SQLException {
            this.cs.setClob(string, reader, l);
        }

        @Override
        public void setNCharacterStream(String string, Reader reader) throws SQLException {
            this.cs.setNCharacterStream(string, reader);
        }

        @Override
        public void setNCharacterStream(String string, Reader reader, long l) throws SQLException {
            this.cs.setNCharacterStream(string, reader, l);
        }

        @Override
        public void setNClob(String string, NClob nClob) throws SQLException {
            this.cs.setNClob(string, nClob);
        }

        @Override
        public void setNClob(String string, Reader reader) throws SQLException {
            this.cs.setNClob(string, reader);
        }

        @Override
        public void setNClob(String string, Reader reader, long l) throws SQLException {
            this.cs.setNClob(string, reader, l);
        }

        @Override
        public void setNString(String string, String string2) throws SQLException {
            this.cs.setNString(string, string2);
        }

        @Override
        public void setRowId(String string, RowId rowId) throws SQLException {
            this.cs.setRowId(string, rowId);
        }

        @Override
        public void setSQLXML(String string, SQLXML sQLXML) throws SQLException {
            this.cs.setSQLXML(string, sQLXML);
        }

        @Override
        public void closeOnCompletion() throws SQLException {
        }

        @Override
        public boolean isCloseOnCompletion() throws SQLException {
            return false;
        }

        @Override
        public <T> T getObject(int n, Class<T> clazz) throws SQLException {
            return null;
        }

        @Override
        public <T> T getObject(String string, Class<T> clazz) throws SQLException {
            return null;
        }
    }

    public class WrappedPreparedStatement
    extends WrappedStatement
    implements PreparedStatement {
        PreparedStatement ps;
        private ParameterMetaData pmd;
        protected HashMap<Integer, String> unicodeParms;

        WrappedPreparedStatement(WrappedConnection wrappedConnection, PreparedStatement preparedStatement) {
            super(wrappedConnection, preparedStatement);
            this.unicodeParms = new HashMap();
            this.ps = preparedStatement;
        }

        public void defineUnicodeParm(int n, String string) {
            this.unicodeParms.put(new Integer(n), string);
        }

        @Override
        public void setBoolean(int n, boolean bl) throws SQLException {
            this.ps.setBoolean(n, bl);
        }

        @Override
        public void setByte(int n, byte by) throws SQLException {
            this.ps.setByte(n, by);
        }

        @Override
        public void setDouble(int n, double d) throws SQLException {
            this.ps.setDouble(n, d);
        }

        @Override
        public void setFloat(int n, float f) throws SQLException {
            this.ps.setFloat(n, f);
        }

        @Override
        public void setInt(int n, int n2) throws SQLException {
            this.ps.setInt(n, n2);
        }

        @Override
        public void setLong(int n, long l) throws SQLException {
            this.ps.setLong(n, l);
        }

        @Override
        public void setShort(int n, short s) throws SQLException {
            this.ps.setShort(n, s);
        }

        @Override
        public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
            this.ps.setTimestamp(n, timestamp, calendar);
        }

        @Override
        public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
            this.ps.setTimestamp(n, timestamp);
        }

        @Override
        public void setURL(int n, URL uRL) throws SQLException {
            this.ps.setURL(n, uRL);
        }

        @Override
        public boolean execute() throws SQLException {
            return this.ps.execute();
        }

        @Override
        public void addBatch() throws SQLException {
            this.ps.addBatch();
        }

        @Override
        public void clearParameters() throws SQLException {
            this.ps.clearParameters();
        }

        @Override
        public ResultSet executeQuery() throws SQLException {
            WrappedResultSet wrappedResultSet = new WrappedResultSet(this.wcon, this, this.ps.executeQuery());
            this.trackResultSet(wrappedResultSet);
            return wrappedResultSet;
        }

        @Override
        public int executeUpdate() throws SQLException {
            return this.ps.executeUpdate();
        }

        @Override
        public ResultSetMetaData getMetaData() throws SQLException {
            return this.ps.getMetaData();
        }

        @Override
        public ParameterMetaData getParameterMetaData() throws SQLException {
            return this.ps.getParameterMetaData();
        }

        @Override
        public void setArray(int n, Array array) throws SQLException {
            this.ps.setArray(n, array);
        }

        @Override
        public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
            this.ps.setAsciiStream(n, inputStream, n2);
        }

        @Override
        public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
            this.ps.setBigDecimal(n, bigDecimal);
        }

        @Override
        public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
            this.ps.setBinaryStream(n, inputStream, n2);
        }

        @Override
        public void setBlob(int n, Blob blob) throws SQLException {
            this.ps.setBlob(n, blob);
        }

        @Override
        public void setBytes(int n, byte[] byArray) throws SQLException {
            this.ps.setBytes(n, byArray);
        }

        @Override
        public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
            this.ps.setCharacterStream(n, reader, n2);
        }

        @Override
        public void setClob(int n, Clob clob) throws SQLException {
            this.ps.setClob(n, clob);
        }

        @Override
        public void setDate(int n, Date date) throws SQLException {
            this.ps.setDate(n, date);
        }

        @Override
        public void setDate(int n, Date date, Calendar calendar) throws SQLException {
            this.ps.setDate(n, date, calendar);
        }

        @Override
        public void setNull(int n, int n2) throws SQLException {
            this.ps.setNull(n, n2);
        }

        @Override
        public void setNull(int n, int n2, String string) throws SQLException {
            this.ps.setNull(n, n2, string);
        }

        @Override
        public void setObject(int n, Object object, int n2) throws SQLException {
            this.ps.setObject(n, object, n2);
        }

        @Override
        public void setObject(int n, Object object, int n2, int n3) throws SQLException {
            this.ps.setObject(n, object, n2, n3);
        }

        @Override
        public void setObject(int n, Object object) throws SQLException {
            Object object2 = object;
            if (object instanceof String) {
                String string = (String)object;
                if (AbstractDatabaseManager.this.encodingManager != null && string != null && string.length() > 0 && !this.isUnicodeDBField(n)) {
                    object2 = AbstractDatabaseManager.this.encodingManager.adjustUnicodeToDB(string);
                }
            }
            this.ps.setObject(n, object2);
        }

        @Override
        public void setRef(int n, Ref ref) throws SQLException {
            this.ps.setRef(n, ref);
        }

        @Override
        public void setString(int n, String string) throws SQLException {
            String string2 = string;
            if (AbstractDatabaseManager.this.encodingManager != null && string != null && string.length() > 0 && !this.isUnicodeDBField(n)) {
                string2 = AbstractDatabaseManager.this.encodingManager.adjustUnicodeToDB(string);
            }
            this.ps.setString(n, string2);
        }

        private boolean isUnicodeDBField(int n) {
            if (this.unicodeParms.containsKey(new Integer(n))) {
                String string = this.unicodeParms.get(new Integer(n));
                if (string.equals("CMD_STRING")) {
                    try {
                        int n2;
                        if (this.pmd == null) {
                            this.pmd = this.ps.getParameterMetaData();
                        }
                        return (n2 = this.pmd.getPrecision(n)) >= 9000;
                    }
                    catch (Throwable throwable) {
                        logger.error((Object)"Error getting statement parameter data.", throwable);
                    }
                } else {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void setTime(int n, Time time, Calendar calendar) throws SQLException {
            this.ps.setTime(n, time, calendar);
        }

        @Override
        public void setTime(int n, Time time) throws SQLException {
            this.ps.setTime(n, time);
        }

        @Override
        public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
            this.ps.setUnicodeStream(n, inputStream, n2);
        }

        @Override
        public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
            this.ps.setAsciiStream(n, inputStream);
        }

        @Override
        public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
            this.ps.setAsciiStream(n, inputStream, l);
        }

        @Override
        public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
            this.ps.setBinaryStream(n, inputStream);
        }

        @Override
        public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
            this.ps.setBinaryStream(n, inputStream, l);
        }

        @Override
        public void setBlob(int n, InputStream inputStream) throws SQLException {
            this.ps.setBlob(n, inputStream);
        }

        @Override
        public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
            this.ps.setBlob(n, inputStream, l);
        }

        @Override
        public void setCharacterStream(int n, Reader reader) throws SQLException {
            this.ps.setCharacterStream(n, reader);
        }

        @Override
        public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
            this.ps.setCharacterStream(n, reader, l);
        }

        @Override
        public void setClob(int n, Reader reader) throws SQLException {
            this.ps.setClob(n, reader);
        }

        @Override
        public void setClob(int n, Reader reader, long l) throws SQLException {
            this.ps.setClob(n, reader, l);
        }

        @Override
        public void setNCharacterStream(int n, Reader reader) throws SQLException {
            this.ps.setNCharacterStream(n, reader);
        }

        @Override
        public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
            this.ps.setNCharacterStream(n, reader, l);
        }

        @Override
        public void setNClob(int n, NClob nClob) throws SQLException {
            this.ps.setNClob(n, nClob);
        }

        @Override
        public void setNClob(int n, Reader reader) throws SQLException {
            this.ps.setNClob(n, reader);
        }

        @Override
        public void setNClob(int n, Reader reader, long l) throws SQLException {
            this.ps.setNClob(n, reader, l);
        }

        @Override
        public void setNString(int n, String string) throws SQLException {
            this.ps.setNString(n, string);
        }

        @Override
        public void setRowId(int n, RowId rowId) throws SQLException {
            this.ps.setRowId(n, rowId);
        }

        @Override
        public void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
            this.ps.setSQLXML(n, sQLXML);
        }
    }

    class WrappedStatement
    implements Statement {
        Statement stmt;
        ArrayList<WrappedResultSet> resultSetList;
        WrappedConnection wcon;

        WrappedStatement(WrappedConnection wrappedConnection, Statement statement) {
            this.stmt = statement;
            this.wcon = wrappedConnection;
            this.resultSetList = new ArrayList();
        }

        void trackResultSet(WrappedResultSet wrappedResultSet) {
            if (!this.resultSetList.contains(wrappedResultSet)) {
                this.resultSetList.add(wrappedResultSet);
            }
        }

        void resultSetClosed(WrappedResultSet wrappedResultSet) {
            this.resultSetList.remove(wrappedResultSet);
        }

        @Override
        public void close() throws SQLException {
            ResultSet[] resultSetArray = new ResultSet[this.resultSetList.size()];
            this.resultSetList.toArray(resultSetArray);
            for (int i = 0; i < resultSetArray.length; ++i) {
                try {
                    resultSetArray[i].close();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.resultSetList.clear();
            this.stmt.close();
            this.wcon.statementClosed(this);
        }

        @Override
        public boolean execute(String string, String[] stringArray) throws SQLException {
            return this.stmt.execute(string, stringArray);
        }

        @Override
        public boolean execute(String string, int n) throws SQLException {
            return this.stmt.execute(string, n);
        }

        @Override
        public boolean execute(String string) throws SQLException {
            return this.stmt.execute(string);
        }

        @Override
        public boolean execute(String string, int[] nArray) throws SQLException {
            return this.stmt.execute(string, nArray);
        }

        @Override
        public void addBatch(String string) throws SQLException {
            this.stmt.addBatch(string);
        }

        @Override
        public void cancel() throws SQLException {
            this.stmt.cancel();
        }

        @Override
        public void clearBatch() throws SQLException {
            this.stmt.clearBatch();
        }

        @Override
        public void clearWarnings() throws SQLException {
            this.stmt.clearWarnings();
        }

        @Override
        public int[] executeBatch() throws SQLException {
            return this.stmt.executeBatch();
        }

        @Override
        public ResultSet executeQuery(String string) throws SQLException {
            WrappedResultSet wrappedResultSet = new WrappedResultSet(this.wcon, this, this.stmt.executeQuery(string));
            this.trackResultSet(wrappedResultSet);
            return wrappedResultSet;
        }

        @Override
        public int executeUpdate(String string, int[] nArray) throws SQLException {
            return this.stmt.executeUpdate(string, nArray);
        }

        @Override
        public int executeUpdate(String string) throws SQLException {
            return this.stmt.executeUpdate(string);
        }

        @Override
        public int executeUpdate(String string, String[] stringArray) throws SQLException {
            return this.stmt.executeUpdate(string, stringArray);
        }

        @Override
        public int executeUpdate(String string, int n) throws SQLException {
            return this.stmt.executeUpdate(string, n);
        }

        @Override
        public Connection getConnection() throws SQLException {
            return this.wcon;
        }

        @Override
        public int getFetchDirection() throws SQLException {
            return this.stmt.getFetchDirection();
        }

        @Override
        public int getFetchSize() throws SQLException {
            return this.stmt.getFetchSize();
        }

        @Override
        public ResultSet getGeneratedKeys() throws SQLException {
            WrappedResultSet wrappedResultSet = new WrappedResultSet(this.wcon, this, this.stmt.getGeneratedKeys());
            this.trackResultSet(wrappedResultSet);
            return wrappedResultSet;
        }

        @Override
        public int getMaxFieldSize() throws SQLException {
            return this.stmt.getMaxFieldSize();
        }

        @Override
        public int getMaxRows() throws SQLException {
            return this.stmt.getMaxRows();
        }

        @Override
        public boolean getMoreResults() throws SQLException {
            return this.stmt.getMoreResults();
        }

        @Override
        public boolean getMoreResults(int n) throws SQLException {
            return this.stmt.getMoreResults(n);
        }

        @Override
        public int getQueryTimeout() throws SQLException {
            return this.stmt.getQueryTimeout();
        }

        @Override
        public ResultSet getResultSet() throws SQLException {
            WrappedResultSet wrappedResultSet = new WrappedResultSet(this.wcon, this, this.stmt.getResultSet());
            this.trackResultSet(wrappedResultSet);
            return wrappedResultSet;
        }

        @Override
        public int getResultSetConcurrency() throws SQLException {
            return this.stmt.getResultSetConcurrency();
        }

        @Override
        public int getResultSetHoldability() throws SQLException {
            return this.stmt.getResultSetHoldability();
        }

        @Override
        public int getResultSetType() throws SQLException {
            return this.stmt.getResultSetType();
        }

        @Override
        public int getUpdateCount() throws SQLException {
            return this.stmt.getUpdateCount();
        }

        @Override
        public SQLWarning getWarnings() throws SQLException {
            return this.stmt.getWarnings();
        }

        @Override
        public void setCursorName(String string) throws SQLException {
            this.stmt.setCursorName(string);
        }

        @Override
        public void setEscapeProcessing(boolean bl) throws SQLException {
            this.stmt.setEscapeProcessing(bl);
        }

        @Override
        public void setFetchDirection(int n) throws SQLException {
            this.stmt.setFetchDirection(n);
        }

        @Override
        public void setFetchSize(int n) throws SQLException {
            this.stmt.setFetchSize(n);
        }

        @Override
        public void setMaxFieldSize(int n) throws SQLException {
            this.stmt.setMaxFieldSize(n);
        }

        @Override
        public void setMaxRows(int n) throws SQLException {
            this.stmt.setMaxRows(n);
        }

        @Override
        public void setQueryTimeout(int n) throws SQLException {
            this.stmt.setQueryTimeout(n);
        }

        @Override
        public boolean isClosed() throws SQLException {
            return this.stmt.isClosed();
        }

        @Override
        public boolean isPoolable() throws SQLException {
            return this.stmt.isPoolable();
        }

        @Override
        public void setPoolable(boolean bl) throws SQLException {
            this.stmt.setPoolable(bl);
        }

        @Override
        public boolean isWrapperFor(Class<?> clazz) throws SQLException {
            return this.stmt.isWrapperFor(clazz);
        }

        @Override
        public <T> T unwrap(Class<T> clazz) throws SQLException {
            return this.stmt.unwrap(clazz);
        }

        @Override
        public void closeOnCompletion() throws SQLException {
        }

        @Override
        public boolean isCloseOnCompletion() throws SQLException {
            return false;
        }
    }

    public class WrappedConnection
    implements Connection {
        Connection con;
        String poolName1;
        boolean isClosed;
        ArrayList<WrappedStatement> statementList;
        boolean needTimeCorrection;
        String serverJobName = null;
        HashMap<String, PreparedStatement> statementCache = null;

        WrappedConnection(Connection connection, String string) {
            Connection connection2;
            String string2;
            this.con = connection;
            this.poolName1 = string;
            this.statementList = new ArrayList();
            if (connection instanceof PoolableConnection && ((string2 = (connection2 = ((PoolableConnection)this.con).getInnermostDelegate()).getClass().getName().toLowerCase()).indexOf("db2") > -1 || string2.indexOf("as400") > -1)) {
                this.needTimeCorrection = true;
            }
        }

        public String getServerJobName() {
            return this.serverJobName;
        }

        public void setServerJobName(String string) {
            this.serverJobName = string;
        }

        private void trackStatement(WrappedStatement wrappedStatement) {
            if (!this.statementList.contains(wrappedStatement)) {
                this.statementList.add(wrappedStatement);
            }
        }

        void statementClosed(WrappedStatement wrappedStatement) {
            this.statementList.remove(wrappedStatement);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws SQLException {
            if (this.isClosed()) {
                return;
            }
            this.isClosed = true;
            if (this.statementCache != null) {
                for (String string : this.statementCache.keySet()) {
                    try {
                        logger.trace((Object)("Closing cached statement: " + string));
                        PreparedStatement preparedStatement = this.statementCache.get(string);
                        preparedStatement.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            Statement[] statementArray = new Statement[this.statementList.size()];
            this.statementList.toArray(statementArray);
            for (int i = 0; i < statementArray.length; ++i) {
                try {
                    statementArray[i].close();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.statementList.clear();
            if (logger.isTraceEnabled() || AbstractDatabaseManager.this.debugConnectionLeak) {
                Object object = AbstractDatabaseManager.this.lockObject;
                synchronized (object) {
                    this.doClose();
                }
            } else {
                this.doClose();
            }
        }

        private void doClose() throws SQLException {
            SQLException sQLException = null;
            try {
                this.con.close();
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
            }
            if (logger.isTraceEnabled() || AbstractDatabaseManager.this.debugConnectionLeak) {
                AbstractDatabaseManager.this.logCaller(this, "released", false);
            }
            if (sQLException != null) {
                throw sQLException;
            }
        }

        public void reallyClose() throws SQLException {
            if (this.con instanceof PoolableConnection) {
                ((PoolableConnection)this.con).reallyClose();
                this.close();
            }
        }

        private void adjustTimeIfNeeded(java.util.Date date) {
            if (this.needTimeCorrection) {
                LocalizedDate.correctTime((java.util.Date)date);
            }
        }

        public void addCachedStatement(String string, PreparedStatement preparedStatement) {
            if (string == null) {
                throw new RuntimeException("Statement cache key is null.");
            }
            if (preparedStatement == null) {
                throw new RuntimeException("Statement cache statement is null.");
            }
            if (this.statementCache == null) {
                this.statementCache = new HashMap();
            }
            if (this.statementCache.containsKey(string)) {
                throw new RuntimeException("Statement cache already contains: " + string);
            }
            this.statementCache.put(string, preparedStatement);
        }

        public PreparedStatement getCachedStatement(String string) {
            if (string == null) {
                throw new RuntimeException("Statement cache request key is null.");
            }
            if (this.statementCache == null) {
                return null;
            }
            return this.statementCache.get(string);
        }

        @Override
        public void setReadOnly(boolean bl) throws SQLException {
            this.con.setReadOnly(bl);
        }

        @Override
        public boolean isReadOnly() throws SQLException {
            return this.con.isReadOnly();
        }

        @Override
        public void clearWarnings() throws SQLException {
            this.con.clearWarnings();
        }

        @Override
        public void commit() throws SQLException {
            this.con.commit();
        }

        @Override
        public Statement createStatement(int n, int n2) throws SQLException {
            WrappedStatement wrappedStatement = new WrappedStatement(this, this.con.createStatement(n, n2));
            this.trackStatement(wrappedStatement);
            return wrappedStatement;
        }

        @Override
        public Statement createStatement(int n, int n2, int n3) throws SQLException {
            WrappedStatement wrappedStatement = new WrappedStatement(this, this.con.createStatement(n, n2, n3));
            this.trackStatement(wrappedStatement);
            return wrappedStatement;
        }

        @Override
        public Statement createStatement() throws SQLException {
            WrappedStatement wrappedStatement = new WrappedStatement(this, this.con.createStatement());
            this.trackStatement(wrappedStatement);
            return wrappedStatement;
        }

        @Override
        public boolean getAutoCommit() throws SQLException {
            return this.con.getAutoCommit();
        }

        @Override
        public String getCatalog() throws SQLException {
            return this.con.getCatalog();
        }

        @Override
        public int getHoldability() throws SQLException {
            return this.con.getHoldability();
        }

        @Override
        public DatabaseMetaData getMetaData() throws SQLException {
            return this.con.getMetaData();
        }

        @Override
        public int getTransactionIsolation() throws SQLException {
            return this.con.getTransactionIsolation();
        }

        @Override
        public Map<String, Class<?>> getTypeMap() throws SQLException {
            return this.con.getTypeMap();
        }

        @Override
        public SQLWarning getWarnings() throws SQLException {
            return this.con.getWarnings();
        }

        @Override
        public boolean isClosed() throws SQLException {
            return this.isClosed;
        }

        @Override
        public String nativeSQL(String string) throws SQLException {
            return this.con.nativeSQL(string);
        }

        @Override
        public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
            WrappedCallableStatement wrappedCallableStatement = new WrappedCallableStatement(this, this.con.prepareCall(string, n, n2, n3));
            this.trackStatement(wrappedCallableStatement);
            return wrappedCallableStatement;
        }

        @Override
        public CallableStatement prepareCall(String string) throws SQLException {
            WrappedCallableStatement wrappedCallableStatement = new WrappedCallableStatement(this, this.con.prepareCall(string));
            this.trackStatement(wrappedCallableStatement);
            return wrappedCallableStatement;
        }

        @Override
        public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
            WrappedCallableStatement wrappedCallableStatement = new WrappedCallableStatement(this, this.con.prepareCall(string, n, n2));
            this.trackStatement(wrappedCallableStatement);
            return wrappedCallableStatement;
        }

        @Override
        public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
            WrappedPreparedStatement wrappedPreparedStatement = new WrappedPreparedStatement(this, this.con.prepareStatement(string, nArray));
            this.trackStatement(wrappedPreparedStatement);
            return wrappedPreparedStatement;
        }

        @Override
        public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
            WrappedPreparedStatement wrappedPreparedStatement = new WrappedPreparedStatement(this, this.con.prepareStatement(string, n, n2, n3));
            this.trackStatement(wrappedPreparedStatement);
            return wrappedPreparedStatement;
        }

        @Override
        public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
            WrappedPreparedStatement wrappedPreparedStatement = new WrappedPreparedStatement(this, this.con.prepareStatement(string, n, n2));
            this.trackStatement(wrappedPreparedStatement);
            return wrappedPreparedStatement;
        }

        @Override
        public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
            WrappedPreparedStatement wrappedPreparedStatement = new WrappedPreparedStatement(this, this.con.prepareStatement(string, stringArray));
            this.trackStatement(wrappedPreparedStatement);
            return wrappedPreparedStatement;
        }

        @Override
        public PreparedStatement prepareStatement(String string) throws SQLException {
            WrappedPreparedStatement wrappedPreparedStatement = new WrappedPreparedStatement(this, this.con.prepareStatement(string));
            this.trackStatement(wrappedPreparedStatement);
            return wrappedPreparedStatement;
        }

        @Override
        public PreparedStatement prepareStatement(String string, int n) throws SQLException {
            WrappedPreparedStatement wrappedPreparedStatement = new WrappedPreparedStatement(this, this.con.prepareStatement(string, n));
            this.trackStatement(wrappedPreparedStatement);
            return wrappedPreparedStatement;
        }

        @Override
        public void releaseSavepoint(Savepoint savepoint) throws SQLException {
            this.con.releaseSavepoint(savepoint);
        }

        @Override
        public void rollback() throws SQLException {
            this.con.rollback();
        }

        @Override
        public void rollback(Savepoint savepoint) throws SQLException {
            this.con.rollback(savepoint);
        }

        @Override
        public void setAutoCommit(boolean bl) throws SQLException {
            this.con.setAutoCommit(bl);
        }

        @Override
        public void setCatalog(String string) throws SQLException {
            this.con.setCatalog(string);
        }

        @Override
        public void setHoldability(int n) throws SQLException {
            this.con.setHoldability(n);
        }

        @Override
        public Savepoint setSavepoint() throws SQLException {
            return this.con.setSavepoint();
        }

        @Override
        public Savepoint setSavepoint(String string) throws SQLException {
            return this.con.setSavepoint(string);
        }

        @Override
        public void setTransactionIsolation(int n) throws SQLException {
            this.con.setTransactionIsolation(n);
        }

        @Override
        public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
            this.con.setTypeMap(map);
        }

        @Override
        public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
            return this.con.createArrayOf(string, objectArray);
        }

        @Override
        public Blob createBlob() throws SQLException {
            return this.con.createBlob();
        }

        @Override
        public Clob createClob() throws SQLException {
            return this.con.createClob();
        }

        @Override
        public NClob createNClob() throws SQLException {
            return this.con.createNClob();
        }

        @Override
        public SQLXML createSQLXML() throws SQLException {
            return this.con.createSQLXML();
        }

        @Override
        public Struct createStruct(String string, Object[] objectArray) throws SQLException {
            return this.con.createStruct(string, objectArray);
        }

        @Override
        public Properties getClientInfo() throws SQLException {
            return this.con.getClientInfo();
        }

        @Override
        public String getClientInfo(String string) throws SQLException {
            return this.con.getClientInfo(string);
        }

        @Override
        public boolean isValid(int n) throws SQLException {
            return this.con.isValid(n);
        }

        @Override
        public void setClientInfo(Properties properties) throws SQLClientInfoException {
            this.con.setClientInfo(properties);
        }

        @Override
        public void setClientInfo(String string, String string2) throws SQLClientInfoException {
            this.con.setClientInfo(string, string2);
        }

        @Override
        public boolean isWrapperFor(Class<?> clazz) throws SQLException {
            return this.con.isWrapperFor(clazz);
        }

        @Override
        public <T> T unwrap(Class<T> clazz) throws SQLException {
            return this.con.unwrap(clazz);
        }

        @Override
        public void abort(Executor executor) throws SQLException {
        }

        @Override
        public int getNetworkTimeout() throws SQLException {
            return 0;
        }

        @Override
        public String getSchema() throws SQLException {
            return null;
        }

        @Override
        public void setNetworkTimeout(Executor executor, int n) throws SQLException {
        }

        @Override
        public void setSchema(String string) throws SQLException {
        }
    }
}

