/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.reader;

import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.FileLogInfoData;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.HelperLib;
import com.sap.tc.logging.ListFormatter;
import com.sap.tc.logging.LogEvents;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.exceptions.CloseException;
import com.sap.tc.logging.exceptions.DataException;
import com.sap.tc.logging.exceptions.FileCloseException;
import com.sap.tc.logging.exceptions.FileDataException;
import com.sap.tc.logging.exceptions.FileOpenException;
import com.sap.tc.logging.exceptions.LoggingBaseException;
import com.sap.tc.logging.exceptions.OpenException;
import com.sap.tc.logging.interfaces.IFilter;
import com.sap.tc.logging.interfaces.ILoggingResultSet;
import com.sap.tc.logging.interfaces.IMessageBuilder;
import com.sap.tc.logging.messagedepot.MessageAccessor;
import com.sap.tc.logging.reader.LocalBuffer;
import com.sap.tc.logging.reader.LogRecordResultSet;
import com.sap.tc.logging.reader.ReadFileSetLog;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;

public final class FileReadLog
extends ReadFileSetLog {
    private static String strLoc = "FileReadLog";
    private int fileHeaderSize;
    private int fileFooterSize;
    private int latestDirection;
    private LocalBuffer buffData;
    private MessageAccessor msgAccessor;
    private LogEvents logEvents;

    public FileReadLog(String fileName) throws FileDataException {
        this(fileName, null);
    }

    public FileReadLog(String fileName, MessageAccessor accessor) throws FileDataException {
        super(fileName);
        this.msgAccessor = accessor;
    }

    public FileReadLog(String fileName, int size, int limit) throws FileDataException {
        this(fileName, null, size, limit);
    }

    public FileReadLog(String fileName, MessageAccessor accessor, int size, int limit) throws FileDataException {
        super(fileName, size, limit);
        if (fileName == null) {
            throw new NullPointerException();
        }
        this.msgAccessor = accessor;
    }

    public FileReadLog(FileLog fileLog) {
        this(fileLog, null);
    }

    public FileReadLog(FileLog fileLog, MessageAccessor accessor) {
        super(fileLog.getPattern(), fileLog.getCnt(), fileLog.getLimit());
        if (fileLog == null) {
            throw new NullPointerException();
        }
        this.msgAccessor = accessor;
    }

    public void registerForLogEvents(LogEvents logEvents) {
        this.logEvents = logEvents;
    }

    public boolean isBOF() throws DataException {
        String rbSource = this.getSource();
        boolean result = true;
        try {
            result = this.isBOFInt();
            if (result && this.isInFileSet()) {
                this.previous();
                if (!rbSource.equalsIgnoreCase(this.getSource()) && new File(this.getSource()).exists()) {
                    this.closeInt();
                    this.openInt();
                    this.buffData.moveToEOF();
                    result = this.isBOFInt();
                }
            }
        }
        catch (Exception ex) {
            this.setSource(rbSource);
            throw new FileDataException(this.getSource(), ex);
        }
        return result;
    }

    public boolean isEndOfCurrentFile() throws DataException {
        String rbSource = this.getSource();
        try {
            return this.isEOFInt();
        }
        catch (Exception ex) {
            this.setSource(rbSource);
            throw new FileDataException(this.getSource(), ex);
        }
    }

    public boolean isBeginningOfCurrentFile() throws DataException {
        String rbSource = this.getSource();
        try {
            return this.isBOFInt();
        }
        catch (Exception ex) {
            this.setSource(rbSource);
            throw new FileDataException(this.getSource(), ex);
        }
    }

    public boolean isEOF() throws DataException {
        String rbSource = this.getSource();
        boolean result = true;
        try {
            result = this.isEOFInt();
            if (result && this.isInFileSet()) {
                this.next();
                if (!rbSource.equalsIgnoreCase(this.getSource()) && new File(this.getSource()).exists()) {
                    this.closeInt();
                    this.openInt();
                    result = this.isEOFInt();
                }
            }
        }
        catch (Exception ex) {
            this.setSource(rbSource);
            throw new FileDataException(this.getSource(), ex);
        }
        return result;
    }

    public void moveToBOF() throws DataException {
        String rbSource = this.getSource();
        try {
            if (this.isInFileSet()) {
                this.moveToBOFS();
                if (!rbSource.equalsIgnoreCase(this.getSource())) {
                    this.closeInt();
                    this.setSource(this.getSource());
                    this.openInt();
                }
            }
            if (this.buffData != null) {
                this.buffData.moveToBOF();
            }
        }
        catch (Exception ex) {
            this.setSource(rbSource);
            throw new FileDataException(this.getSource(), ex);
        }
    }

    void moveToBeginningOfCurrentFile() throws DataException {
        String rbSource = this.getSource();
        try {
            if (this.buffData != null) {
                this.buffData.moveToBOF();
            }
        }
        catch (Exception ex) {
            this.setSource(rbSource);
            throw new FileDataException(this.getSource(), ex);
        }
    }

    void moveToEndOfCurrentFile() throws DataException {
        String rbSource = this.getSource();
        try {
            if (this.buffData != null) {
                this.buffData.moveToEOF();
            }
        }
        catch (Exception ex) {
            this.setSource(rbSource);
            throw new FileDataException(this.getSource(), ex);
        }
    }

    public void moveToEOF() throws DataException {
        String rbSource = this.getSource();
        try {
            if (this.isInFileSet()) {
                this.moveToEOFS();
                if (!rbSource.equalsIgnoreCase(this.getSource())) {
                    this.closeInt();
                    this.setSource(this.getSource());
                    this.openInt();
                }
            }
            if (this.buffData != null) {
                this.buffData.moveToEOF();
            }
        }
        catch (Exception ex) {
            this.setSource(rbSource);
            throw new FileDataException(this.getSource(), ex);
        }
    }

    public ILoggingResultSet readNext(int numberOfRecords) throws DataException {
        if (numberOfRecords < 0) {
            numberOfRecords = 0;
        }
        LogRecordResultSet resultSet = new LogRecordResultSet();
        IFilter fileFilter = this.getFilter(0);
        boolean readContinue = true;
        try {
            this.openInt();
            if (!this.isEOF()) {
                block2: for (int i = 0; i < numberOfRecords; ++i) {
                    if (this.isEOF()) {
                        return resultSet;
                    }
                    do {
                        IMessageBuilder msgBuilder = this.buffData.readNext();
                        byte[] result = msgBuilder.message();
                        if (fileFilter != null && fileFilter.isFilterEnabled()) {
                            readContinue = fileFilter.beRead(result);
                        }
                        if (!readContinue) continue;
                        LogRecord lr = this.getFormatter().parseMsg(msgBuilder);
                        if (lr == null) continue block2;
                        lr.setBookMark(msgBuilder.getBookMarkBOL());
                        resultSet.add(lr);
                    } while (!readContinue && !this.isEOF());
                }
            } else {
                this.moveToEOF();
            }
        }
        catch (Exception ex) {
            throw new FileDataException(this.getSource(), ex);
        }
        return resultSet;
    }

    public ILoggingResultSet readPrevious(int numberOfRecords) throws DataException {
        if (numberOfRecords < 0) {
            numberOfRecords = 0;
        }
        LogRecordResultSet resultSet = new LogRecordResultSet();
        IFilter fileFilter = this.getFilter(0);
        boolean readContinue = true;
        try {
            this.openInt();
            if (!this.isBOF()) {
                block3: for (int i = 0; i < numberOfRecords; ++i) {
                    if (this.isBOF()) {
                        return resultSet;
                    }
                    do {
                        IMessageBuilder msgBuilder = this.buffData.readPrevious();
                        byte[] result = msgBuilder.message();
                        if (fileFilter != null && fileFilter.isFilterEnabled()) {
                            readContinue = fileFilter.beRead(result);
                        }
                        if (!readContinue) continue;
                        LogRecord lr = this.getFormatter().parseMsg(msgBuilder);
                        if (lr == null) continue block3;
                        lr.setBookMark(msgBuilder.getBookMarkBOL());
                        resultSet.add(lr);
                    } while (!readContinue && !this.isBOF());
                }
            } else {
                this.moveToBOF();
            }
        }
        catch (LoggingBaseException ex) {
            resultSet.setStatus(-1);
            resultSet.setException(ex);
        }
        catch (Exception ex) {
            resultSet.setStatus(-1);
            resultSet.setException(new FileDataException(this.getSource(), ex));
        }
        return resultSet;
    }

    public boolean isPartOfFileSet() {
        return this.isInFileSet();
    }

    public void seek(long filePointer) throws DataException {
        try {
            this.buffData.seek(filePointer);
        }
        catch (IOException ex) {
            throw new FileDataException(this.getSource(), ex);
        }
    }

    public long find(String condition) throws DataException {
        int operaterID = 0;
        String operater = null;
        for (int i = 0; i < condition.length(); ++i) {
            operater = condition.substring(i, i + 1);
            operaterID = HelperLib.parseOperator(operater);
            if (operaterID <= 0 || i + 1 >= condition.length()) continue;
            String multiOperater = condition.substring(i, i + 2);
            int multiOperaterID = HelperLib.parseOperator(multiOperater);
            if (multiOperaterID <= 0) break;
            operaterID = multiOperaterID;
            operater = multiOperater;
            break;
        }
        if (operaterID < 0) {
            return -1L;
        }
        int endFieldNamePos = condition.indexOf(operater);
        if (!(this.getFormatter() instanceof ListFormatter)) {
            return -1L;
        }
        int fieldIndex = 0;
        String fieldName = condition.substring(0, endFieldNamePos).trim();
        if (!ListFormatter.getFields().containsKey(fieldName)) {
            return -1L;
        }
        fieldIndex = (Integer)ListFormatter.getFields().get(fieldName);
        String compareStr = condition.substring(endFieldNamePos + operater.length());
        while (!this.isEOF()) {
            String filedStr;
            IMessageBuilder msgByte = this.buffData.readNext();
            byte[] msgChunk = msgByte.message();
            int delimiterSize = msgByte.getDelimiter().size();
            int[] delimiter = new int[delimiterSize];
            msgByte.reset();
            if (msgChunk == null || msgChunk.length == 0) continue;
            int startFieldPos = delimiter[fieldIndex];
            int endFieldPos = 0;
            if (fieldIndex + 1 < delimiterSize) {
                endFieldPos = delimiter[fieldIndex + 1];
            }
            if (endFieldPos == 0) {
                endFieldPos = msgChunk.length;
            }
            if (!ListFormatter.compareField(fieldIndex, operaterID, (filedStr = new String(msgChunk, startFieldPos, endFieldPos = endFieldPos - startFieldPos - 1)).trim(), compareStr.trim())) continue;
            return this.getBookMark();
        }
        return -1L;
    }

    public ILoggingResultSet search(String condition) throws DataException {
        return null;
    }

    public synchronized void setFormatter(Formatter formatter) {
        super.setFormatter(formatter);
        this.getFormatter().setMessageAccessor(this.msgAccessor);
    }

    protected void openInt() throws OpenException {
        if (this.isClosed() && this.buffData == null) {
            try {
                this.loadDataFromFileHeader(new FileLogInfoData(this.getSource()));
                IMessageBuilder msgBuilder = this.getFormatter().getMessageBuilder();
                msgBuilder.setEncoding(this.getEncoding());
                this.buffData = new LocalBuffer(this.getSource(), msgBuilder);
                this.buffData.setFileHeaderSize(this.fileHeaderSize);
                this.buffData.setFileFooterSize(this.fileFooterSize);
                if (this.logEvents != null) {
                    this.logEvents.eventLogIsOpen(this);
                }
                this.setStatus(2);
            }
            catch (OpenException ex) {
                this.buffData = null;
                throw ex;
            }
            catch (Exception ex) {
                this.buffData = null;
                throw new FileOpenException(this.getSource(), ex);
            }
        }
    }

    protected void closeInt() throws CloseException {
        if (this.isOpened() && this.buffData != null) {
            try {
                this.buffData.close();
                this.setStatus(1);
                if (this.logEvents != null) {
                    this.logEvents.eventLogIsClosed(this);
                }
            }
            catch (IOException ex) {
                throw new FileCloseException(this.getSource(), ex);
            }
            finally {
                this.buffData = null;
            }
        }
    }

    public ILoggingResultSet searchNext(String[] searchTokens, boolean isCaseSensitive) throws DataException {
        LogRecordResultSet resultSet = new LogRecordResultSet();
        if (searchTokens == null || searchTokens.length == 0) {
            return resultSet;
        }
        this.moveToBOF();
        String token = null;
        try {
            this.openInt();
            while (!this.isEOF()) {
                byte[] resultChunk = this.buffData.readNext().message();
                String resultStr = new String(resultChunk);
                if (!isCaseSensitive) {
                    resultStr = resultStr.toUpperCase();
                }
                for (int i = 0; i < searchTokens.length; ++i) {
                    token = searchTokens[i];
                    if (!isCaseSensitive) {
                        token = token.toUpperCase();
                    }
                    if (resultStr.indexOf(token) <= 0) continue;
                    LogRecord lr = this.getFormatter().parseMsg(resultChunk);
                    if (lr != null) {
                        resultSet.add(lr);
                        continue;
                    }
                    throw new FileDataException(this.getSource(), new ParseException("Parsing error...", 0));
                }
            }
        }
        catch (DataException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new FileDataException(this.getSource(), ex);
        }
        return resultSet;
    }

    protected void setBookMarkInt(long value) throws DataException {
        try {
            this.buffData.setBookMark(value);
        }
        catch (IOException ex) {
            throw new FileDataException(this.getSource(), ex);
        }
    }

    protected long getBookMarkInt() throws DataException {
        return this.buffData.getBookMark();
    }

    private void loadDataFromFileHeader(FileLogInfoData fileHeader) {
        if (fileHeader.getHeader() != null && fileHeader.getHeader().length() > 0) {
            this.setName(fileHeader.getName());
            this.setDescription(fileHeader.getDescription());
            this.setFormatter(fileHeader.getFormatter());
            this.setEncoding(fileHeader.getEncoding());
            this.setHeader(fileHeader.getHeader());
            this.setFooter(fileHeader.getFooter());
            this.fileHeaderSize = fileHeader.getFileHeaderSize();
            this.fileFooterSize = this.getFooter().length();
        } else {
            this.setName(fileHeader.getFileName());
        }
    }

    private boolean isBOFInt() throws IOException {
        if (this.buffData == null) {
            return true;
        }
        return this.buffData.isBOF();
    }

    private boolean isEOFInt() throws IOException {
        if (this.buffData == null) {
            return true;
        }
        return this.buffData.isEOF();
    }
}

