/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine;

public abstract class RfcUtilities {
    private static final int KT_ENTRIES = 64;
    private static final byte[] kt = new byte[]{-16, -19, 83, -72, 50, 68, -15, -8, 118, -58, 121, 89, -3, 79, 19, -94, -63, 81, -107, -20, 84, -125, -62, 52, 119, 73, 67, -94, 125, -30, 101, -106, 94, 83, -104, 120, -102, 23, -93, 60, -45, -125, -88, -72, 41, -5, -36, -91, 85, -41, 2, 119, -124, 19, -84, -35, -7, -72, 49, 22, 97, 14, 109, -6};
    public static final int KT_MASK = 63;
    private static byte[][] order = new byte[][]{{0, 1, 2, 3, 4, 5, 6, 7}, {1, 0, 3, 2, 5, 4, 7, 6}, {2, 3, 0, 1, 6, 7, 4, 5}, {3, 2, 1, 0, 7, 6, 5, 4}, {4, 5, 6, 7, 0, 1, 2, 3}, {5, 4, 7, 6, 1, 0, 3, 2}, {6, 7, 4, 5, 2, 3, 0, 1}, {7, 6, 5, 4, 3, 2, 1, 0}};

    public static byte[] STCM15(int val) {
        byte[] x = new byte[]{(byte)(val >> 24 & 0xFF), (byte)(val >> 16 & 0xFF), (byte)(val >> 8 & 0xFF), (byte)(val & 0xFF)};
        return x;
    }

    public static byte[] STCM03(int val) {
        byte[] x = new byte[]{(byte)(val >> 8 & 0xFF), (byte)(val & 0xFF)};
        return x;
    }

    public static int ICM03(byte[] x) {
        int res = x[0] << 8 | x[1] & 0xFF;
        return 0xFFFF & res;
    }

    public static int ICM15(byte[] x) {
        int res = 0;
        res = x[0] << 24 | (x[1] & 0xFF) << 16 | (x[2] & 0xFF) << 8 | x[3] & 0xFF;
        return 0xFFFFFFFF & res;
    }

    public static int ICM15(byte[] x, int offset) {
        int res = 0;
        res = x[0 + offset] << 24 | (x[1 + offset] & 0xFF) << 16 | (x[2 + offset] & 0xFF) << 8 | x[3 + offset] & 0xFF;
        return 0xFFFFFFFF & res;
    }

    public static int memcmp(byte[] lvalue, int offset_lvalue, byte[] rvalue, int offset_rvalue, int leng) {
        int i = 0;
        if (leng > lvalue.length + offset_lvalue || leng > rvalue.length + offset_rvalue) {
            return 1;
        }
        for (i = 0; i < leng; ++i) {
            if (lvalue[i + offset_lvalue] == rvalue[i + offset_rvalue]) continue;
            return 1;
        }
        return 0;
    }

    public static void ab_scramble(byte[] data, int dlen, long key) {
        long kti = key ^ key >>> 5 ^ key << 1;
        kti &= 0x3FL;
        int i = 0;
        while (i < dlen) {
            short keyvalue = (short)(kt[(int)kti] & 0xFF);
            keyvalue = (short)((long)keyvalue ^ key * (long)i * (long)i - (long)i & 0xFFL);
            int n = i++;
            data[n] = (byte)(data[n] ^ keyvalue);
            ++kti;
            kti &= 0x3FL;
        }
    }

    public static double ab_ieeetofl(byte[] src) {
        byte[] dest = new byte[8];
        for (int i = 0; i < 8; ++i) {
            dest[RfcUtilities.order[0][i]] = src[i];
        }
        long tmp = (dest[0] & 0xFF) << 56 | (dest[1] & 0xFF) << 48 | (dest[2] & 0xFF) << 40 | (dest[3] & 0xFF) << 32 | (dest[4] & 0xFF) << 24 | (dest[5] & 0xFF) << 16 | (dest[6] & 0xFF) << 8 | dest[7] & 0xFF;
        return Double.longBitsToDouble(tmp);
    }
}

