/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunctionUnitState;
import com.sap.conn.jco.JCoRepository;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.JCoUnitIdentifier;
import com.sap.conn.jco.monitor.JCoDestinationMonitor;
import com.sap.conn.jco.rt.AbapFunction;
import com.sap.conn.jco.rt.AbapFunctionTemplate;
import com.sap.conn.jco.rt.AbapFunctionUnit;
import com.sap.conn.jco.rt.BasicRepository;
import com.sap.conn.jco.rt.ClientConnection;
import com.sap.conn.jco.rt.ClientFactory;
import com.sap.conn.jco.rt.ConnectionAttributes;
import com.sap.conn.jco.rt.ConnectionManager;
import com.sap.conn.jco.rt.Context;
import com.sap.conn.jco.rt.DefaultDestinationManager;
import com.sap.conn.jco.rt.InternalDestination;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.JCoRuntimeFactory;
import com.sap.conn.jco.rt.RfcCustomDestination;
import com.sap.conn.jco.rt.RfcDestinationMonitor;
import com.sap.conn.jco.rt.StaticFunctionTemplates;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.jco.util.Codecs;
import com.sap.conn.jco.util.FastStringBuffer;
import java.util.ArrayList;
import java.util.Properties;

public class RfcDestination
extends InternalDestination
implements JCoDestination,
Cloneable {
    static final long serialVersionUID = 3000120080918L;
    private static JCoRuntime runtime = JCoRuntimeFactory.getRuntime();
    protected String name;
    private String destinationId = null;
    private String destinationRepositoryId = null;
    protected boolean isInitialized = false;
    protected Properties properties = null;
    protected ConnectionAttributes attributes = null;
    protected transient BasicRepository repository = null;
    protected int peakLimit;
    protected int capacity = 0;
    protected long maxGetClientTime = 30000L;
    protected long expirationTime = 60000L;
    protected long expirationCheckPeriod = 60000L;
    String scopeType = null;
    RfcDestination parentDestination = null;
    InternalDestination repositoryDestination = null;
    boolean withCurrentUser = false;
    volatile ArrayList<RfcDestination> scopeList = null;
    private ConfigurationState state = ConfigurationState.VALID;
    private transient RfcDestinationMonitor monitor = null;
    private transient RfcDestinationMonitor repMonitor = null;
    transient Object mutex = new Object();

    protected RfcDestination(String name, Properties properties, String propertiesProvider) {
        this.name = name;
        this.setProperties(properties, propertiesProvider);
        this.parentDestination = this;
        if (Trace.isOn(32)) {
            Trace.fireTrace(32, "[JCoAPI] create destination with:" + this.getProperties().toString());
        }
    }

    protected RfcDestination(String name, Properties properties, String propertiesProvider, RfcDestination parent) {
        this.name = name;
        this.setProperties(properties, propertiesProvider);
        this.parentDestination = parent;
        if (Trace.isOn(32)) {
            Trace.fireTrace(32, "[JCoAPI] create custom destination with:" + this.getProperties().toString());
        }
    }

    final void setProperties(Properties properties, String propertiesProvider) {
        this.properties = properties;
        this.expirationCheckPeriod = RfcDestination.getLongProperty(properties, "jco.destination.expiration_check_period", this.expirationCheckPeriod);
        this.expirationTime = RfcDestination.getLongProperty(properties, "jco.destination.expiration_time", this.expirationTime);
        this.maxGetClientTime = RfcDestination.getLongProperty(properties, "jco.destination.max_get_client_time", this.maxGetClientTime);
        this.capacity = RfcDestination.getIntProperty(properties, "jco.destination.pool_capacity", this.capacity);
        this.peakLimit = RfcDestination.getIntProperty(properties, "jco.destination.peak_limit", this.capacity);
        if (this.peakLimit == 0) {
            this.peakLimit = Integer.MAX_VALUE;
        }
        this.properties.setProperty("jco.client.destination", this.name);
        this.properties.setProperty("propertiesProvider", propertiesProvider);
        this.withCurrentUser = "CURRENT_USER".equals(properties.get("jco.destination.auth_type"));
    }

    public RfcDestination clone() {
        try {
            RfcDestination clonedDestination = (RfcDestination)super.clone();
            clonedDestination.scopeList = null;
            return clonedDestination;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public String getDestinationName() {
        return this.name;
    }

    public char getType() {
        String typeString = this.properties.getProperty("jco.client.type");
        if (typeString != null) {
            typeString = typeString.trim();
        }
        return typeString == null || typeString.length() == 0 ? (char)'3' : typeString.charAt(0);
    }

    public String getSAPRouterString() {
        return this.properties.getProperty("jco.client.saprouter");
    }

    public String getApplicationServerHost() {
        return this.properties.getProperty("jco.client.ashost");
    }

    public String getGatewayHost() {
        return this.properties.getProperty("jco.client.gwhost");
    }

    public String getGatewayService() {
        return this.properties.getProperty("jco.client.gwserv");
    }

    public String getSystemNumber() {
        return this.properties.getProperty("jco.client.sysnr");
    }

    public String getLogonGroup() {
        return this.properties.getProperty("jco.client.group");
    }

    public String getMessageServerHost() {
        return this.properties.getProperty("jco.client.mshost");
    }

    public String getMessageServerService() {
        return this.properties.getProperty("jco.client.msserv");
    }

    public String getR3Name() {
        return this.properties.getProperty("jco.client.r3name");
    }

    public String getTPHost() {
        return this.properties.getProperty("jco.client.tphost");
    }

    public String getTPName() {
        return this.properties.getProperty("jco.client.tpname");
    }

    public String getSncLibrary() {
        return this.properties.getProperty("jco.client.snc_lib");
    }

    public String getSncMode() {
        return this.properties.getProperty("jco.client.snc_mode");
    }

    public String getSncMyName() {
        return this.properties.getProperty("jco.client.snc_myname");
    }

    public String getSncPartnerName() {
        return this.properties.getProperty("jco.client.snc_partnername");
    }

    public String getSncQOP() {
        return this.properties.getProperty("jco.client.snc_qop");
    }

    public String getAliasUser() {
        return this.properties.getProperty("jco.client.alias_user");
    }

    public String getClient() {
        return this.properties.getProperty("jco.client.client");
    }

    public String getLanguage() {
        return this.properties.getProperty("jco.client.lang");
    }

    public String getUser() {
        return this.properties.getProperty("jco.client.user");
    }

    public String getRepositoryUser() {
        String repositoryUser = this.properties.getProperty("jco.destination.repository.user");
        return repositoryUser != null ? repositoryUser : this.properties.getProperty("jco.client.user");
    }

    public String getLogonCheck() {
        return this.properties.getProperty("jco.client.lcheck");
    }

    String getSSOTicket() {
        return this.properties.getProperty("jco.client.mysapsso2");
    }

    public void setSSOTicket(String base64CodedSSOTicket) {
        this.checkState();
        if (base64CodedSSOTicket == null) {
            this.properties.remove("jco.client.mysapsso2");
        } else {
            this.properties.setProperty("jco.client.mysapsso2", base64CodedSSOTicket);
        }
    }

    public boolean usesSSOTicket() {
        return this.properties.getProperty("jco.client.mysapsso2") != null;
    }

    String getX509Certificate() {
        return this.properties.getProperty("jco.client.x509cert");
    }

    public boolean usesX509Certificate() {
        return this.properties.getProperty("jco.client.x509cert") != null;
    }

    public long getExpirationCheckPeriod() {
        return this.expirationCheckPeriod;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public long getMaxGetClientTime() {
        return this.maxGetClientTime;
    }

    public int getPeakLimit() {
        return this.peakLimit;
    }

    public int getPoolCapacity() {
        return this.capacity;
    }

    public ConnectionAttributes getAttributes() throws JCoException {
        if (this.attributes == null) {
            this.initialize();
        }
        if (this.attributes.getPartnerRelease() == null && "0".equals(this.getLogonCheck())) {
            this.isInitialized = false;
            ConnectionAttributes returnAttributes = this.attributes;
            this.attributes = null;
            return returnAttributes;
        }
        return this.attributes;
    }

    private void toUpper(StringBuilder buffer, String data) {
        int strlen = data.length();
        for (int i = 0; i < strlen; ++i) {
            buffer.append(Character.toUpperCase(data.charAt(i)));
        }
    }

    private String createDestinationID() throws JCoRuntimeException {
        boolean isUserDefined = false;
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(this.getDestinationName());
        buffer.append(this.withCurrentUser ? "|CURRENT_USER" : "|CONFIGURED_USER");
        String tmp = this.getClient();
        if (tmp != null) {
            buffer.append('&').append(tmp);
        }
        if ((tmp = this.getUser()) != null) {
            buffer.append('|');
            this.toUpper(buffer, tmp);
            isUserDefined = true;
        }
        if ((tmp = this.getLanguage()) != null) {
            buffer.append('|');
            this.toUpper(buffer, tmp);
        }
        if ((tmp = this.getAliasUser()) != null) {
            buffer.append('|').append(tmp);
            isUserDefined = true;
        }
        if ((tmp = this.properties.getProperty("jco.client.passwd")) != null) {
            buffer.append('|').append(Codecs.MD5.getMD5HashAsString(tmp));
        }
        if (!isUserDefined && this.getType() != 'E') {
            tmp = this.properties.getProperty("jco.destination.user_id");
            if (tmp == null) {
                tmp = DefaultDestinationManager.getUserId(this.name, this.properties, false);
            }
            if (tmp != null) {
                buffer.append('|').append(tmp);
            }
        }
        if ("1".equals(tmp = this.properties.getProperty("jco.client.trace"))) {
            buffer.append("|TRC").append(tmp);
        }
        if ((tmp = this.properties.getProperty("jco.client.use_sapgui")) != null && (tmp.equals("1") || tmp.equals("2"))) {
            buffer.append("|GUI").append(tmp);
        }
        if ("1".equals(tmp = this.properties.getProperty("jco.client.abap_debug"))) {
            buffer.append("|DEBUG");
        }
        String id = buffer.toString();
        return id;
    }

    private String createDestinationRepositoryID() {
        StringBuilder buffer = new StringBuilder(64);
        buffer.append(this.getDestinationName());
        String tmp = this.getClient();
        if (tmp != null) {
            buffer.append('&').append(tmp);
            tmp = this.getRepositoryUser();
            if (tmp != null) {
                buffer.append('|');
                this.toUpper(buffer, tmp);
            }
            if ((tmp = this.getLanguage()) != null) {
                buffer.append('|');
                this.toUpper(buffer, tmp);
            }
        }
        buffer.append("&R");
        String id = buffer.toString();
        return id;
    }

    public String getDestinationID() {
        if (this.destinationId == null) {
            this.destinationId = this.createDestinationID();
        }
        return this.destinationId;
    }

    String getRepositoryKey() {
        if (this.destinationRepositoryId == null) {
            this.destinationRepositoryId = this.createDestinationRepositoryID();
        }
        return this.destinationRepositoryId;
    }

    public String getOriginDestinationID(boolean repositoryFactory) {
        if (this.parentDestination != null) {
            return repositoryFactory ? this.parentDestination.getRepositoryKey() : this.parentDestination.getDestinationID();
        }
        return null;
    }

    String getScopeType() {
        return this.scopeType;
    }

    protected void initialize() throws JCoException {
        String userId;
        if (this.isInitialized) {
            return;
        }
        if (this.getType() != 'E' && this.properties.getProperty("jco.destination.user_id") == null && (userId = DefaultDestinationManager.getUserId(this.name, this.properties, true)) != null) {
            this.properties.setProperty("jco.destination.user_id", userId);
        }
        this.getDestinationID();
        switch (this.getType()) {
            case '3': 
            case 'A': 
            case 'B': 
            case 'V': {
                ClientFactory factory = ConnectionManager.getConnectionManager().getFactory(this, false, true);
                this.attributes = factory.getAttributes();
                if (this.attributes.getSSOTicket() == null) break;
                this.setSSOTicket(this.attributes.getSSOTicket());
                break;
            }
            case 'E': {
                ClientFactory factory = ConnectionManager.getConnectionManager().getFactory(this, false, true);
                this.attributes = factory.getAttributes();
                break;
            }
        }
        this.isInitialized = true;
    }

    String getSystemID() throws JCoException {
        if (this.destinationId == null) {
            this.initialize();
        }
        ClientFactory factory = ConnectionManager.getConnectionManager().getFactory(this, true, true);
        return factory.getAttributes().getSystemID();
    }

    public Properties getProperties() {
        Properties clonedP = this.getAllProperties();
        clonedP.remove("jco.client.passwd");
        clonedP.remove("jco.client.mysapsso2");
        clonedP.remove("jco.client.x509cert");
        clonedP.remove("jco.destination.repository.passwd");
        return clonedP;
    }

    Properties getAllProperties() {
        return (Properties)this.properties.clone();
    }

    private void checkState() {
        if (this.isInitialized) {
            throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "Destination instance is already connected to a backend, hence changes in the destination parameters are not allowed. If you need to change a setting, create a new instance with createCustomDestination().");
        }
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.properties.hashCode();
    }

    public boolean equals(Object destination) {
        if (destination instanceof RfcDestination) {
            RfcDestination rfcDestination = (RfcDestination)destination;
            return this.name.equals(rfcDestination.name) && this.properties.equals(rfcDestination.properties) && this.state.equals((Object)rfcDestination.state);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicRepository getRepository() throws JCoException {
        if (this.state != ConfigurationState.VALID) {
            StringBuilder buf = this.getStateTrace();
            throw new JCoException(180, "JCO_ERROR_DESTINATION_DATA_INVALID", buf.toString());
        }
        if (this.repository == null) {
            RfcDestination rfcDestination = this;
            synchronized (rfcDestination) {
                InternalDestination repDestination = this.getRepositoryDestination();
                this.repository = runtime.getRepositoryManager().getRepository(repDestination);
                if (Trace.isOn(32)) {
                    StringBuilder buffer = new StringBuilder(100);
                    buffer.append("[JCoAPI] RfcDestination.getRepository() on ").append(this.getDestinationName());
                    buffer.append(" allocated repository ").append(this.repository.getName());
                    buffer.append(" from destination ").append(repDestination.getDestinationName());
                    Trace.fireTrace(32, buffer.toString());
                }
            }
        }
        return this.repository;
    }

    InternalDestination getRepositoryDestination() {
        if (this.repositoryDestination == null) {
            String repDestinationName = this.properties.getProperty("jco.destination.repository_destination");
            if (repDestinationName != null) {
                JCoDestination myDest = null;
                try {
                    myDest = JCoDestinationManager.getDestination(repDestinationName);
                    this.repositoryDestination = (InternalDestination)myDest;
                }
                catch (ClassCastException cce) {
                    throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Unsupported class " + (myDest != null ? myDest.getClass().getName() : "null") + " encountered when getting destination " + repDestinationName);
                }
                catch (JCoException ex) {
                    this.repositoryDestination = this;
                }
            } else {
                this.repositoryDestination = this;
            }
        }
        return this.repositoryDestination;
    }

    public String toString() {
        FastStringBuffer result = new FastStringBuffer(200);
        result.append("destination ");
        result.append(this.name);
        result.append(" with properties:");
        result.append(this.getProperties().toString());
        return result.toString();
    }

    public RfcCustomDestination createCustomDestination() {
        if (this.isInPasswordChangeHandler()) {
            throw new JCoRuntimeException(136, "Not allowed to invoke createCustomDestination(), while being in a PasswordHandler");
        }
        RfcCustomDestination clone = new RfcCustomDestination("customized_" + this.name, this.getAllProperties(), "custom destination", this.parentDestination);
        clone.scopeType = this.scopeType;
        clone.repository = this.repository;
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void confirmTID(String tid) throws JCoException {
        if (this.isInPasswordChangeHandler()) {
            throw new JCoException(136, "Not allowed to invoke confirmTID(), while being in a PasswordHandler");
        }
        ClientConnection client = null;
        JCoRuntime rt = JCoRuntimeFactory.getRuntime();
        Context ctx = rt.getRuntimeContext(false, this.scopeType);
        try {
            client = ctx.getConnection(this, false);
            client.confirmTID(tid);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            ctx.releaseConnection(this, client);
            throw throwable;
        }
        ctx.releaseConnection(this, client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createTID() throws JCoException {
        if (this.isInPasswordChangeHandler()) {
            throw new JCoException(136, "Not allowed to invoke createTID(), while being in a PasswordHandler");
        }
        ClientConnection client = null;
        JCoRuntime rt = JCoRuntimeFactory.getRuntime();
        Context ctx = rt.getRuntimeContext(false, this.scopeType);
        String tid = null;
        try {
            client = ctx.getConnection(this, false);
            tid = client.createTID();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            ctx.releaseConnection(this, client);
            throw throwable;
        }
        ctx.releaseConnection(this, client);
        return tid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void confirmFunctionUnit(JCoUnitIdentifier unitIdentifier) throws JCoException {
        if (this.isInPasswordChangeHandler()) {
            throw new JCoException(136, "Not allowed to invoke confirmFunctionUnit(), while being in a PasswordHandler");
        }
        ClientConnection client = null;
        JCoRuntime rt = JCoRuntimeFactory.getRuntime();
        Context ctx = rt.getRuntimeContext(false, this.scopeType);
        try {
            client = ctx.getConnection(this, false);
            client.confirmUnitID(unitIdentifier);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            ctx.releaseConnection(this, client);
            throw throwable;
        }
        ctx.releaseConnection(this, client);
    }

    public JCoFunctionUnitState getFunctionUnitState(JCoUnitIdentifier unitIdentifier) throws JCoException {
        AbapFunctionTemplate getStateT = StaticFunctionTemplates.getBGRFC_CHECK_UNIT_STATE_SERVERTemplate();
        AbapFunction getState = getStateT.getFunction();
        getState.getImportParameterList().setValue("UNIT_ID", unitIdentifier.getIDAsBytes());
        int unitKind = 1409196103;
        if (unitIdentifier.getType() == JCoUnitIdentifier.Type.TYPE_T) {
            unitKind = 1409196105;
        }
        getState.getImportParameterList().setValue("UNIT_KIND", unitKind);
        this.execute(getState);
        int srvState = getState.getExportParameterList().getInt("STATE");
        JCoFunctionUnitState unitState = JCoFunctionUnitState.ROLLED_BACK;
        switch (srvState) {
            case 22203: {
                unitState = JCoFunctionUnitState.CONFIRMED;
                break;
            }
            case 22202: {
                unitState = JCoFunctionUnitState.COMMITTED;
                break;
            }
            case 22201: {
                unitState = JCoFunctionUnitState.IN_PROCESS;
                break;
            }
            case 22206: {
                unitState = JCoFunctionUnitState.NOT_FOUND;
                break;
            }
            default: {
                unitState = JCoFunctionUnitState.ROLLED_BACK;
            }
        }
        return unitState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ping() throws JCoException {
        if (this.isInPasswordChangeHandler()) {
            throw new JCoException(136, "Not allowed to invoke ping(), while being in a PasswordHandler");
        }
        if (!this.isInitialized) {
            this.initialize();
        }
        if (this.state != ConfigurationState.VALID) {
            StringBuilder buf = this.getStateTrace();
            throw new JCoException(180, "JCO_ERROR_DESTINATION_DATA_INVALID", buf.toString());
        }
        ClientConnection client = null;
        JCoRuntime rt = JCoRuntimeFactory.getRuntime();
        Context ctx = rt.getRuntimeContext(false, this.scopeType);
        try {
            client = ctx.getConnection(this, false);
            client.ping();
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            ctx.releaseConnection(this, client);
            throw throwable;
        }
        ctx.releaseConnection(this, client);
    }

    public boolean isValid() {
        return this.state == ConfigurationState.VALID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RfcDestination getDestinationForScope(String aScopeType) {
        ArrayList<RfcDestination> localList = this.scopeList;
        if (localList == null) {
            RfcDestination rfcDestination = this;
            synchronized (rfcDestination) {
                localList = this.scopeList;
                if (localList == null) {
                    localList = this.scopeList = new ArrayList();
                }
            }
        }
        RfcDestination destForScope = null;
        RfcDestination iDest = null;
        int len = this.scopeList.size();
        for (int i = 0; i < len; ++i) {
            iDest = this.scopeList.get(i);
            if (iDest == null || !aScopeType.equals(iDest.scopeType)) continue;
            destForScope = iDest;
            break;
        }
        if (destForScope == null) {
            RfcDestination rfcDestination = this;
            synchronized (rfcDestination) {
                len = this.scopeList.size();
                for (int i = 0; i < len; ++i) {
                    iDest = this.scopeList.get(i);
                    if (!aScopeType.equals(iDest.scopeType)) continue;
                    destForScope = iDest;
                    break;
                }
                if (destForScope == null) {
                    destForScope = this.clone();
                    destForScope.scopeType = aScopeType;
                    destForScope.parentDestination = this;
                    destForScope.repository = this.parentDestination.repository;
                    this.scopeList.add(destForScope);
                }
            }
        }
        return destForScope;
    }

    synchronized void resetRepository() {
        this.repository = null;
        if (this.scopeList != null) {
            for (RfcDestination iDest : this.scopeList) {
                iDest.repository = null;
            }
        }
    }

    void markDeleted() {
        this.state = ConfigurationState.DELETED;
    }

    void markChanged() {
        this.state = ConfigurationState.CHANGED;
    }

    void execute(AbapFunction fct) throws JCoException {
        this.execute(fct, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute(AbapFunction fct, String tid, String queueName) throws JCoException {
        if (this.isInPasswordChangeHandler()) {
            throw new JCoException(136, "Not allowed to invoke execute(), while being in a PasswordHandler");
        }
        if (this.state != ConfigurationState.VALID) {
            StringBuilder buf = this.getStateTrace();
            throw new JCoException(180, "JCO_ERROR_DESTINATION_DATA_INVALID", buf.toString());
        }
        Context ctx = runtime.getRuntimeContext(false, this.scopeType);
        if (Trace.isOn(64)) {
            StringBuilder buf = new StringBuilder("[JCoAPI] destination ").append(this.name).append(" destinationID=").append(this.getDestinationID()).append(" executes ").append(fct.getName()).append(" sessionID=").append(ctx.sessionID).append(", threadID=0x").append(Long.toHexString(Thread.currentThread().getId()));
            Trace.fireTrace(64, buf.toString());
        }
        ClientConnection conn = null;
        try {
            conn = ctx.getConnection(this, false);
            conn.execute(fct, tid, queueName, (JCoRepository)this.getRepository());
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            ctx.releaseConnection(this, conn);
            throw throwable;
        }
        ctx.releaseConnection(this, conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute(AbapFunctionUnit unit) throws JCoException {
        if (this.isInPasswordChangeHandler()) {
            throw new JCoException(136, "Not allowed to invoke execute(), while being in a PasswordHandler");
        }
        if (this.state != ConfigurationState.VALID) {
            StringBuilder buf = this.getStateTrace();
            throw new JCoException(180, "JCO_ERROR_DESTINATION_DATA_INVALID", buf.toString());
        }
        Context ctx = runtime.getRuntimeContext(false, this.scopeType);
        ClientConnection conn = null;
        try {
            conn = ctx.getConnection(this, false);
            conn.execute(unit, (JCoRepository)this.getRepository());
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            ctx.releaseConnection(this, conn);
            throw throwable;
        }
        ctx.releaseConnection(this, conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changePassword(String oldPassword, String newPassword) throws JCoException {
        if (this.isInPasswordChangeHandler()) {
            throw new JCoException(136, "Not allowed to invoke changePassword(), while being in a PasswordHandler");
        }
        if (this.state != ConfigurationState.VALID) {
            StringBuilder buf = this.getStateTrace();
            throw new JCoException(180, "JCO_ERROR_DESTINATION_DATA_INVALID", buf.toString());
        }
        Context ctx = runtime.getRuntimeContext(false, this.scopeType);
        if (Trace.isOn(64)) {
            StringBuilder buf = new StringBuilder("[JCoAPI] destination ").append(this.name).append(" destinationID=").append(this.getDestinationID()).append(" executes changePassword() sessionID=").append(ctx.sessionID).append(", threadID=0x").append(Long.toHexString(Thread.currentThread().getId()));
            Trace.fireTrace(64, buf.toString());
        }
        ClientConnection conn = null;
        try {
            conn = ctx.getConnection(this, true);
            conn.changeBackendPassword(this.getUser(), oldPassword, newPassword);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            ctx.releaseConnection(this, conn);
            throw throwable;
        }
        ctx.releaseConnection(this, conn);
    }

    private StringBuilder getStateTrace() {
        StringBuilder buf = new StringBuilder("Destination ").append(this.name).append(" was ");
        if (this.state == ConfigurationState.CHANGED) {
            buf.append("changed. Refresh the destination instance with the JCoDestinationManager.");
        } else {
            buf.append("removed. Check the destination configuration.");
        }
        if (Trace.isOn(8)) {
            Trace.fireTrace(8, "[JCoAPI] " + buf.toString());
        }
        return buf;
    }

    static String getProperty(Properties props, String key, String defaultValue) {
        Object value = props.get(key);
        if (value != null) {
            return value.toString();
        }
        return defaultValue;
    }

    static String getProperty(Properties props, String key) {
        Object value = props.get(key);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    static int getIntProperty(Properties props, String key, int defvalue) {
        int result;
        Object value = props.get(key);
        if (value == null) {
            return defvalue;
        }
        try {
            result = Integer.parseInt(value.toString());
        }
        catch (Exception e) {
            result = defvalue;
        }
        return result;
    }

    static long getLongProperty(Properties props, String key, long defvalue) {
        long result;
        Object value = props.get(key);
        try {
            result = Long.parseLong(value.toString());
        }
        catch (Exception e) {
            result = defvalue;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCoDestinationMonitor getMonitor() {
        try {
            this.initialize();
        }
        catch (JCoException ex) {
            throw new JCoRuntimeException(106, "JCO_ERROR_RESOURCE", "Unable to initialize the destination", ex);
        }
        String string = this.destinationId;
        synchronized (string) {
            if (this.monitor == null) {
                this.monitor = new RfcDestinationMonitor(this.destinationId);
            }
        }
        return this.monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCoDestinationMonitor getRepositoryDestinationMonitor() {
        try {
            this.initialize();
        }
        catch (JCoException ex) {
            throw new JCoRuntimeException(106, "JCO_ERROR_RESOURCE", "Unable to initialize the destination", ex);
        }
        String string = this.destinationId;
        synchronized (string) {
            if (this.repMonitor == null) {
                try {
                    this.repMonitor = new RfcDestinationMonitor(this.destinationRepositoryId);
                }
                catch (JCoRuntimeException ex) {
                    this.repMonitor = null;
                }
            }
        }
        return this.repMonitor;
    }

    Context getCurrentContext() {
        return runtime.getRuntimeContext(false, this.scopeType);
    }

    Boolean supportsTurboRepository() {
        String isSupported = this.properties.getProperty("jco.destination.repository_roundtrip_optimization");
        if (isSupported == null) {
            return null;
        }
        if (isSupported.equals("1")) {
            return new Boolean(true);
        }
        return new Boolean(false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ConfigurationState {
        VALID,
        CHANGED,
        DELETED;

    }
}

