/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.automate;

import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.automate.AutomateV11Helper;
import com.helpsystems.enterprise.bpa_11.automate.constructs.ClientType;
import com.helpsystems.enterprise.bpa_11.automate.constructs.ConstructType;
import com.helpsystems.enterprise.bpa_11.automate.constructs.ExecutionEventConstruct;
import com.helpsystems.enterprise.bpa_11.automate.constructs.GeneralEventConstruct;
import com.helpsystems.enterprise.bpa_11.automate.constructs.RunningWorkflowItemInstanceInfo;
import com.helpsystems.enterprise.bpa_11.automate.constructs.WorkFlowItemExecutionStatus;
import com.helpsystems.enterprise.bpa_11.automate.messages.CloseSessionRequestMessage;
import com.helpsystems.enterprise.bpa_11.automate.messages.CloseSessionResponseMessage;
import com.helpsystems.enterprise.bpa_11.automate.messages.GetAllRunningWorkflowsRequestMessage;
import com.helpsystems.enterprise.bpa_11.automate.messages.GetAllRunningWorkflowsResponseMessage;
import com.helpsystems.enterprise.bpa_11.automate.messages.GetExecutedConstructsEventsRequestMessage;
import com.helpsystems.enterprise.bpa_11.automate.messages.GetExecutedConstructsEventsResponseMessage;
import com.helpsystems.enterprise.bpa_11.automate.messages.OpenSessionRequestMessage;
import com.helpsystems.enterprise.bpa_11.automate.messages.OpenSessionResponseMessage;
import com.helpsystems.enterprise.bpa_11.automate.messages.RunProcessesRequestMessage;
import com.helpsystems.enterprise.bpa_11.automate.messages.RunProcessesResponseMessage;
import com.helpsystems.enterprise.bpa_11.automate.messages.RunTasksRequestMessage;
import com.helpsystems.enterprise.bpa_11.automate.messages.RunTasksResponseMessage;
import com.helpsystems.enterprise.bpa_11.automate.messages.RunWorkflowRequestMessage;
import com.helpsystems.enterprise.bpa_11.automate.messages.RunWorkflowResponseMessage;
import com.helpsystems.enterprise.bpa_11.org.tempuri.CloseSessionRequest;
import com.helpsystems.enterprise.bpa_11.org.tempuri.CloseSessionRequestResponse;
import com.helpsystems.enterprise.bpa_11.org.tempuri.GetAllRunningWorkflowsRequest;
import com.helpsystems.enterprise.bpa_11.org.tempuri.GetAllRunningWorkflowsRequestResponse;
import com.helpsystems.enterprise.bpa_11.org.tempuri.GetExecutedConstructsEventsRequest;
import com.helpsystems.enterprise.bpa_11.org.tempuri.GetExecutedConstructsEventsRequestResponse;
import com.helpsystems.enterprise.bpa_11.org.tempuri.IBPAManagementServerHTTPServiceContract;
import com.helpsystems.enterprise.bpa_11.org.tempuri.OpenSessionRequest;
import com.helpsystems.enterprise.bpa_11.org.tempuri.OpenSessionRequestResponse;
import com.helpsystems.enterprise.bpa_11.org.tempuri.RunProcessesRequest;
import com.helpsystems.enterprise.bpa_11.org.tempuri.RunProcessesRequestResponse;
import com.helpsystems.enterprise.bpa_11.org.tempuri.RunTasksRequest;
import com.helpsystems.enterprise.bpa_11.org.tempuri.RunTasksRequestResponse;
import com.helpsystems.enterprise.bpa_11.org.tempuri.RunWorkflowRequest;
import com.helpsystems.enterprise.bpa_11.org.tempuri.RunWorkflowRequestResponse;
import com.helpsystems.enterprise.core.busobj.automate.AutoMateBPACommand;
import com.helpsystems.enterprise.core.busobj.automate.AutoMateBPACommandType;
import com.helpsystems.enterprise.core.busobj.automate.AutoMateBPARequestComposite;
import com.helpsystems.enterprise.core.busobj.automate.AutoMateSystemDefinition;
import com.helpsystems.enterprise.core.busobj.automate.AutoMateTargetType;
import java.io.File;
import java.rmi.RemoteException;
import java.util.Calendar;

public class AutomateEnterpriseCommandRunner {
    private static LogLevel currentLogLevel = LogLevel.INFO;
    private static final long DEFAULT_POLLING_INTERVAL_MILLIS = 2000L;
    private static final int MAX_CONNECTION_ID_LENGTH = 38;
    private static AutomateV11Helper automateV11Helper;

    public static void main(String[] stringArray) {
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Starting Automate Enterprise Command Runner...");
        AutoMateBPARequestComposite autoMateBPARequestComposite = AutomateEnterpriseCommandRunner.getAutoMateBPARequestComposite(stringArray);
        try {
            AutomateEnterpriseCommandRunner automateEnterpriseCommandRunner = new AutomateEnterpriseCommandRunner();
            automateEnterpriseCommandRunner.runCommand(autoMateBPARequestComposite);
            System.exit(0);
        }
        catch (Exception exception) {
            AutomateEnterpriseCommandRunner.logException(exception);
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "");
            System.exit(1);
        }
    }

    private void runCommand(AutoMateBPARequestComposite autoMateBPARequestComposite) throws Exception {
        AutoMateBPACommand autoMateBPACommand = autoMateBPARequestComposite.getAutoMateBPACommand();
        AutoMateBPACommandType autoMateBPACommandType = autoMateBPACommand.getCommandType();
        AutoMateSystemDefinition autoMateSystemDefinition = autoMateBPARequestComposite.getAutoMateSystemDefinition();
        this.runAutomateEnterpriseCommand(autoMateBPARequestComposite, autoMateBPACommand, autoMateBPACommandType, autoMateSystemDefinition);
    }

    private void monitorQueuedBPACommandStatuses(IBPAManagementServerHTTPServiceContract iBPAManagementServerHTTPServiceContract, String string, String string2, String string3, Calendar calendar, String[] stringArray, AutoMateBPACommandType autoMateBPACommandType, int n) {
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "");
        String string4 = "instances";
        if (stringArray.length == 1) {
            string4 = "instance";
        }
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Start of Monitor queued Enterprise " + autoMateBPACommandType + " for " + stringArray.length + " " + string4 + ".");
        long l = System.currentTimeMillis();
        boolean bl = true;
        while (bl) {
            try {
                long l2 = this.getPollingInterval(l, n);
                AutomateEnterpriseCommandRunner.logmsg(LogLevel.DEBUG, "");
                AutomateEnterpriseCommandRunner.logmsg(LogLevel.DEBUG, "Waiting " + l2 + " ms...");
                Thread.sleep(l2);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            try {
                int n2 = 0;
                for (int i = 0; i < stringArray.length; ++i) {
                    String string5 = stringArray[i];
                    AutomateEnterpriseCommandRunner.logmsg(LogLevel.DEBUG, "");
                    AutomateEnterpriseCommandRunner.logmsgWithTimestamp(LogLevel.DEBUG, "Checking status for Instance ID (" + (i + 1) + " of " + stringArray.length + "): " + string5);
                    WorkFlowItemExecutionStatus workFlowItemExecutionStatus = this.getWorkFlowItemExecutionStatus(iBPAManagementServerHTTPServiceContract, string, string2, string3, calendar, string5, true);
                    if (workFlowItemExecutionStatus == null) {
                        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Workflow status is not available for instance ID: " + string5);
                        continue;
                    }
                    AutomateEnterpriseCommandRunner.logmsg(LogLevel.DEBUG, "Workflow status for instance ID " + string5 + ": " + workFlowItemExecutionStatus);
                    AutomateEnterpriseCommandRunner.logmsg(LogLevel.DEBUG, "");
                    if (workFlowItemExecutionStatus != WorkFlowItemExecutionStatus.Queued) continue;
                    ++n2;
                }
                AutomateEnterpriseCommandRunner.logmsgWithTimestamp(LogLevel.INFO, "Queued Workflow instance count: " + n2);
                if (n2 > 0) continue;
                bl = false;
            }
            catch (Exception exception) {
                if (currentLogLevel == LogLevel.INFO) {
                    AutomateEnterpriseCommandRunner.logmsg(currentLogLevel, "Monitor error: " + exception.getMessage());
                } else {
                    AutomateEnterpriseCommandRunner.logException(exception);
                }
                bl = false;
            }
        }
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "End of Monitor for queued Enterprise " + autoMateBPACommandType);
    }

    private static AutomateV11Helper getAutomateV11Helper() {
        if (automateV11Helper == null) {
            automateV11Helper = new AutomateV11Helper();
        }
        return automateV11Helper;
    }

    private boolean checkBPAWorkflowStatuses(IBPAManagementServerHTTPServiceContract iBPAManagementServerHTTPServiceContract, String string, String string2, String string3, Calendar calendar, String[] stringArray) throws Exception {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            WorkFlowItemExecutionStatus workFlowItemExecutionStatus;
            String string4 = stringArray[i];
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "");
            AutomateEnterpriseCommandRunner.logmsgWithTimestamp(LogLevel.INFO, "Checking status for Instance ID (" + (i + 1) + " of " + stringArray.length + "): " + string4);
            int n = 10;
            do {
                if (n-- < 10) {
                    AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "");
                    AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Attempt failed.  Waiting 30000 ms...");
                    Thread.sleep(30000L);
                }
                AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "");
                AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Attempt number " + (10 - n) + " to obtain the WorkFlow status...");
            } while ((workFlowItemExecutionStatus = this.getWorkFlowItemExecutionStatus(iBPAManagementServerHTTPServiceContract, string, string2, string3, calendar, string4)) == WorkFlowItemExecutionStatus.TimedOut && n > 0);
            if (workFlowItemExecutionStatus == null) {
                AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Workflow status is not available for instance ID: " + string4);
                bl = false;
                continue;
            }
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Workflow status for instance ID " + string4 + ": " + workFlowItemExecutionStatus);
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "");
            if (workFlowItemExecutionStatus == WorkFlowItemExecutionStatus.Success) continue;
            bl = false;
        }
        return bl;
    }

    private WorkFlowItemExecutionStatus getWorkFlowItemExecutionStatus(IBPAManagementServerHTTPServiceContract iBPAManagementServerHTTPServiceContract, String string, String string2, String string3, Calendar calendar, String string4) throws Exception {
        return this.getWorkFlowItemExecutionStatus(iBPAManagementServerHTTPServiceContract, string, string2, string3, calendar, string4, false);
    }

    private WorkFlowItemExecutionStatus getWorkFlowItemExecutionStatus(IBPAManagementServerHTTPServiceContract iBPAManagementServerHTTPServiceContract, String string, String string2, String string3, Calendar calendar, String string4, boolean bl) throws Exception {
        WorkFlowItemExecutionStatus workFlowItemExecutionStatus = WorkFlowItemExecutionStatus.Unknown;
        GetExecutedConstructsEventsRequestMessage getExecutedConstructsEventsRequestMessage = new GetExecutedConstructsEventsRequestMessage();
        getExecutedConstructsEventsRequestMessage.setConnectionID(string);
        getExecutedConstructsEventsRequestMessage.setMessageID(string2);
        getExecutedConstructsEventsRequestMessage.setTimestamp(calendar);
        getExecutedConstructsEventsRequestMessage.setMinimumIndex(10L);
        getExecutedConstructsEventsRequestMessage.setPageSize(1000L);
        String string5 = "\"InstanceID\"='" + string4 + "'";
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.DEBUG, "whereClause: " + string5);
        getExecutedConstructsEventsRequestMessage.setWhereClause(string5);
        GetExecutedConstructsEventsRequest getExecutedConstructsEventsRequest = new GetExecutedConstructsEventsRequest(getExecutedConstructsEventsRequestMessage, string3);
        GetExecutedConstructsEventsRequestResponse getExecutedConstructsEventsRequestResponse = iBPAManagementServerHTTPServiceContract.getExecutedConstructsEventsRequest(getExecutedConstructsEventsRequest);
        if (getExecutedConstructsEventsRequestResponse == null) {
            String string6 = "getExecutedConstructsEventsRequestResponse is null!  Session problem?";
            throw new RuntimeException(string6);
        }
        GetExecutedConstructsEventsResponseMessage getExecutedConstructsEventsResponseMessage = getExecutedConstructsEventsRequestResponse.getGetExecutedConstructsEventsRequestResult();
        if (getExecutedConstructsEventsResponseMessage == null) {
            throw new Exception("No response message from GetExecutedConstructsEventsRequestResponse.");
        }
        ExecutionEventConstruct[] executionEventConstructArray = getExecutedConstructsEventsResponseMessage.getExecutionEvents();
        if (executionEventConstructArray != null && executionEventConstructArray.length > 0) {
            ExecutionEventConstruct executionEventConstruct = null;
            for (int i = 0; i < executionEventConstructArray.length; ++i) {
                executionEventConstruct = executionEventConstructArray[i];
                if (currentLogLevel == LogLevel.DEBUG) {
                    this.logExecutionEventConstruct(executionEventConstruct, i);
                } else if (!bl) {
                    AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Result Code: " + executionEventConstruct.getResultCode() + " Result Text: " + executionEventConstruct.getResultText());
                }
                if (bl) {
                    workFlowItemExecutionStatus = executionEventConstruct.getResultCode() == 11 ? WorkFlowItemExecutionStatus.Queued : WorkFlowItemExecutionStatus.Unknown;
                    break;
                }
                if (executionEventConstruct.getResultCode() == -1) {
                    workFlowItemExecutionStatus = WorkFlowItemExecutionStatus.TimedOut;
                    break;
                }
                if (executionEventConstruct.getResultCode() == 1) {
                    workFlowItemExecutionStatus = WorkFlowItemExecutionStatus.Success;
                    break;
                }
                workFlowItemExecutionStatus = WorkFlowItemExecutionStatus.Error;
            }
        } else if (executionEventConstructArray == null) {
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "ExecutionEventConstructs array is null.  Results are not available for: " + string4);
        } else {
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "No ExecutionEventConstructs were returned from the GetExecutedConstructsEventsResponseMessage for instance ID '" + string4 + "'.");
            workFlowItemExecutionStatus = WorkFlowItemExecutionStatus.TimedOut;
        }
        return workFlowItemExecutionStatus;
    }

    private void logStartedBPACommand(AutoMateBPACommandType autoMateBPACommandType, String string, String[] stringArray) {
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "*******************************");
        String string2 = "Started " + autoMateBPACommandType;
        switch (autoMateBPACommandType) {
            case WORKFLOW: {
                string2 = string2 + " . . ";
                break;
            }
            case TASK: {
                string2 = string2 + " . . . . ";
                break;
            }
            case PROCESS: {
                string2 = string2 + "  . . ";
            }
        }
        string2 = string2 + ": ";
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, string2 + string);
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Instance Count . . . : " + stringArray.length);
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "InstanceID . . . . . : " + stringArray[i]);
            }
        }
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "*******************************");
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "");
    }

    private void monitorActiveBPACommand(IBPAManagementServerHTTPServiceContract iBPAManagementServerHTTPServiceContract, String string, String string2, String string3, Calendar calendar, String[] stringArray, AutoMateBPACommandType autoMateBPACommandType, int n) throws RemoteException {
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "");
        String string4 = "instances";
        if (stringArray.length == 1) {
            string4 = "instance";
        }
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Start of Monitor active BPA " + autoMateBPACommandType + " for " + stringArray.length + " " + string4 + ".");
        GetAllRunningWorkflowsRequestMessage getAllRunningWorkflowsRequestMessage = new GetAllRunningWorkflowsRequestMessage();
        getAllRunningWorkflowsRequestMessage.setConnectionID(string);
        getAllRunningWorkflowsRequestMessage.setTimestamp(calendar);
        getAllRunningWorkflowsRequestMessage.setMessageID(string2);
        GetAllRunningWorkflowsRequest getAllRunningWorkflowsRequest = new GetAllRunningWorkflowsRequest(getAllRunningWorkflowsRequestMessage, string3);
        long l = System.currentTimeMillis();
        boolean bl = true;
        while (bl) {
            try {
                long l2 = this.getPollingInterval(l, n);
                AutomateEnterpriseCommandRunner.logmsg(LogLevel.DEBUG, "");
                AutomateEnterpriseCommandRunner.logmsg(LogLevel.DEBUG, "Waiting " + l2 + " ms...");
                Thread.sleep(l2);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            try {
                Object object;
                GetAllRunningWorkflowsRequestResponse getAllRunningWorkflowsRequestResponse = iBPAManagementServerHTTPServiceContract.getAllRunningWorkflowsRequest(getAllRunningWorkflowsRequest);
                if (getAllRunningWorkflowsRequestResponse == null) {
                    object = "getAllRunningWorkflowsRequestResponse is null!  Session problem?";
                    throw new RuntimeException((String)object);
                }
                object = getAllRunningWorkflowsRequestResponse.getGetAllRunningWorkflowsRequestResult();
                if (object == null) {
                    throw new Exception("No response message from GetAllRunningWorkflowsRequestResponse.");
                }
                RunningWorkflowItemInstanceInfo[] runningWorkflowItemInstanceInfoArray = ((GetAllRunningWorkflowsResponseMessage)object).getRunningWorkflows();
                int n2 = this.checkWorkflowStatus(runningWorkflowItemInstanceInfoArray, stringArray, autoMateBPACommandType);
                AutomateEnterpriseCommandRunner.logmsgWithTimestamp(LogLevel.INFO, "Active Workflow instance count: " + n2);
                if (n2 > 0) continue;
                bl = false;
            }
            catch (Exception exception) {
                if (currentLogLevel == LogLevel.INFO) {
                    AutomateEnterpriseCommandRunner.logmsg(currentLogLevel, "Monitor error: " + exception.getMessage());
                } else {
                    AutomateEnterpriseCommandRunner.logException(exception);
                }
                bl = false;
            }
        }
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "End of Monitor active BPA " + autoMateBPACommandType);
    }

    private String[] runTasks(IBPAManagementServerHTTPServiceContract iBPAManagementServerHTTPServiceContract, String string, String string2, String string3, Calendar calendar, AutoMateBPARequestComposite autoMateBPARequestComposite) throws Exception {
        Object object;
        String[] stringArray;
        String string4;
        AutoMateBPACommand autoMateBPACommand = autoMateBPARequestComposite.getAutoMateBPACommand();
        String[] stringArray2 = null;
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "");
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Preparing to Run Automate Enterprise Task...");
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.DEBUG, "autoMateBPACommand.isRunAgentByID() = " + autoMateBPACommand.isRunAgentByID());
        String string5 = autoMateBPACommand.getBpaCommandID();
        AutoMateTargetType autoMateTargetType = autoMateBPACommand.getTargetType();
        String string6 = "Agent";
        if (autoMateBPACommand.getTargetType() == AutoMateTargetType.AGENT_GROUP) {
            string6 = "Agent Group";
        }
        if (autoMateBPACommand.isRunAgentByID()) {
            string4 = autoMateBPACommand.getTargetID();
        } else {
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "");
            stringArray = autoMateBPACommand.getTargetPath();
            stringArray = stringArray.replace("\\\\", "\\");
            autoMateBPACommand.setTargetPath((String)stringArray);
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Looking for " + string6 + ": " + autoMateBPACommand.getTargetPath());
            string4 = AutomateEnterpriseCommandRunner.getAutomateV11Helper().getTargetIDFromTargetName(iBPAManagementServerHTTPServiceContract, string, string2, string3, autoMateBPARequestComposite);
        }
        if (string4 == null) {
            stringArray = "Error: ID not found for " + string6 + " path: " + autoMateBPACommand.getTargetPath();
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, (String)stringArray);
            throw new Exception("Error during start of Task: " + (String)stringArray);
        }
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Found ID: " + string4 + " for " + string6 + ": " + autoMateBPACommand.getTargetPath());
        stringArray = new String[]{string5};
        String[] stringArray3 = new String[]{};
        String[] stringArray4 = new String[]{};
        String[] stringArray5 = null;
        String[] stringArray6 = null;
        switch (autoMateTargetType) {
            case AGENT: {
                stringArray5 = new String[]{string4};
                stringArray6 = new String[]{};
                break;
            }
            case AGENT_GROUP: {
                stringArray6 = new String[]{string4};
                stringArray5 = new String[]{};
            }
        }
        RunTasksRequestMessage runTasksRequestMessage = new RunTasksRequestMessage();
        runTasksRequestMessage.setConnectionID(string);
        runTasksRequestMessage.setMessageID(string2);
        runTasksRequestMessage.setTimestamp(calendar);
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "");
        if (autoMateBPACommand.isRunByID()) {
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Running by ID  . . . : " + autoMateBPACommand.getBpaCommandID());
            runTasksRequestMessage.setTaskIDs(stringArray);
            runTasksRequestMessage.setTaskNames(stringArray3);
            runTasksRequestMessage.setTaskPaths(stringArray4);
        } else {
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Running by Name . . . : " + autoMateBPACommand.getBpaCommandName());
            object = autoMateBPACommand.getBpaCommandPath();
            object = ((String)object).replace("\\\\", "\\");
            autoMateBPACommand.setBpaCommandPath((String)object);
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Running by Path . . . : " + autoMateBPACommand.getBpaCommandPath());
            stringArray = new String[]{};
            runTasksRequestMessage.setTaskIDs(stringArray);
            stringArray3 = new String[]{autoMateBPACommand.getBpaCommandName()};
            runTasksRequestMessage.setTaskNames(stringArray3);
            stringArray4 = new String[]{autoMateBPACommand.getBpaCommandPath()};
            runTasksRequestMessage.setTaskPaths(stringArray4);
        }
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Approximate start time: " + this.formatTimestamp(calendar));
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "");
        runTasksRequestMessage.setAgentIDs(stringArray5);
        runTasksRequestMessage.setAgentGroupIDs(stringArray6);
        object = new RunTasksRequest(runTasksRequestMessage, string3);
        if (currentLogLevel == LogLevel.DEBUG) {
            this.logArray(runTasksRequestMessage.getAgentGroupIDs(), "AgentGroupIDs . . . :");
            this.logArray(runTasksRequestMessage.getAgentIDs(), "AgentIDs  . . . . . :");
            this.logArray(runTasksRequestMessage.getTaskIDs(), "TaskIDs . . . . . . :");
            this.logArray(runTasksRequestMessage.getTaskNames(), "TaskNames . . . . . :");
            this.logArray(runTasksRequestMessage.getTaskPaths(), "TaskPaths . . . . . :");
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "");
        }
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Running Task...");
        RunTasksRequestResponse runTasksRequestResponse = iBPAManagementServerHTTPServiceContract.runTasksRequest((RunTasksRequest)object);
        if (runTasksRequestResponse == null) {
            String string7 = "runTasksRequestResponse is null!  Session problem?";
            throw new RuntimeException(string7);
        }
        RunTasksResponseMessage runTasksResponseMessage = runTasksRequestResponse.getRunTasksRequestResult();
        if (runTasksResponseMessage == null) {
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "");
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "runTasksResponseMessage is null!  Session error?");
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "");
        } else {
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Response MessageID . . . : " + runTasksResponseMessage.getMessageID());
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Response ErrorText . . . : " + runTasksResponseMessage.getResponseErrorText());
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Response Result  . . . . : " + runTasksResponseMessage.getResponseResult());
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Result Value . . . . . . : " + runTasksResponseMessage.getResult());
            String[] stringArray7 = runTasksResponseMessage.getInstanceIDs();
            if (stringArray7 != null && stringArray7.length > 0) {
                AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Run Task Response InstanceID count: " + stringArray7.length);
                stringArray2 = stringArray7;
            }
            if (runTasksResponseMessage.getResponseErrorText() != null && runTasksResponseMessage.getResponseErrorText().length() > 0) {
                if (autoMateBPACommand.isRunByID() && runTasksResponseMessage.getResponseErrorText().equals("No tasks found")) {
                    throw new Exception("Error starting Task: No Task found for given Unique ID " + autoMateBPACommand.getBpaCommandID());
                }
                throw new Exception("Error during start of Task: " + runTasksResponseMessage.getResponseErrorText());
            }
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "");
        }
        return stringArray2;
    }

    private String[] runProcesses(IBPAManagementServerHTTPServiceContract iBPAManagementServerHTTPServiceContract, String string, String string2, String string3, Calendar calendar, AutoMateBPARequestComposite autoMateBPARequestComposite) throws Exception {
        Object object;
        String string4;
        String string5;
        AutoMateBPACommand autoMateBPACommand = autoMateBPARequestComposite.getAutoMateBPACommand();
        String[] stringArray = null;
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "");
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Preparing to Run Automate Enterprise Process...");
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.DEBUG, "autoMateBPACommand.isRunAgentByID() = " + autoMateBPACommand.isRunAgentByID());
        AutoMateTargetType autoMateTargetType = autoMateBPACommand.getTargetType();
        String string6 = "Agent";
        if (autoMateBPACommand.getTargetType() == AutoMateTargetType.AGENT_GROUP) {
            string6 = "Agent Group";
        }
        if (autoMateBPACommand.isRunAgentByID()) {
            string5 = autoMateBPACommand.getTargetID();
        } else {
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "");
            string4 = autoMateBPACommand.getTargetPath();
            string4 = string4.replace("\\\\", "\\");
            autoMateBPACommand.setTargetPath(string4);
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Looking for " + string6 + ": " + autoMateBPACommand.getTargetPath());
            string5 = AutomateEnterpriseCommandRunner.getAutomateV11Helper().getTargetIDFromTargetName(iBPAManagementServerHTTPServiceContract, string, string2, string3, autoMateBPARequestComposite);
        }
        if (string5 == null) {
            string4 = "Error: ID not found for " + string6 + " path: " + autoMateBPACommand.getTargetPath();
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, string4);
            throw new Exception("Error during start of Task: " + string4);
        }
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Found ID: " + string5 + " for " + string6 + ": " + autoMateBPACommand.getTargetPath());
        string4 = autoMateBPACommand.getBpaCommandID();
        String[] stringArray2 = new String[]{string4};
        String[] stringArray3 = null;
        String[] stringArray4 = null;
        String[] stringArray5 = null;
        String[] stringArray6 = null;
        switch (autoMateTargetType) {
            case AGENT: {
                stringArray5 = new String[]{string5};
                stringArray6 = new String[]{};
                break;
            }
            case AGENT_GROUP: {
                stringArray6 = new String[]{string5};
                stringArray5 = new String[]{};
            }
        }
        RunProcessesRequestMessage runProcessesRequestMessage = new RunProcessesRequestMessage();
        runProcessesRequestMessage.setConnectionID(string);
        runProcessesRequestMessage.setMessageID(string2);
        runProcessesRequestMessage.setTimestamp(calendar);
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "");
        if (autoMateBPACommand.isRunByID()) {
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Running by ID . . . . : " + autoMateBPACommand.getBpaCommandID());
            runProcessesRequestMessage.setProcessIDs(stringArray2);
            runProcessesRequestMessage.setAgentIDs(stringArray5);
            runProcessesRequestMessage.setAgentGroupIDs(stringArray6);
            stringArray3 = new String[]{};
            runProcessesRequestMessage.setProcessNames(stringArray3);
            stringArray4 = new String[]{};
            runProcessesRequestMessage.setProcessPaths(stringArray4);
        } else {
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Running by Name . . . : " + autoMateBPACommand.getBpaCommandName());
            object = autoMateBPACommand.getBpaCommandPath();
            object = ((String)object).replace("\\\\", "\\");
            autoMateBPACommand.setBpaCommandPath((String)object);
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Running by Path . . . : " + autoMateBPACommand.getBpaCommandPath());
            stringArray2 = new String[]{};
            runProcessesRequestMessage.setProcessIDs(stringArray2);
            runProcessesRequestMessage.setAgentIDs(stringArray5);
            runProcessesRequestMessage.setAgentGroupIDs(stringArray6);
            stringArray3 = new String[]{autoMateBPACommand.getBpaCommandName()};
            runProcessesRequestMessage.setProcessNames(stringArray3);
            stringArray4 = new String[]{autoMateBPACommand.getBpaCommandPath()};
            runProcessesRequestMessage.setProcessPaths(stringArray4);
        }
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "");
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Approximate start time: " + this.formatTimestamp(calendar));
        object = new RunProcessesRequest(runProcessesRequestMessage, string3);
        if (currentLogLevel == LogLevel.DEBUG) {
            this.logArray(runProcessesRequestMessage.getAgentGroupIDs(), "AgentGroupIDs . . :");
            this.logArray(runProcessesRequestMessage.getAgentIDs(), "AgentIDs  . . . . :");
            this.logArray(runProcessesRequestMessage.getProcessIDs(), "ProcessIDs  . . . :");
            this.logArray(runProcessesRequestMessage.getProcessNames(), "ProcessNames  . . :");
            this.logArray(runProcessesRequestMessage.getProcessPaths(), "ProcessPaths  . . :");
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "");
        }
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "");
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Running Process...");
        RunProcessesRequestResponse runProcessesRequestResponse = iBPAManagementServerHTTPServiceContract.runProcessesRequest((RunProcessesRequest)object);
        if (runProcessesRequestResponse == null) {
            String string7 = "runProcessesRequestResponse is null!  Session problem?";
            throw new RuntimeException(string7);
        }
        RunProcessesResponseMessage runProcessesResponseMessage = runProcessesRequestResponse.getRunProcessesRequestResult();
        if (runProcessesResponseMessage == null) {
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "");
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "runProcessesResponseMessage is null!  Session problem?");
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "");
        } else {
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Response MessageID  : " + runProcessesResponseMessage.getMessageID());
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Response ErrorText  : " + runProcessesResponseMessage.getResponseErrorText());
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Response Result . . : " + runProcessesResponseMessage.getResponseResult());
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Result Value  . . . : " + runProcessesResponseMessage.getResult());
            String[] stringArray7 = runProcessesResponseMessage.getInstanceIDs();
            if (stringArray7 != null && stringArray7.length > 0) {
                AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Run Process Response InstanceID count: " + stringArray7.length);
                stringArray = stringArray7;
            }
            if (runProcessesResponseMessage.getResponseErrorText() != null && runProcessesResponseMessage.getResponseErrorText().length() > 0) {
                if (autoMateBPACommand.isRunByID() && runProcessesResponseMessage.getResponseErrorText().equals("No processes found")) {
                    throw new Exception("Error starting Process: No Process found for given Unique ID " + autoMateBPACommand.getBpaCommandID());
                }
                throw new Exception("Error during start of Task: " + runProcessesResponseMessage.getResponseErrorText());
            }
            String[] stringArray8 = runProcessesResponseMessage.getPathsOfNonuniqueProcesses();
            if (stringArray8 != null) {
                for (int i = 0; i < stringArray8.length; ++i) {
                    AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "  nonUniqueProcessPaths[" + i + "]: " + stringArray8[i]);
                }
            }
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "");
        }
        return stringArray;
    }

    private int checkWorkflowStatus(RunningWorkflowItemInstanceInfo[] runningWorkflowItemInstanceInfoArray, String[] stringArray, AutoMateBPACommandType autoMateBPACommandType) throws Exception {
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl = false;
            String string = stringArray[i];
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.DEBUG, "Looking for " + autoMateBPACommandType + " instance ID: " + string);
            for (int j = 0; j < runningWorkflowItemInstanceInfoArray.length; ++j) {
                RunningWorkflowItemInstanceInfo runningWorkflowItemInstanceInfo = runningWorkflowItemInstanceInfoArray[j];
                String string2 = null;
                ConstructType constructType = null;
                switch (autoMateBPACommandType) {
                    case WORKFLOW: {
                        string2 = runningWorkflowItemInstanceInfo.getWorkflowInstanceID();
                        constructType = ConstructType.WorkFlow;
                        break;
                    }
                    case TASK: {
                        string2 = runningWorkflowItemInstanceInfo.getWorkflowItemInstanceID();
                        constructType = ConstructType.Task;
                        break;
                    }
                    case PROCESS: {
                        constructType = ConstructType.Process;
                        string2 = runningWorkflowItemInstanceInfo.getWorkflowItemInstanceID();
                        break;
                    }
                }
                if (!runningWorkflowItemInstanceInfo.getConstructType().equals(constructType) || !string2.equals(string)) continue;
                if (currentLogLevel == LogLevel.DEBUG) {
                    AutomateEnterpriseCommandRunner.logmsg(LogLevel.DEBUG, "Found running workflow info for " + autoMateBPACommandType + " Instance ID: " + string);
                    this.logRunningWorkflowItemInstanceInfo(runningWorkflowItemInstanceInfo, j);
                }
                bl = true;
                break;
            }
            if (bl) {
                ++n;
                continue;
            }
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.DEBUG, "Running workflow info was not found for " + autoMateBPACommandType + " Instance ID: " + string);
        }
        return n;
    }

    private void logArray(Object[] objectArray, String string) {
        System.out.print(string + ": ");
        if (objectArray == null) {
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Item list is null.");
            return;
        }
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, String.valueOf(objectArray.length));
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] instanceof RunningWorkflowItemInstanceInfo) {
                this.logRunningWorkflowItemInstanceInfo((RunningWorkflowItemInstanceInfo)objectArray[i], i);
                continue;
            }
            if (objectArray[i] instanceof GeneralEventConstruct) {
                this.logGeneralEventConstruct((GeneralEventConstruct)objectArray[i], i);
                continue;
            }
            if (objectArray[i] instanceof ExecutionEventConstruct) {
                this.logExecutionEventConstruct((ExecutionEventConstruct)objectArray[i], i);
                continue;
            }
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "  " + (i + 1) + "=" + objectArray[i]);
        }
    }

    private String[] runWorkflow(IBPAManagementServerHTTPServiceContract iBPAManagementServerHTTPServiceContract, String string, String string2, String string3, Calendar calendar, AutoMateBPACommand autoMateBPACommand) throws Exception {
        String[] stringArray = null;
        RunWorkflowRequestMessage runWorkflowRequestMessage = new RunWorkflowRequestMessage();
        runWorkflowRequestMessage.setConnectionID(string);
        runWorkflowRequestMessage.setMessageID(string2);
        runWorkflowRequestMessage.setTimestamp(calendar);
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "");
        if (autoMateBPACommand.isRunByID()) {
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Running by ID . . . . : " + autoMateBPACommand.getBpaCommandID());
            runWorkflowRequestMessage.setWorkFlowID(autoMateBPACommand.getBpaCommandID());
            runWorkflowRequestMessage.setWorkFlowName("");
            runWorkflowRequestMessage.setWorkFlowPath("");
        } else {
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Running by Name . . . : " + autoMateBPACommand.getBpaCommandName());
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Running by Path . . . : " + autoMateBPACommand.getBpaCommandPath());
            runWorkflowRequestMessage.setWorkFlowID("");
            runWorkflowRequestMessage.setWorkFlowName(autoMateBPACommand.getBpaCommandName());
            runWorkflowRequestMessage.setWorkFlowPath(autoMateBPACommand.getBpaCommandPath());
        }
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "");
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Approximate start time: " + this.formatTimestamp(calendar));
        runWorkflowRequestMessage.setUseLocalWorkflow(Boolean.FALSE);
        runWorkflowRequestMessage.setResumeFromFailure(Boolean.FALSE);
        String[] stringArray2 = new String[]{};
        runWorkflowRequestMessage.setStartingItemIDs(stringArray2);
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Request WorkFlow ID . : " + runWorkflowRequestMessage.getWorkFlowID());
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Request WorkFlow Name : " + runWorkflowRequestMessage.getWorkFlowName());
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Request WorkFlow Path : " + runWorkflowRequestMessage.getWorkFlowPath());
        if (currentLogLevel == LogLevel.DEBUG) {
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.DEBUG, "runWorkflowRequestMessage.getMessageID() . . . . : " + runWorkflowRequestMessage.getMessageID());
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.DEBUG, "runWorkflowRequestMessage.getConnectionID()  . . : " + runWorkflowRequestMessage.getConnectionID());
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.DEBUG, "runWorkflowRequestMessage.getTimestamp() . . . . : " + this.formatTimestamp(runWorkflowRequestMessage.getTimestamp()));
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.DEBUG, "runWorkflowRequestMessage.getResumeFromFailure() : " + runWorkflowRequestMessage.getResumeFromFailure());
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.DEBUG, "runWorkflowRequestMessage.getUseLocalWorkflow()  : " + runWorkflowRequestMessage.getUseLocalWorkflow());
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.DEBUG, "runWorkflowRequestMessage.getLocalWorkflow() . . : " + runWorkflowRequestMessage.getLocalWorkflow());
        }
        RunWorkflowRequest runWorkflowRequest = new RunWorkflowRequest(runWorkflowRequestMessage, string3);
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "");
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Running Workflow...");
        RunWorkflowRequestResponse runWorkflowRequestResponse = iBPAManagementServerHTTPServiceContract.runWorkflowRequest(runWorkflowRequest);
        if (runWorkflowRequestResponse == null) {
            String string4 = "runWorkflowRequestResponse is null!  Session problem?";
            throw new RuntimeException(string4);
        }
        RunWorkflowResponseMessage runWorkflowResponseMessage = runWorkflowRequestResponse.getRunWorkflowRequestResult();
        if (runWorkflowResponseMessage == null) {
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "");
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "runWorkflowResponseMessage is null!");
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "");
        } else {
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Response MessageID  . : " + runWorkflowResponseMessage.getMessageID());
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Response ErrorText  . : " + runWorkflowResponseMessage.getResponseErrorText());
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Response Result . . . : " + runWorkflowResponseMessage.getResponseResult());
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Result Value  . . . . : " + runWorkflowResponseMessage.getResult());
            String[] stringArray3 = runWorkflowResponseMessage.getInstanceIDs();
            if (stringArray3 != null && stringArray3.length > 0) {
                AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Run Workflow Response InstanceID count: " + stringArray3.length);
                stringArray = stringArray3;
            } else {
                AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "No instance IDs were returned upon start.");
                if (stringArray3 != null) {
                    AutomateEnterpriseCommandRunner.logmsg(LogLevel.DEBUG, "instanceIDs.length: " + stringArray3.length);
                }
            }
            if (runWorkflowResponseMessage.getResponseErrorText() != null && runWorkflowResponseMessage.getResponseErrorText().length() > 0) {
                if (autoMateBPACommand.isRunByID() && runWorkflowResponseMessage.getResponseErrorText().equals("No workflows found")) {
                    throw new Exception("Error starting Workflow: No Workflow found for given Unique ID " + autoMateBPACommand.getBpaCommandID());
                }
                throw new Exception("Error during start of Workflow: " + runWorkflowResponseMessage.getResponseErrorText());
            }
            String[] stringArray4 = runWorkflowResponseMessage.getPathsOfNonuniqueWorkflows();
            if (stringArray4 != null) {
                for (int i = 0; i < stringArray4.length; ++i) {
                    AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "  workflowPaths[" + i + "]: " + stringArray4[i]);
                }
            }
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "");
        }
        return stringArray;
    }

    private void closeSession(IBPAManagementServerHTTPServiceContract iBPAManagementServerHTTPServiceContract, String string, String string2, String string3) throws RemoteException {
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Closing the session...");
        if (iBPAManagementServerHTTPServiceContract != null && string != null && string2 != null && string3 != null) {
            CloseSessionRequestMessage closeSessionRequestMessage = new CloseSessionRequestMessage(string, string2, null, string3);
            CloseSessionRequest closeSessionRequest = new CloseSessionRequest(closeSessionRequestMessage);
            CloseSessionRequestResponse closeSessionRequestResponse = iBPAManagementServerHTTPServiceContract.closeSessionRequest(closeSessionRequest);
            CloseSessionResponseMessage closeSessionResponseMessage = closeSessionRequestResponse.getCloseSessionRequestResult();
            Boolean bl = closeSessionResponseMessage.getResponseResult();
            if (bl.booleanValue()) {
                AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Successfully closed the session with ID " + string3);
            } else {
                AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Unsuccessfully closed the session with ID " + string3);
            }
        } else {
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "No session to close.");
        }
    }

    private OpenSessionResponseMessage openSessionGetResponse(IBPAManagementServerHTTPServiceContract iBPAManagementServerHTTPServiceContract, AutoMateSystemDefinition autoMateSystemDefinition, String string) throws RemoteException, ResourceUnavailableException {
        OpenSessionRequestMessage openSessionRequestMessage = new OpenSessionRequestMessage();
        openSessionRequestMessage.setConnectionID(string);
        openSessionRequestMessage.setClientID(string);
        openSessionRequestMessage.setClientName(string);
        openSessionRequestMessage.setClientType(ClientType.Skybot);
        openSessionRequestMessage.setUsername(autoMateSystemDefinition.getUsername());
        openSessionRequestMessage.setPassword(autoMateSystemDefinition.getDecryptedPassword());
        OpenSessionRequest openSessionRequest = new OpenSessionRequest(openSessionRequestMessage);
        OpenSessionRequestResponse openSessionRequestResponse = iBPAManagementServerHTTPServiceContract.openSessionRequest(openSessionRequest);
        return openSessionRequestResponse.getOpenSessionRequestResult();
    }

    private static AutoMateBPARequestComposite getAutoMateBPARequestComposite(String[] stringArray) {
        AutoMateBPARequestComposite autoMateBPARequestComposite = null;
        if (stringArray.length < 1) {
            AutomateEnterpriseCommandRunner.exit(1, "Command failed: File name containing an Automate Enterprise request definition is required.");
        }
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringArray[i].trim();
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String[] stringArray2 = stringArray[i].split(":");
            int n3 = stringArray2.length;
            if (n3 > 0) {
                string = stringArray2[0].trim().toLowerCase();
            }
            string2 = null;
            if (n3 == 2) {
                string2 = stringArray2[1];
            } else if (n3 > 2) {
                String string4;
                string2 = string4 = stringArray[i].substring(stringArray2[0].length() + 1);
            }
            try {
                if (string.equals("-xml")) {
                    string3 = string2;
                    continue;
                }
                if (string.equals("-is_unix")) {
                    bl = Boolean.parseBoolean(string2);
                    continue;
                }
                AutomateEnterpriseCommandRunner.exit(1, "Command failed: Invalid option parameter: " + string + " full parm: " + stringArray[i]);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                AutomateEnterpriseCommandRunner.exit(1, "Command failed:" + illegalArgumentException.getMessage());
            }
        }
        File file = new File(string3);
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Loading Automate Enterprise Request Definition from: " + file.getAbsolutePath());
        try {
            autoMateBPARequestComposite = AutoMateBPARequestComposite.restoreFromDisk((String)file.getAbsolutePath());
            return autoMateBPARequestComposite;
        }
        catch (Exception exception) {
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "");
            exception.printStackTrace();
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "");
            AutomateEnterpriseCommandRunner.exit(1, "Command failed: Error loading Automate Enterprise request definition.");
            return autoMateBPARequestComposite;
        }
    }

    private static void exit(int n, String string) {
        AutomateEnterpriseCommandRunner.exit(n, string, null);
    }

    private static void exit(int n, String string, Throwable throwable) {
        if (string != null) {
            System.err.println(string);
            System.err.flush();
        }
        if (throwable != null) {
            throwable.printStackTrace(System.err);
            System.err.flush();
        }
        System.exit(n);
    }

    private long getPollingInterval(long l, long l2) {
        if (l < 1L) {
            return 2000L;
        }
        if (l2 > 0L) {
            if (l2 > 15000L) {
                return 15000L;
            }
            return l2;
        }
        long l3 = System.currentTimeMillis() - l;
        if (l3 < 30000L) {
            return 2000L;
        }
        if (l3 < 300000L) {
            return 5000L;
        }
        return 15000L;
    }

    private void logRunningWorkflowItemInstanceInfo(RunningWorkflowItemInstanceInfo runningWorkflowItemInstanceInfo, int n) {
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "");
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "  RunningWorkflowItemInstanceInfo #" + (n + 1) + ":");
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "    Workflow Name  . . . . . : " + runningWorkflowItemInstanceInfo.getWorkflowName());
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "    Workflow Instance ID . . : " + runningWorkflowItemInstanceInfo.getWorkflowInstanceID());
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "    Workflow Instance Name . : " + runningWorkflowItemInstanceInfo.getWorkflowInstanceName());
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "    Workflow Item ID . . . . : " + runningWorkflowItemInstanceInfo.getWorkflowItemID());
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "    Workflow Item Instance ID: " + runningWorkflowItemInstanceInfo.getWorkflowItemInstanceID());
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "    Agent Name . . . . . . . : " + runningWorkflowItemInstanceInfo.getAgentName());
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "    Started At . . . . . . . : " + this.formatTimestamp(runningWorkflowItemInstanceInfo.getStartedAt()));
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "    Ended At . . . . . . . . : " + this.formatTimestamp(runningWorkflowItemInstanceInfo.getEndedAt()));
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "    Status . . . . . . . . . : " + runningWorkflowItemInstanceInfo.getStatus());
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "    Construct Name . . . . . : " + runningWorkflowItemInstanceInfo.getConstructName());
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "    Construct ID . . . . . . : " + runningWorkflowItemInstanceInfo.getConstructID());
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "    Construct Type . . . . . : " + runningWorkflowItemInstanceInfo.getConstructType());
    }

    private void logGeneralEventConstruct(GeneralEventConstruct generalEventConstruct, int n) {
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "");
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "  GeneralEventConstruct #" + (n + 1) + ":");
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "    getName . . . . . . . . : " + generalEventConstruct.getName());
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "    getEventType  . . . . . : " + generalEventConstruct.getEventType());
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "    getStatusType . . . . . : " + generalEventConstruct.getStatusType());
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "    getType . . . . . . . . : " + generalEventConstruct.getType());
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "    getUserID . . . . . . . : " + generalEventConstruct.getUserID());
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "    getEventText  . . . . . : " + generalEventConstruct.getEventText());
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "    getData . . . . . . . . : " + generalEventConstruct.getData());
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "    getEventDateTime  . . . : " + this.formatTimestamp(generalEventConstruct.getEventDateTime()));
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "    getID . . . . . . . . . : " + generalEventConstruct.getID());
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "    getParentID . . . . . . : " + generalEventConstruct.getParentID());
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "    getPrimaryConstructID . : " + generalEventConstruct.getPrimaryConstructID());
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "    getRowIndex . . . . . . : " + generalEventConstruct.getRowIndex());
    }

    private void logExecutionEventConstruct(ExecutionEventConstruct executionEventConstruct, int n) {
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "");
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "  ExecutionEventConstruct #" + (n + 1) + ":");
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "    Name . . . . . . . . : " + executionEventConstruct.getName());
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "    ID . . . . . . . . . : " + executionEventConstruct.getID());
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "    Instance ID  . . . . : " + executionEventConstruct.getInstanceID());
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "    Agent ID . . . . . . : " + executionEventConstruct.getAgentID());
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "    Construct ID . . . . : " + executionEventConstruct.getConstructID());
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "    Parent ID  . . . . . : " + executionEventConstruct.getParentID());
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "    Result Text  . . . . : " + executionEventConstruct.getResultText());
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "    Result Code  . . . . : " + executionEventConstruct.getResultCode());
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "    Row Index  . . . . . : " + executionEventConstruct.getRowIndex());
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "    Start Date/Time  . . : " + this.formatTimestamp(executionEventConstruct.getStartDateTime()));
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "    End Date/Time  . . . : " + this.formatTimestamp(executionEventConstruct.getEndDateTime()));
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "    Type . . . . . . . . : " + executionEventConstruct.getType());
    }

    private String formatTimestamp(Calendar calendar) {
        return AutomateEnterpriseCommandRunner.getAutomateV11Helper().getFormattedTimestamp(calendar);
    }

    private static void logException(Throwable throwable) {
        AutomateEnterpriseCommandRunner.logException(throwable, 1);
        if (currentLogLevel == LogLevel.DEBUG) {
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.DEBUG, "");
            throwable.printStackTrace(System.out);
        }
    }

    private static void logException(Throwable throwable, int n) {
        if (throwable == null) {
            return;
        }
        if (n > 20) {
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Maximum nested exception level logging reached...");
            return;
        }
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, throwable.getMessage());
        if (throwable.getCause() != null) {
            AutomateEnterpriseCommandRunner.logException(throwable.getCause(), n + 1);
        }
    }

    private static void logmsgWithTimestamp(LogLevel logLevel, String string) {
        AutomateEnterpriseCommandRunner.logmsg(logLevel, AutomateEnterpriseCommandRunner.getAutomateV11Helper().getCurrentTimestampString() + " - " + string);
    }

    private static void logmsg(LogLevel logLevel, String string) {
        switch (logLevel) {
            case DEBUG: {
                if (currentLogLevel == LogLevel.DEBUG) {
                    System.out.println(string);
                }
                return;
            }
            case INFO: {
                if (currentLogLevel == LogLevel.DEBUG || currentLogLevel == LogLevel.INFO) {
                    System.out.println(string);
                }
                return;
            }
        }
        System.out.println(string);
    }

    public void runAutomateEnterpriseCommand(AutoMateBPARequestComposite autoMateBPARequestComposite, AutoMateBPACommand autoMateBPACommand, AutoMateBPACommandType autoMateBPACommandType, AutoMateSystemDefinition autoMateSystemDefinition) throws Exception {
        String string;
        String string2;
        String string3;
        IBPAManagementServerHTTPServiceContract iBPAManagementServerHTTPServiceContract;
        block15: {
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "");
            AutomateEnterpriseCommandRunner.logmsgWithTimestamp(LogLevel.INFO, "Start of running Enterprise " + autoMateBPACommandType + " command.");
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Enterprise System . . . . . : " + autoMateSystemDefinition.getName());
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Enterprise Command Type . . : " + autoMateBPACommand.getCommandType());
            if (autoMateBPACommand.isRunByID()) {
                AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Enterprise Command ID . . . : " + autoMateBPACommand.getBpaCommandID());
            } else {
                AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Enterprise Command Name . . : " + autoMateBPACommand.getBpaCommandName());
                AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Enterprise Command Path . . : " + autoMateBPACommand.getBpaCommandPath());
            }
            AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "");
            iBPAManagementServerHTTPServiceContract = null;
            long l = System.currentTimeMillis();
            String string4 = System.getenv().get("COMPUTERNAME");
            String string5 = autoMateBPARequestComposite.getSkybotJobName();
            long l2 = autoMateBPARequestComposite.getSkybotJobHistoryID();
            string3 = l2 + "." + string5 + "." + string4;
            int n = string3.length();
            if (n > 38) {
                n = 38;
            }
            string3 = string3.substring(0, n);
            string2 = null;
            string = null;
            try {
                AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Connecting to Enterprise Server...");
                iBPAManagementServerHTTPServiceContract = AutomateEnterpriseCommandRunner.getAutomateV11Helper().getServiceContract(autoMateSystemDefinition.getEndPointURL());
                OpenSessionResponseMessage openSessionResponseMessage = this.openSessionGetResponse(iBPAManagementServerHTTPServiceContract, autoMateSystemDefinition, string3);
                AutomateEnterpriseCommandRunner.getAutomateV11Helper().processResponseMessage(openSessionResponseMessage);
                string2 = openSessionResponseMessage.getMessageID();
                string = openSessionResponseMessage.getConnectionID();
                AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "");
                AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Connection Successful!");
                AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Connection Session ID : " + string);
                AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Connection Message ID : " + string2);
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(l);
                String[] stringArray = null;
                switch (autoMateBPACommandType) {
                    case WORKFLOW: {
                        stringArray = this.runWorkflow(iBPAManagementServerHTTPServiceContract, string3, string2, string, calendar, autoMateBPACommand);
                        break;
                    }
                    case TASK: {
                        stringArray = this.runTasks(iBPAManagementServerHTTPServiceContract, string3, string2, string, calendar, autoMateBPARequestComposite);
                        break;
                    }
                    case PROCESS: {
                        stringArray = this.runProcesses(iBPAManagementServerHTTPServiceContract, string3, string2, string, calendar, autoMateBPARequestComposite);
                    }
                }
                if (stringArray == null || stringArray.length == 0) {
                    throw new Exception("Error starting " + autoMateBPACommandType + ": No instance IDs were returned upon start.");
                }
                String string6 = "";
                string6 = autoMateBPACommand.isRunByID() ? string6 + autoMateBPACommand.getBpaCommandID() : string6 + autoMateBPACommand.getBpaCommandName();
                this.logStartedBPACommand(autoMateBPACommandType, string6, stringArray);
                if (autoMateBPACommand.isWaitForCompletion()) {
                    AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "About to monitor Queued and Running " + autoMateBPACommandType + " instances...");
                    this.monitorQueuedBPACommandStatuses(iBPAManagementServerHTTPServiceContract, string3, string2, string, calendar, stringArray, autoMateBPACommandType, autoMateSystemDefinition.getStatusPollingInterval());
                    this.monitorActiveBPACommand(iBPAManagementServerHTTPServiceContract, string3, string2, string, calendar, stringArray, autoMateBPACommandType, autoMateSystemDefinition.getStatusPollingInterval());
                    AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "");
                    AutomateEnterpriseCommandRunner.logmsgWithTimestamp(LogLevel.INFO, "About to check final status for " + autoMateBPACommandType + " instances...");
                    boolean bl = this.checkBPAWorkflowStatuses(iBPAManagementServerHTTPServiceContract, string3, string2, string, calendar, stringArray);
                    if (!bl) {
                        throw new Exception("Automate Enterprise Command failed.");
                    }
                    break block15;
                }
                AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "Wait for completion was not selected.");
            }
            catch (Exception exception) {
                try {
                    AutomateEnterpriseCommandRunner.getAutomateV11Helper().checkForUserRelatedErrors(exception.getMessage(), autoMateSystemDefinition.getUsername());
                    throw new Exception("Error running BPA " + autoMateBPACommandType + " on URL '" + autoMateSystemDefinition.getEndPointURL() + "'", exception);
                }
                catch (Throwable throwable) {
                    this.closeSession(iBPAManagementServerHTTPServiceContract, string3, string2, string);
                    AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "");
                    AutomateEnterpriseCommandRunner.logmsgWithTimestamp(LogLevel.INFO, "End of running BPA " + autoMateBPACommandType + " command.");
                    throw throwable;
                }
            }
        }
        this.closeSession(iBPAManagementServerHTTPServiceContract, string3, string2, string);
        AutomateEnterpriseCommandRunner.logmsg(LogLevel.INFO, "");
        AutomateEnterpriseCommandRunner.logmsgWithTimestamp(LogLevel.INFO, "End of running BPA " + autoMateBPACommandType + " command.");
    }

    static {
        String string = "SKYBOT_AUTOMATE_LOGLEVEL";
        String string2 = System.getenv(string);
        if (string2 != null && string2.trim().length() > 0) {
            if (string2.trim().equalsIgnoreCase("debug")) {
                currentLogLevel = LogLevel.DEBUG;
            } else if (string2.trim().equalsIgnoreCase("info")) {
                currentLogLevel = LogLevel.INFO;
            } else {
                System.out.println("Undefined value for " + string + ": " + string2);
                System.out.println(string + " must be INFO or DEBUG when specified.");
            }
        }
    }

    private static enum LogLevel {
        DEBUG,
        INFO;

    }
}

