/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.service;

import com.helpsystems.common.core.xml.XMLReflector;
import com.helpsystems.common.core.xml.XMLUtil;
import com.helpsystems.common.tl.PeerDescriptor;
import com.helpsystems.enterprise.peer.AgentPeerConfig;
import com.helpsystems.enterprise.peer.DefaultConfigPath;
import com.helpsystems.enterprise.service.AgentServiceAMImpl;
import com.helpsystems.enterprise.service.AgentServiceConfig;
import com.helpsystems.enterprise.service.AgentServiceEntry;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;

public class ReadConfig {
    private static boolean verbose = false;

    private ReadConfig() {
    }

    public static void main(String[] stringArray) {
        File file;
        String string = "";
        String string2 = "Default";
        if (stringArray.length == 0) {
            ReadConfig.showHelp();
            return;
        }
        String string3 = DefaultConfigPath.getDefaultPath() + File.separator + "agentService.config";
        AgentPeerConfig agentPeerConfig = null;
        Map<String, List<String>> map = ReadConfig.parseArgs(stringArray);
        String string4 = ReadConfig.getSingleString(map, "f");
        string = ReadConfig.getSingleString(map, "an");
        File file2 = new File(DefaultConfigPath.getDefaultPath() + File.separator + "agentService.config");
        AgentServiceConfig agentServiceConfig = null;
        try {
            agentServiceConfig = AgentServiceAMImpl.loadOrCreateConfig(file2);
        }
        catch (Exception exception) {
            ReadConfig.finished("Unable to load the config file agentService.config", exception, -1);
        }
        AgentServiceEntry agentServiceEntry = agentServiceConfig.getEntry(0);
        int n = agentServiceConfig.getEntries().length;
        for (int i = 0; i < n; ++i) {
            agentServiceEntry = agentServiceConfig.getEntry(i);
            if (agentServiceEntry.getFilename().compareToIgnoreCase("agent.xml") != 0) continue;
            string2 = agentServiceEntry.getLabel();
            break;
        }
        if (string != null && string.length() > 0) {
            agentServiceEntry.setLabel(string);
            AgentServiceConfig.saveAgentServiceConfig(agentServiceConfig, string3, true);
            ReadConfig.finished("AgentServiceConfig " + file2.getAbsolutePath() + " has been updated.", null, 0);
        }
        if ((file = new File(string4)).isDirectory()) {
            ReadConfig.finished("The filename " + file.getAbsolutePath() + " is a directory.", null, -1);
        }
        if (file.exists()) {
            try {
                Document document = XMLUtil.loadXML((String)file.getAbsolutePath());
                agentPeerConfig = (AgentPeerConfig)XMLReflector.readObject((Document)document);
            }
            catch (Exception exception) {
                ReadConfig.finished("Unable to parse the content of the configuration file " + string4, exception, -1);
            }
        }
        int n2 = agentPeerConfig.getListenPort();
        PeerDescriptor peerDescriptor = agentPeerConfig.getMaster();
        int n3 = peerDescriptor.getPort();
        String[] stringArray2 = peerDescriptor.getAddresses();
        String string5 = "";
        if (stringArray2 != null && stringArray2[0].length() > 0) {
            string5 = stringArray2[0];
        }
        File file3 = new File("agent.txt");
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file3)));
            printWriter.println(n2);
            printWriter.println(string5);
            printWriter.println(n3);
            printWriter.println(string2);
            printWriter.close();
        }
        catch (Exception exception) {
            ReadConfig.finished("Unable to write installer values to " + string4, exception, -1);
        }
    }

    public static void showHelp() {
        System.out.println("Read values from an Agent's configuration.");
        System.out.println("  -f      Specifies the name of the config file to use.\n\n");
        System.out.println("This program creates agent.txt with values needed by Nullsoft.");
    }

    static void finished(String string, Exception exception, int n) {
        if (n == 0) {
            if (string != null) {
                System.out.println(string);
            }
        } else if (string != null) {
            System.err.println(string);
        }
        if (verbose && exception != null) {
            exception.printStackTrace();
        }
        System.exit(n);
    }

    private static String getSingleString(Map<String, List<String>> map, String string) {
        List<String> list = map.remove(string);
        if (list == null) {
            return null;
        }
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public static Map<String, List<String>> parseArgs(String[] stringArray) {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            ArrayList<String> arrayList;
            String string2 = stringArray[i];
            if (string2.startsWith("-")) {
                if (string2.length() == 1) {
                    string = "";
                    continue;
                }
                string = string2.substring(1);
                continue;
            }
            if (string == null) {
                string = "";
            }
            if ((arrayList = (ArrayList<String>)hashMap.get(string)) == null) {
                arrayList = new ArrayList<String>();
                hashMap.put(string, arrayList);
            }
            arrayList.add(string2);
        }
        return hashMap;
    }
}

