/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.service;

import com.helpsystems.common.core.util.Equal;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.common.core.xml.XMLReflector;
import com.helpsystems.common.core.xml.XMLSerializable;
import com.helpsystems.common.core.xml.XMLUtil;
import com.helpsystems.enterprise.peer.AgentPeerConfig;
import com.helpsystems.enterprise.peer.DefaultConfigPath;
import com.helpsystems.enterprise.service.FileExistsException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class AgentServiceEntry
implements XMLSerializable,
Serializable {
    private static final Logger logger = Logger.getLogger(AgentServiceEntry.class);
    private static final long serialVersionUID = -6155003408201664775L;
    private boolean autostart;
    private String label;
    private String filename;
    private transient AgentPeerConfig previousConfig = null;
    private transient long previousConfigModTime;
    private transient long whenLoggingLevelCached;
    private transient String cachedLoggingLevel;

    public boolean getAutostart() {
        return this.autostart;
    }

    public void setAutostart(boolean bl) {
        this.autostart = bl;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        ValidationHelper.checkForNullAndBlank((String)"Alias", (String)string);
        this.label = string;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getFilePath() {
        if (this.filename == null) {
            return null;
        }
        return DefaultConfigPath.getDefaultPath() + File.separator + this.filename;
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public AgentPeerConfig loadPeerConfig() throws FileNotFoundException {
        if (this.filename == null) {
            throw new NullPointerException("Agent configuration file path is null.");
        }
        if (this.filename.length() == 0) {
            throw new IllegalStateException("Agent configuration file path blank.");
        }
        String string = this.getFilePath();
        logger.trace((Object)("Requesting AgentServiceEntry: " + string));
        File file = new File(string);
        if (this.previousConfig != null && file.lastModified() == this.previousConfigModTime) {
            return this.previousConfig;
        }
        if (!file.exists()) {
            throw new FileNotFoundException("Agent configuration file '" + this.filename + "' does not exist.");
        }
        if (!file.isFile()) {
            throw new RuntimeException("Agent configuration file '" + this.filename + "' is actually a directory.");
        }
        logger.trace((Object)("Loading AgentServiceEntry: " + file.getAbsolutePath()));
        AgentPeerConfig agentPeerConfig = null;
        try {
            Document document = XMLUtil.loadXML((String)string);
            agentPeerConfig = (AgentPeerConfig)XMLReflector.readObject((Document)document);
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException("The selected file is not an Agent configuration file.");
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Error loading Agent configuration file: " + this.filename, throwable);
        }
        this.previousConfig = agentPeerConfig;
        this.previousConfigModTime = file.lastModified();
        return agentPeerConfig;
    }

    public boolean savePeerConfig(AgentPeerConfig agentPeerConfig, boolean bl) throws FileExistsException {
        if (this.filename == null) {
            throw new NullPointerException("Agent configuration file path is null.");
        }
        if (this.filename.length() == 0) {
            throw new IllegalStateException("Agent configuration file path blank.");
        }
        File file = new File(this.getFilePath());
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new FileExistsException("Agent configuration file '" + this.filename + "' already exists as a directory.");
            }
            if (!bl) {
                throw new FileExistsException("Agent configuration file '" + this.filename + "' already exists.");
            }
        }
        String string = file.getAbsolutePath();
        logger.trace((Object)("Saving AgentPeerConfig in AgentServiceEntry: " + string));
        try {
            XMLUtil.writeXML((Document)XMLReflector.writeObject((XMLSerializable)agentPeerConfig), (String)string);
            return true;
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Error saving agent configuration file: " + string, throwable);
        }
    }

    public String[] doNotInvoke() {
        return new String[]{"getLogFileName", "getLoggingLevel", "getFilePath"};
    }

    public int hashCode() {
        if (this.label == null) {
            return -1;
        }
        return this.label.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!Equal.isEqual((Object)object.getClass().getName(), (Object)this.getClass().getName())) {
            return false;
        }
        AgentServiceEntry agentServiceEntry = (AgentServiceEntry)object;
        return Equal.isEqual((Object)agentServiceEntry.label, (Object)this.label);
    }

    public String getLogFileName() {
        String string = this.filename;
        String string2 = "\\";
        int n = (string = string.trim()).lastIndexOf(string2);
        n = n < 0 ? 0 : ++n;
        int n2 = string.length();
        String string3 = ".xml";
        if (string.toLowerCase().endsWith(string3)) {
            n2 -= string3.length();
        }
        string = string.substring(n, n2) + ".log";
        return "logs" + string2 + string;
    }

    public String makeLink(String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            this.loadPeerConfig();
        }
        catch (FileNotFoundException fileNotFoundException) {
            stringBuilder.append(string);
            stringBuilder.append(" - ");
            stringBuilder.append("Error: ");
            stringBuilder.append(fileNotFoundException.getLocalizedMessage());
            return stringBuilder.toString();
        }
        if (this.previousConfig == null || !bl) {
            return string;
        }
        int n = this.previousConfig.getListenPort();
        stringBuilder.append("<a href=\"https://");
        stringBuilder.append("localhost");
        stringBuilder.append(":");
        stringBuilder.append(n);
        stringBuilder.append("/cp/HS_diagnostics.html#general\">");
        stringBuilder.append(string);
        stringBuilder.append(":");
        stringBuilder.append(n);
        stringBuilder.append("</a>");
        return stringBuilder.toString();
    }

    public Level getLoggingLevel() throws FileNotFoundException {
        File file = new File(this.getFilePath());
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        long l = file.lastModified();
        if (l != this.whenLoggingLevelCached) {
            this.cachedLoggingLevel = this.loadPeerConfig().findLoggingLevel();
            this.whenLoggingLevelCached = l;
        }
        if ("TRACE".equals(this.cachedLoggingLevel)) {
            return Level.TRACE;
        }
        if ("DEBUG".equals(this.cachedLoggingLevel)) {
            return Level.DEBUG;
        }
        return Level.INFO;
    }
}

