/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.util;

import com.helpsystems.common.core.util.ResourceBundleHandler;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.ProgramParameter;
import org.apache.log4j.Logger;

public class QUSRJOBI_Parameters {
    private static final Logger logger = Logger.getLogger(QUSRJOBI_Parameters.class);
    private static ResourceBundleHandler rbh = ResourceBundleHandler.getHandler(QUSRJOBI_Parameters.class);
    private static final AS400Bin4 bin4_ = new AS400Bin4();
    private AS400 as400;
    private final int ccsid;

    public QUSRJOBI_Parameters(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException(rbh.getText("the_system_is_null"));
        }
        this.as400 = aS400;
        this.ccsid = this.as400.getCcsid();
    }

    public ProgramParameter[] getParms() {
        AS400Text aS400Text = new AS400Text(10, this.ccsid, this.as400);
        int n = 1024;
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(n), new ProgramParameter(bin4_.toBytes(n)), this.getFormatParm("JOBI0400"), this.getCurrentJobParm(), this.getInternalJobIDParm(""), this.getErrorParm()};
        return programParameterArray;
    }

    private ProgramParameter getFormatParm(String string) {
        String string2 = string.trim().toUpperCase();
        if (string2.length() != 8) {
            throw new IllegalArgumentException(rbh.getText("invalid_format_parameter_for") + string2);
        }
        if (!string2.startsWith("JOBI")) {
            throw new IllegalArgumentException(rbh.getText("invalid_format_parameter_prefix_for") + string2);
        }
        AS400Text aS400Text = new AS400Text(8, this.ccsid, this.as400);
        byte[] byArray = new byte[8];
        aS400Text.toBytes((Object)string, byArray, 0);
        return new ProgramParameter(byArray);
    }

    private ProgramParameter getCurrentJobParm() {
        AS400Text aS400Text = new AS400Text(26, this.ccsid, this.as400);
        byte[] byArray = new byte[26];
        aS400Text.toBytes((Object)"*", byArray, 0);
        return new ProgramParameter(byArray);
    }

    private ProgramParameter getInternalJobIDParm(String string) {
        AS400Text aS400Text = new AS400Text(16, this.ccsid, this.as400);
        byte[] byArray = new byte[16];
        aS400Text.toBytes((Object)string, byArray, 0);
        return new ProgramParameter(byArray);
    }

    private ProgramParameter getErrorParm() {
        return new ProgramParameter(bin4_.toBytes(0));
    }
}

