/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.util;

import com.helpsystems.common.as400.busobj.QUSRJOBI_Job;
import com.helpsystems.common.as400.util.QUSRJOBI_Parameters;
import com.helpsystems.common.core.util.ResourceBundleHandler;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import org.apache.log4j.Logger;

public class QUSRJOBI_API {
    private static final Logger logger = Logger.getLogger(QUSRJOBI_API.class);
    private static ResourceBundleHandler rbh = ResourceBundleHandler.getHandler(QUSRJOBI_API.class);
    private AS400 as400;
    private final int ccsid;
    public static final int SO_SELECT = 0;
    public static final int SO_OMIT = 1;
    public static final int FLD_ATTR = 202;
    public static final int FLD_TEXT = 203;
    public static final int FLD_ASP = 301;
    public static final int FLD_ASPDEV = 605;

    public QUSRJOBI_API(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException(rbh.getText("the_system_is_null"));
        }
        this.as400 = aS400;
        this.ccsid = this.as400.getCcsid();
    }

    public QUSRJOBI_Job runAPI() {
        QUSRJOBI_Parameters qUSRJOBI_Parameters = new QUSRJOBI_Parameters(this.as400);
        ProgramParameter[] programParameterArray = qUSRJOBI_Parameters.getParms();
        try {
            return this.callQUSRJOBI(programParameterArray);
        }
        catch (AS400Exception aS400Exception) {
            String string = rbh.getText("error_retriving_job_information");
            logger.debug((Object)string, (Throwable)aS400Exception);
            throw new RuntimeException(string, aS400Exception);
        }
    }

    private QUSRJOBI_Job callQUSRJOBI(ProgramParameter[] programParameterArray) throws AS400Exception {
        CharConverter charConverter;
        ProgramCall programCall = new ProgramCall(this.as400, "/QSYS.LIB/QUSRJOBI.PGM", programParameterArray);
        boolean bl = false;
        try {
            bl = programCall.run();
        }
        catch (Exception exception) {
            String string = "QUSRJOBI api failed.";
            logger.debug((Object)string, (Throwable)exception);
            throw new RuntimeException(string, exception);
        }
        if (!bl) {
            logger.debug((Object)"QUSRJOBI was not successful.");
            AS400Message[] aS400MessageArray = programCall.getMessageList();
            for (int i = 0; i < aS400MessageArray.length; ++i) {
                logger.debug((Object)(" ** " + aS400MessageArray[i].getID() + " ** " + aS400MessageArray[i].getText()));
            }
            throw new AS400Exception(aS400MessageArray);
        }
        try {
            charConverter = new CharConverter(this.ccsid, this.as400);
        }
        catch (Exception exception) {
            String string = rbh.getText("character_convert_error");
            logger.debug((Object)string, (Throwable)exception);
            throw new RuntimeException(string, exception);
        }
        byte[] byArray = programParameterArray[0].getOutputData();
        int n = BinaryConverter.byteArrayToInt((byte[])byArray, (int)0);
        String string = charConverter.byteArrayToString(byArray, 8, 10);
        String string2 = charConverter.byteArrayToString(byArray, 18, 10);
        String string3 = charConverter.byteArrayToString(byArray, 28, 6);
        String string4 = "";
        if (n > 522) {
            int n2 = BinaryConverter.byteArrayToInt((byte[])byArray, (int)532);
            int n3 = BinaryConverter.byteArrayToInt((byte[])byArray, (int)536);
            if (n3 == 0) {
                string4 = "*NONE";
            } else {
                string4 = charConverter.byteArrayToString(byArray, n2, 10);
                if (n3 > 1) {
                    logger.debug((Object)(n3 + " ASP groups were indicated by the QUSRJOBI api!"));
                }
            }
        }
        QUSRJOBI_Job qUSRJOBI_Job = new QUSRJOBI_Job();
        qUSRJOBI_Job.setJobName(string);
        qUSRJOBI_Job.setJobUser(string2);
        qUSRJOBI_Job.setJobNumber(string3);
        qUSRJOBI_Job.setAspGroup(string4);
        return qUSRJOBI_Job;
    }
}

