/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.service;

import com.helpsystems.common.as400.access.AS400ConnectionFactory;
import com.helpsystems.common.as400.access.AS400ObjectPool;
import com.helpsystems.common.as400.access.AS400PoolManager;
import com.helpsystems.common.as400.service.AS400Service;
import com.helpsystems.common.as400.service.AS400ServiceDescriptor;
import com.helpsystems.common.core.encryption.EncryptUtil;
import com.helpsystems.common.core.service.Service;
import com.helpsystems.common.core.service.ServiceDescriptor;
import com.helpsystems.common.core.service.ServiceException;
import com.helpsystems.common.core.service.ServiceStarter;
import com.helpsystems.common.core.util.HSJvmProperties;
import com.helpsystems.common.core.util.OutputStreamLogger;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.Trace;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.log4j.Logger;

public class AS400ServiceStarter
implements ServiceStarter {
    private static final Logger logger = Logger.getLogger(AS400ServiceStarter.class);
    private EncryptUtil decoder;

    public Service startService(ServiceDescriptor serviceDescriptor) throws ServiceException {
        if (serviceDescriptor instanceof AS400ServiceDescriptor) {
            return this.startAS400Service((AS400ServiceDescriptor)serviceDescriptor);
        }
        throw new ServiceException("The service descriptor passed in is incompatible with this ServiceStarter.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Service startAS400Service(AS400ServiceDescriptor aS400ServiceDescriptor) throws ServiceException {
        Object object;
        String string;
        if (HSJvmProperties.isJT400TraceEnabled()) {
            Logger.getLogger((String)"jtopen");
            string = new OutputStreamLogger("jtopen", logger);
            object = new PrintWriter((OutputStream)((Object)string));
            try {
                Trace.setPrintWriter((PrintWriter)object);
                Trace.setTraceAllOn((boolean)true);
                Trace.setTraceOn((boolean)true);
            }
            catch (Exception exception) {
                logger.debug((Object)"Unable to activate JT400 logging.", (Throwable)exception);
            }
        }
        if (aS400ServiceDescriptor == null) {
            throw new NullPointerException("The service descriptor passed in is null.");
        }
        string = aS400ServiceDescriptor.getName();
        if (string == null) {
            throw new ServiceException("An AS400 service descriptor is missing a name.");
        }
        object = aS400ServiceDescriptor.getIPAddress();
        if (object == null) {
            throw new ServiceException("The IP Address within the descriptor " + string + " is null.");
        }
        String string2 = aS400ServiceDescriptor.getUsername();
        String string3 = aS400ServiceDescriptor.getEncryptedPassword();
        String string4 = null;
        if (((String)object).equalsIgnoreCase("localhost")) {
            string2 = System.getProperty("user.name");
            if (string2 == null || string2.trim().length() == 0 || string2.trim().equalsIgnoreCase("unknown")) {
                string2 = "*CURRENT";
            }
            string4 = "*CURRENT";
        } else {
            if (string2 == null) {
                throw new ServiceException("The username within the descriptor " + aS400ServiceDescriptor.getName() + " is null.");
            }
            if (string3 == null) {
                throw new ServiceException("The password within the descriptor " + aS400ServiceDescriptor.getName() + " is null.");
            }
            if (this.decoder != null) {
                try {
                    string4 = this.decoder.decode(string3);
                }
                catch (Exception exception) {
                    throw new ServiceException("Unable to decrypt the AS400 password for service " + aS400ServiceDescriptor.getName(), (Throwable)exception);
                }
            } else {
                string4 = string3;
            }
        }
        Exception exception = null;
        boolean bl = false;
        AS400 aS400 = null;
        try {
            aS400 = new AS400((String)object);
            bl = ((String)object).equalsIgnoreCase("localhost") ? true : aS400.validateSignon(string2, string4);
        }
        catch (Exception exception2) {
            exception = exception2;
            bl = false;
        }
        finally {
            try {
                aS400.disconnectAllServices();
            }
            catch (Exception exception3) {}
        }
        if (!bl) {
            throw new ServiceException("Unable to connect to the server " + (String)object + " using the username " + string2, (Throwable)exception);
        }
        AS400ConnectionFactory aS400ConnectionFactory = new AS400ConnectionFactory((String)object, string2, string4);
        aS400ConnectionFactory.setSysLibrary(aS400ServiceDescriptor.getSysLibrary());
        aS400ConnectionFactory.setSyslibOverride(aS400ServiceDescriptor.getSyslibOverride());
        aS400ConnectionFactory.setCleanSystemLibraryList(aS400ServiceDescriptor.getCleanSystemLibraryList());
        AS400ObjectPool aS400ObjectPool = new AS400ObjectPool(aS400ConnectionFactory);
        int n = aS400ServiceDescriptor.getMaxConnections();
        aS400ObjectPool.setMaxActive(n);
        aS400ObjectPool.setMaxIdle(-1);
        aS400ObjectPool.setMinIdle(1);
        aS400ObjectPool.setMaxWait(3000L);
        aS400ObjectPool.setMinEvictableIdleTimeMillis(-1L);
        aS400ObjectPool.setWhenExhaustedAction((byte)1);
        aS400ObjectPool.setTestOnBorrow(true);
        aS400ObjectPool.setTestOnReturn(true);
        aS400ObjectPool.setTestWhileIdle(true);
        aS400ObjectPool.setTimeBetweenEvictionRunsMillis(60000L);
        aS400ObjectPool.setDescriptor(aS400ServiceDescriptor);
        this.testPool(aS400ObjectPool, aS400ServiceDescriptor.getName());
        AS400PoolManager.getInstance().registerPool(string, (ObjectPool)aS400ObjectPool);
        logger.debug((Object)("AS400ServiceStarter service has started: " + aS400ServiceDescriptor.getName()));
        AS400Service aS400Service = new AS400Service();
        aS400Service.setDescriptor(aS400ServiceDescriptor);
        aS400Service.setStatus(1);
        aS400Service.setConnectionPool(aS400ObjectPool);
        return aS400Service;
    }

    public void stopService(Service service) throws ServiceException {
        if (!(service instanceof AS400Service)) {
            throw new ServiceException("The service passed in is incompatible with this ServiceStarter.");
        }
        AS400Service aS400Service = (AS400Service)service;
        GenericObjectPool genericObjectPool = aS400Service.getConnectionPool();
        try {
            if (genericObjectPool != null) {
                genericObjectPool.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void testPool(GenericObjectPool genericObjectPool, String string) throws ServiceException {
        try {
            AS400 aS400 = (AS400)genericObjectPool.borrowObject();
            if (aS400 == null) {
                throw new ServiceException("Unable to get a connection from the AS/400 pool " + string);
            }
            genericObjectPool.returnObject((Object)aS400);
        }
        catch (Exception exception) {
            throw new ServiceException("Error getting a connection from the AS/400 pool " + string, (Throwable)exception);
        }
    }

    public void useEncryption(EncryptUtil encryptUtil) {
        this.decoder = encryptUtil;
    }
}

