/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.schedule;

import com.helpsystems.common.as400.access.AbstractProgramCallManager;
import com.helpsystems.common.as400.access.CcsidManager;
import com.helpsystems.common.as400.access.WrappedAS400;
import com.helpsystems.common.as400.ex.CommandExecutionResponse;
import com.helpsystems.common.as400.schedule.CommonNameValidatorCHECKVN;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.busobj.InstalledProduct;
import com.helpsystems.common.core.busobj.InstalledProducts;
import com.helpsystems.common.core.busobj.UserIdentity;
import com.helpsystems.common.core.network.ProductIID;
import com.helpsystems.common.core.schedule.CommonScheduleJob;
import com.helpsystems.common.core.schedule.CommonScheduleJobDM;
import com.helpsystems.common.core.schedule.SchedulePCMLException;
import com.helpsystems.common.core.schedule.SendRobotData;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import org.apache.log4j.Logger;

public class CommonScheduleJobPCML
extends AbstractProgramCallManager
implements CommonScheduleJobDM {
    private static final Logger logger = Logger.getLogger(CommonScheduleJobPCML.class);

    public CommonScheduleJobPCML(String string, String string2) throws PcmlException {
        super("com.helpsystems.common.as400.schedule.commonschedjob", string, string2);
        this.setName("COMMON.CommonScheduleJobDM");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommonScheduleJob getScheduleJobByXR(String string, String string2, String string3, String string4, String string5, UserIdentity userIdentity) throws SchedulePCMLException {
        SchedulePCMLException schedulePCMLException = null;
        this.validateApp(string);
        this.validateXR(string2);
        WrappedAS400 wrappedAS400 = null;
        CommonScheduleJob commonScheduleJob = null;
        try {
            commonScheduleJob = new CommonScheduleJob();
            wrappedAS400 = this.borrowConnection(userIdentity);
            ProgramCallDocument programCallDocument = this.pcml;
            synchronized (programCallDocument) {
                this.pcml.setSystem((AS400)wrappedAS400);
                String string6 = QSYSObjectPathName.toPath((String)this.productLibrary, (String)"RBT872", (String)"PGM");
                this.pcml.setPath("RBT872", string6);
                this.pcml.setValue("RBT872.p1xref", (Object)string2);
                this.pcml.setValue("RBT872.p1appl", (Object)string);
                boolean bl = this.pcml.callProgram("RBT872");
                if (!bl) {
                    AS400Message[] aS400MessageArray = this.pcml.getMessageList("RBT872");
                    String[] stringArray = new String[aS400MessageArray.length];
                    for (int i = 0; i < aS400MessageArray.length; ++i) {
                        stringArray[i] = aS400MessageArray[i].getText();
                        String string7 = aS400MessageArray[i].getID();
                        String string8 = aS400MessageArray[i].getText();
                        logger.debug((Object)("   " + string7 + "  -  " + string8));
                    }
                    schedulePCMLException = new SchedulePCMLException("Error calling RBT872.", stringArray);
                } else {
                    String string9 = (String)this.pcml.getValue("RBT872.p1msid");
                    int n = string9.length();
                    if (n != 0) {
                        if (string9.equals("RB85301") || string9.equals("RB85302")) {
                            throw new RuntimeException(string9 + " - Not authorized.");
                        }
                        throw new RuntimeException(string9);
                    }
                    String string10 = (String)this.pcml.getValue("RBT872.p1jbnm");
                    if (string10.length() > 0) {
                        commonScheduleJob.setJobName(string10);
                    } else {
                        commonScheduleJob.setJobName(string3);
                    }
                    String string11 = (String)this.pcml.getValue("RBT872.p1desc");
                    if (string11.length() > 0) {
                        commonScheduleJob.setDescription(string11);
                    } else {
                        commonScheduleJob.setDescription(string4);
                    }
                    commonScheduleJob.setJobNumber((String)this.pcml.getValue("RBT872.p1jbnb"));
                    commonScheduleJob.setJobType("C");
                    int[] nArray = new int[]{this.pcml.getIntValue("RBT872.p1tim1"), this.pcml.getIntValue("RBT872.p1tim2"), this.pcml.getIntValue("RBT872.p1tim3"), this.pcml.getIntValue("RBT872.p1tim4"), this.pcml.getIntValue("RBT872.p1tim5"), this.pcml.getIntValue("RBT872.p1tim6"), this.pcml.getIntValue("RBT872.p1tim7"), this.pcml.getIntValue("RBT872.p1tim8")};
                    commonScheduleJob.setRunTimes(nArray);
                    String string12 = (String)this.pcml.getValue("RBT872.p1mon");
                    char[] cArray = new char[7];
                    if (string12.length() > 0) {
                        cArray[0] = string12.charAt(0);
                    }
                    if ((string12 = (String)this.pcml.getValue("RBT872.p1tue")).length() > 0) {
                        cArray[1] = string12.charAt(0);
                    }
                    if ((string12 = (String)this.pcml.getValue("RBT872.p1wed")).length() > 0) {
                        cArray[2] = string12.charAt(0);
                    }
                    if ((string12 = (String)this.pcml.getValue("RBT872.p1thur")).length() > 0) {
                        cArray[3] = string12.charAt(0);
                    }
                    if ((string12 = (String)this.pcml.getValue("RBT872.p1fri")).length() > 0) {
                        cArray[4] = string12.charAt(0);
                    }
                    if ((string12 = (String)this.pcml.getValue("RBT872.p1sat")).length() > 0) {
                        cArray[5] = string12.charAt(0);
                    }
                    if ((string12 = (String)this.pcml.getValue("RBT872.p1sun")).length() > 0) {
                        cArray[6] = string12.charAt(0);
                    }
                    commonScheduleJob.setRunDays(cArray);
                    if (commonScheduleJob.getJobNumber().trim().length() > 0) {
                        commonScheduleJob.setPersistent(true);
                    } else {
                        commonScheduleJob.setScheduleJobApplicationName(string5);
                        commonScheduleJob.setPersistent(false);
                    }
                }
            }
        }
        catch (Exception exception) {
            try {
                throw new RuntimeException("Error retrieving Robot job.", exception);
            }
            catch (Throwable throwable) {
                this.releaseConnection(wrappedAS400, true);
                throw throwable;
            }
        }
        this.releaseConnection(wrappedAS400, true);
        if (schedulePCMLException != null) {
            throw schedulePCMLException;
        }
        return commonScheduleJob;
    }

    public boolean saveScheduleJob(String string, String string2, CommonScheduleJob commonScheduleJob, UserIdentity userIdentity) throws SchedulePCMLException {
        boolean bl = false;
        this.validateApp(string);
        this.validateXR(string2);
        commonScheduleJob.validate();
        InstalledProducts installedProducts = InstalledProducts.getInstance();
        InstalledProduct installedProduct = installedProducts.getInstalledProduct(InstalledProduct.getApplCode((int)1), (BasicIdentifier)ProductIID.DIRECT_CONNECT);
        String string3 = installedProduct.getRelMod();
        bl = string3.trim().compareTo("R09M99") <= 0 ? this.saveJobInSchedule9(string, string2, commonScheduleJob, userIdentity) : this.saveJobInSchedule(string, string2, commonScheduleJob, userIdentity);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveJobInSchedule(String string, String string2, CommonScheduleJob commonScheduleJob, UserIdentity userIdentity) throws SchedulePCMLException {
        SchedulePCMLException schedulePCMLException = null;
        CcsidManager ccsidManager = new CcsidManager();
        CommonNameValidatorCHECKVN commonNameValidatorCHECKVN = new CommonNameValidatorCHECKVN(ccsidManager);
        commonNameValidatorCHECKVN.validateName("Schedule Job Name", commonScheduleJob.getJobName());
        WrappedAS400 wrappedAS400 = null;
        try {
            wrappedAS400 = this.borrowConnection(userIdentity);
            ProgramCallDocument programCallDocument = this.pcml;
            synchronized (programCallDocument) {
                int n;
                this.pcml.setSystem((AS400)wrappedAS400);
                String string3 = QSYSObjectPathName.toPath((String)this.productLibrary, (String)"RBT875", (String)"PGM");
                this.pcml.setPath("RBT875", string3);
                String string4 = commonScheduleJob.getCommandStr()[0];
                this.pcml.setValue("RBT875.p1cmd", (Object)string4);
                this.pcml.setValue("RBT875.p1jbnb", (Object)commonScheduleJob.getJobNumber());
                this.pcml.setValue("RBT875.p1jbnm", (Object)commonScheduleJob.getJobName());
                this.pcml.setValue("RBT875.p1xref", (Object)string2);
                this.pcml.setValue("RBT875.p1appl", (Object)string);
                this.pcml.setValue("RBT875.p1jobd", (Object)commonScheduleJob.getJobD());
                this.pcml.setValue("RBT875.p1jobdlib", (Object)commonScheduleJob.getJobDLib());
                this.pcml.setValue("RBT875.p1outq", (Object)commonScheduleJob.getOutQ());
                this.pcml.setValue("RBT875.p1outqlib", (Object)commonScheduleJob.getOutQLib());
                this.pcml.setValue("RBT875.p1desc", (Object)commonScheduleJob.getDescription());
                String string5 = commonScheduleJob.getNotes();
                if (string5 == null) {
                    string5 = " ";
                }
                this.pcml.setValue("RBT875.p1note", (Object)string5);
                int[] nArray = commonScheduleJob.getRunTimes();
                this.pcml.setIntValue("RBT875.p1time1", nArray[0]);
                this.pcml.setIntValue("RBT875.p1time2", nArray[1]);
                this.pcml.setIntValue("RBT875.p1time3", nArray[2]);
                this.pcml.setIntValue("RBT875.p1time4", nArray[3]);
                this.pcml.setIntValue("RBT875.p1time5", nArray[4]);
                this.pcml.setIntValue("RBT875.p1time6", nArray[5]);
                this.pcml.setIntValue("RBT875.p1time7", nArray[6]);
                this.pcml.setIntValue("RBT875.p1time8", nArray[7]);
                String string6 = " ";
                Character[] characterArray = new Character[7];
                char[] cArray = commonScheduleJob.getRunDays();
                for (n = 0; n < cArray.length; ++n) {
                    characterArray[n] = new Character(cArray[n]);
                }
                String string7 = characterArray[0].toString();
                if (string7.equals(string6)) {
                    string7 = "N";
                }
                this.pcml.setValue("RBT875.p1mon", (Object)string7);
                string7 = characterArray[1].toString();
                if (string7.equals(string6)) {
                    string7 = "N";
                }
                this.pcml.setValue("RBT875.p1tue", (Object)string7);
                string7 = characterArray[2].toString();
                if (string7.equals(string6)) {
                    string7 = "N";
                }
                this.pcml.setValue("RBT875.p1wed", (Object)string7);
                string7 = characterArray[3].toString();
                if (string7.equals(string6)) {
                    string7 = "N";
                }
                this.pcml.setValue("RBT875.p1thur", (Object)string7);
                string7 = characterArray[4].toString();
                if (string7.equals(string6)) {
                    string7 = "N";
                }
                this.pcml.setValue("RBT875.p1fri", (Object)string7);
                string7 = characterArray[5].toString();
                if (string7.equals(string6)) {
                    string7 = "N";
                }
                this.pcml.setValue("RBT875.p1sat", (Object)string7);
                string7 = characterArray[6].toString();
                if (string7.equals(string6)) {
                    string7 = "N";
                }
                this.pcml.setValue("RBT875.p1sun", (Object)string7);
                this.pcml.setValue("RBT875.p1schappl", (Object)commonScheduleJob.getScheduleJobApplicationName());
                n = this.pcml.callProgram("RBT875") ? 1 : 0;
                if (n == 0) {
                    AS400Message[] aS400MessageArray = this.pcml.getMessageList("RBT875");
                    String[] stringArray = new String[aS400MessageArray.length];
                    for (int i = 0; i < aS400MessageArray.length; ++i) {
                        String string8 = aS400MessageArray[i].getID();
                        String string9 = aS400MessageArray[i].getText();
                        stringArray[i] = aS400MessageArray[i].getText();
                        logger.debug((Object)(string8 + " - " + string9));
                    }
                    schedulePCMLException = new SchedulePCMLException("Error calling RBT875.", stringArray);
                } else {
                    String[] stringArray = commonScheduleJob.getCommandStr();
                    CommonScheduleJob commonScheduleJob2 = this.getScheduleJobByXR(string, string2, commonScheduleJob.getJobName(), commonScheduleJob.getDescription(), commonScheduleJob.getScheduleJobApplicationName(), userIdentity);
                    commonScheduleJob2.setCommandStr(stringArray);
                    logger.debug((Object)"PCML call to RBT875 succeeded.");
                    logger.debug((Object)("Retrieving job info for app:" + string + " xrField:" + string2));
                    logger.debug((Object)("Got job info...job name [" + commonScheduleJob2.getJobName() + "] description [" + commonScheduleJob2.getDescription() + "]"));
                    logger.debug((Object)("Command is " + stringArray));
                    if (stringArray != null && stringArray.length > 1) {
                        StringBuffer stringBuffer = new StringBuffer("RBTBCHUPD JOBNAME(" + commonScheduleJob2.getJobName() + ") JOBNUMBER(" + commonScheduleJob2.getJobNumber() + ") CMD(");
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (i > 0) {
                                stringBuffer.append(" ");
                            }
                            stringBuffer.append("'" + this.doubleQuotes(stringArray[i].trim()) + "'");
                        }
                        stringBuffer.append(")");
                        logger.trace((Object)stringBuffer);
                        try {
                            if (wrappedAS400 == null) {
                                wrappedAS400 = this.borrowConnection(userIdentity);
                            }
                            CommandCall commandCall = new CommandCall((AS400)wrappedAS400);
                            CommonScheduleJobPCML.runCommand(stringBuffer.toString(), commandCall);
                            AS400Message[] aS400MessageArray = commandCall.getMessageList();
                            for (int i = 0; i < aS400MessageArray.length; ++i) {
                                logger.debug((Object)aS400MessageArray[i].getText());
                            }
                        }
                        catch (Exception exception) {
                            throw new RuntimeException("Error updating the schedule job object.", exception);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Error saving Robot job.", exception);
        }
        finally {
            this.releaseConnection(wrappedAS400, true);
        }
        if (schedulePCMLException != null) {
            throw schedulePCMLException;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveJobInSchedule9(String string, String string2, CommonScheduleJob commonScheduleJob, UserIdentity userIdentity) throws SchedulePCMLException {
        SchedulePCMLException schedulePCMLException = null;
        WrappedAS400 wrappedAS400 = null;
        try {
            wrappedAS400 = this.borrowConnection(userIdentity);
            ProgramCallDocument programCallDocument = this.pcml;
            synchronized (programCallDocument) {
                int n;
                this.pcml.setSystem((AS400)wrappedAS400);
                String string3 = QSYSObjectPathName.toPath((String)this.productLibrary, (String)"RBT873", (String)"PGM");
                this.pcml.setPath("RBT873", string3);
                String string4 = commonScheduleJob.getCommandStr()[0];
                this.pcml.setValue("RBT873.p1cmd", (Object)string4);
                this.pcml.setValue("RBT873.p1jbnb", (Object)commonScheduleJob.getJobNumber());
                this.pcml.setValue("RBT873.p1jbnm", (Object)commonScheduleJob.getJobName());
                this.pcml.setValue("RBT873.p1xref", (Object)string2);
                this.pcml.setValue("RBT873.p1appl", (Object)string);
                this.pcml.setValue("RBT873.p1jobd", (Object)commonScheduleJob.getJobD());
                this.pcml.setValue("RBT873.p1jobdlib", (Object)commonScheduleJob.getJobDLib());
                this.pcml.setValue("RBT873.p1outq", (Object)commonScheduleJob.getOutQ());
                this.pcml.setValue("RBT873.p1outqlib", (Object)commonScheduleJob.getOutQLib());
                this.pcml.setValue("RBT873.p1desc", (Object)commonScheduleJob.getDescription());
                String string5 = commonScheduleJob.getNotes();
                if (string5 == null) {
                    string5 = " ";
                }
                this.pcml.setValue("RBT873.p1note", (Object)string5);
                int[] nArray = commonScheduleJob.getRunTimes();
                this.pcml.setIntValue("RBT873.p1time1", nArray[0]);
                this.pcml.setIntValue("RBT873.p1time2", nArray[1]);
                this.pcml.setIntValue("RBT873.p1time3", nArray[2]);
                this.pcml.setIntValue("RBT873.p1time4", nArray[3]);
                this.pcml.setIntValue("RBT873.p1time5", nArray[4]);
                this.pcml.setIntValue("RBT873.p1time6", nArray[5]);
                this.pcml.setIntValue("RBT873.p1time7", nArray[6]);
                this.pcml.setIntValue("RBT873.p1time8", nArray[7]);
                String string6 = " ";
                Character[] characterArray = new Character[7];
                char[] cArray = commonScheduleJob.getRunDays();
                for (n = 0; n < cArray.length; ++n) {
                    characterArray[n] = new Character(cArray[n]);
                }
                String string7 = characterArray[0].toString();
                if (string7.equals(string6)) {
                    string7 = "N";
                }
                this.pcml.setValue("RBT873.p1mon", (Object)string7);
                string7 = characterArray[1].toString();
                if (string7.equals(string6)) {
                    string7 = "N";
                }
                this.pcml.setValue("RBT873.p1tue", (Object)string7);
                string7 = characterArray[2].toString();
                if (string7.equals(string6)) {
                    string7 = "N";
                }
                this.pcml.setValue("RBT873.p1wed", (Object)string7);
                string7 = characterArray[3].toString();
                if (string7.equals(string6)) {
                    string7 = "N";
                }
                this.pcml.setValue("RBT873.p1thur", (Object)string7);
                string7 = characterArray[4].toString();
                if (string7.equals(string6)) {
                    string7 = "N";
                }
                this.pcml.setValue("RBT873.p1fri", (Object)string7);
                string7 = characterArray[5].toString();
                if (string7.equals(string6)) {
                    string7 = "N";
                }
                this.pcml.setValue("RBT873.p1sat", (Object)string7);
                string7 = characterArray[6].toString();
                if (string7.equals(string6)) {
                    string7 = "N";
                }
                this.pcml.setValue("RBT873.p1sun", (Object)string7);
                n = this.pcml.callProgram("RBT873") ? 1 : 0;
                if (n == 0) {
                    AS400Message[] aS400MessageArray = this.pcml.getMessageList("RBT873");
                    String[] stringArray = new String[aS400MessageArray.length];
                    for (int i = 0; i < aS400MessageArray.length; ++i) {
                        String string8 = aS400MessageArray[i].getID();
                        String string9 = aS400MessageArray[i].getText();
                        stringArray[i] = aS400MessageArray[i].getText();
                        logger.debug((Object)(string8 + " - " + string9));
                    }
                    schedulePCMLException = new SchedulePCMLException("Error calling RBT873.", stringArray);
                } else {
                    String[] stringArray = commonScheduleJob.getCommandStr();
                    CommonScheduleJob commonScheduleJob2 = this.getScheduleJobByXR(string, string2, commonScheduleJob.getJobName(), commonScheduleJob.getDescription(), commonScheduleJob.getScheduleJobApplicationName(), userIdentity);
                    commonScheduleJob2.setCommandStr(stringArray);
                    logger.debug((Object)"PCML call to RBT873 succeeded.");
                    logger.debug((Object)("Retrieving job info for app:" + string + " xrField:" + string2));
                    logger.debug((Object)("Got job info...job name [" + commonScheduleJob2.getJobName() + "] description [" + commonScheduleJob2.getDescription() + "]"));
                    logger.debug((Object)("Command is " + stringArray));
                    if (stringArray != null && stringArray.length > 1) {
                        StringBuffer stringBuffer = new StringBuffer("RBTBCHUPD JOBNAME(" + commonScheduleJob2.getJobName() + ") JOBNUMBER(" + commonScheduleJob2.getJobNumber() + ") CMD(");
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (i > 0) {
                                stringBuffer.append(" ");
                            }
                            stringBuffer.append("'" + this.doubleQuotes(stringArray[i].trim()) + "'");
                        }
                        stringBuffer.append(")");
                        logger.trace((Object)stringBuffer);
                        try {
                            if (wrappedAS400 == null) {
                                wrappedAS400 = this.borrowConnection(userIdentity);
                            }
                            CommandCall commandCall = new CommandCall((AS400)wrappedAS400);
                            commandCall.run(stringBuffer.toString());
                            AS400Message[] aS400MessageArray = commandCall.getMessageList();
                            for (int i = 0; i < aS400MessageArray.length; ++i) {
                                logger.debug((Object)aS400MessageArray[i].getText());
                            }
                        }
                        catch (Exception exception) {
                            throw new RuntimeException("Error updating the schedule job object.", exception);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Error saving Robot job.", exception);
        }
        finally {
            this.releaseConnection(wrappedAS400, true);
        }
        if (schedulePCMLException != null) {
            throw schedulePCMLException;
        }
        return true;
    }

    private String doubleQuotes(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char c = "'".charAt(0);
        int n = string.indexOf(c);
        if (n == -1) {
            return string;
        }
        int n2 = string.trim().length();
        stringBuffer.append(string.substring(0, n));
        for (int i = n; i < n2; ++i) {
            stringBuffer.append(string.charAt(i));
            if (string.charAt(i) != c) continue;
            int n3 = i + 1;
            if (n3 <= n2 && string.charAt(n3) != c) {
                stringBuffer.append(c);
                continue;
            }
            i = n3;
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString().trim();
    }

    private void validateApp(String string) {
        if (string == null) {
            throw new RuntimeException("Robot Job Application cannot be null.");
        }
        if (string.trim().length() > 3) {
            throw new RuntimeException("Robot Job Application length cannot exceed 3 chartacters.");
        }
    }

    private void validateXR(String string) {
        if (string == null) {
            throw new RuntimeException("Robot Job XR field cannot be null.");
        }
        if (string.trim().length() > 50) {
            throw new RuntimeException("Robot Job XR field length cannot exceed 50 chartacters.");
        }
    }

    public String sendRobotData(SendRobotData sendRobotData) throws ResourceUnavailableException {
        String string = sendRobotData.buildSndMsgCommand();
        WrappedAS400 wrappedAS400 = this.borrowConnection();
        try {
            logger.trace((Object)("SNDRBTDTA Command: " + string));
            CommandExecutionResponse commandExecutionResponse = CommonScheduleJobPCML.runCommand(string, wrappedAS400);
            if (!commandExecutionResponse.isSuccessful()) {
                String string2 = "An error occurred sending the Robot/SCHEDULE Data.\n" + commandExecutionResponse.getMessageString(1);
                throw new ResourceUnavailableException(string2);
            }
            String string3 = string;
            return string3;
        }
        catch (Exception exception) {
            String string4 = "An error occurred sending the Robot/SCHEDULE data: " + string;
            logger.debug((Object)string4, (Throwable)exception);
            throw new ResourceUnavailableException(string4, (Throwable)exception);
        }
        finally {
            this.releaseConnection(wrappedAS400, true);
        }
    }
}

