/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.prompter.parser;

import com.helpsystems.common.as400.prompter.busobj.ChoiceProgram;
import com.helpsystems.common.as400.prompter.busobj.ControlCondition;
import com.helpsystems.common.as400.prompter.busobj.GenericParameter;
import com.helpsystems.common.as400.prompter.busobj.ParameterEntry;
import com.helpsystems.common.as400.prompter.busobj.PromptControl;
import com.helpsystems.common.as400.prompter.busobj.PromptControlEvaluator;
import com.helpsystems.common.as400.prompter.busobj.SpecialValueDefinition;
import com.helpsystems.common.as400.prompter.parser.EntryParser;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ParameterParser {
    protected static void fillChoiceProgramValues(Element element, ChoiceProgram choiceProgram) {
        if (element == null) {
            throw new NullPointerException("The element passed in was null.");
        }
        if (choiceProgram == null) {
            throw new NullPointerException("The ChoiceProgram passed in was null.");
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element element2 = (Element)node;
            String string = element2.getNodeName();
            if ("Value".equals(string)) {
                choiceProgram.addValue(element2.getAttribute("Val"));
                continue;
            }
            throw new IllegalArgumentException("Don't know what to do with '" + string + "' tag.");
        }
    }

    protected static void fillParameter(Element element, GenericParameter genericParameter) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object;
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element element2 = (Element)node;
            String string = element2.getNodeName();
            if ("SngVal".equals(string)) {
                ParameterParser.parseSingleValues(element2, genericParameter);
                continue;
            }
            if ("Values".equals(string)) {
                ParameterParser.parseSingleValues(element2, genericParameter);
                continue;
            }
            if ("SpcVal".equals(string)) {
                ParameterParser.parseSpecialValues(element2, genericParameter);
                continue;
            }
            if ("Qual".equals(string)) {
                object = new GenericParameter();
                ParameterParser.parse(element2, (GenericParameter)object);
                genericParameter.addNestedParameterTemplate((GenericParameter)object);
                continue;
            }
            if ("Elem".equals(string)) {
                object = new GenericParameter();
                ParameterParser.parse(element2, (GenericParameter)object);
                genericParameter.addNestedParameterTemplate((GenericParameter)object);
                continue;
            }
            if ("ChoicePgmText".equals(string)) {
                object = element2.getAttribute("Text");
                ChoiceProgram choiceProgram = genericParameter.getChoiceProgram();
                if (choiceProgram == null) {
                    choiceProgram = new ChoiceProgram();
                    genericParameter.setChoiceProgram(choiceProgram);
                }
                choiceProgram.setText((String)object);
                continue;
            }
            if ("ChoicePgmValues".equals(string)) {
                object = genericParameter.getChoiceProgram();
                if (object == null) {
                    object = new ChoiceProgram();
                    genericParameter.setChoiceProgram((ChoiceProgram)object);
                }
                ParameterParser.fillChoiceProgramValues(element2, (ChoiceProgram)object);
                continue;
            }
            if ("PmtCtl".equals(string) && genericParameter instanceof ParameterEntry) {
                object = ParameterParser.parsePromptControls(element2);
                ((ParameterEntry)genericParameter).addPromptControl((PromptControl)object);
                continue;
            }
            throw new IllegalArgumentException("Don't know what to do with '" + string + "' tag.");
        }
    }

    public static void parse(Element element, GenericParameter genericParameter) {
        if (element == null) {
            throw new NullPointerException("The element passed in is null.");
        }
        if (genericParameter == null) {
            throw new NullPointerException("The Parameter passed in is null.");
        }
        String string = element.getNodeName();
        boolean bl = false;
        if ("Parm".equalsIgnoreCase(string) || "Qual".equalsIgnoreCase(string) || "Elem".equalsIgnoreCase(string)) {
            bl = true;
        }
        if (!bl) {
            throw new IllegalArgumentException("The element passed in is a " + string + ". It should be 'Parm', 'Qual', or 'Elem'.");
        }
        String string2 = element.getAttribute("Type");
        genericParameter.setType(string2);
        genericParameter.setMinOccurrence(EntryParser.parseNumber(element, "Min", false));
        genericParameter.setMaxOccurrence(EntryParser.parseNumber(element, "Max", false));
        if (element.hasAttribute("PmtCtlPgm")) {
            genericParameter.setPromptControlProgram(element.getAttribute("PmtCtlPgm"));
        }
        if (element.hasAttribute("PmtCtlLib")) {
            genericParameter.setPromptControlLibrary(element.getAttribute("PmtCtlLib"));
        }
        genericParameter.setPrompt(element.getAttribute("Prompt"));
        EntryParser.ParsedDecimal parsedDecimal = EntryParser.parseNumber(element, "Len");
        genericParameter.setLength(parsedDecimal.integer);
        genericParameter.setFractionLength(parsedDecimal.decimal);
        genericParameter.setDefaultValue(element.getAttribute("Dft"));
        if (element.hasAttribute("Rel")) {
            genericParameter.setRelOperator(element.getAttribute("Rel"));
        }
        genericParameter.setRelValue(element.getAttribute("RelVal"));
        if (element.getAttribute("RelKwd").length() > 0) {
            throw new RuntimeException("Attribute 'RelKwd' is not supported.");
        }
        if (element.getAttribute("RangeMinKwd").length() > 0) {
            throw new RuntimeException("Attribute 'RangeMinKwd' is not supported.");
        }
        if (element.getAttribute("RangeMaxKwd").length() > 0) {
            throw new RuntimeException("Attribute 'RangeMaxKwd' is not supported.");
        }
        genericParameter.setRangeMinValue(EntryParser.parseDouble(element, "RangeMinVal"));
        genericParameter.setRangeMaxValue(EntryParser.parseDouble(element, "RangeMaxVal"));
        genericParameter.setDisplayInput(element.getAttribute("DspInput"));
        if ("YES".equals(element.getAttribute("Rstd"))) {
            genericParameter.setRestricted(true);
        }
        if ("YES".equals(element.getAttribute("Full"))) {
            genericParameter.setFullFieldSize(true);
        }
        genericParameter.setChoice(element.getAttribute("Choice"));
        ParameterParser.fillParameter(element, genericParameter);
    }

    protected static PromptControl parsePromptControls(Element element) {
        if (!"PmtCtl".equals(element.getNodeName())) {
            throw new IllegalArgumentException("The element passed is  was a '" + element.getNodeName() + "' it should " + " have been a 'PmtCtl'");
        }
        PromptControl promptControl = new PromptControl();
        promptControl.setKeyword(element.getAttribute("CtlKwd"));
        promptControl.setNumberTrue(EntryParser.parseNumber(element, "NbrTrue", true));
        if (element.hasAttribute("LglRel")) {
            promptControl.setBooleanControl(PromptControl.parseBooleanControl(element.getAttribute("LglRel")));
        }
        promptControl.setOperator(PromptControlEvaluator.mapOperator(element.getAttribute("NbrTrueRel")));
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element element2 = (Element)node;
            String string = element2.getNodeName();
            if ("PmtCtlCond".equals(string)) {
                ControlCondition controlCondition = new ControlCondition(element2.getAttribute("CmpVal"), element2.getAttribute("Rel"));
                promptControl.addCondition(controlCondition);
                continue;
            }
            throw new IllegalArgumentException("I don't know what to do with a '" + string + "' tag.");
        }
        return promptControl;
    }

    protected static void parseSpecialValues(Element element, GenericParameter genericParameter) {
        if (!"SpcVal".equals(element.getNodeName())) {
            throw new IllegalArgumentException("The element passed is  was a '" + element.getNodeName() + "' it should " + " have been a 'SpcVal'");
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element element2 = (Element)node;
            String string = element2.getNodeName();
            if ("Value".equals(string)) {
                SpecialValueDefinition specialValueDefinition = new SpecialValueDefinition(element2.getAttribute("Val"), element2.getAttribute("MapTo"));
                genericParameter.addSpecialValueDefinition(specialValueDefinition);
                continue;
            }
            throw new IllegalArgumentException("I don't know what to do with a '" + string + "' tag.");
        }
    }

    protected static void parseSingleValues(Element element, GenericParameter genericParameter) {
        String string = element.getNodeName();
        if (!"SngVal".equals(string) && !"Values".equals(string)) {
            throw new IllegalArgumentException("The element passed is  was a '" + element.getNodeName() + "' it should " + " have been a 'SngVal' or 'Values'");
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element element2 = (Element)node;
            String string2 = element2.getNodeName();
            if ("Value".equals(string2)) {
                SpecialValueDefinition specialValueDefinition = new SpecialValueDefinition(element2.getAttribute("Val"), element2.getAttribute("MapTo"));
                genericParameter.addSingleValueDefinition(specialValueDefinition);
                continue;
            }
            throw new IllegalArgumentException("I don't know what to do with a '" + string2 + "' tag.");
        }
    }
}

