/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.prompter.busobj;

import com.helpsystems.common.as400.dm.OS400CommandInfoDM;
import com.helpsystems.common.as400.prompter.busobj.AbstractParameterValue;
import com.helpsystems.common.as400.prompter.busobj.Dependency;
import com.helpsystems.common.as400.prompter.busobj.DependencyControl;
import com.helpsystems.common.as400.prompter.busobj.ParameterEntry;
import com.helpsystems.common.as400.prompter.busobj.ParameterValueList;
import com.helpsystems.common.as400.prompter.busobj.PromptControlEvaluator;
import com.helpsystems.common.as400.prompter.busobj.VariableInfo;
import com.helpsystems.common.as400.prompter.parser.CommandTokenizer;
import com.helpsystems.common.as400.prompter.parser.ParsedParameterList;
import com.helpsystems.common.core.util.ValidationHelper;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class PromptedCommand
implements Cloneable {
    private static final Logger logger = Logger.getLogger(PromptedCommand.class);
    protected String commandName;
    protected String libraryName;
    protected String commandDescription;
    protected ArrayList<ParameterEntry> entryList = new ArrayList();
    private String helpPanelGroup;
    private String helpID;
    private String productLibrary;
    private String messageFile;
    private ArrayList<Dependency> depList = new ArrayList();
    private char[] charMap;
    private ArrayList<String> parseErrorList = new ArrayList();
    private int positionalLimit;
    private OS400CommandInfoDM commandManager;
    private VariableInfo variableInfo;
    private String dateFormat;
    private String dateSeparator;
    private String timeSeparator;

    public Object clone() {
        PromptedCommand promptedCommand = null;
        try {
            promptedCommand = (PromptedCommand)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Unable to clone a PromptedCommand", cloneNotSupportedException);
        }
        promptedCommand.entryList = new ArrayList();
        ParameterEntry[] parameterEntryArray = this.getEntries();
        for (int i = 0; i < parameterEntryArray.length; ++i) {
            promptedCommand.entryList.add((ParameterEntry)parameterEntryArray[i].clone());
        }
        return promptedCommand;
    }

    public void addEntry(ParameterEntry parameterEntry) {
        if (parameterEntry == null) {
            throw new NullPointerException("The parameter-entry object passed in is null.");
        }
        parameterEntry.setPositionalIndex(this.entryList.size());
        if (this.entryList.size() == 0) {
            this.entryList.add(parameterEntry);
        } else {
            boolean bl = false;
            for (int i = 0; i < this.entryList.size(); ++i) {
                ParameterEntry parameterEntry2 = this.entryList.get(i);
                if (parameterEntry2.getDisplayPosition() <= parameterEntry.getDisplayPosition()) continue;
                this.entryList.add(i, parameterEntry);
                bl = true;
                break;
            }
            if (!bl) {
                this.entryList.add(parameterEntry);
            }
        }
        parameterEntry.setCommand(this);
    }

    public void addDependency(Dependency dependency) {
        ValidationHelper.checkForNull((String)"Dependency", (Object)dependency);
        dependency.setCommand(this);
        this.depList.add(dependency);
    }

    public String checkDependencies() {
        for (Dependency dependency : this.depList) {
            String string;
            if (!this.needToTestDependency(dependency) || (string = this.testSubDependencies(dependency)) == null) continue;
            return string;
        }
        return null;
    }

    public String checkRequiredParameters() {
        ParameterEntry[] parameterEntryArray = this.getEntries();
        for (int i = 0; i < parameterEntryArray.length; ++i) {
            ParameterEntry parameterEntry = parameterEntryArray[i];
            if (!parameterEntry.hasRequiredValues()) {
                return "The parameter " + parameterEntry.getKeyword() + " is required.";
            }
            String string = parameterEntry.checkRange();
            if (string == null) continue;
            return string;
        }
        return null;
    }

    public void clearValues() {
        ParameterEntry[] parameterEntryArray = this.getEntries();
        for (int i = 0; i < parameterEntryArray.length; ++i) {
            parameterEntryArray[i].clearValues();
        }
    }

    public ParameterEntry findParameter(String string) {
        ParameterEntry[] parameterEntryArray = this.getEntries();
        for (int i = 0; i < parameterEntryArray.length; ++i) {
            if (!string.equalsIgnoreCase(parameterEntryArray[i].getKeyword())) continue;
            return parameterEntryArray[i];
        }
        return null;
    }

    public String getCommandString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!(this.libraryName == null || this.libraryName.length() <= 0 || "qsys".equalsIgnoreCase(this.libraryName) || "__LIBL".equalsIgnoreCase(this.libraryName) || "*LIBL".equalsIgnoreCase(this.libraryName))) {
            stringBuffer.append(this.libraryName.toUpperCase());
            stringBuffer.append('/');
        }
        stringBuffer.append(this.getCommandName());
        ParameterEntry[] parameterEntryArray = this.getEntries();
        for (int i = 0; i < parameterEntryArray.length; ++i) {
            String string = parameterEntryArray[i].getCommandString();
            if (string == null || string.length() == 0) continue;
            stringBuffer.append(" ");
            stringBuffer.append(string);
        }
        String string = stringBuffer.toString();
        string = string.replaceAll("\\r", "").replaceAll("\\n", "");
        return string;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public String getDescription() {
        return this.commandDescription;
    }

    public ParameterEntry getEntry(int n) {
        ParameterEntry parameterEntry2 = null;
        if (n - 1 < this.entryList.size() && (parameterEntry2 = this.entryList.get(n - 1)).getDisplayPosition() == n) {
            return parameterEntry2;
        }
        for (ParameterEntry parameterEntry2 : this.entryList) {
            if (parameterEntry2.getDisplayPosition() != n) continue;
            return parameterEntry2;
        }
        return null;
    }

    public ParameterEntry[] getEntries() {
        ParameterEntry[] parameterEntryArray = new ParameterEntry[this.entryList.size()];
        this.entryList.toArray(parameterEntryArray);
        return parameterEntryArray;
    }

    public int getEntryCount() {
        return this.entryList.size();
    }

    public int getPositionalLimit() {
        return this.positionalLimit;
    }

    public void setPositionalLimit(int n) {
        this.positionalLimit = n;
    }

    public ParameterEntry getPositionalEntry(int n) {
        if (n >= this.positionalLimit) {
            throw new ArrayIndexOutOfBoundsException("Positional index " + n + " exceeds maximum of " + this.positionalLimit);
        }
        for (ParameterEntry parameterEntry : this.entryList) {
            if (parameterEntry.getPositionalIndex() != n) continue;
            return parameterEntry;
        }
        return null;
    }

    public void setCommandString(String string) {
        if (string == null || string.length() == 0) {
            for (ParameterEntry parameterEntry : this.entryList) {
                parameterEntry.clearValues();
            }
            return;
        }
        String string2 = string.replaceAll("\\r", "").replaceAll("\\n", "");
        CommandTokenizer commandTokenizer = new CommandTokenizer(string2);
        int n = 0;
        ParsedParameterList parsedParameterList;
        while ((parsedParameterList = commandTokenizer.nextValue()) != null) {
            String string3;
            logger.trace((Object)("Processing token: " + parsedParameterList));
            ParameterEntry parameterEntry = null;
            String string4 = parsedParameterList.getKeyword();
            if (string4 == null) {
                if (n >= this.getPositionalLimit()) {
                    string3 = "Positional parameter " + parsedParameterList + " exceeds limit of " + this.getPositionalLimit();
                    this.parseErrorList.add(string3);
                    continue;
                }
                parameterEntry = this.getPositionalEntry(n);
                ++n;
                if (parameterEntry != null) {
                    string4 = parameterEntry.getKeyword();
                    parsedParameterList.setKeyword(string4);
                }
            } else {
                parameterEntry = this.findParameter(string4);
                n = -1;
            }
            if (parameterEntry != null) {
                parameterEntry.parseParameterValue(parsedParameterList);
                continue;
            }
            if (string4 == null) {
                string3 = "No keyword specified for parameter value " + parsedParameterList;
                this.parseErrorList.add(string3);
                continue;
            }
            string3 = "Keyword " + string4 + " not valid for this command.";
            this.parseErrorList.add(string3);
        }
        return;
    }

    public void setCommandName(String string) {
        this.commandName = string;
    }

    public void setLibraryName(String string) {
        this.libraryName = string;
    }

    public void setDescription(String string) {
        this.commandDescription = string;
    }

    public String getHelpPanelGroup() {
        return this.helpPanelGroup;
    }

    public void setHelpPanelGroup(String string) {
        this.helpPanelGroup = string;
    }

    public String getHelpID() {
        return this.helpID;
    }

    public void setHelpID(String string) {
        this.helpID = string;
    }

    public String getProductLibrary() {
        return this.productLibrary;
    }

    public void setProductLibrary(String string) {
        this.productLibrary = string;
    }

    public String getMessageFile() {
        return this.messageFile;
    }

    public void setMessageFile(String string) {
        this.messageFile = string;
    }

    public char[] getCharMap() {
        return this.charMap;
    }

    public void setCharMap(char[] cArray) {
        this.charMap = cArray;
    }

    public boolean isValidVariableName(String string) {
        if (this.variableInfo == null) {
            return false;
        }
        if (string == null || string.length() == 0) {
            return false;
        }
        return this.variableInfo.isValid(string);
    }

    public VariableInfo getVariableInfo() {
        return this.variableInfo;
    }

    public void setVariableInfo(VariableInfo variableInfo) {
        this.variableInfo = variableInfo;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String string) {
        this.dateFormat = string;
    }

    public String getDateSeparator() {
        return this.dateSeparator;
    }

    public void setDateSeparator(String string) {
        this.dateSeparator = string;
    }

    public boolean isValidDate(String string) {
        int n;
        int n2;
        int n3;
        if (string == null) {
            return false;
        }
        SimpleDateFormat simpleDateFormat = this.makeDateFormat("yy");
        if (simpleDateFormat == null) {
            return true;
        }
        String[] stringArray = null;
        if (string.matches("[0-9]{6,8}")) {
            if (string.length() == 6) {
                stringArray = new String[]{string.substring(0, 2), string.substring(2, 4), string.substring(4)};
            } else {
                if (string.length() == 7) {
                    return false;
                }
                stringArray = new String[3];
                n3 = 0;
                block15: for (n2 = 0; n2 < 3; ++n2) {
                    n = this.dateFormat.charAt(n2);
                    switch (n) {
                        case 68: 
                        case 77: {
                            stringArray[n2] = string.substring(n3, n3 + 2);
                            n3 += 2;
                            continue block15;
                        }
                        case 89: {
                            stringArray[n2] = string.substring(n3, n3 + 4);
                            n3 += 4;
                        }
                    }
                }
            }
        } else {
            try {
                simpleDateFormat.parse(string);
            }
            catch (ParseException parseException) {
                simpleDateFormat = this.makeDateFormat("yyyy");
                try {
                    simpleDateFormat.parse(string);
                }
                catch (ParseException parseException2) {
                    logger.trace((Object)("Invalid date: " + string), (Throwable)parseException2);
                    return false;
                }
            }
            stringArray = string.split(this.dateSeparator);
        }
        if (stringArray == null || stringArray.length != 3) {
            return false;
        }
        block16: for (n3 = 0; n3 < 3; ++n3) {
            n2 = this.dateFormat.charAt(n3);
            n = 0;
            try {
                n = Integer.parseInt(stringArray[n3]);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            switch (n2) {
                case 77: {
                    if (n >= 1 && n <= 12) continue block16;
                    return false;
                }
                case 68: {
                    if (n >= 1 && n <= 31) continue block16;
                    return false;
                }
                case 89: {
                    if (stringArray[n3].length() != 2 && stringArray[n3].length() != 4) {
                        return false;
                    }
                    if (n >= 0) continue block16;
                    return false;
                }
            }
        }
        return true;
    }

    public String getDateFormatAsString() {
        SimpleDateFormat simpleDateFormat = this.makeDateFormat("yy");
        if (simpleDateFormat == null) {
            return this.dateFormat;
        }
        return simpleDateFormat.toPattern().toUpperCase();
    }

    private SimpleDateFormat makeDateFormat(String string) {
        if (this.dateSeparator == null || this.dateFormat == null || this.dateFormat.equals("JUL") || this.dateFormat.length() != 3) {
            return null;
        }
        String string2 = this.dateFormat.charAt(0) + this.dateSeparator + this.dateFormat.charAt(1) + this.dateSeparator + this.dateFormat.charAt(2);
        string2 = string2.replaceAll("D", "dd");
        string2 = string2.replaceAll("M", "MM");
        string2 = string2.replaceAll("Y", string);
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
            return simpleDateFormat;
        }
        catch (Exception exception) {
            logger.debug((Object)("Unable to create a date format: " + string2), (Throwable)exception);
            return null;
        }
    }

    public String getTimeSeparator() {
        return this.timeSeparator;
    }

    public void setTimeSeparator(String string) {
        this.timeSeparator = string;
    }

    public boolean isValidTime(String string) {
        if (string == null) {
            return false;
        }
        if (this.timeSeparator == null) {
            return true;
        }
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (string.matches("[0-9]{4,6}")) {
            if (string.length() == 5) {
                return false;
            }
            string2 = string.substring(0, 2);
            string3 = string.substring(2, 4);
            string4 = string.length() == 6 ? string.substring(4) : "0";
        } else if (string.matches("[0-9]{1,2}" + this.timeSeparator + "[0-9]{2}")) {
            String[] stringArray = string.split(this.timeSeparator);
            string2 = stringArray[0];
            string3 = stringArray[1];
            string4 = "0";
        } else if (string.matches("[0-9]{1,2}" + this.timeSeparator + "[0-9]{2}" + this.timeSeparator + "[0-9]{2}")) {
            String[] stringArray = string.split(this.timeSeparator);
            string2 = stringArray[0];
            string3 = stringArray[1];
            string4 = stringArray[2];
        } else {
            return false;
        }
        return this.testBoundedNumber(string2, 0, 23) && this.testBoundedNumber(string3, 0, 59) && this.testBoundedNumber(string4, 0, 59);
    }

    private boolean testBoundedNumber(String string, int n, int n2) {
        try {
            int n3 = Integer.parseInt(string);
            if (n3 < n || n3 > n2) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public String getTimeFormatAsString() {
        String string = this.timeSeparator;
        if (string == null) {
            string = "";
        }
        return "HH" + string + "MM";
    }

    public String[] getMessageIDs() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Dependency stringArray2 : this.depList) {
            String string = stringArray2.getMessageID();
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public String[] getParseErrors() {
        String[] stringArray = new String[this.parseErrorList.size()];
        this.parseErrorList.toArray(stringArray);
        return stringArray;
    }

    public void setCommandManager(OS400CommandInfoDM oS400CommandInfoDM) {
        this.commandManager = oS400CommandInfoDM;
    }

    private boolean needToTestDependency(Dependency dependency) {
        String string;
        int n = dependency.getOperator();
        if (n == 12) {
            return true;
        }
        String string2 = dependency.getKeyword();
        ParameterEntry parameterEntry = this.findParameter(string2);
        if (parameterEntry == null) {
            throw new NullPointerException("Could not test dependency for parameter " + string2);
        }
        ParameterValueList parameterValueList = parameterEntry.getAllParameterValues();
        AbstractParameterValue[] abstractParameterValueArray = null;
        if (parameterValueList != null) {
            abstractParameterValueArray = parameterValueList.getValues();
        }
        if ((string = parameterEntry.getDefaultValue()) == null) {
            string = "";
        }
        if (parameterEntry.isNumeric() && "".equals(string)) {
            string = "0";
        }
        String string3 = null;
        if (abstractParameterValueArray != null && abstractParameterValueArray.length > 0) {
            string3 = abstractParameterValueArray[0].toString();
        }
        if (string3 == null || string3.equals("")) {
            string3 = string;
        }
        string3 = PromptControlEvaluator.unmapVariableIfNecessary(parameterEntry, string3);
        if ((string3 = this.callPromptControl(parameterEntry, string3)) == null) {
            return false;
        }
        boolean bl = PromptControlEvaluator.compare(string3, this.unEBCDIC(dependency.getCompareValue()), n, parameterEntry.isValueSpecified(), this);
        return bl;
    }

    String callPromptControl(ParameterEntry parameterEntry, String string) {
        String string2;
        block5: {
            String string3 = parameterEntry.getPromptControlLibrary();
            String string4 = parameterEntry.getPromptControlProgram();
            if ("_System_State_Program_".equals(string4)) {
                return null;
            }
            if ("*LIBL".equals(string3)) {
                string3 = this.libraryName;
            }
            string2 = string;
            if (string4 != null && string3 != null && this.commandManager != null) {
                try {
                    string2 = this.commandManager.callPromptControl(string3, string4, this.getCommandName(), parameterEntry.getKeyword(), string);
                }
                catch (Exception exception) {
                    logger.debug((Object)("Error calling prompt control program for " + parameterEntry.getKeyword()), (Throwable)exception);
                    string2 = null;
                    String string5 = exception.getMessage();
                    if (string5 == null || string5.indexOf("MCH6801") <= -1) break block5;
                    parameterEntry.setPromptControlProgram("_System_State_Program_");
                }
            }
        }
        return string2;
    }

    private String testSubDependencies(Dependency dependency) {
        int n;
        int n2;
        DependencyControl[] dependencyControlArray = dependency.getRules();
        int n3 = 0;
        for (n2 = 0; n2 < dependencyControlArray.length; ++n2) {
            ParameterValueList parameterValueList;
            ParameterEntry parameterEntry;
            DependencyControl dependencyControl = dependencyControlArray[n2];
            String string = dependencyControl.getKeyword();
            String string2 = dependencyControl.getCompareValue();
            String string3 = dependencyControl.getCompareKeyword();
            if (string3 != null) {
                parameterEntry = this.findParameter(string3);
                parameterValueList = parameterEntry.getAllParameterValues();
                if (parameterValueList.size() == 0) {
                    string2 = parameterEntry.getDefaultValue();
                    if (parameterEntry.isNumeric() && (string2 == null || "".equals(string2))) {
                        string2 = "0";
                    }
                } else {
                    string2 = parameterValueList.toString();
                }
                string2 = PromptControlEvaluator.unmapVariableIfNecessary(parameterEntry, string2);
            }
            string2 = this.unEBCDIC(string2);
            parameterEntry = this.findParameter(string);
            if (parameterEntry == null) {
                throw new NullPointerException("Could not test dependency rule for parameter " + string);
            }
            parameterValueList = parameterEntry.getAllParameterValues();
            String string4 = "";
            if (parameterValueList.size() > 0 && (string4 = parameterValueList.toString()) == null) {
                string4 = "";
            }
            if (string4.equals("")) {
                String string5 = parameterEntry.getDefaultValue();
                if (string5 != null) {
                    string4 = string5;
                }
                if (parameterEntry.isNumeric() && (string5 == null || "".equals(string5))) {
                    string4 = "0";
                }
            }
            string4 = PromptControlEvaluator.unmapVariableIfNecessary(parameterEntry, string4);
            int n4 = dependencyControl.getOperator();
            boolean bl = false;
            bl = PromptControlEvaluator.compare(string4, string2, n4, parameterEntry.isValueSpecified(), this);
            if (!bl) continue;
            ++n3;
        }
        n2 = dependency.getNumberTrue();
        boolean bl = PromptControlEvaluator.compare(n3, n2, n = dependency.getNumberTrueOperator());
        if (!bl) {
            return dependency.getMessageID();
        }
        return null;
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.commandName);
        stringBuffer.append(": ");
        stringBuffer.append(this.commandDescription);
        stringBuffer.append(string);
        if (this.entryList.size() == 0) {
            stringBuffer.append("No parameter entries.");
        } else {
            for (int i = 0; i < this.entryList.size(); ++i) {
                stringBuffer.append("\t");
                stringBuffer.append(this.entryList.get(i).toString());
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    String unEBCDIC(String string) {
        String string2 = string;
        if (string2 == null || string2.length() == 0) {
            return string2;
        }
        if (!string2.startsWith("X'")) {
            return string2;
        }
        if (this.charMap == null) {
            throw new NullPointerException("The EBCDIC char map is null.");
        }
        string2 = string2.substring(2, string2.length() - 1);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string2.length(); i += 2) {
            String string3 = string2.substring(i, i + 2);
            int n = Integer.parseInt(string3, 16);
            stringBuffer.append(this.charMap[n]);
        }
        return stringBuffer.toString();
    }
}

