/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.console;

import com.helpsystems.common.as400.access.AbstractProgramCallManager;
import com.helpsystems.common.as400.access.WrappedAS400;
import com.helpsystems.common.as400.ex.CommandExecutionResponse;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.console.ConsoleProgramCallDM;
import com.helpsystems.common.core.console.MessageCenterMessage;
import com.helpsystems.common.core.dm.InstalledProductsDM;
import com.ibm.as400.access.AS400;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import org.apache.log4j.Logger;

public class ConsoleProgramCallPCML
extends AbstractProgramCallManager
implements ConsoleProgramCallDM {
    private static final Logger logger = Logger.getLogger(ConsoleProgramCallPCML.class);
    private InstalledProductsDM installedProductsDM = null;

    public ConsoleProgramCallPCML(String string, String string2, InstalledProductsDM installedProductsDM) throws PcmlException {
        super("com.helpsystems.common.as400.console.ConsoleProgramCall", string, string2);
        this.setName("COMMON.ConsoleProgramCall");
        this.installedProductsDM = installedProductsDM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDateTimeStamp() throws ResourceUnavailableException {
        WrappedAS400 wrappedAS400 = this.borrowConnection();
        try {
            ProgramCallDocument programCallDocument = this.pcml;
            synchronized (programCallDocument) {
                try {
                    this.pcml.setSystem((AS400)wrappedAS400);
                    this.pcml.setPath("QWCCVTDT", "/QSYS.lib/QWCCVTDT.pgm");
                    this.doCall("QWCCVTDT");
                    String string = (String)this.pcml.getValue("QWCCVTDT.CURDTS");
                    String string2 = string = string.trim();
                    return string2;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (Exception exception) {
                        if (exception instanceof ResourceUnavailableException) {
                            throw (ResourceUnavailableException)((Object)exception);
                        }
                        throw new ResourceUnavailableException("Unable to retrieve CURDTS", (Throwable)exception);
                    }
                }
            }
        }
        finally {
            this.releaseConnection(wrappedAS400);
        }
    }

    public String sendMessageToMessageCenter(MessageCenterMessage messageCenterMessage) throws ResourceUnavailableException {
        String string = messageCenterMessage.buildSndMsgCommand();
        WrappedAS400 wrappedAS400 = this.borrowConnection();
        try {
            logger.trace((Object)("SENDMC Command: " + string));
            CommandExecutionResponse commandExecutionResponse = ConsoleProgramCallPCML.runCommand(string, wrappedAS400);
            if (!commandExecutionResponse.isSuccessful()) {
                String string2 = "An error occurred sending the Console Message.\n" + commandExecutionResponse.getMessageString(1);
                throw new ResourceUnavailableException(string2);
            }
            String string3 = string;
            return string3;
        }
        catch (Exception exception) {
            logger.debug((Object)("An error occurred sending the Console message: " + string), (Throwable)exception);
            throw new ResourceUnavailableException("An error occurred sending the Console message.", (Throwable)exception);
        }
        finally {
            this.releaseConnection(wrappedAS400, true);
        }
    }
}

