/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.busobj.reporting;

import com.helpsystems.common.as400.busobj.reporting.Report;
import com.helpsystems.common.core.busobj.Proxy;
import com.helpsystems.common.core.util.ValidationHelper;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public abstract class AbstractReport
extends Proxy
implements Report {
    private static final long serialVersionUID = -5931732701340713992L;
    private static final Logger logger = Logger.getLogger(AbstractReport.class);
    private String programName;
    private String library;
    private String scheduleXRKey;
    private String scheduleJobName;
    private String scheduleJobDescription;
    private String scheduleJobApplicationName;

    protected AbstractReport() {
    }

    public AbstractReport(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        this.setName(string);
        this.setTitle(string2);
        this.setProgramName(string3);
        this.setScheduleXRKey(string4);
        this.setScheduleJobName(string5);
        this.setScheduleJobDescription(string6);
        this.setScheduleJobApplicationName(string7);
    }

    @Override
    public String getTitle() {
        return this.getDescription();
    }

    @Override
    public String getLibrary() {
        return this.library;
    }

    @Override
    public String getSubmitCommand(String string, String string2, String string3) {
        Object[] objectArray = new Object[]{this.getRunCommand(string), this.getName(), this.getOutqPath(string2, string3)};
        String string4 = MessageFormat.format("SBMJOB CMD({0}) JOB({1}) OUTQ({2}) INLLIBL(*CURRENT) USER(*CURRENT)", objectArray);
        logger.trace((Object)("Report submit command: " + string4));
        return string4;
    }

    @Override
    public String getProgramName() {
        return this.programName;
    }

    @Override
    public String getScheduleXRKey() {
        return this.scheduleXRKey;
    }

    @Override
    public String getScheduleJobName() {
        return this.scheduleJobName;
    }

    @Override
    public String getScheduleJobDescription() {
        return this.scheduleJobDescription;
    }

    @Override
    public String getScheduleJobApplicationName() {
        return this.scheduleJobApplicationName;
    }

    @Override
    public String getOutqPath(String string, String string2) {
        String string3 = string != null ? (string2 != null ? string2.trim() + "/" + string.trim() : string) : "*JOBD";
        return string3;
    }

    @Override
    public void setName(String string) {
        ValidationHelper.checkForNullAndBlank((String)"Report Name", (String)string);
        ValidationHelper.validateLength((String)"Report Name", (int)10, (String)string);
        super.setName(string);
    }

    @Override
    public void setTitle(String string) {
        this.setDescription(string);
    }

    public void setDescription(String string) {
        ValidationHelper.checkForNullAndBlank((String)"Report Title", (String)string);
        ValidationHelper.validateLength((String)"Report Title", (int)128, (String)string);
        super.setDescription(string);
    }

    @Override
    public void setLibrary(String string) {
        ValidationHelper.checkForNullAndBlank((String)"Report Library", (String)string);
        ValidationHelper.validateLength((String)"Report Library", (int)10, (String)string);
        this.library = string;
    }

    @Override
    public void setProgramName(String string) {
        ValidationHelper.checkForNullAndBlank((String)"Report Program Name", (String)string);
        ValidationHelper.validateLength((String)"Report Program Name", (int)10, (String)string);
        this.programName = string;
    }

    @Override
    public void setScheduleXRKey(String string) {
        ValidationHelper.checkForNullAndBlank((String)"Robot/SCHEDULE XR Key", (String)string);
        ValidationHelper.validateLength((String)"Robot/SCHEDULE XR Key", (int)50, (String)string);
        this.scheduleXRKey = string;
    }

    @Override
    public void setScheduleJobName(String string) {
        ValidationHelper.checkForNullAndBlank((String)"Robot/SCHEDULE Job Name", (String)string);
        ValidationHelper.validateLength((String)"Robot/SCHEDULE Job Name", (int)10, (String)string);
        this.scheduleJobName = string;
    }

    @Override
    public void setScheduleJobDescription(String string) {
        ValidationHelper.checkForNullAndBlank((String)"Robot/SCHEDULE Job Description", (String)string);
        this.scheduleJobDescription = string.length() > 25 ? string.substring(0, 24) : string;
    }

    @Override
    public void setScheduleJobApplicationName(String string) {
        ValidationHelper.checkForNull((String)"Robot/SCHEDULE Application Name", (Object)string);
        ValidationHelper.validateLength((String)"Robot/SCHEDULE Application Name", (int)10, (String)string);
        this.scheduleJobApplicationName = string;
    }

    @Override
    public void validate() {
    }
}

