/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.busobj;

import com.helpsystems.common.as400.busobj.OS400Object;
import com.helpsystems.common.core.busobj.Proxy;
import com.helpsystems.common.core.util.ResourceBundleHandler;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.common.core.xml.XMLSerializable;

public class OS400QualifiedObjectName
extends Proxy
implements XMLSerializable {
    private static final long serialVersionUID = 4884819423979607797L;
    private static final ResourceBundleHandler rbh = ResourceBundleHandler.getHandler(OS400QualifiedObjectName.class);
    public static final String LIB_NAME_SEPARATOR = "/";
    private String library = null;

    public OS400QualifiedObjectName() {
        this.initialize("", "");
    }

    public OS400QualifiedObjectName(String string, String string2) {
        this.initialize(string, string2);
    }

    public OS400QualifiedObjectName(Object object) {
        String string = "";
        String string2 = null;
        if (object instanceof OS400Object) {
            OS400Object oS400Object = (OS400Object)((Object)object);
            string = oS400Object.getLibrary();
            string2 = oS400Object.getObject();
        } else if (object instanceof OS400QualifiedObjectName) {
            OS400QualifiedObjectName oS400QualifiedObjectName = (OS400QualifiedObjectName)((Object)object);
            string = oS400QualifiedObjectName.getLibrary();
            string2 = oS400QualifiedObjectName.getObjectName();
        } else if (object instanceof String) {
            int n = -1;
            String string3 = (String)object;
            if (string3 != null) {
                n = string3.lastIndexOf(LIB_NAME_SEPARATOR);
                if (n > 0 && n + 1 < string3.length()) {
                    if (n != string3.indexOf(LIB_NAME_SEPARATOR)) {
                        throw new IllegalArgumentException(rbh.getMsg("only_one_char", (Object)LIB_NAME_SEPARATOR, (Object)string3));
                    }
                    string = string3.substring(0, n).trim();
                    string2 = string3.substring(n + 1).trim();
                } else {
                    string2 = string3;
                }
            }
        } else {
            throw new IllegalArgumentException(rbh.getMsg("bad_object", object.getClass()));
        }
        this.initialize(string, string2);
    }

    private void initialize(String string, String string2) {
        this.setLibrary(string);
        this.setObjectName(string2);
    }

    public String getLibrary() {
        return this.library;
    }

    public void setObjectName(String string) {
        super.setName(string);
    }

    public void setLibrary(String string) {
        this.library = string;
    }

    public String getObjectName() {
        return super.getName();
    }

    public void validate(String string) throws IllegalArgumentException {
        ValidationHelper.checkForNullAndBlank((String)(string + " " + rbh.getText("library")), (String)this.library);
        ValidationHelper.checkForNullAndBlank((String)string, (String)this.getObjectName());
    }

    public void validateSpecialValue(String string) throws IllegalArgumentException {
        ValidationHelper.checkForNull((String)(string + " " + rbh.getText("library")), (Object)this.library);
        if (!this.library.equals("")) {
            throw new IllegalArgumentException("If special value specified for " + string + ", then " + string + " library must be blank. " + "Value is '" + this.library + "'.");
        }
    }

    public boolean isBlank() {
        ValidationHelper.checkForNull((String)"Library name", (Object)this.getLibrary());
        ValidationHelper.checkForNull((String)"Object name", (Object)this.getObjectName());
        return this.getLibrary().trim().length() == 0 && this.getObjectName().trim().length() == 0;
    }

    public void chkNameAndLibForNull(String string) {
        ValidationHelper.checkForNull((String)"Property name", (Object)string);
        ValidationHelper.checkForNull((String)string, (Object)this.getObjectName());
        ValidationHelper.checkForNull((String)(string + " library"), (Object)this.getLibrary());
    }

    public boolean equals(Object object) {
        if (object == null || !((Object)((Object)this)).getClass().equals(object.getClass())) {
            return false;
        }
        OS400QualifiedObjectName oS400QualifiedObjectName = (OS400QualifiedObjectName)((Object)object);
        boolean bl = this.getObjectName() == null || oS400QualifiedObjectName.getObjectName() == null ? this.getObjectName() == null && oS400QualifiedObjectName.getObjectName() == null : this.getObjectName().equals(oS400QualifiedObjectName.getObjectName());
        if (!bl) {
            return bl;
        }
        bl = this.library == null || oS400QualifiedObjectName.library == null ? this.library == null && oS400QualifiedObjectName.library == null : this.library.equals(oS400QualifiedObjectName.getLibrary());
        if (!bl) {
            return bl;
        }
        return bl;
    }

    public int hashCode() {
        int n = this.getObjectName() == null ? 456 : this.getObjectName().hashCode();
        int n2 = this.library == null ? 295 : this.library.hashCode();
        return n * 100 + n2;
    }

    public String toString() {
        String string = this.getLibrary();
        if (string != null && string.trim().length() > 0) {
            return this.getLibrary() + LIB_NAME_SEPARATOR + this.getObjectName();
        }
        return this.getObjectName();
    }
}

