/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.access;

import com.helpsystems.common.as400.access.AbstractAS400Manager;
import com.helpsystems.common.as400.access.WrappedAS400;
import com.helpsystems.common.as400.dm.ISystemValueManager;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.SystemValue;

public class SystemValueManager
extends AbstractAS400Manager
implements ISystemValueManager {
    public SystemValueManager(String string) {
        super(string);
        this.setName("COMMON.SystemValueManager");
    }

    @Override
    public Object getSystemValue(String string) throws ResourceUnavailableException {
        WrappedAS400 wrappedAS400 = null;
        try {
            wrappedAS400 = this.borrowConnection();
            SystemValue systemValue = new SystemValue((AS400)wrappedAS400, string);
            Object object = systemValue.getValue();
            return object;
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Unable to retrieve the system value " + string, (Throwable)exception);
        }
        finally {
            if (wrappedAS400 != null) {
                this.releaseConnection(wrappedAS400);
            }
        }
    }
}

